/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.rest;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.telemetry.internal.helper.AgentDetection;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import jakarta.annotation.Nullable;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;

@Provider
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TelemetryClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private Instrumenter<ClientRequestContext, ClientResponseContext> instrumenter;
    private final String configString = "otel.span.client.";
    private static final NetClientAttributesGetterImpl NET_CLIENT_ATTRIBUTES_GETTER;
    private static final HttpClientAttributesGetterImpl HTTP_CLIENT_ATTRIBUTES_GETTER;
    static final long serialVersionUID = 5234814689221387380L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static TelemetryClientFilter getCurrent() {
        return (TelemetryClientFilter)CDI.current().select(TelemetryClientFilter.class, new Annotation[0]).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        TelemetryClientFilter telemetryClientFilter = this;
        synchronized (telemetryClientFilter) {
            if (this.instrumenter != null) {
                return;
            }
            OpenTelemetry openTelemetry = (OpenTelemetry)CDI.current().select(OpenTelemetry.class, new Annotation[0]).get();
            InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"Client filter", (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)HTTP_CLIENT_ATTRIBUTES_GETTER));
            this.instrumenter = builder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)HTTP_CLIENT_ATTRIBUTES_GETTER)).addAttributesExtractor((AttributesExtractor)HttpClientAttributesExtractor.create((HttpClientAttributesGetter)HTTP_CLIENT_ATTRIBUTES_GETTER)).addAttributesExtractor((AttributesExtractor)NetClientAttributesExtractor.create((NetClientAttributesGetter)NET_CLIENT_ATTRIBUTES_GETTER)).buildClientInstrumenter((TextMapSetter)new ClientRequestContextTextMapSetter());
        }
    }

    public void filter(final ClientRequestContext request) {
        this.init();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = -4581910829900604706L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                Context parentContext = Context.current();
                if (!AgentDetection.isAgentActive() && TelemetryClientFilter.this.instrumenter.shouldStart(parentContext, (Object)request)) {
                    Context spanContext = TelemetryClientFilter.this.instrumenter.start(parentContext, (Object)request);
                    request.setProperty("otel.span.client.context", (Object)spanContext);
                    request.setProperty("otel.span.client.parentContext", (Object)parentContext);
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.rest.TelemetryClientFilter$1", 1.class, (String)"TELEMETRY", null);
            }
        });
    }

    public void filter(final ClientRequestContext request, final ClientResponseContext response) {
        this.init();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = -4643249173743172640L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                Context spanContext = (Context)request.getProperty("otel.span.client.context");
                if (spanContext == null) {
                    return null;
                }
                try {
                    TelemetryClientFilter.this.instrumenter.end(spanContext, (Object)request, (Object)response, null);
                }
                finally {
                    request.removeProperty("otel.span.client.context");
                    request.removeProperty("otel.span.client.parentContext");
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.rest.TelemetryClientFilter$2", 2.class, (String)"TELEMETRY", null);
            }
        });
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.rest.TelemetryClientFilter", TelemetryClientFilter.class, (String)"TELEMETRY", null);
        NET_CLIENT_ATTRIBUTES_GETTER = new NetClientAttributesGetterImpl();
        HTTP_CLIENT_ATTRIBUTES_GETTER = new HttpClientAttributesGetterImpl();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class HttpClientAttributesGetterImpl
    implements HttpClientAttributesGetter<ClientRequestContext, ClientResponseContext> {
        static final long serialVersionUID = -8723778617660649945L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private HttpClientAttributesGetterImpl() {
        }

        public String flavor(ClientRequestContext request, ClientResponseContext response) {
            return null;
        }

        public String method(ClientRequestContext request) {
            return request.getMethod();
        }

        public Integer statusCode(ClientRequestContext request, ClientResponseContext response, @Nullable Throwable error) {
            return response.getStatus();
        }

        public String url(ClientRequestContext request) {
            return request.getUri().toString();
        }

        public List<String> requestHeader(ClientRequestContext request, String name) {
            return (List)request.getStringHeaders().getOrDefault((Object)name, Collections.emptyList());
        }

        public List<String> responseHeader(ClientRequestContext request, ClientResponseContext response, String name) {
            return (List)response.getHeaders().getOrDefault((Object)name, Collections.emptyList());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.rest.TelemetryClientFilter$HttpClientAttributesGetterImpl", HttpClientAttributesGetterImpl.class, (String)"TELEMETRY", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class NetClientAttributesGetterImpl
    implements NetClientAttributesGetter<ClientRequestContext, ClientResponseContext> {
        static final long serialVersionUID = -7412605336825804356L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private NetClientAttributesGetterImpl() {
        }

        public String transport(ClientRequestContext request, ClientResponseContext response) {
            return "ip_tcp";
        }

        public String peerName(ClientRequestContext request) {
            return request.getUri().getHost();
        }

        public Integer peerPort(ClientRequestContext request) {
            return request.getUri().getPort();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.rest.TelemetryClientFilter$NetClientAttributesGetterImpl", NetClientAttributesGetterImpl.class, (String)"TELEMETRY", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ClientRequestContextTextMapSetter
    implements TextMapSetter<ClientRequestContext> {
        static final long serialVersionUID = -1819741224770051308L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ClientRequestContextTextMapSetter() {
        }

        public void set(ClientRequestContext carrier, String key, String value) {
            if (carrier != null) {
                carrier.getHeaders().put((Object)key, Collections.singletonList(value));
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.rest.TelemetryClientFilter$ClientRequestContextTextMapSetter", ClientRequestContextTextMapSetter.class, (String)"TELEMETRY", null);
        }
    }
}

