/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.FixedBoundaryVictoriaMetricsHistogram;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.HistogramSupport;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.CumulativeHistogramLongTaskTimer;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.lang.Nullable;
import io.micrometer.prometheus.MicrometerCollector;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusCounter;
import io.micrometer.prometheus.PrometheusDistributionSummary;
import io.micrometer.prometheus.PrometheusNamingConvention;
import io.micrometer.prometheus.PrometheusTimer;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exemplars.Exemplar;
import io.prometheus.client.exemplars.ExemplarSampler;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PrometheusMeterRegistry
extends MeterRegistry {
    private final PrometheusConfig prometheusConfig;
    private final CollectorRegistry registry;
    private final ConcurrentMap<String, MicrometerCollector> collectorMap = new ConcurrentHashMap<String, MicrometerCollector>();
    @Nullable
    private final ExemplarSampler exemplarSampler;

    public PrometheusMeterRegistry(PrometheusConfig config) {
        this(config, new CollectorRegistry(), Clock.SYSTEM);
    }

    public PrometheusMeterRegistry(PrometheusConfig config, CollectorRegistry registry, Clock clock) {
        this(config, registry, clock, null);
    }

    public PrometheusMeterRegistry(PrometheusConfig config, CollectorRegistry registry, Clock clock, @Nullable ExemplarSampler exemplarSampler) {
        super(clock);
        config.requireValid();
        this.prometheusConfig = config;
        this.registry = registry;
        this.exemplarSampler = exemplarSampler;
        this.config().namingConvention(new PrometheusNamingConvention());
        this.config().onMeterRemoved(this::onMeterRemoved);
    }

    private static List<String> tagValues(Meter.Id id) {
        return StreamSupport.stream(id.getTagsAsIterable().spliterator(), false).map(Tag::getValue).collect(Collectors.toList());
    }

    public String scrape() {
        return this.scrape("text/plain; version=0.0.4; charset=utf-8");
    }

    public String scrape(String contentType) {
        StringWriter writer = new StringWriter();
        try {
            this.scrape(writer, contentType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ((Object)writer).toString();
    }

    public void scrape(Writer writer) throws IOException {
        this.scrape(writer, "text/plain; version=0.0.4; charset=utf-8");
    }

    public void scrape(Writer writer, String contentType) throws IOException {
        this.scrape(writer, contentType, this.registry.metricFamilySamples());
    }

    private void scrape(Writer writer, String contentType, Enumeration<Collector.MetricFamilySamples> samples) throws IOException {
        TextFormat.writeFormat(contentType, writer, samples);
    }

    public String scrape(String contentType, @Nullable Set<String> includedNames) {
        StringWriter writer = new StringWriter();
        try {
            this.scrape((Writer)writer, contentType, includedNames);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ((Object)writer).toString();
    }

    public void scrape(Writer writer, String contentType, @Nullable Set<String> includedNames) throws IOException {
        Enumeration<Collector.MetricFamilySamples> samples = includedNames != null ? this.registry.filteredMetricFamilySamples(includedNames) : this.registry.metricFamilySamples();
        this.scrape(writer, contentType, samples);
    }

    @Override
    public Counter newCounter(Meter.Id id) {
        PrometheusCounter counter = new PrometheusCounter(id, this.exemplarSampler);
        this.applyToCollector(id, collector -> {
            List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
            collector.add(tagValues, (conventionName, tagKeys) -> Stream.of(new MicrometerCollector.Family(Collector.Type.COUNTER, conventionName, new Collector.MetricFamilySamples.Sample(conventionName, (List<String>)tagKeys, tagValues, counter.count(), counter.exemplar()))));
        });
        return counter;
    }

    @Override
    public DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        PrometheusDistributionSummary summary = new PrometheusDistributionSummary(id, this.clock, distributionStatisticConfig, scale, this.prometheusConfig.histogramFlavor(), this.exemplarSampler);
        this.applyToCollector(id, collector -> {
            List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
            collector.add(tagValues, (conventionName, tagKeys) -> {
                Stream.Builder<Collector.MetricFamilySamples.Sample> samples = Stream.builder();
                ValueAtPercentile[] percentileValues = summary.takeSnapshot().percentileValues();
                CountAtBucket[] histogramCounts = summary.histogramCounts();
                double count = summary.count();
                if (percentileValues.length > 0) {
                    ArrayList<String> quantileKeys = new ArrayList<String>(tagKeys);
                    quantileKeys.add("quantile");
                    for (ValueAtPercentile v : percentileValues) {
                        ArrayList<String> quantileValues = new ArrayList<String>(tagValues);
                        quantileValues.add(Collector.doubleToGoString(v.percentile()));
                        samples.add(new Collector.MetricFamilySamples.Sample(conventionName, quantileKeys, quantileValues, v.value()));
                    }
                }
                Collector.Type type = Collector.Type.SUMMARY;
                if (histogramCounts.length > 0) {
                    type = Collector.Type.HISTOGRAM;
                    ArrayList<String> histogramKeys = new ArrayList<String>(tagKeys);
                    String sampleName = conventionName + "_bucket";
                    switch (summary.histogramFlavor()) {
                        case Prometheus: {
                            histogramKeys.add("le");
                            Exemplar[] exemplars = summary.exemplars();
                            for (int i = 0; i < histogramCounts.length; ++i) {
                                CountAtBucket c = histogramCounts[i];
                                ArrayList<String> histogramValues = new ArrayList<String>(tagValues);
                                histogramValues.add(Collector.doubleToGoString(c.bucket()));
                                if (exemplars == null) {
                                    samples.add(new Collector.MetricFamilySamples.Sample(sampleName, histogramKeys, histogramValues, c.count()));
                                    continue;
                                }
                                samples.add(new Collector.MetricFamilySamples.Sample(sampleName, histogramKeys, histogramValues, c.count(), exemplars[i]));
                            }
                            if (!Double.isFinite(histogramCounts[histogramCounts.length - 1].bucket())) break;
                            ArrayList<String> histogramValues = new ArrayList<String>(tagValues);
                            histogramValues.add("+Inf");
                            if (exemplars == null) {
                                samples.add(new Collector.MetricFamilySamples.Sample(sampleName, histogramKeys, histogramValues, count));
                                break;
                            }
                            samples.add(new Collector.MetricFamilySamples.Sample(sampleName, histogramKeys, histogramValues, count, exemplars[exemplars.length - 1]));
                            break;
                        }
                        case VictoriaMetrics: {
                            histogramKeys.add("vmrange");
                            for (CountAtBucket c : histogramCounts) {
                                ArrayList<String> histogramValuesVM = new ArrayList<String>(tagValues);
                                histogramValuesVM.add(FixedBoundaryVictoriaMetricsHistogram.getRangeTagValue(c.bucket()));
                                samples.add(new Collector.MetricFamilySamples.Sample(sampleName, histogramKeys, histogramValuesVM, c.count()));
                            }
                            break;
                        }
                    }
                }
                samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_count", tagKeys, tagValues, count));
                samples.add(new Collector.MetricFamilySamples.Sample(conventionName + "_sum", tagKeys, tagValues, summary.totalAmount()));
                return Stream.of(new MicrometerCollector.Family(type, conventionName, samples.build()), new MicrometerCollector.Family(Collector.Type.GAUGE, conventionName + "_max", new Collector.MetricFamilySamples.Sample(conventionName + "_max", tagKeys, tagValues, summary.max())));
            });
        });
        return summary;
    }

    @Override
    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        PrometheusTimer timer = new PrometheusTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.prometheusConfig.histogramFlavor(), this.exemplarSampler);
        this.applyToCollector(id, collector -> this.addDistributionStatisticSamples(distributionStatisticConfig, (MicrometerCollector)collector, timer, timer::exemplars, PrometheusMeterRegistry.tagValues(id), false));
        return timer;
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        DefaultGauge gauge = new DefaultGauge(id, obj, valueFunction);
        this.applyToCollector(id, collector -> {
            List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
            collector.add(tagValues, (conventionName, tagKeys) -> Stream.of(new MicrometerCollector.Family(Collector.Type.GAUGE, conventionName, new Collector.MetricFamilySamples.Sample(conventionName, tagKeys, tagValues, gauge.value()))));
        });
        return gauge;
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        CumulativeHistogramLongTaskTimer ltt = new CumulativeHistogramLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig);
        this.applyToCollector(id, collector -> this.addDistributionStatisticSamples(distributionStatisticConfig, (MicrometerCollector)collector, ltt, () -> null, PrometheusMeterRegistry.tagValues(id), true));
        return ltt;
    }

    @Override
    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        CumulativeFunctionTimer ft = new CumulativeFunctionTimer(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
        this.applyToCollector(id, collector -> {
            List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
            collector.add(tagValues, (conventionName, tagKeys) -> Stream.of(new MicrometerCollector.Family(Collector.Type.SUMMARY, conventionName, new Collector.MetricFamilySamples.Sample(conventionName + "_count", tagKeys, tagValues, ft.count()), new Collector.MetricFamilySamples.Sample(conventionName + "_sum", tagKeys, tagValues, ft.totalTime(TimeUnit.SECONDS)))));
        });
        return ft;
    }

    @Override
    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        CumulativeFunctionCounter fc = new CumulativeFunctionCounter(id, obj, countFunction);
        this.applyToCollector(id, collector -> {
            List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
            collector.add(tagValues, (conventionName, tagKeys) -> Stream.of(new MicrometerCollector.Family(Collector.Type.COUNTER, conventionName, new Collector.MetricFamilySamples.Sample(conventionName, tagKeys, tagValues, fc.count()))));
        });
        return fc;
    }

    @Override
    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        Collector.Type promType = Collector.Type.UNKNOWN;
        switch (type) {
            case COUNTER: {
                promType = Collector.Type.COUNTER;
                break;
            }
            case GAUGE: {
                promType = Collector.Type.GAUGE;
                break;
            }
            case DISTRIBUTION_SUMMARY: 
            case TIMER: {
                promType = Collector.Type.SUMMARY;
            }
        }
        Collector.Type finalPromType = promType;
        this.applyToCollector(id, collector -> {
            List<String> tagValues = PrometheusMeterRegistry.tagValues(id);
            collector.add(tagValues, (conventionName, tagKeys) -> {
                ArrayList<String> statKeys = new ArrayList<String>(tagKeys);
                statKeys.add("statistic");
                return Stream.of(new MicrometerCollector.Family(finalPromType, conventionName, StreamSupport.stream(measurements.spliterator(), false).map(m -> {
                    ArrayList<String> statValues = new ArrayList<String>(tagValues);
                    statValues.add(m.getStatistic().toString());
                    String name = conventionName;
                    switch (m.getStatistic()) {
                        case TOTAL: 
                        case TOTAL_TIME: {
                            name = name + "_sum";
                            break;
                        }
                        case MAX: {
                            name = name + "_max";
                            break;
                        }
                        case ACTIVE_TASKS: {
                            name = name + "_active_count";
                            break;
                        }
                        case DURATION: {
                            name = name + "_duration_sum";
                        }
                    }
                    return new Collector.MetricFamilySamples.Sample(name, statKeys, statValues, m.getValue());
                })));
            });
        });
        return new DefaultMeter(id, type, measurements);
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    public CollectorRegistry getPrometheusRegistry() {
        return this.registry;
    }

    private void addDistributionStatisticSamples(DistributionStatisticConfig distributionStatisticConfig, MicrometerCollector collector, HistogramSupport histogramSupport, Supplier<Exemplar[]> exemplarsSupplier, List<String> tagValues, boolean forLongTaskTimer) {
        collector.add(tagValues, (conventionName, tagKeys) -> {
            Collector.Type type;
            Stream.Builder<Collector.MetricFamilySamples.Sample> samples = Stream.builder();
            HistogramSnapshot histogramSnapshot = histogramSupport.takeSnapshot();
            ValueAtPercentile[] percentileValues = histogramSnapshot.percentileValues();
            CountAtBucket[] histogramCounts = histogramSnapshot.histogramCounts();
            double count = histogramSnapshot.count();
            if (percentileValues.length > 0) {
                ArrayList<String> quantileKeys = new ArrayList<String>(tagKeys);
                quantileKeys.add("quantile");
                for (ValueAtPercentile v : percentileValues) {
                    ArrayList<String> quantileValues = new ArrayList<String>(tagValues);
                    quantileValues.add(Collector.doubleToGoString(v.percentile()));
                    samples.add(new Collector.MetricFamilySamples.Sample(conventionName, quantileKeys, quantileValues, v.value(TimeUnit.SECONDS)));
                }
            }
            Collector.Type type2 = type = distributionStatisticConfig.isPublishingHistogram() ? Collector.Type.HISTOGRAM : Collector.Type.SUMMARY;
            if (histogramCounts.length > 0) {
                type = Collector.Type.HISTOGRAM;
                ArrayList<String> histogramKeys = new ArrayList<String>(tagKeys);
                String sampleName = conventionName + "_bucket";
                switch (this.prometheusConfig.histogramFlavor()) {
                    case Prometheus: {
                        histogramKeys.add("le");
                        Exemplar[] exemplars = (Exemplar[])exemplarsSupplier.get();
                        for (int i = 0; i < histogramCounts.length; ++i) {
                            CountAtBucket c = histogramCounts[i];
                            ArrayList<String> histogramValues = new ArrayList<String>(tagValues);
                            histogramValues.add(Collector.doubleToGoString(c.bucket(TimeUnit.SECONDS)));
                            if (exemplars == null) {
                                samples.add(new Collector.MetricFamilySamples.Sample(sampleName, histogramKeys, histogramValues, c.count()));
                                continue;
                            }
                            samples.add(new Collector.MetricFamilySamples.Sample(sampleName, histogramKeys, histogramValues, c.count(), exemplars[i]));
                        }
                        ArrayList<String> histogramValues = new ArrayList<String>(tagValues);
                        histogramValues.add("+Inf");
                        if (exemplars == null) {
                            samples.add(new Collector.MetricFamilySamples.Sample(sampleName, histogramKeys, histogramValues, count));
                            break;
                        }
                        samples.add(new Collector.MetricFamilySamples.Sample(sampleName, histogramKeys, histogramValues, count, exemplars[exemplars.length - 1]));
                        break;
                    }
                    case VictoriaMetrics: {
                        histogramKeys.add("vmrange");
                        for (CountAtBucket c : histogramCounts) {
                            ArrayList<String> histogramValuesVM = new ArrayList<String>(tagValues);
                            histogramValuesVM.add(FixedBoundaryVictoriaMetricsHistogram.getRangeTagValue(c.bucket()));
                            samples.add(new Collector.MetricFamilySamples.Sample(sampleName, histogramKeys, histogramValuesVM, c.count()));
                        }
                        break;
                    }
                }
            }
            samples.add(new Collector.MetricFamilySamples.Sample(conventionName + (forLongTaskTimer ? "_active_count" : "_count"), tagKeys, tagValues, count));
            samples.add(new Collector.MetricFamilySamples.Sample(conventionName + (forLongTaskTimer ? "_duration_sum" : "_sum"), tagKeys, tagValues, histogramSnapshot.total(TimeUnit.SECONDS)));
            return Stream.of(new MicrometerCollector.Family(type, conventionName, samples.build()), new MicrometerCollector.Family(Collector.Type.GAUGE, conventionName + "_max", Stream.of(new Collector.MetricFamilySamples.Sample(conventionName + "_max", tagKeys, tagValues, histogramSnapshot.max(this.getBaseTimeUnit())))));
        });
    }

    private void onMeterRemoved(Meter meter) {
        MicrometerCollector collector = (MicrometerCollector)this.collectorMap.get(this.getConventionName(meter.getId()));
        if (collector != null) {
            collector.remove(PrometheusMeterRegistry.tagValues(meter.getId()));
            if (collector.isEmpty()) {
                this.collectorMap.remove(this.getConventionName(meter.getId()));
                this.getPrometheusRegistry().unregister(collector);
            }
        }
    }

    private void applyToCollector(Meter.Id id, Consumer<MicrometerCollector> consumer) {
        this.collectorMap.compute(this.getConventionName(id), (name, existingCollector) -> {
            if (existingCollector == null) {
                MicrometerCollector micrometerCollector = new MicrometerCollector(id, this.config().namingConvention(), this.prometheusConfig);
                consumer.accept(micrometerCollector);
                return (MicrometerCollector)micrometerCollector.register(this.registry);
            }
            List tagKeys = this.getConventionTags(id).stream().map(Tag::getKey).collect(Collectors.toList());
            if (existingCollector.getTagKeys().equals(tagKeys)) {
                consumer.accept((MicrometerCollector)existingCollector);
                return existingCollector;
            }
            this.meterRegistrationFailed(id, "Prometheus requires that all meters with the same name have the same set of tag keys. There is already an existing meter named '" + id.getName() + "' containing tag keys [" + String.join((CharSequence)", ", ((MicrometerCollector)this.collectorMap.get(this.getConventionName(id))).getTagKeys()) + "]. The meter you are attempting to register has keys [" + this.getConventionTags(id).stream().map(Tag::getKey).collect(Collectors.joining(", ")) + "].");
            return existingCollector;
        });
    }

    @Override
    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.prometheusConfig.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    public PrometheusMeterRegistry throwExceptionOnRegistrationFailure() {
        this.config().onMeterRegistrationFailed((id, reason) -> {
            throw new IllegalArgumentException((String)reason);
        });
        return this;
    }
}

