/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.schemagen.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.schemagen.internal.DocumentationWriter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Type
extends Enum<Type> {
    public static final /* enum */ Type STRING;
    public static final /* enum */ Type BOOLEAN;
    public static final /* enum */ Type BYTE;
    public static final /* enum */ Type CHAR;
    public static final /* enum */ Type DOUBLE;
    public static final /* enum */ Type FLOAT;
    public static final /* enum */ Type INTEGER;
    public static final /* enum */ Type LONG;
    public static final /* enum */ Type SHORT;
    public static final /* enum */ Type PASSWORD;
    public static final /* enum */ Type PASSWORD_IBM;
    public static final /* enum */ Type PASSWORD_HASH;
    public static final /* enum */ Type DURATION;
    public static final /* enum */ Type DURATION_HOUR;
    public static final /* enum */ Type DURATION_MINUTE;
    public static final /* enum */ Type DURATION_SECOND;
    public static final /* enum */ Type ON_ERROR;
    public static final /* enum */ Type LOCATION;
    public static final /* enum */ Type LOCATION_DIR;
    public static final /* enum */ Type LOCATION_FILE;
    public static final /* enum */ Type LOCATION_URL;
    public static final /* enum */ Type TOKEN;
    public static final /* enum */ Type PID;
    public static final /* enum */ Type PID_LIST;
    public static final /* enum */ Type VARIABLE;
    private int typeId;
    private String globalSchemaType;
    private String schemaBaseType;
    private MinMaxWriter minMaxWriter;
    private static final /* synthetic */ Type[] $VALUES;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static Type[] values() {
        return (Type[])$VALUES.clone();
    }

    public static Type valueOf(String name) {
        return Enum.valueOf(Type.class, name);
    }

    private Type(int id, String globalType, String schemaType, MinMaxWriter mmw) {
        this.typeId = id;
        this.globalSchemaType = globalType;
        this.schemaBaseType = schemaType;
        this.minMaxWriter = mmw;
    }

    public static Type fromId(int id) {
        Type[] types = Type.values();
        for (int i = 0; i < types.length; ++i) {
            if (types[i].getTypeId() != id) continue;
            return types[i];
        }
        return null;
    }

    public static Type fromId(String globalType) {
        Type[] types = Type.values();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].getGlobalSchemaType().equals(globalType)) continue;
            return types[i];
        }
        return null;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getGlobalSchemaType() {
        return this.globalSchemaType;
    }

    public String getSchemaBaseType() {
        return this.schemaBaseType;
    }

    public void writeGlobalType(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "simpleType");
        writer.writeAttribute("name", this.getGlobalSchemaType());
        writer.writeEmptyElement("http://www.w3.org/2001/XMLSchema", "union");
        writer.writeAttribute("memberTypes", this.getSchemaBaseType() + " variableType");
        writer.writeEndElement();
    }

    public void writeType(XMLStreamWriter writer, DocumentationWriter documentationWriter) throws XMLStreamException {
        writer.writeAttribute("type", this.getGlobalSchemaType());
        documentationWriter.writeDoc();
    }

    @FFDCIgnore(value={NumberFormatException.class})
    public void writeType(XMLStreamWriter writer, String min, String max, DocumentationWriter documentationWriter) throws XMLStreamException {
        if (min != null) {
            try {
                Integer.parseInt(min);
            }
            catch (NumberFormatException e) {
                min = null;
            }
        }
        if (max != null) {
            try {
                Integer.parseInt(max);
            }
            catch (NumberFormatException e) {
                max = null;
            }
        }
        if (min == null && max == null || this.minMaxWriter == null) {
            this.writeType(writer, documentationWriter);
        } else {
            documentationWriter.writeDoc();
            this.minMaxWriter.writeType(writer, this.getSchemaBaseType(), min, max);
        }
    }

    private static void writePatternType(XMLStreamWriter writer, String name, String pattern) throws XMLStreamException {
        writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "simpleType");
        writer.writeAttribute("name", name);
        writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "restriction");
        writer.writeAttribute("base", "xsd:string");
        writer.writeEmptyElement("http://www.w3.org/2001/XMLSchema", "pattern");
        writer.writeAttribute("value", pattern);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(Type.class);
        STRING = new Type(1, "xsd:string", "xsd:string", MinMaxWriter.STRING){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void writeGlobalType(XMLStreamWriter writer) throws XMLStreamException {
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
        BOOLEAN = new Type(11, "booleanType", "xsd:boolean", null){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void writeType(XMLStreamWriter writer, String min, String max, DocumentationWriter documentationWriter) throws XMLStreamException {
                this.writeType(writer, documentationWriter);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        };
        BYTE = new Type(6, "byteType", "xsd:byte", MinMaxWriter.NUMBER);
        CHAR = new Type(5, "charType", "char", null){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void writeGlobalType(XMLStreamWriter writer) throws XMLStreamException {
                writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "simpleType");
                writer.writeAttribute("name", "char");
                writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "restriction");
                writer.writeAttribute("base", "xsd:string");
                writer.writeEmptyElement("http://www.w3.org/2001/XMLSchema", "length");
                writer.writeAttribute("value", "1");
                writer.writeEndElement();
                writer.writeEndElement();
                super.writeGlobalType(writer);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        };
        DOUBLE = new Type(7, "doubleType", "xsd:double", MinMaxWriter.NUMBER);
        FLOAT = new Type(8, "floatType", "xsd:float", MinMaxWriter.NUMBER);
        INTEGER = new Type(3, "intType", "xsd:int", MinMaxWriter.NUMBER);
        LONG = new Type(2, "longType", "xsd:long", MinMaxWriter.NUMBER);
        SHORT = new Type(4, "shortType", "xsd:short", MinMaxWriter.NUMBER);
        PASSWORD = new Type(12, "password", "xsd:string", MinMaxWriter.STRING){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void writeGlobalType(XMLStreamWriter writer) throws XMLStreamException {
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(4.class);
            }
        };
        PASSWORD_IBM = new Type(1003, "password", "xsd:string", MinMaxWriter.STRING);
        PASSWORD_HASH = new Type(1008, "passwordHash", "xsd:string", MinMaxWriter.STRING);
        DURATION = new Type(1000, "duration", "xsd:string", null);
        DURATION_HOUR = new Type(1006, "hourDuration", "xsd:string", null);
        DURATION_MINUTE = new Type(1005, "minuteDuration", "xsd:string", null);
        DURATION_SECOND = new Type(1004, "secondDuration", "xsd:string", null);
        ON_ERROR = new Type(1007, "xsd:string", "xsd:string", null){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void writeGlobalType(XMLStreamWriter writer) throws XMLStreamException {
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(5.class);
            }
        };
        LOCATION = new Type(1002, "location", "xsd:string", null);
        LOCATION_DIR = new Type(1010, "dirLocation", "xsd:string", null);
        LOCATION_FILE = new Type(1009, "fileLocation", "xsd:string", null);
        LOCATION_URL = new Type(1011, "urlLocation", "xsd:string", null);
        TOKEN = new Type(1012, "tokenType", "xsd:token", MinMaxWriter.STRING);
        PID = new Type(1001, "pidType", "singlePidType", null){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void writeGlobalType(XMLStreamWriter writer) throws XMLStreamException {
                Type.writePatternType(writer, this.getSchemaBaseType(), "[^, ]+");
                super.writeGlobalType(writer);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(6.class);
            }
        };
        PID_LIST = new Type(-1, "pidListType", "multiplePidType", null){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void writeGlobalType(XMLStreamWriter writer) throws XMLStreamException {
                Type.writePatternType(writer, this.getSchemaBaseType(), "[^, ]+(\\s*,\\s*[^, ]+)*");
                super.writeGlobalType(writer);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(7.class);
            }
        };
        VARIABLE = new Type(-2, "variableType", "xsd:string", null){
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void writeGlobalType(XMLStreamWriter writer) throws XMLStreamException {
                Type.writePatternType(writer, this.getGlobalSchemaType(), ".*$\\{[^\\s\\}]*\\}.*");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(8.class);
            }
        };
        $VALUES = new Type[]{STRING, BOOLEAN, BYTE, CHAR, DOUBLE, FLOAT, INTEGER, LONG, SHORT, PASSWORD, PASSWORD_IBM, PASSWORD_HASH, DURATION, DURATION_HOUR, DURATION_MINUTE, DURATION_SECOND, ON_ERROR, LOCATION, LOCATION_DIR, LOCATION_FILE, LOCATION_URL, TOKEN, PID, PID_LIST, VARIABLE};
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static abstract class MinMaxWriter
    extends Enum<MinMaxWriter> {
        public static final /* enum */ MinMaxWriter NUMBER;
        public static final /* enum */ MinMaxWriter STRING;
        private static final /* synthetic */ MinMaxWriter[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static MinMaxWriter[] values() {
            return (MinMaxWriter[])$VALUES.clone();
        }

        public static MinMaxWriter valueOf(String name) {
            return Enum.valueOf(MinMaxWriter.class, name);
        }

        public void writeType(XMLStreamWriter writer, String baseType, String min, String max) throws XMLStreamException {
            writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "simpleType");
            writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "union");
            writer.writeAttribute("memberTypes", "variableType");
            writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "simpleType");
            writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "restriction");
            writer.writeAttribute("base", baseType);
            this.writeLimits(writer, min, max);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }

        public abstract void writeLimits(XMLStreamWriter var1, String var2, String var3) throws XMLStreamException;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(MinMaxWriter.class);
            NUMBER = new MinMaxWriter(){
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void writeLimits(XMLStreamWriter writer, String min, String max) throws XMLStreamException {
                    if (min != null) {
                        writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "minInclusive");
                        writer.writeAttribute("value", min);
                        writer.writeEndElement();
                    }
                    if (max != null) {
                        writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "maxInclusive");
                        writer.writeAttribute("value", max);
                        writer.writeEndElement();
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            };
            STRING = new MinMaxWriter(){
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void writeLimits(XMLStreamWriter writer, String min, String max) throws XMLStreamException {
                    if (min != null) {
                        writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "minLength");
                        writer.writeAttribute("value", min);
                        writer.writeEndElement();
                    }
                    if (max != null) {
                        writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "maxLength");
                        writer.writeAttribute("value", max);
                        writer.writeEndElement();
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            };
            $VALUES = new MinMaxWriter[]{NUMBER, STRING};
        }
    }
}

