/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.weld.injection;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.impl.weld.injection.BindingResourceReferenceImpl;
import com.ibm.ws.cdi.impl.weld.injection.WebSphereInjectionServices;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ResourceReferenceFactoryImpl<T>
implements ResourceReferenceFactory<T> {
    private static final TraceComponent tc = Tr.register(ResourceReferenceFactoryImpl.class);
    private final WebSphereInjectionServices webSphereInjectionServices;
    private final InjectionPoint injectionPoint;
    private final Class<?> targetClass;
    private InjectionBinding<?> binding = null;
    static final long serialVersionUID = 8355468318217036659L;

    public ResourceReferenceFactoryImpl(WebSphereInjectionServices webSphereInjectionServices, InjectionPoint injectionPoint) {
        this.webSphereInjectionServices = webSphereInjectionServices;
        this.injectionPoint = injectionPoint;
        Bean bean = injectionPoint.getBean();
        this.targetClass = bean != null ? bean.getBeanClass() : injectionPoint.getMember().getDeclaringClass();
    }

    public ResourceReference<T> createResource() {
        if (this.binding == null) {
            InjectionTarget[] targets;
            block6: {
                targets = null;
                try {
                    targets = this.webSphereInjectionServices.getInjectionTargets(this.targetClass);
                }
                catch (CDIException cDIException) {
                    FFDCFilter.processException((Throwable)cDIException, (String)"com.ibm.ws.cdi.impl.weld.injection.ResourceReferenceFactoryImpl", (String)"68", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)"Could not find anything to inject for ", (Object[])new Object[]{this.injectionPoint.getMember()});
                }
            }
            if (targets != null && targets.length > 0) {
                for (InjectionTarget target : targets) {
                    if (!target.getMember().equals(this.injectionPoint.getMember())) continue;
                    this.binding = target.getInjectionBinding();
                    break;
                }
            }
        }
        ResourceReference<T> reference = null;
        if (this.binding != null) {
            reference = this.createResourceReference(this.binding);
        }
        return reference;
    }

    private <S extends Annotation> ResourceReference<T> createResourceReference(InjectionBinding<S> binding) {
        return new BindingResourceReferenceImpl(binding);
    }
}

