/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.weld.injection;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.impl.weld.injection.WebSphereInjectionServices;
import com.ibm.ws.cdi.interfaces.CDIRuntime;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.InjectionEngine;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Inject;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.ws.WebServiceRef;
import org.jboss.weld.bean.proxy.InterceptedSubclassFactory;
import org.jboss.weld.injection.spi.InjectionContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebSphereInjectionServicesImpl
implements WebSphereInjectionServices {
    static final TraceComponent tc = Tr.register(WebSphereInjectionServicesImpl.class);
    private static final Set<Class<?>> ANNOTATIONS_KNOWN_TO_WELD = new HashSet<Class>(Arrays.asList(Inject.class, EJB.class, Resource.class, WebServiceRef.class, PersistenceContext.class, PersistenceUnit.class));
    private final InjectionEngine injectionEngine;
    private final Map<Class<?>, ReferenceContext> referenceContextMap = new HashMap();
    private final Set<ReferenceContext> referenceContexts = new HashSet<ReferenceContext>();
    static final long serialVersionUID = 421894837224870343L;

    public WebSphereInjectionServicesImpl(CDIRuntime cdiRuntime) {
        this.injectionEngine = cdiRuntime.getInjectionEngine();
    }

    public void addReferenceContext(ReferenceContext referenceContext) {
        this.referenceContexts.add(referenceContext);
        Set classes = referenceContext.getProcessedInjectionClasses();
        for (Class clazz : classes) {
            this.referenceContextMap.put(clazz, referenceContext);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void injectJavaEEResources(Object managedBeanInstance) {
        block6: {
            Object mbInstance = managedBeanInstance;
            if (mbInstance != null) {
                try {
                    Boolean hasTarget = this.callInject(mbInstance);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"hasTarget [" + hasTarget + "]"});
                    }
                    break block6;
                }
                catch (PrivilegedActionException hasTarget) {
                    void pae;
                    FFDCFilter.processException((Throwable)hasTarget, (String)"com.ibm.ws.cdi.impl.weld.injection.WebSphereInjectionServicesImpl", (String)"110", (Object)this, (Object[])new Object[]{managedBeanInstance});
                    Exception e = pae.getException();
                    if (tc.isErrorEnabled()) {
                        Tr.error((TraceComponent)tc, (String)"cdi.resource.injection.error.CWOWB1000E", (Object[])new Object[]{e.getLocalizedMessage()});
                    }
                    break block6;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"inject - null mbInstance", (Object[])new Object[0]);
            }
        }
    }

    private Boolean callInject(final Object mbInstance) throws PrivilegedActionException {
        Boolean hasTargets = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
            static final long serialVersionUID = 5628775274643621010L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() throws Exception {
                Boolean hasTargets = WebSphereInjectionServicesImpl.this.inject(mbInstance.getClass(), mbInstance);
                return hasTargets;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        return hasTargets;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private Boolean inject(Class<?> clazz, Object toInject) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"inject", (Object[])new Object[]{Util.identity((Object)toInject)});
        }
        Boolean hasTargets = Boolean.FALSE;
        InjectionTarget[] targets = this.getInjectionTargets(clazz, toInject);
        if (null != targets && targets.length > 0) {
            hasTargets = Boolean.TRUE;
            for (InjectionTarget target : targets) {
                if (ANNOTATIONS_KNOWN_TO_WELD.contains(target.getInjectionBinding().getAnnotationType())) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"skipping --> [" + target + "]"});
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"about to inject resource --> [" + target + "]"});
                }
                try {
                    this.injectionEngine.inject(toInject, target);
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.cdi.impl.weld.injection.WebSphereInjectionServicesImpl", (String)"159", (Object)this, (Object[])new Object[]{clazz, toInject});
                    if (tc.isErrorEnabled()) {
                        Tr.error((TraceComponent)tc, (String)"cdi.resource.injection.error.CWOWB1000E", (Object[])new Object[]{e.getMessage()});
                    }
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".inject"), (String)"248", (Object)this);
                    throw e;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"injected resource --> [" + target + "]"});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"inject");
        }
        return hasTargets;
    }

    @Override
    public InjectionTarget[] getInjectionTargets(Class<?> clazz) throws CDIException {
        return this.getInjectionTargets(clazz, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    InjectionTarget[] getInjectionTargets(Class<?> clazz, Object toInject) throws CDIException {
        ReferenceContext referenceContext;
        Class<?> injectionClass = clazz;
        if (toInject != null && InterceptedSubclassFactory.isProxy((Object)toInject)) {
            injectionClass = clazz.getSuperclass();
        }
        if ((referenceContext = this.referenceContextMap.get(injectionClass)) == null) {
            referenceContext = this.findReferenceContext(injectionClass);
        }
        InjectionTarget[] targets = null;
        if (referenceContext != null) {
            try {
                targets = referenceContext.getInjectionTargets(injectionClass);
                if (targets != null && targets.length > 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"getInjectionTargets", (Object[])new Object[]{injectionClass + " injection targets found " + Arrays.asList(targets)});
                    }
                    for (InjectionTarget target : targets) {
                        Class<?> declaringClass = target.getMember().getDeclaringClass();
                        if (declaringClass == clazz || this.referenceContextMap.containsKey(declaringClass)) continue;
                        this.referenceContextMap.put(declaringClass, referenceContext);
                    }
                    return targets;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return targets;
                Tr.debug((TraceComponent)tc, (String)"getInjectionTargets", (Object[])new Object[]{injectionClass + " no injection targets found"});
                return targets;
            }
            catch (InjectionException injectionException) {
                void e;
                FFDCFilter.processException((Throwable)injectionException, (String)"com.ibm.ws.cdi.impl.weld.injection.WebSphereInjectionServicesImpl", (String)"224", (Object)this, (Object[])new Object[]{clazz, toInject});
                throw new CDIException((Throwable)e);
            }
        } else {
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return targets;
            Tr.debug((TraceComponent)tc, (String)"getInjectionTargets", (Object[])new Object[]{injectionClass + " ReferenceContext not found"});
        }
        return targets;
    }

    private ReferenceContext findReferenceContext(Class<?> injectionClass) {
        ReferenceContext referenceContext = null;
        for (ReferenceContext ctx : this.referenceContexts) {
            Set clazzes = ctx.getProcessedInjectionClasses();
            if (!clazzes.contains(injectionClass)) continue;
            referenceContext = ctx;
            this.addReferenceContext(referenceContext);
        }
        return referenceContext;
    }

    public void cleanup() {
    }

    public <T> void aroundInject(final InjectionContext<T> injectionContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Annotations: " + injectionContext.getAnnotatedType()), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Perform EE injection.", (Object[])new Object[0]);
        }
        this.injectJavaEEResources(injectionContext.getTarget());
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = -4095719878981672489L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                injectionContext.proceed();
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
    }

    public <T> void registerInjectionTarget(javax.enterprise.inject.spi.InjectionTarget<T> injectionTarget, AnnotatedType<T> annotatedType) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Injection Target Annotations: " + annotatedType.getAnnotations()), (Object[])new Object[0]);
        }
    }
}

