/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.liberty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.cdi12.cdiContainer", service={CDI12ContainerConfig.class}, configurationPid={"com.ibm.ws.cdi12.cdiContainer"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"service.vendor=IBM"})
public class CDI12ContainerConfig {
    private static final TraceComponent tc = Tr.register(CDI12ContainerConfig.class);
    private static final AtomicReference<CDI12ContainerConfig> INSTANCE = new AtomicReference();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private boolean hasLoggedNoImplicitMsg = false;
    static final long serialVersionUID = 6195743458155510320L;

    protected void activate(ComponentContext compcontext, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Activating " + this), (Object[])new Object[0]);
        }
        INSTANCE.set(this);
        this.updateConfiguration(properties);
    }

    protected void deactivate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deactivating " + this), (Object[])new Object[0]);
        }
        INSTANCE.compareAndSet(this, null);
    }

    @Modified
    protected void modified(ComponentContext compcontext, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Modifying " + this), (Object[])new Object[0]);
        }
        this.updateConfiguration(properties);
    }

    protected void updateConfiguration(Map<String, Object> properties) {
        if (properties != null) {
            this.properties.clear();
            this.properties.putAll(properties);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Current Properties: " + this.properties), (Object[])new Object[0]);
        }
    }

    public boolean isImplicitBeanArchivesScanningDisabled() {
        boolean enableImplicitBeanArchivesValue = (Boolean)this.properties.get("enableImplicitBeanArchives");
        if (tc.isWarningEnabled() && !this.hasLoggedNoImplicitMsg && !enableImplicitBeanArchivesValue) {
            this.hasLoggedNoImplicitMsg = true;
            Tr.warning((TraceComponent)tc, (String)"implicit.bean.scanning.disabled.CWOWB1009W", (Object[])new Object[0]);
        }
        return !enableImplicitBeanArchivesValue;
    }
}

