/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.liberty;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.cdi.impl.AbstractCDIRuntime;
import com.ibm.ws.cdi.interfaces.Application;
import com.ibm.ws.cdi.interfaces.ArchiveType;
import com.ibm.ws.cdi.interfaces.CDIArchive;
import com.ibm.ws.cdi.interfaces.CDIRuntime;
import com.ibm.ws.cdi.interfaces.CDIUtils;
import com.ibm.ws.cdi.interfaces.EjbEndpointService;
import com.ibm.ws.cdi.interfaces.ExtensionArchive;
import com.ibm.ws.cdi.liberty.CDI12ContainerConfig;
import com.ibm.ws.cdi.liberty.JndiHelperComponentMetaData;
import com.ibm.ws.cdi.liberty.ProxyServicesImpl;
import com.ibm.ws.cdi.liberty.RuntimeFactory;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.metadata.MetaDataSlotService;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceRefConfigFactory;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.injectionengine.InjectionEngine;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.kernel.service.utils.ServiceAndServiceReferencePair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.enterprise.inject.spi.CDIProvider;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.cdi.liberty.CDIRuntimeImpl", service={ApplicationStateListener.class, CDIService.class}, property={"service.vendor=IBM"})
public class CDIRuntimeImpl
extends AbstractCDIRuntime
implements ApplicationStateListener,
CDIService,
CDIRuntime,
CDIProvider {
    private static final TraceComponent tc = Tr.register(CDIRuntimeImpl.class);
    private final AtomicServiceReference<MetaDataSlotService> metaDataSlotServiceSR = new AtomicServiceReference("metaDataSlotService");
    private final AtomicServiceReference<EjbEndpointService> ejbEndpointServiceSR = new AtomicServiceReference("ejbEndpointService");
    private final AtomicServiceReference<ClassLoadingService> classLoadingSRRef = new AtomicServiceReference("classLoadingService");
    private final AtomicServiceReference<EjbServices> ejbServices = new AtomicServiceReference("ejbServices");
    private final AtomicServiceReference<TransactionServices> transactionServices = new AtomicServiceReference("transactionServices");
    private final AtomicServiceReference<SecurityServices> securityServices = new AtomicServiceReference("securityServices");
    private final ConcurrentServiceReferenceSet<WebSphereCDIExtension> extensionsSR = new ConcurrentServiceReferenceSet("extensionService");
    private final AtomicServiceReference<ArtifactContainerFactory> containerFactorySRRef = new AtomicServiceReference("containerFactory");
    private final AtomicServiceReference<AdaptableModuleFactory> adaptableModuleFactorySRRef = new AtomicServiceReference("adaptableModuleFactory");
    private final AtomicServiceReference<InjectionEngine> injectionEngineServiceRef = new AtomicServiceReference("injectionEngine");
    private final AtomicServiceReference<ScheduledExecutorService> scheduledExecutorServiceRef = new AtomicServiceReference("scheduledExecutorService");
    private final AtomicServiceReference<ExecutorService> executorServiceRef = new AtomicServiceReference("executorService");
    private final AtomicServiceReference<CDI12ContainerConfig> containerConfigRef = new AtomicServiceReference("containerConfig");
    private final AtomicServiceReference<ResourceRefConfigFactory> resourceRefConfigFactoryRef = new AtomicServiceReference("resourceRefConfigFactory");
    private MetaDataSlot applicationSlot;
    private boolean isClientProcess;
    private RuntimeFactory runtimeFactory;
    private ProxyServicesImpl proxyServices;
    static final long serialVersionUID = -2058706800729178839L;

    public void activate(ComponentContext cc) {
        this.containerConfigRef.activate(cc);
        this.metaDataSlotServiceSR.activate(cc);
        this.ejbEndpointServiceSR.activate(cc);
        this.classLoadingSRRef.activate(cc);
        this.extensionsSR.activate(cc);
        this.applicationSlot = ((MetaDataSlotService)this.metaDataSlotServiceSR.getServiceWithException()).reserveMetaDataSlot(ApplicationMetaData.class);
        this.ejbServices.activate(cc);
        this.securityServices.activate(cc);
        this.transactionServices.activate(cc);
        this.containerFactorySRRef.activate(cc);
        this.scheduledExecutorServiceRef.activate(cc);
        this.executorServiceRef.activate(cc);
        this.adaptableModuleFactorySRRef.activate(cc);
        this.injectionEngineServiceRef.activate(cc);
        this.resourceRefConfigFactoryRef.activate(cc);
        this.runtimeFactory = new RuntimeFactory(this);
        this.proxyServices = new ProxyServicesImpl();
        this.start();
    }

    public void deactivate(ComponentContext cc) {
        this.stop();
        this.runtimeFactory = null;
        this.proxyServices = null;
        this.metaDataSlotServiceSR.deactivate(cc);
        this.ejbEndpointServiceSR.deactivate(cc);
        this.classLoadingSRRef.deactivate(cc);
        this.ejbServices.deactivate(cc);
        this.securityServices.deactivate(cc);
        this.transactionServices.deactivate(cc);
        this.extensionsSR.deactivate(cc);
        this.containerFactorySRRef.deactivate(cc);
        this.scheduledExecutorServiceRef.deactivate(cc);
        this.executorServiceRef.deactivate(cc);
        this.adaptableModuleFactorySRRef.deactivate(cc);
        this.injectionEngineServiceRef.deactivate(cc);
        this.containerConfigRef.deactivate(cc);
        this.resourceRefConfigFactoryRef.deactivate(cc);
    }

    @Reference(name="containerConfig", service=CDI12ContainerConfig.class)
    protected void setContainerConfig(ServiceReference<CDI12ContainerConfig> ref) {
        this.containerConfigRef.setReference(ref);
    }

    protected void unsetContainerConfig(ServiceReference<CDI12ContainerConfig> ref) {
        this.containerConfigRef.unsetReference(ref);
    }

    @Reference(name="executorService", service=ExecutorService.class)
    protected void setExecutorService(ServiceReference<ExecutorService> ref) {
        this.executorServiceRef.setReference(ref);
    }

    protected void unsetExecutorService(ServiceReference<ExecutorService> ref) {
        this.executorServiceRef.unsetReference(ref);
    }

    @Reference(name="scheduledExecutorService", service=ScheduledExecutorService.class, target="(deferrable=false)")
    protected void setScheduledExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.scheduledExecutorServiceRef.setReference(ref);
    }

    protected void unsetScheduledExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.scheduledExecutorServiceRef.unsetReference(ref);
    }

    @Reference(name="containerFactory", service=ArtifactContainerFactory.class, target="(&(category=DIR)(category=JAR)(category=BUNDLE))")
    protected void setContainerFactory(ServiceReference<ArtifactContainerFactory> ref) {
        this.containerFactorySRRef.setReference(ref);
    }

    protected void unsetContainerFactory(ServiceReference<ArtifactContainerFactory> ref) {
        this.containerFactorySRRef.unsetReference(ref);
    }

    @Reference(name="adaptableModuleFactory", service=AdaptableModuleFactory.class)
    protected void setAdaptableModuleFactory(ServiceReference<AdaptableModuleFactory> ref) {
        this.adaptableModuleFactorySRRef.setReference(ref);
    }

    protected void unsetAdaptableModuleFactory(ServiceReference<AdaptableModuleFactory> ref) {
        this.adaptableModuleFactorySRRef.unsetReference(ref);
    }

    @Reference(name="extensionService", service=WebSphereCDIExtension.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void setExtensionService(ServiceReference<WebSphereCDIExtension> reference) {
        this.extensionsSR.addReference(reference);
    }

    protected void unsetExtensionService(ServiceReference<WebSphereCDIExtension> reference) {
        this.extensionsSR.removeReference(reference);
    }

    @Reference(name="transactionServices", service=TransactionServices.class)
    protected void setTransactionServices(ServiceReference<TransactionServices> transactionServices) {
        this.transactionServices.setReference(transactionServices);
    }

    protected void unsetTransactionServices(ServiceReference<TransactionServices> transactionServices) {
        this.transactionServices.unsetReference(transactionServices);
    }

    @Reference(name="securityServices", service=SecurityServices.class)
    protected void setSecurityServices(ServiceReference<SecurityServices> securityServices) {
        this.securityServices.setReference(securityServices);
    }

    protected void unsetSecurityServices(ServiceReference<SecurityServices> securityServices) {
        this.securityServices.unsetReference(securityServices);
    }

    @Reference(name="ejbServices", service=EjbServices.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setEjbServices(ServiceReference<EjbServices> ejbServices) {
        this.ejbServices.setReference(ejbServices);
    }

    protected void unsetEjbServices(ServiceReference<EjbServices> ejbServices) {
        this.ejbServices.unsetReference(ejbServices);
    }

    @Reference(name="metaDataSlotService", service=MetaDataSlotService.class)
    protected void setMetaDataSlotService(ServiceReference<MetaDataSlotService> reference) {
        this.metaDataSlotServiceSR.setReference(reference);
    }

    protected void unsetMetaDataSlotService(ServiceReference<MetaDataSlotService> reference) {
        this.metaDataSlotServiceSR.unsetReference(reference);
    }

    @Reference(name="ejbEndpointService", service=EjbEndpointService.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setEjbEndpointService(ServiceReference<EjbEndpointService> reference) {
        this.ejbEndpointServiceSR.setReference(reference);
    }

    protected void unsetEjbEndpointService(ServiceReference<EjbEndpointService> reference) {
        this.ejbEndpointServiceSR.unsetReference(reference);
    }

    @Reference(name="resourceRefConfigFactory", service=ResourceRefConfigFactory.class)
    protected void setResourceRefConfigFactory(ServiceReference<ResourceRefConfigFactory> resourceRefConfigFactory) {
        this.resourceRefConfigFactoryRef.setReference(resourceRefConfigFactory);
    }

    protected void unsetResourceRefConfigFactory(ServiceReference<ResourceRefConfigFactory> resourceRefConfigFactory) {
        this.resourceRefConfigFactoryRef.unsetReference(resourceRefConfigFactory);
    }

    @Reference(name="classLoadingService", service=ClassLoadingService.class)
    protected void setClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingSRRef.setReference(ref);
    }

    protected void unsetClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingSRRef.unsetReference(ref);
    }

    @Reference(name="injectionEngine", service=InjectionEngine.class)
    protected void setInjectionEngine(ServiceReference<InjectionEngine> ref) {
        this.injectionEngineServiceRef.setReference(ref);
    }

    protected void unsetInjectionEngine(ServiceReference<InjectionEngine> ref) {
        this.injectionEngineServiceRef.unsetReference(ref);
    }

    @Reference(name="libertyProcess", service=LibertyProcess.class, target="(wlp.process.type=client)", cardinality=ReferenceCardinality.OPTIONAL)
    protected void setLibertyProcess(ServiceReference<LibertyProcess> sr) {
        this.isClientProcess = true;
    }

    @Override
    public ResourceRefConfigFactory getResourceRefConfigFactory() {
        return (ResourceRefConfigFactory)this.resourceRefConfigFactoryRef.getService();
    }

    @Override
    public TransactionServices getTransactionServices() {
        return (TransactionServices)this.transactionServices.getService();
    }

    @Override
    public SecurityServices getSecurityServices() {
        return (SecurityServices)this.securityServices.getService();
    }

    @Override
    public Iterator<ServiceAndServiceReferencePair<WebSphereCDIExtension>> getExtensionServices() {
        return this.extensionsSR.getServicesWithReferences();
    }

    public ArtifactContainerFactory getArtifactContainerFactory() {
        return (ArtifactContainerFactory)this.containerFactorySRRef.getService();
    }

    public AdaptableModuleFactory getAdaptableModuleFactory() {
        return (AdaptableModuleFactory)this.adaptableModuleFactorySRRef.getService();
    }

    @Override
    public MetaDataSlot getApplicationSlot() {
        return this.applicationSlot;
    }

    @Override
    public EjbEndpointService getEjbEndpointService() {
        return (EjbEndpointService)this.ejbEndpointServiceSR.getService();
    }

    @Override
    public InjectionEngine getInjectionEngine() {
        return (InjectionEngine)this.injectionEngineServiceRef.getService();
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return (ScheduledExecutorService)this.scheduledExecutorServiceRef.getService();
    }

    @Override
    public ExecutorService getExecutorService() {
        return (ExecutorService)this.executorServiceRef.getService();
    }

    @Override
    public boolean isClientProcess() {
        return this.isClientProcess;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
        ClassLoader newCL = null;
        ClassLoader oldCl = null;
        try {
            Application application = this.runtimeFactory.newApplication(appInfo);
            newCL = this.getRealAppClassLoader(application);
            if (newCL != null) {
                oldCl = CDIUtils.getAndSetLoader(newCL);
            }
            this.getCDIContainer().applicationStarting(application);
            if (oldCl == null) return;
        }
        catch (CDIException application) {
            try {
                void e;
                FFDCFilter.processException((Throwable)application, (String)"com.ibm.ws.cdi.liberty.CDIRuntimeImpl", (String)"380", (Object)this, (Object[])new Object[]{appInfo});
                throw new StateChangeException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (oldCl == null) throw throwable;
                CDIUtils.getAndSetLoader(oldCl);
                throw throwable;
            }
        }
        CDIUtils.getAndSetLoader(oldCl);
        return;
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        Application application = this.runtimeFactory.removeApplication(appInfo);
        try {
            this.getCDIContainer().applicationStopped(application);
        }
        catch (CDIException cDIException) {
            FFDCFilter.processException((Throwable)cDIException, (String)"com.ibm.ws.cdi.liberty.CDIRuntimeImpl", (String)"399", (Object)this, (Object[])new Object[]{appInfo});
        }
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)Util.identity((Object)this), (Object[])new Object[]{"applicationStarted", appInfo});
        }
    }

    public void applicationStopping(ApplicationInfo appInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)Util.identity((Object)this), (Object[])new Object[]{"applicationStopping", appInfo});
        }
    }

    @Override
    public boolean isImplicitBeanArchivesScanningDisabled(CDIArchive archive) {
        return ((CDI12ContainerConfig)this.containerConfigRef.getService()).isImplicitBeanArchivesScanningDisabled();
    }

    @Override
    public ExtensionArchive getExtensionArchiveForBundle(Bundle bundle, Set<String> extraClasses, Set<String> extraAnnotations, boolean applicationBDAsVisible, boolean extClassesOnly) throws CDIException {
        ExtensionArchive extensionArchive = this.runtimeFactory.getExtensionArchiveForBundle(bundle, extraClasses, extraAnnotations, applicationBDAsVisible, extClassesOnly);
        return extensionArchive;
    }

    @Override
    public ProxyServices getProxyServices() {
        return this.proxyServices;
    }

    @Override
    public void beginContext(CDIArchive archive) throws CDIException {
        JndiHelperComponentMetaData cmd = null;
        MetaData metaData = archive.getMetaData();
        if (archive.isModule()) {
            ModuleMetaData moduleMetaData = (ModuleMetaData)metaData;
            cmd = new JndiHelperComponentMetaData(moduleMetaData);
        } else {
            ApplicationMetaData applicationMetaData = (ApplicationMetaData)metaData;
            cmd = new JndiHelperComponentMetaData(applicationMetaData);
        }
        ComponentMetaDataAccessorImpl accessor = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        accessor.beginContext((ComponentMetaData)cmd);
    }

    public ClassLoader getRealAppClassLoader(Application application) {
        try {
            ArrayList<CDIArchive> moduleArchives = new ArrayList<CDIArchive>(application.getModuleArchives());
            if (moduleArchives.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)Util.identity((Object)this), (Object[])new Object[]{"Application {0} has no modules so no thread context class loader will be set, this is expected for an OSGI app.", application});
                }
                return null;
            }
            if (moduleArchives.size() == 1 && ArchiveType.WEB_MODULE == ((CDIArchive)moduleArchives.get(0)).getType()) {
                return ((CDIArchive)moduleArchives.get(0)).getClassLoader();
            }
            return application.getClassLoader();
        }
        catch (CDIException moduleArchives) {
            FFDCFilter.processException((Throwable)moduleArchives, (String)"com.ibm.ws.cdi.liberty.CDIRuntimeImpl", (String)"484", (Object)this, (Object[])new Object[]{application});
            return null;
        }
    }
}

