/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JmsBodyType;
import com.ibm.ws.sib.mfp.JsJmsStreamMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.impl.JsJmsMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsMsgList;
import com.ibm.ws.sib.mfp.impl.JsMsgObject;
import com.ibm.ws.sib.mfp.impl.JsMsgPart;
import com.ibm.ws.sib.mfp.impl.MFPUnsupportedEncodingRuntimeException;
import com.ibm.ws.sib.mfp.schema.JmsStreamBodyAccess;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.UnsupportedEncodingException;
import java.util.List;

final class JsJmsStreamMessageImpl
extends JsJmsMessageImpl
implements JsJmsStreamMessage {
    private static TraceComponent tc = SibTr.register(JsJmsStreamMessageImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final long serialVersionUID = 1L;
    private static final byte[] flattenedClassName;
    private static final int FLUFFED_STREAM_LIST_OVERHEAD;
    private transient int streamIndex = 0;
    private transient JsMsgList bodyList = null;

    JsJmsStreamMessageImpl() {
    }

    JsJmsStreamMessageImpl(int flag) throws MessageDecodeFailedException {
        super(flag);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.setFormat("JMS:stream");
        this.setBodyType(JmsBodyType.STREAM);
        if (flag != 2) {
            this.jmo.getPayloadPart().setPart(1, JmsStreamBodyAccess.schema);
            this.getPayload().setChoiceField(1, 0);
        }
        this.bodyList = null;
    }

    JsJmsStreamMessageImpl(JsMsgObject inJmo) {
        super(inJmo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>, inbound jmo ");
        }
    }

    @Override
    public Object readObject() throws UnsupportedEncodingException {
        if (this.streamIndex < this.getBodyList().size()) {
            return this.getBodyList().get(this.streamIndex++);
        }
        return JsJmsStreamMessage.END_OF_STREAM;
    }

    @Override
    public void clearBody() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearBody");
        }
        this.getPayload().setChoiceField(1, 0);
        this.bodyList = new JsMsgList(null);
        this.reset();
        this.clearCachedLengths();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearBody");
        }
    }

    @Override
    int guessPayloadLength() {
        int length = 0;
        try {
            List<Object> payload = this.getBodyList();
            length = payload.size() * 40;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return length;
    }

    @Override
    int guessFluffedDataSize() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"guessFluffedDataSize");
        }
        int total = 0;
        if (this.bodyList != null) {
            total += FLUFFED_STREAM_LIST_OVERHEAD;
            total += this.bodyList.size() * (FLUFFED_OBJECT_OVERHEAD + 30);
        } else {
            JsMsgPart part = this.getPayloadIfFluffed();
            if (part != null) {
                total += part.estimateFieldValueSize(0);
            } else {
                int payloadSize = this.jmo.getPayloadPart().getAssembledLengthIfKnown();
                if (payloadSize != -1) {
                    int flatListSize = payloadSize - 40;
                    int numEnts = flatListSize / 15;
                    if (numEnts > 0) {
                        total += numEnts * 86 + 72;
                    }
                } else {
                    total += this.getPayload().estimateFieldValueSize(0);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"guessFluffedDataSize", (Object)total);
        }
        return total;
    }

    JsMsgPart getPayload() {
        return this.getPayload(JmsStreamBodyAccess.schema);
    }

    List<Object> getBodyList() throws UnsupportedEncodingException {
        if (this.bodyList == null) {
            try {
                List list = (List)this.getPayload().getField(0);
                this.bodyList = new JsMsgList(list);
            }
            catch (MFPUnsupportedEncodingRuntimeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsJmsStreamMessageImpl.getBodyList", (String)"148");
                throw (UnsupportedEncodingException)e.getCause();
            }
        }
        return this.bodyList;
    }

    @Override
    void updateDataFields(int why) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateDataFields");
        }
        super.updateDataFields(why);
        if (this.bodyList != null && this.bodyList.isChanged()) {
            this.getPayload().setField(0, this.bodyList.getList());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateDataFields");
        }
    }

    @Override
    public void writeBoolean(boolean value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeBoolean", (Object)value);
        }
        this.getBodyList().add(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeBoolean");
        }
    }

    @Override
    public void writeByte(byte value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeByte", (Object)value);
        }
        this.getBodyList().add(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeByte");
        }
    }

    @Override
    public void writeShort(short value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeShort", (Object)value);
        }
        this.getBodyList().add(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeShort");
        }
    }

    @Override
    public void writeChar(char value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeChar", (Object)Character.valueOf(value));
        }
        this.getBodyList().add(Character.valueOf(value));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeChar");
        }
    }

    @Override
    public void writeInt(int value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeInt", (Object)value);
        }
        this.getBodyList().add(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeInt");
        }
    }

    @Override
    public void writeLong(long value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeLong", (Object)value);
        }
        this.getBodyList().add(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeLong");
        }
    }

    @Override
    public void writeFloat(float value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeFloat", (Object)new Float(value));
        }
        this.getBodyList().add(new Float(value));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeFloat");
        }
    }

    @Override
    public void writeDouble(double value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeDouble", (Object)new Double(value));
        }
        this.getBodyList().add(new Double(value));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeDouble");
        }
    }

    @Override
    public void writeString(String value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeString", (Object)value);
        }
        this.getBodyList().add(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeString");
        }
    }

    @Override
    public void writeBytes(byte[] value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeBytes", (Object)value);
        }
        this.getBodyList().add(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeBytes");
        }
    }

    @Override
    public void writeObject(Object value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeObject", (Object)value);
        }
        this.getBodyList().add(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeObject");
        }
    }

    @Override
    public void reset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reset");
        }
        this.streamIndex = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reset");
        }
    }

    @Override
    public void stepBack() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stepBack");
        }
        if (this.streamIndex > 0) {
            --this.streamIndex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stepBack");
        }
    }

    @Override
    public byte[] getUserFriendlyBytes() throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUserFriendlyBytes");
        }
        byte[] result = null;
        if (this.getBodyList().size() > 0) {
            int index = 0;
            StringBuilder buff = new StringBuilder();
            String lineSeparator = System.getProperty("line.separator");
            Object item = this.getBodyList().get(index++);
            if (item != null) {
                if (!(item instanceof byte[])) {
                    buff.append(item.toString());
                } else {
                    buff.append(new String((byte[])item));
                }
            }
            while (index < this.getBodyList().size()) {
                buff.append(lineSeparator);
                item = this.getBodyList().get(index++);
                if (item == null) continue;
                if (!(item instanceof byte[])) {
                    buff.append(item.toString());
                    continue;
                }
                buff.append(new String((byte[])item));
            }
            result = buff.toString().getBytes();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUserFriendlyBytes", result);
        }
        return result;
    }

    @Override
    final byte[] getFlattenedClassName() {
        return flattenedClassName;
    }

    static {
        FLUFFED_STREAM_LIST_OVERHEAD = FLUFFED_OBJECT_OVERHEAD + FLUFFED_REF_SIZE + FLUFFED_JMF_LIST_SIZE;
        flattenedClassName = JsJmsStreamMessageImpl.flattenClassName(JsJmsStreamMessageImpl.class.getName());
    }
}

