/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.gbs;

import com.ibm.ws.sib.msgstore.gbs.GBSTree;
import com.ibm.ws.sib.msgstore.gbs.InsertStack;
import com.ibm.ws.sib.msgstore.gbs.NodeInsertPoint;
import com.ibm.ws.sib.msgstore.gbs.NodeStack;
import com.ibm.ws.sib.msgstore.gbs.OptimisticDepthException;
import com.ibm.ws.sib.msgstore.gbs.SearchComparator;
import java.util.Comparator;

public class GBSNode {
    private GBSNode _leftChild;
    private GBSNode _rightChild;
    private short _balance;
    private short _population;
    private GBSTree _index;
    private Object[] _nodeKey;

    private GBSNode() {
    }

    public GBSNode(GBSTree index) {
        this._index = index;
        this._nodeKey = new Object[this.width()];
        this._population = 0;
        this._balance = 0;
    }

    public GBSNode(GBSTree index, Object key) {
        this._index = index;
        this._nodeKey = new Object[this.width()];
        this.reset(key);
    }

    public GBSNode(GBSTree index, int x) {
        this._index = index;
    }

    void reset(Object key) {
        this._nodeKey[0] = key;
        this._nodeKey[this.midPoint()] = key;
        this._population = 1;
        this._rightChild = null;
        this._leftChild = null;
        this._balance = 0;
    }

    GBSTree index() {
        return this._index;
    }

    public int kFactor() {
        return this.index().kFactor();
    }

    public GBSNode leftChild() {
        return this._leftChild;
    }

    public GBSNode rightChild() {
        return this._rightChild;
    }

    public Object key(int x) {
        return this._nodeKey[x];
    }

    String keyString(int x) {
        if (this.isDummy()) {
            return "---";
        }
        return this.key(x).toString();
    }

    public Object testKey(int x) {
        if (this.isDummy()) {
            return null;
        }
        return this.key(x);
    }

    public void testSetKey(int x, Object q) {
        this._nodeKey[x] = q;
    }

    public void testIncrementPopulation() {
        this._population = (short)(this._population + 1);
    }

    boolean hasChild() {
        boolean has = false;
        if (this.leftChild() != null || this.rightChild() != null) {
            has = true;
        }
        return has;
    }

    private boolean isDummy() {
        boolean x = false;
        if (this._nodeKey == null) {
            x = true;
        }
        return x;
    }

    public short balance() {
        if (this._balance == -1 || this._balance == 0 || this._balance == 1) {
            return this._balance;
        }
        String x = "Found invalid balance factor: " + this._balance;
        throw new RuntimeException(x);
    }

    void clearBalance() {
        this._balance = 0;
    }

    void setBalance(int b) {
        if (b != -1 && b != 0 && b != 1) {
            String x = "Attempt to set invalid balance factor: " + b;
            throw new IllegalArgumentException(x);
        }
        this._balance = (short)b;
    }

    public int population() {
        return this._population;
    }

    void decrementPopulation() {
        if (this._population <= 0) {
            String x = "Attempt to make node population negative.\nCurrent population = " + this._population + ".";
            throw new IllegalArgumentException(x);
        }
        this._population = (short)(this._population - 1);
    }

    public boolean isFull() {
        boolean full = false;
        if (this.population() == this.width()) {
            full = true;
        }
        return full;
    }

    public boolean isInnerNode() {
        boolean inner = true;
        if (this._leftChild == null || this._rightChild == null) {
            inner = false;
        }
        return inner;
    }

    public boolean isLeafNode() {
        boolean leaf = false;
        if (this._leftChild == null && this._rightChild == null) {
            leaf = true;
        }
        return leaf;
    }

    public int width() {
        return this.index().nodeWidth();
    }

    int midPoint() {
        return this.index().nodeMidPoint();
    }

    public Object middleKey() {
        return this._nodeKey[this.midPoint()];
    }

    public Object leftMostKey() {
        return this._nodeKey[0];
    }

    public String lmkString() {
        if (this.isDummy()) {
            return "---";
        }
        return this._nodeKey[0].toString();
    }

    private int endPoint() {
        int x = this.midPoint();
        int r = this.rightMostIndex();
        if (r < this.midPoint()) {
            x = r;
        }
        return x;
    }

    void findInsertPointInLeft(Object new1, NodeInsertPoint point) {
        int endp = this.endPoint();
        this.findIndex(0, endp, new1, point);
    }

    void findInsertPointInRight(Object new1, NodeInsertPoint point) {
        int m;
        int r = this.rightMostIndex();
        if (r <= (m = this.midPoint())) {
            String x = "Erroneous call to findInsertPointInRight(). rightMostIndex() = " + r + ", midPoint() = " + m + ".";
            throw new OptimisticDepthException(x);
        }
        this.findIndex(m + 1, r, new1, point);
    }

    public void setRightChild(GBSNode x) {
        this._rightChild = x;
    }

    void clearRightChild() {
        this._rightChild = null;
    }

    public void setLeftChild(GBSNode x) {
        this._leftChild = x;
    }

    void clearLeftChild() {
        this._leftChild = null;
    }

    public void setChildren(GBSNode left, GBSNode right) {
        this._leftChild = left;
        this._rightChild = right;
    }

    public int searchLeft(SearchComparator comp, Object searchKey) {
        int idx = -1;
        int top = this.middleIndex();
        idx = comp.type() == 1 ? this.findEqual(comp, 0, top, searchKey) : this.findGreater(comp, 0, top, searchKey);
        return idx;
    }

    public int searchRight(SearchComparator comp, Object searchKey) {
        int right;
        int idx = -1;
        int bot = this.middleIndex();
        if (bot > (right = this.rightMostIndex())) {
            String x = "bot = " + bot + ", right = " + right;
            throw new OptimisticDepthException(x);
        }
        idx = comp.type() == 1 ? this.findEqual(comp, bot, right, searchKey) : this.findGreater(comp, bot, right, searchKey);
        return idx;
    }

    int searchAll(SearchComparator comp, Object searchKey) {
        int idx = -1;
        idx = comp.type() == 1 ? this.findEqual(comp, 0, this.rightMostIndex(), searchKey) : this.findGreater(comp, 0, this.rightMostIndex(), searchKey);
        return idx;
    }

    private int findEqual(SearchComparator comp, int lower, int upper, Object searchKey) {
        int nkeys = GBSNode.numKeys(lower, upper);
        int idx = -1;
        idx = nkeys < 4 ? this.sequentialSearchEqual(comp, lower, upper, searchKey) : this.binarySearchEqual(comp, lower, upper, searchKey);
        return idx;
    }

    private int sequentialSearchEqual(SearchComparator comp, int lower, int upper, Object searchKey) {
        int idx = -1;
        for (int i = lower; i <= upper; ++i) {
            int xcc = comp.compare(searchKey, this._nodeKey[i]);
            if (xcc != 0) continue;
            idx = i;
            break;
        }
        return idx;
    }

    private int binarySearchEqual(SearchComparator comp, int lower, int upper, Object searchKey) {
        int idx = -1;
        while (lower <= upper) {
            int i = lower + upper >>> 1;
            int xcc = comp.compare(searchKey, this._nodeKey[i]);
            if (xcc < 0) {
                upper = i - 1;
                continue;
            }
            if (xcc > 0) {
                lower = i + 1;
                continue;
            }
            idx = i;
            break;
        }
        return idx;
    }

    private int findGreater(SearchComparator comp, int lower, int upper, Object searchKey) {
        int nkeys = GBSNode.numKeys(lower, upper);
        int idx = -1;
        idx = nkeys < 4 ? this.sequentialSearchGreater(comp, lower, upper, searchKey) : this.binarySearchGreater(comp, lower, upper, searchKey);
        return idx;
    }

    private int sequentialSearchGreater(SearchComparator comp, int lower, int upper, Object searchKey) {
        int idx = -1;
        for (int i = lower; i <= upper; ++i) {
            int xcc = comp.compare(searchKey, this._nodeKey[i]);
            if (xcc > 0) continue;
            idx = i;
            break;
        }
        return idx;
    }

    private int binarySearchGreater(SearchComparator comp, int lower, int upper, Object searchKey) {
        int idx = -1;
        while (lower <= upper) {
            int i = lower + upper >>> 1;
            int xcc = comp.compare(searchKey, this._nodeKey[i]);
            if (xcc < 0) {
                upper = i - 1;
                idx = i;
                continue;
            }
            if (xcc <= 0) continue;
            lower = i + 1;
        }
        return idx;
    }

    private void findIndex(int lower, int upper, Object new1, NodeInsertPoint point) {
        int nkeys = GBSNode.numKeys(lower, upper);
        if (nkeys < 4) {
            this.sequentialFindIndex(lower, upper, new1, point);
        } else {
            this.binaryFindIndex(lower, upper, new1, point);
        }
    }

    private void sequentialFindIndex(int lower, int upper, Object new1, NodeInsertPoint point) {
        Comparator comp = this.insertComparator();
        int lxcc = 1;
        int idx = this.rightMostIndex() + 1;
        for (int i = lower; i <= upper; ++i) {
            int xcc = comp.compare(new1, this._nodeKey[i]);
            if (xcc > 0) continue;
            idx = i;
            lxcc = xcc;
            break;
        }
        if (lxcc != 0) {
            point.setInsertPoint(idx - 1);
        } else {
            point.markDuplicate(idx);
        }
    }

    private void binaryFindIndex(int lower, int upper, Object new1, NodeInsertPoint point) {
        Comparator comp = this.insertComparator();
        int lxcc = 1;
        int idx = upper + 1;
        while (lower <= upper) {
            int i = lower + upper >>> 1;
            int xcc = comp.compare(new1, this._nodeKey[i]);
            if (xcc <= 0) {
                upper = i - 1;
                idx = i;
                lxcc = xcc;
                continue;
            }
            lower = i + 1;
        }
        if (lxcc != 0) {
            point.setInsertPoint(idx - 1);
        } else {
            point.markDuplicate(idx);
        }
    }

    int findDeleteInRight(Object delKey) {
        int m;
        int idx = -1;
        int r = this.rightMostIndex();
        if (r > (m = this.midPoint())) {
            idx = this.findDelete(m, r, delKey);
        }
        return idx;
    }

    int findDeleteInLeft(Object delKey) {
        int endp = this.endPoint();
        return this.findDelete(0, endp, delKey);
    }

    int findDelete(int lower, int upper, Object delKey) {
        int nkeys = GBSNode.numKeys(lower, upper);
        int idx = -1;
        idx = nkeys < 4 ? this.sequentialFindDelete(lower, upper, delKey) : this.binaryFindDelete(lower, upper, delKey);
        return idx;
    }

    private int sequentialFindDelete(int lower, int upper, Object delKey) {
        Comparator comp = this.deleteComparator();
        int idx = -1;
        for (int i = lower; i <= upper; ++i) {
            int xcc = comp.compare(delKey, this._nodeKey[i]);
            if (xcc != 0) continue;
            idx = i;
            break;
        }
        return idx;
    }

    private int binaryFindDelete(int lower, int upper, Object delKey) {
        Comparator comp = this.insertComparator();
        int idx = -1;
        while (lower <= upper) {
            int i = lower + upper >>> 1;
            int xcc = comp.compare(delKey, this._nodeKey[i]);
            if (xcc < 0) {
                upper = i - 1;
                continue;
            }
            if (xcc > 0) {
                lower = i + 1;
                continue;
            }
            idx = i;
            break;
        }
        return idx;
    }

    public Comparator insertComparator() {
        return this.index().insertComparator();
    }

    Comparator deleteComparator() {
        return this.index().deleteComparator();
    }

    private static int numKeys(int lower, int upper) {
        if (lower > upper) {
            String x = "Lower bound greater than upper bound.  lower = " + lower + ", upper = " + upper + ".";
            throw new IllegalArgumentException(x);
        }
        return upper - lower + 1;
    }

    public int rightMostIndex() {
        int x = this.population() - 1;
        if (x == -1) {
            throw new OptimisticDepthException("Empty Node.");
        }
        return x;
    }

    public int topMostIndex() {
        return this.width() - 1;
    }

    public int middleIndex() {
        int x = this.midPoint();
        int r = this.rightMostIndex();
        if (r < this.midPoint()) {
            x = r;
        }
        return x;
    }

    boolean lessThanHalfFull() {
        boolean result = false;
        if (this.rightMostIndex() <= this.midPoint()) {
            result = true;
        }
        return result;
    }

    public Object rightMostKey() {
        return this._nodeKey[this.rightMostIndex()];
    }

    void addRightLeaf(Object new1) {
        GBSNode p = this._index.getNode(new1);
        if (this.rightChild() != null) {
            throw new RuntimeException("Help!");
        }
        this.setRightChild(p);
    }

    Object insertByLeftShift(int ix, Object new1) {
        Object old1 = this.leftMostKey();
        this.leftShift(ix);
        this._nodeKey[ix] = new1;
        if (this.midPoint() > this.rightMostIndex()) {
            this._nodeKey[this.midPoint()] = this.rightMostKey();
        }
        return old1;
    }

    void deleteByLeftShift(int ix) {
        this.overlayLeftShift(ix);
        this._population = (short)(this._population - 1);
    }

    private void leftShift(int ix) {
        for (int j = 0; j < ix; ++j) {
            this._nodeKey[j] = this._nodeKey[j + 1];
        }
    }

    Object insertByRightShift(int ix, Object new1) {
        Object old1 = null;
        if (this.isFull()) {
            old1 = this.rightMostKey();
            this.rightMove(ix + 1);
            this._nodeKey[ix + 1] = new1;
        } else {
            this.rightShift(ix + 1);
            this._nodeKey[ix + 1] = new1;
            this._population = (short)(this._population + 1);
            if (this.midPoint() > this.rightMostIndex()) {
                this._nodeKey[this.midPoint()] = this.rightMostKey();
            }
        }
        return old1;
    }

    public Object addLeftMostKey(Object new1) {
        Object old1 = null;
        if (this.isFull()) {
            old1 = this.rightMostKey();
            this.rightMove(0);
            this._nodeKey[0] = new1;
        } else {
            this.rightShift(0);
            this._population = (short)(this._population + 1);
            this._nodeKey[0] = new1;
            if (this.midPoint() > this.rightMostIndex()) {
                this._nodeKey[this.midPoint()] = this.rightMostKey();
            }
        }
        return old1;
    }

    Object addRightMostKey(Object new1) {
        Object old1 = null;
        if (this.isFull()) {
            old1 = this.rightMostKey();
            this._nodeKey[this.rightMostIndex()] = new1;
        } else {
            this._population = (short)(this._population + 1);
            this._nodeKey[this.rightMostIndex()] = new1;
            if (this.midPoint() > this.rightMostIndex()) {
                this._nodeKey[this.midPoint()] = this.rightMostKey();
            }
        }
        return old1;
    }

    void addLeftMostKeyByDelete(int ix, Object new1) {
        this.overlayRightShift(ix);
        this.overlayLeftMostKey(new1);
    }

    void addRightMostKeyByDelete(int ix, Object new1) {
        this.overlayLeftShift(ix);
        this.overlayRightMostKey(new1);
    }

    void overlayLeftMostKey(Object new1) {
        this._nodeKey[0] = new1;
    }

    void overlayRightMostKey(Object new1) {
        this._nodeKey[this.rightMostIndex()] = new1;
    }

    void fillFromRight() {
        int gapWid = this.width() - this.population();
        int gidx = this.population();
        GBSNode p = this.rightChild();
        for (int j = 0; j < gapWid; ++j) {
            this._nodeKey[j + gidx] = p._nodeKey[j];
        }
        int delta = gapWid;
        if (p._population < delta) {
            delta = p._population;
        }
        this._population = (short)(this._population + delta);
        p._population = (short)(p._population - delta);
        for (int j = 0; j < gidx; ++j) {
            p._nodeKey[j] = p._nodeKey[j + gapWid];
        }
    }

    void adjustMedian() {
        if (this.midPoint() > this.rightMostIndex()) {
            this._nodeKey[this.midPoint()] = this.rightMostKey();
        }
    }

    GBSNode rightMostChild() {
        GBSNode q = this;
        for (GBSNode p = this.rightChild(); p != null; p = p.rightChild()) {
            q = p;
        }
        return q;
    }

    private void rightShift(int ix) {
        for (int j = this.rightMostIndex(); j >= ix; --j) {
            this._nodeKey[j + 1] = this._nodeKey[j];
        }
    }

    private void rightMove(int ix) {
        for (int j = this.rightMostIndex() - 1; j >= ix; --j) {
            this._nodeKey[j + 1] = this._nodeKey[j];
        }
    }

    void overlayLeftShift(int ix) {
        for (int j = ix; j < this.rightMostIndex(); ++j) {
            this._nodeKey[j] = this._nodeKey[j + 1];
        }
    }

    private void overlayRightShift(int ix) {
        for (int j = ix; j > 0; --j) {
            this._nodeKey[j] = this._nodeKey[j - 1];
        }
    }

    GBSNode lowerPredecessor(NodeStack stack) {
        GBSNode r;
        GBSNode lastr = r = this.leftChild();
        if (r != null) {
            stack.push(2, this);
        }
        while (r != null) {
            if (r.rightChild() != null) {
                stack.push(4, r);
            }
            lastr = r;
            r = r.rightChild();
        }
        return lastr;
    }

    GBSNode lowerSuccessor(NodeStack stack) {
        GBSNode r;
        GBSNode lastr = r = this.rightChild();
        if (r != null) {
            stack.push(4, this);
        }
        while (r != null) {
            if (r.leftChild() != null) {
                stack.push(2, r);
            }
            lastr = r;
            r = r.leftChild();
        }
        return lastr;
    }

    GBSNode leftMostChild(InsertStack stack) {
        stack.start(this, "GBSNode.leftMostChild");
        GBSNode lastl = this;
        for (GBSNode l = this.leftChild(); l != null; l = l.leftChild()) {
            stack.push(0, l);
            lastl = l;
        }
        return lastl;
    }

    public GBSNode testClone(GBSTree target) {
        GBSNode p = new GBSNode(target, this.leftMostKey());
        for (int j = 1; j < this.population(); ++j) {
            p._nodeKey[j] = this._nodeKey[j];
        }
        p._population = this._population;
        p.adjustMedian();
        return p;
    }

    public boolean validate() {
        boolean correct = true;
        if (this.population() > 1) {
            Comparator comp = this.index().insertComparator();
            int xcc = 0;
            for (int i = 0; i < this.population() - 1; ++i) {
                xcc = comp.compare(this._nodeKey[i], this._nodeKey[i + 1]);
                if (xcc < 0) continue;
                System.out.println("Entry " + i + " not less than entry " + i + 1);
                correct = false;
            }
        }
        return correct;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String x = "width = " + this.width() + ", midPoint = " + this.midPoint() + ", population = " + this.population() + ", rightMostIndex = " + this.rightMostIndex() + ", balance = " + this.balance();
        buf.append(x);
        if (this._nodeKey != null) {
            buf.append("\n ");
            buf.append("middleKey = " + this.middleKey());
            if (this.population() != 0) {
                buf.append("\n");
                buf.append("{");
                for (int i = 0; i <= this.rightMostIndex(); ++i) {
                    buf.append("[" + i + "]: " + this._nodeKey[i]);
                    if (i == this.rightMostIndex()) continue;
                    buf.append(", ");
                }
                buf.append("}\n ");
            }
            if (this.leftChild() != null) {
                buf.append("Has left child.");
            } else {
                buf.append("Left child null.");
            }
            if (this.rightChild() != null) {
                buf.append("  Has right child.");
            } else {
                buf.append("  Right child null.");
            }
        }
        String y = buf.toString();
        return y;
    }
}

