/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.archaius.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.config.archaius.impl.CachedCompositePropertyContainer;
import com.ibm.ws.microprofile.config.interfaces.ConfigException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyListener;
import com.netflix.archaius.property.ListenerManager;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicStampedReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class CachedCompositeProperty<T>
implements Property<T> {
    private static final TraceComponent tc = Tr.register(CachedCompositeProperty.class);
    private final AtomicStampedReference<T> cache = new AtomicStampedReference<Object>(null, -1);
    private final Class<T> type;
    private final T defaultValue;
    private final CachedCompositePropertyContainer parentContainer;
    static final long serialVersionUID = 3981994732776542102L;

    CachedCompositeProperty(Class<T> type, T defaultValue, CachedCompositePropertyContainer parentContainer) {
        this.type = type;
        this.defaultValue = defaultValue;
        this.parentContainer = parentContainer;
    }

    public void addListener(final PropertyListener<T> listener) {
        this.parentContainer.addListener(listener, new ListenerManager.ListenerUpdater(){
            private final AtomicReference<T> last = new AtomicReference<Object>(null);
            static final long serialVersionUID = 4337203540876017065L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            public void update() {
                Object value;
                Object prev = this.last.get();
                try {
                    value = CachedCompositeProperty.this.get();
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.config.archaius.impl.CachedCompositeProperty$1", (String)"65", (Object)this, (Object[])new Object[0]);
                    listener.onParseError((Throwable)e);
                    return;
                }
                if (prev != value && this.last.compareAndSet(prev, value)) {
                    listener.onChange(value);
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    public void removeListener(PropertyListener<T> listener) {
        this.parentContainer.removeListener(listener);
    }

    public String getKey() {
        return this.parentContainer.getKey();
    }

    /*
     * WARNING - void declaration
     */
    public T get() {
        int latestVersion;
        int cacheVersion = this.cache.getStamp();
        if (cacheVersion != (latestVersion = this.parentContainer.getMasterVersion())) {
            T currentValue = this.cache.getReference();
            T newValue = null;
            try {
                newValue = this.resolveCurrent();
            }
            catch (ConfigException configException) {
                void e;
                FFDCFilter.processException((Throwable)configException, (String)"com.ibm.ws.microprofile.config.archaius.impl.CachedCompositeProperty", (String)"109", (Object)this, (Object[])new Object[0]);
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.config.archaius.impl.CachedCompositeProperty", (String)"111", (Object)this, (Object[])new Object[0]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"get", (Object[])new Object[]{"Unable to get current version of property '" + this.parentContainer.getKey() + "'", e});
                }
                throw new ConfigException(e);
            }
            if (this.cache.compareAndSet(currentValue, newValue, cacheVersion, latestVersion)) {
                return this.firstNonNull(newValue, this.defaultValue);
            }
        }
        return this.firstNonNull(this.cache.getReference(), this.defaultValue);
    }

    private T firstNonNull(T first, T second) {
        return first == null ? second : first;
    }

    protected abstract T resolveCurrent() throws Exception;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CachedCompositeProperty other = (CachedCompositeProperty)obj;
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        return this.type == other.type;
    }
}

