/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.archaius.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.config.archaius.impl.CachedCompositeProperty;
import com.ibm.ws.microprofile.config.archaius.impl.CompositeConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyContainer;
import com.netflix.archaius.api.PropertyListener;
import com.netflix.archaius.property.ListenerManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CachedCompositePropertyContainer
implements PropertyContainer {
    private final String key;
    private final CompositeConfig config;
    private final CopyOnWriteArrayList<CachedCompositeProperty<?>> cache = new CopyOnWriteArrayList();
    private final ListenerManager listeners;
    private final AtomicInteger masterVersion;
    static final long serialVersionUID = -6278297673616647006L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public CachedCompositePropertyContainer(String key, CompositeConfig config, AtomicInteger version, ListenerManager listeners) {
        this.key = key;
        this.config = config;
        this.listeners = listeners;
        this.masterVersion = version;
    }

    private <T> CachedCompositeProperty<T> add(CachedCompositeProperty<T> newProperty) {
        CachedCompositeProperty<Object> cachedProperty = null;
        for (CachedCompositeProperty<?> property : this.cache) {
            if (!property.equals(newProperty)) continue;
            cachedProperty = property;
            break;
        }
        if (cachedProperty == null) {
            this.cache.add(newProperty);
            cachedProperty = newProperty;
        }
        return cachedProperty;
    }

    public Property<String> asString(String defaultValue) {
        return this.asType(String.class, defaultValue);
    }

    public Property<Integer> asInteger(Integer defaultValue) {
        return this.asType(Integer.class, defaultValue);
    }

    public Property<Long> asLong(Long defaultValue) {
        return this.asType(Long.class, defaultValue);
    }

    public Property<Double> asDouble(Double defaultValue) {
        return this.asType(Double.class, defaultValue);
    }

    public Property<Float> asFloat(Float defaultValue) {
        return this.asType(Float.class, defaultValue);
    }

    public Property<Short> asShort(Short defaultValue) {
        return this.asType(Short.class, defaultValue);
    }

    public Property<Byte> asByte(Byte defaultValue) {
        return this.asType(Byte.class, defaultValue);
    }

    public Property<BigDecimal> asBigDecimal(BigDecimal defaultValue) {
        return this.asType(BigDecimal.class, defaultValue);
    }

    public Property<Boolean> asBoolean(Boolean defaultValue) {
        return this.asType(Boolean.class, defaultValue);
    }

    public Property<BigInteger> asBigInteger(BigInteger defaultValue) {
        return this.asType(BigInteger.class, defaultValue);
    }

    public <T> Property<T> asType(final Class<T> type, final T defaultValue) {
        CachedCompositeProperty<T> prop = this.add(new CachedCompositeProperty<T>(type, defaultValue, this){
            static final long serialVersionUID = 2497038363108577228L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            protected T resolveCurrent() throws Exception {
                return CachedCompositePropertyContainer.this.config.get(type, CachedCompositePropertyContainer.this.key, defaultValue);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        return prop;
    }

    public <T> Property<T> asType(Function<String, T> type, String defaultValue) {
        throw new UnsupportedOperationException();
    }

    void addListener(PropertyListener<?> listener, ListenerManager.ListenerUpdater updater) {
        this.listeners.add(listener, updater);
    }

    String getKey() {
        return this.key;
    }

    void removeListener(PropertyListener<?> listener) {
        this.listeners.remove(listener);
    }

    int getMasterVersion() {
        return this.masterVersion.get();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CachedCompositePropertyContainer.class);
    }
}

