/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.archaius.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.config.archaius.impl.CachedCompositePropertyContainer;
import com.ibm.ws.microprofile.config.archaius.impl.CachedCompositePropertyFactory;
import com.ibm.ws.microprofile.config.archaius.impl.PollingDynamicConfig;
import com.ibm.ws.microprofile.config.impl.SortedSources;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.config.AbstractConfig;
import java.io.Closeable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.microprofile.config.spi.ConfigSource;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CompositeConfig
extends AbstractConfig
implements Closeable,
ConfigListener {
    private final CopyOnWriteArrayList<PollingDynamicConfig> children = new CopyOnWriteArrayList();
    private final CachedCompositePropertyFactory factory;
    static final long serialVersionUID = 8986587843756194745L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public CompositeConfig(SortedSources sources, Decoder decoder, ScheduledExecutorService executor, long refreshInterval) {
        this.setDecoder(decoder);
        this.factory = new CachedCompositePropertyFactory(this);
        for (ConfigSource source : sources) {
            this.addConfig(source, executor, refreshInterval);
        }
    }

    public void onConfigAdded(Config config) {
        this.notifyConfigAdded((Config)this);
    }

    public void onConfigRemoved(Config config) {
        this.notifyConfigRemoved((Config)this);
    }

    public void onConfigUpdated(Config config) {
        this.notifyConfigUpdated((Config)this);
    }

    public void onError(Throwable error, Config config) {
        this.notifyError(error, (Config)this);
    }

    private PollingDynamicConfig addConfig(ConfigSource source, ScheduledExecutorService executor, long refreshInterval) {
        PollingDynamicConfig archaiusConfig = new PollingDynamicConfig(source, executor, refreshInterval);
        this.children.add(archaiusConfig);
        archaiusConfig.setStrInterpolator(this.getStrInterpolator());
        archaiusConfig.setDecoder(this.getDecoder());
        this.notifyConfigAdded((Config)archaiusConfig);
        archaiusConfig.addListener(this);
        return archaiusConfig;
    }

    public Object getRawProperty(String key) {
        for (Config config : this.children) {
            if (!config.containsKey(key)) continue;
            return config.getRawProperty(key);
        }
        return null;
    }

    public <T> List<T> getList(String key, Class<T> type) {
        for (Config config : this.children) {
            if (!config.containsKey(key)) continue;
            return config.getList(key, type);
        }
        return (List)this.notFound(key);
    }

    public List<?> getList(String key) {
        for (Config config : this.children) {
            if (!config.containsKey(key)) continue;
            return config.getList(key);
        }
        return (List)this.notFound(key);
    }

    public boolean containsKey(String key) {
        for (Config config : this.children) {
            if (!config.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        for (Config config : this.children) {
            if (config.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Iterator<String> getKeys() {
        Set<String> result = this.getKeySet();
        return result.iterator();
    }

    Set<String> getKeySet() {
        HashSet<String> result = new HashSet<String>();
        for (Config config : this.children) {
            Iterator iter = config.getKeys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                result.add(key);
            }
        }
        return result;
    }

    public synchronized <T> T accept(Config.Visitor<T> visitor) {
        Object result = null;
        for (Config config : this.children) {
            result = config.accept(visitor);
        }
        return (T)result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (PollingDynamicConfig child : this.children) {
            sb.append(child).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void close() {
        for (PollingDynamicConfig child : this.children) {
            child.close();
        }
    }

    protected <T> T getTypedValue(String propertyName, Class<T> propertyType) {
        CachedCompositePropertyContainer container = this.factory.getProperty(propertyName);
        Property property = container.asType(propertyType, null);
        Object value = property.get();
        return (T)value;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CompositeConfig.class);
    }
}

