/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.interfaces;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.config.interfaces.ConfigException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.BitSet;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.microprofile.config.spi.Converter;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DefaultConverters {
    private static final TraceComponent tc = Tr.register(DefaultConverters.class);
    public static final Converter<String> STRING_CONVERTER = v -> v;
    public static final Converter<Boolean> BOOLEAN_CONVERTER = v -> {
        if (v.equalsIgnoreCase("true") || v.equalsIgnoreCase("yes") || v.equalsIgnoreCase("y") || v.equalsIgnoreCase("on") || v.equalsIgnoreCase("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    };
    public static final Converter<Integer> INTEGER_CONVERTER = Integer::valueOf;
    public static final Converter<Long> LONG_CONVERTER = Long::valueOf;
    public static final Converter<Short> SHORT_CONVERTER = Short::valueOf;
    public static final Converter<Byte> BYTE_CONVERTER = Byte::valueOf;
    public static final Converter<Double> DOUBLE_CONVERTER = Double::valueOf;
    public static final Converter<Float> FLOAT_CONVERTER = Float::valueOf;
    public static final Converter<BigInteger> BIG_INTEGER_CONVERTER = BigInteger::new;
    public static final Converter<BigDecimal> BIG_DECIMAL_CONVERTER = BigDecimal::new;
    public static final Converter<AtomicInteger> ATOMIC_INTEGER_CONVERTER = s -> new AtomicInteger(Integer.parseInt(s));
    public static final Converter<AtomicLong> ATOMIC_LONG_CONVERTER = s -> new AtomicLong(Long.parseLong(s));
    public static final Converter<Duration> DURATION_CONVERTER = value -> {
        try {
            return Duration.parse(value);
        }
        catch (DateTimeException dte) {
            throw new IllegalArgumentException(dte);
        }
    };
    public static final Converter<Period> PERIOD_CONVERTER = value -> {
        try {
            return Period.parse(value);
        }
        catch (DateTimeException dte) {
            throw new IllegalArgumentException(dte);
        }
    };
    public static final Converter<LocalDateTime> LOCAL_DATE_TIME_CONVERTER = value -> {
        try {
            return LocalDateTime.parse(value);
        }
        catch (DateTimeException dte) {
            throw new IllegalArgumentException(dte);
        }
    };
    public static final Converter<LocalDate> LOCAL_DATE_CONVERTER = value -> {
        try {
            return LocalDate.parse(value);
        }
        catch (DateTimeException dte) {
            throw new IllegalArgumentException(dte);
        }
    };
    public static final Converter<LocalTime> LOCAL_TIME_CONVERTER = value -> {
        try {
            return LocalTime.parse(value);
        }
        catch (DateTimeException dte) {
            throw new IllegalArgumentException(dte);
        }
    };
    public static final Converter<OffsetDateTime> OFFSET_DATE_TIME_CONVERTER = value -> {
        try {
            return OffsetDateTime.parse(value);
        }
        catch (DateTimeException dte) {
            throw new IllegalArgumentException(dte);
        }
    };
    public static final Converter<OffsetTime> OFFSET_TIME_CONVERTER = value -> {
        try {
            return OffsetTime.parse(value);
        }
        catch (DateTimeException dte) {
            throw new IllegalArgumentException(dte);
        }
    };
    public static final Converter<ZonedDateTime> ZONED_DATE_TIME_CONVERTER = value -> {
        try {
            return ZonedDateTime.parse(value);
        }
        catch (DateTimeException dte) {
            throw new IllegalArgumentException(dte);
        }
    };
    public static final Converter<Instant> INSTANT_CONVERTER = value -> {
        try {
            return Instant.from(OffsetDateTime.parse(value));
        }
        catch (DateTimeException dte) {
            throw new IllegalArgumentException(dte);
        }
    };
    public static final Converter<Currency> CURRENCY_CONVERTER = Currency::getInstance;
    public static final Converter<BitSet> BIT_SET_CONVERTER = v -> BitSet.valueOf(DatatypeConverter.parseHexBinary((String)v));
    public static final Converter<URI> URI_CONVERTER = value -> {
        URI uri = null;
        try {
            uri = new URI(value);
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException(use);
        }
        return uri;
    };
    public static final Converter<ChronoUnit> CHRONO_UNIT_CONVERTER = ChronoUnit::valueOf;
    public static final Converter<URL> URL_CONVERTER = value -> {
        URL url = null;
        try {
            url = new URL(value);
        }
        catch (MalformedURLException mfue) {
            throw new IllegalArgumentException(mfue);
        }
        return url;
    };
    private static Map<Type, Converter<?>> defaultConverters = new HashMap();
    static final long serialVersionUID = -1247082043753342471L;

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={DateTimeParseException.class})
    private static final Instant parseZonedDateTime(String value) {
        Instant instant = null;
        try {
            instant = ZonedDateTime.parse(value, DateTimeFormatter.ISO_ZONED_DATE_TIME).toInstant();
        }
        catch (DateTimeParseException dateTimeParseException) {
        }
        catch (DateTimeException dateTimeException) {
            void e;
            FFDCFilter.processException((Throwable)dateTimeException, (String)"com.ibm.ws.microprofile.config.interfaces.DefaultConverters", (String)"170", null, (Object[])new Object[]{value});
            throw new IllegalArgumentException((Throwable)e);
        }
        return instant;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={DateTimeParseException.class})
    private static final Instant parseLocalDateTime(String value) {
        Instant instant = null;
        try {
            instant = LocalDateTime.parse(value, DateTimeFormatter.ISO_LOCAL_DATE_TIME).atZone(ZoneOffset.UTC).toInstant();
        }
        catch (DateTimeParseException dateTimeParseException) {
        }
        catch (DateTimeException dateTimeException) {
            void e;
            FFDCFilter.processException((Throwable)dateTimeException, (String)"com.ibm.ws.microprofile.config.interfaces.DefaultConverters", (String)"183", null, (Object[])new Object[]{value});
            throw new IllegalArgumentException((Throwable)e);
        }
        return instant;
    }

    /*
     * WARNING - void declaration
     */
    private static final Instant parseLocalDate(String value) {
        Instant instant = null;
        try {
            instant = LocalDate.parse(value, DateTimeFormatter.ISO_LOCAL_DATE).atStartOfDay(ZoneOffset.UTC).toInstant();
        }
        catch (DateTimeException dateTimeException) {
            void e;
            FFDCFilter.processException((Throwable)dateTimeException, (String)"com.ibm.ws.microprofile.config.interfaces.DefaultConverters", (String)"193", null, (Object[])new Object[]{value});
            throw new IllegalArgumentException((Throwable)e);
        }
        return instant;
    }

    public static Type getConverterType(Converter<?> converter) {
        Type[] itypes;
        Type type = null;
        for (Type itype : itypes = converter.getClass().getGenericInterfaces()) {
            ParameterizedType ptype = (ParameterizedType)itype;
            if (ptype.getRawType() != Converter.class) continue;
            Type[] atypes = ptype.getActualTypeArguments();
            if (atypes.length == 1) {
                type = atypes[0];
                break;
            }
            throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"unable.to.determine.conversion.type.CWMCG0009E", (Object[])new Object[]{converter.getClass().getName()}));
        }
        if (type == null) {
            throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"unable.to.determine.conversion.type.CWMCG0009E", (Object[])new Object[]{converter.getClass().getName()}));
        }
        return type;
    }

    public static Map<Type, Converter<?>> getDefaultConverters() {
        return defaultConverters;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<Type, Converter<?>> getDiscoveredConverters(ClassLoader classLoader) {
        HashMap discoveredConverters = new HashMap();
        try {
            ServiceLoader<Converter> sl = ServiceLoader.load(Converter.class, classLoader);
            for (Converter converter : sl) {
                Type converterType = DefaultConverters.getConverterType(converter);
                discoveredConverters.put(converterType, converter);
            }
        }
        catch (ServiceConfigurationError sl) {
            void e;
            FFDCFilter.processException((Throwable)sl, (String)"com.ibm.ws.microprofile.config.interfaces.DefaultConverters", (String)"339", null, (Object[])new Object[]{classLoader});
            throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"unable.to.discover.converters.CWMCG0012E", (Object[])new Object[]{e}), (Throwable)e);
        }
        return discoveredConverters;
    }

    public static Map<Type, Converter<?>> getConverters(ClassLoader classLoader) {
        HashMap converters = new HashMap();
        converters.putAll(DefaultConverters.getDefaultConverters());
        converters.putAll(DefaultConverters.getDiscoveredConverters(classLoader));
        return converters;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        defaultConverters.put((Type)((Object)String.class), STRING_CONVERTER);
        defaultConverters.put((Type)((Object)Boolean.class), BOOLEAN_CONVERTER);
        defaultConverters.put(Boolean.TYPE, BOOLEAN_CONVERTER);
        defaultConverters.put((Type)((Object)Integer.class), INTEGER_CONVERTER);
        defaultConverters.put(Integer.TYPE, INTEGER_CONVERTER);
        defaultConverters.put((Type)((Object)Long.class), LONG_CONVERTER);
        defaultConverters.put(Long.TYPE, LONG_CONVERTER);
        defaultConverters.put((Type)((Object)Short.class), SHORT_CONVERTER);
        defaultConverters.put(Short.TYPE, SHORT_CONVERTER);
        defaultConverters.put((Type)((Object)Byte.class), BYTE_CONVERTER);
        defaultConverters.put(Byte.TYPE, BYTE_CONVERTER);
        defaultConverters.put((Type)((Object)Double.class), DOUBLE_CONVERTER);
        defaultConverters.put(Double.TYPE, DOUBLE_CONVERTER);
        defaultConverters.put((Type)((Object)Float.class), FLOAT_CONVERTER);
        defaultConverters.put(Float.TYPE, FLOAT_CONVERTER);
        defaultConverters.put((Type)((Object)BigInteger.class), BIG_INTEGER_CONVERTER);
        defaultConverters.put((Type)((Object)BigDecimal.class), BIG_DECIMAL_CONVERTER);
        defaultConverters.put((Type)((Object)AtomicInteger.class), ATOMIC_INTEGER_CONVERTER);
        defaultConverters.put((Type)((Object)AtomicLong.class), ATOMIC_LONG_CONVERTER);
        defaultConverters.put((Type)((Object)Duration.class), DURATION_CONVERTER);
        defaultConverters.put((Type)((Object)Period.class), PERIOD_CONVERTER);
        defaultConverters.put((Type)((Object)LocalDateTime.class), LOCAL_DATE_TIME_CONVERTER);
        defaultConverters.put((Type)((Object)LocalDate.class), LOCAL_DATE_CONVERTER);
        defaultConverters.put((Type)((Object)LocalTime.class), LOCAL_TIME_CONVERTER);
        defaultConverters.put((Type)((Object)OffsetDateTime.class), OFFSET_DATE_TIME_CONVERTER);
        defaultConverters.put((Type)((Object)OffsetTime.class), OFFSET_TIME_CONVERTER);
        defaultConverters.put((Type)((Object)ZonedDateTime.class), ZONED_DATE_TIME_CONVERTER);
        defaultConverters.put((Type)((Object)Instant.class), INSTANT_CONVERTER);
        defaultConverters.put((Type)((Object)Currency.class), CURRENCY_CONVERTER);
        defaultConverters.put((Type)((Object)BitSet.class), BIT_SET_CONVERTER);
        defaultConverters.put((Type)((Object)URL.class), URL_CONVERTER);
        defaultConverters.put((Type)((Object)URI.class), URI_CONVERTER);
        defaultConverters.put((Type)((Object)ChronoUnit.class), CHRONO_UNIT_CONVERTER);
        defaultConverters = Collections.unmodifiableMap(defaultConverters);
    }
}

