/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation;

import com.ibm.ejs.util.dopriv.SetContextClassLoaderPrivileged;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.beanvalidation.AbstractBeanValidation;
import com.ibm.ws.beanvalidation.OSGiBeanValidationScopeData;
import com.ibm.ws.beanvalidation.ValidatorFactoryAccessor;
import com.ibm.ws.beanvalidation.config.ValidationConfigurationFactory;
import com.ibm.ws.beanvalidation.config.ValidationConfigurationInterface;
import com.ibm.ws.beanvalidation.service.BeanValidation;
import com.ibm.ws.beanvalidation.service.BeanValidationExtensionHelper;
import com.ibm.ws.beanvalidation.service.BeanValidationRuntimeVersion;
import com.ibm.ws.beanvalidation.service.BeanValidationUsingClassLoader;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataSlotService;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.bval.ValidationConfig;
import com.ibm.ws.kernel.service.util.PrivHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ModuleMetaDataListener.class, BeanValidationUsingClassLoader.class, BeanValidation.class}, immediate=true)
public class OSGiBeanValidationImpl
extends AbstractBeanValidation
implements ModuleMetaDataListener,
BeanValidationUsingClassLoader {
    private static final TraceComponent tc = Tr.register(OSGiBeanValidationImpl.class);
    private static final String REFERENCE_VALIDATION_CONFIG_FACTORY = "validationConfigFactory";
    private static final String REFERENCE_CLASSLOADING_SERVICE = "classLoadingService";
    private MetaDataSlot ivModuleMetaDataSlot;
    private final AtomicServiceReference<ValidationConfigurationFactory> validationConfigFactorySR = new AtomicServiceReference("validationConfigFactory");
    private final AtomicServiceReference<ClassLoadingService> classLoadingServiceSR = new AtomicServiceReference("classLoadingService");
    private static final Version DEFAULT_VERSION = BeanValidationRuntimeVersion.VERSION_1_0;
    private Version runtimeVersion = DEFAULT_VERSION;
    private static final PrivilegedAction<ThreadContextAccessor> getThreadContextAccessorAction = new PrivilegedAction<ThreadContextAccessor>(){
        static final long serialVersionUID = -2198084351891221209L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public ThreadContextAccessor run() {
            return ThreadContextAccessor.getThreadContextAccessor();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    static final long serialVersionUID = 7902133382449898809L;

    @Override
    public void registerValidatorFactory(ModuleMetaData mmd, ClassLoader cl, ValidatorFactory validatorFactory) {
        this.getValidatorFactory(mmd, cl, validatorFactory);
    }

    @Override
    @Trivial
    public ConstraintValidatorFactory getConstraintValidatorFactory(Configuration<?> config) {
        ValidationConfigurationFactory configFactory = (ValidationConfigurationFactory)this.validationConfigFactorySR.getServiceWithException();
        return configFactory.getConstraintValidatorFactoryOverride(config);
    }

    @Override
    @Trivial
    public ValidatorFactory getValidatorFactory(ModuleMetaData mmd) {
        return this.getValidatorFactory(mmd, null);
    }

    @Override
    public ValidatorFactory getValidatorFactory(ModuleMetaData mmd, ClassLoader loader) {
        return this.getValidatorFactory(mmd, loader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private ValidatorFactory getValidatorFactory(ModuleMetaData mmd, ClassLoader loader, ValidatorFactory validatorFactoryToSave) {
        MetaDataSlot mmdSlot = this.ivModuleMetaDataSlot;
        if (mmdSlot == null) {
            throw new ValidationException("Validation not enabled for module " + mmd.getName() + "; MetaDataSlotService not active");
        }
        OSGiBeanValidationScopeData scopeData = (OSGiBeanValidationScopeData)mmd.getMetaData(mmdSlot);
        if (scopeData == null) {
            throw new ValidationException("Validation not enabled for module " + mmd.getName());
        }
        ValidatorFactory vf = scopeData.ivValidatorFactory;
        if (vf == null) {
            OSGiBeanValidationScopeData oSGiBeanValidationScopeData = scopeData;
            synchronized (oSGiBeanValidationScopeData) {
                vf = scopeData.ivValidatorFactory;
                if (vf == null) {
                    if (scopeData.configuratorReleased && this.isBeanValidationVersion11OrGreater()) {
                        throw new ValidationException("the module is stopped, so either the ValidatorFactory has already been destroyed or it was never created");
                    }
                    if (loader != null && !((ClassLoadingService)this.classLoadingServiceSR.getServiceWithException()).isThreadContextClassLoader(loader)) {
                        loader = this.createTCCL(loader);
                    }
                    ClassLoader origLoader = scopeData.setClassLoader(loader);
                    boolean createSuccessful = false;
                    ValidationConfigurationInterface bvalConfigurator = null;
                    try {
                        boolean canLookInAppClassPath;
                        ValidationConfig config = null;
                        try {
                            config = (ValidationConfig)scopeData.ivModuleContainer.adapt(ValidationConfig.class);
                        }
                        catch (UnableToAdaptException unableToAdaptException) {
                            void e;
                            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.beanvalidation.OSGiBeanValidationImpl", (String)"155", (Object)this, (Object[])new Object[]{mmd, loader, validatorFactoryToSave});
                            throw new ValidationException((Throwable)e);
                        }
                        boolean bVal11OrHigher = this.isBeanValidationVersion11OrGreater();
                        boolean bl = canLookInAppClassPath = !bVal11OrHigher || !BeanValidationExtensionHelper.IS_VALIDATION_CLASSLOADING_ENABLED;
                        if (config == null && canLookInAppClassPath) {
                            vf = ValidatorFactoryAccessor.getValidatorFactory(loader, bVal11OrHigher, validatorFactoryToSave != null);
                        } else {
                            ValidationConfigurationFactory configFactory = (ValidationConfigurationFactory)this.validationConfigFactorySR.getServiceWithException();
                            bvalConfigurator = configFactory.createValidationConfiguration(scopeData, config);
                            vf = ValidatorFactoryAccessor.getValidatorFactory(bvalConfigurator, validatorFactoryToSave != null);
                        }
                        if (validatorFactoryToSave != null) {
                            vf = validatorFactoryToSave;
                        }
                        scopeData.ivValidatorFactory = vf;
                        scopeData.configurator = bvalConfigurator;
                        createSuccessful = true;
                    }
                    finally {
                        if (loader != null) {
                            this.releaseLoader(loader);
                        }
                        scopeData.setClassLoader(origLoader);
                        if (!createSuccessful && bvalConfigurator != null) {
                            bvalConfigurator.release(null);
                        }
                    }
                }
            }
        }
        return vf;
    }

    @Override
    @Trivial
    public Validator getValidator(ComponentMetaData cmd) {
        ClassLoader tccl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = -665022786711479047L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        return this.getValidator(cmd.getModuleMetaData(), tccl);
    }

    @Override
    public Validator getValidator(ModuleMetaData mmd, ClassLoader loader) {
        ValidatorFactory vfactory = this.getValidatorFactory(mmd, loader);
        Validator validator = vfactory.getValidator();
        return validator;
    }

    private ClassLoader createTCCL(ClassLoader parentCL) {
        return ((ClassLoadingService)this.classLoadingServiceSR.getServiceWithException()).createThreadContextClassLoader(parentCL);
    }

    @Override
    public void releaseLoader(ClassLoader tccl) {
        ((ClassLoadingService)this.classLoadingServiceSR.getServiceWithException()).destroyThreadContextClassLoader(tccl);
    }

    public void moduleMetaDataCreated(MetaDataEvent<ModuleMetaData> event) {
        Container container;
        ModuleMetaData mmd;
        block7: {
            ValidationConfig validationConfig = null;
            mmd = (ModuleMetaData)event.getMetaData();
            container = event.getContainer();
            try {
                validationConfig = (ValidationConfig)container.adapt(ValidationConfig.class);
                if (validationConfig != null) {
                    URL validationXmlUrl = container.getEntry(validationConfig.getDeploymentDescriptorPath()).getResource();
                    this.moduleValidationXMLs.put(mmd, validationXmlUrl);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("validation.xml found at: " + validationXmlUrl.getPath()), (Object[])new Object[0]);
                    }
                }
            }
            catch (UnableToAdaptException validationXmlUrl) {
                FFDCFilter.processException((Throwable)validationXmlUrl, (String)"com.ibm.ws.beanvalidation.OSGiBeanValidationImpl", (String)"270", (Object)this, (Object[])new Object[]{event});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)("Failed to find a valid validation.xml - will continue to start module: " + ((ModuleMetaData)event.getMetaData()).getJ2EEName()), (Object[])new Object[0]);
            }
        }
        MetaDataSlot mmdSlot = this.ivModuleMetaDataSlot;
        if (mmdSlot == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MetaDataSlotService not active... skipping start module action", (Object[])new Object[]{mmd.getName()});
            }
            return;
        }
        OSGiBeanValidationScopeData scopeData = (OSGiBeanValidationScopeData)mmd.getMetaData(this.ivModuleMetaDataSlot);
        if (scopeData == null) {
            scopeData = new OSGiBeanValidationScopeData(container);
            mmd.setMetaData(mmdSlot, (Object)scopeData);
            BeanValidationExtensionHelper.putContainer(mmd, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moduleMetaDataDestroyed(MetaDataEvent<ModuleMetaData> event) {
        ModuleMetaData mmd = (ModuleMetaData)event.getMetaData();
        this.moduleValidationXMLs.remove(mmd);
        MetaDataSlot mmdSlot = this.ivModuleMetaDataSlot;
        if (mmdSlot == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MetaDataSlotService not active... skipping stop module action", (Object[])new Object[]{mmd.getName()});
            }
            return;
        }
        OSGiBeanValidationScopeData scopeData = (OSGiBeanValidationScopeData)mmd.getMetaData(mmdSlot);
        if (scopeData != null) {
            OSGiBeanValidationScopeData oSGiBeanValidationScopeData = scopeData;
            synchronized (oSGiBeanValidationScopeData) {
                ValidationConfigurationInterface configurator = scopeData.configurator;
                if (configurator != null) {
                    configurator.release(scopeData.ivValidatorFactory);
                }
                scopeData.classloader = null;
                scopeData.configuratorReleased = true;
                if (this.isBeanValidationVersion11OrGreater()) {
                    scopeData.configurator = null;
                    scopeData.ivValidatorFactory = null;
                }
                BeanValidationExtensionHelper.removeContainer(mmd);
            }
        }
        this.cleanBvalCache();
    }

    @Activate
    protected void activate(ComponentContext cc) {
        OSGiBeanValidationImpl.setInstance(this);
        this.classLoadingServiceSR.activate(cc);
        this.validationConfigFactorySR.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        OSGiBeanValidationImpl.setInstance(null);
        this.classLoadingServiceSR.deactivate(cc);
        this.validationConfigFactorySR.deactivate(cc);
    }

    @Reference
    protected void setMetaDataSlotService(MetaDataSlotService slotService) {
        this.ivModuleMetaDataSlot = slotService.reserveMetaDataSlot(ModuleMetaData.class);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setMetaDataSlotService : mmd slot=" + this.ivModuleMetaDataSlot), (Object[])new Object[0]);
        }
    }

    protected void unsetMetaDataSlotService(MetaDataSlotService slotService) {
        this.ivModuleMetaDataSlot = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetMetaDataSlotService", (Object[])new Object[0]);
        }
    }

    @Reference(service=BeanValidationRuntimeVersion.class, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setRuntimeVersion(ServiceReference<BeanValidationRuntimeVersion> ref) {
        this.runtimeVersion = Version.parseVersion((String)((String)ref.getProperty("version")));
    }

    protected void unsetRuntimeVersion(ServiceReference<BeanValidationRuntimeVersion> ref) {
        this.runtimeVersion = DEFAULT_VERSION;
    }

    @Reference(name="classLoadingService", service=ClassLoadingService.class)
    protected void setClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingServiceSR.setReference(ref);
    }

    protected void unsetClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingServiceSR.unsetReference(ref);
    }

    @Reference(name="validationConfigFactory", service=ValidationConfigurationFactory.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setValidationConfigFactory(ServiceReference<ValidationConfigurationFactory> factoryRef) {
        this.validationConfigFactorySR.setReference(factoryRef);
    }

    protected void unsetValidationConfigFactory(ServiceReference<ValidationConfigurationFactory> factoryRef) {
        this.validationConfigFactorySR.unsetReference(factoryRef);
    }

    private boolean isBeanValidationVersion11OrGreater() {
        return this.runtimeVersion.compareTo(BeanValidationRuntimeVersion.VERSION_1_1) >= 0;
    }

    @Override
    public ClassLoader configureBvalClassloader(ClassLoader cl) {
        if (cl == null) {
            cl = PrivHelper.getContextClassLoader();
        }
        if (cl != null) {
            ClassLoadingService classLoadingService = (ClassLoadingService)this.classLoadingServiceSR.getServiceWithException();
            if (classLoadingService.isThreadContextClassLoader(cl)) {
                return cl;
            }
            if (classLoadingService.isAppClassLoader(cl)) {
                return this.createTCCL(cl);
            }
        }
        return this.createTCCL(AbstractBeanValidation.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanBvalCache() {
        if (this.isBeanValidationVersion11OrGreater()) {
            boolean wasTcclCreated;
            ClassLoader classLoader;
            block16: {
                classLoader = null;
                SetContextClassLoaderPrivileged setClassLoader = null;
                ClassLoader oldClassLoader = null;
                wasTcclCreated = false;
                try {
                    classLoader = ((ValidationConfigurationFactory)this.validationConfigFactorySR.getServiceWithException()).getClass().getClassLoader();
                    if (classLoader != null && !((ClassLoadingService)this.classLoadingServiceSR.getServiceWithException()).isThreadContextClassLoader(classLoader)) {
                        classLoader = this.createTCCL(classLoader);
                        wasTcclCreated = true;
                    }
                    ThreadContextAccessor tca = System.getSecurityManager() == null ? ThreadContextAccessor.getThreadContextAccessor() : AccessController.doPrivileged(getThreadContextAccessorAction);
                    setClassLoader = new SetContextClassLoaderPrivileged(tca);
                    oldClassLoader = setClassLoader.execute(classLoader);
                    if (classLoader == null) {
                        classLoader = oldClassLoader;
                    }
                    Class<?> clazz = classLoader.loadClass("org.apache.bval.jsr.ConstraintAnnotationAttributes");
                    final Field methodByNameAndClass = clazz.getDeclaredField("METHOD_BY_NAME_AND_CLASS");
                    if (System.getSecurityManager() == null) {
                        methodByNameAndClass.setAccessible(true);
                    } else {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){
                            static final long serialVersionUID = 712025067130631074L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public Object run() {
                                methodByNameAndClass.setAccessible(true);
                                return null;
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register(3.class);
                            }
                        });
                    }
                    Map methodMap = (Map)methodByNameAndClass.get(null);
                    methodMap.clear();
                    if (setClassLoader == null) break block16;
                }
                catch (Exception exception) {
                    block17: {
                        try {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.beanvalidation.OSGiBeanValidationImpl", (String)"464", (Object)this, (Object[])new Object[0]);
                            if (setClassLoader == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (setClassLoader != null) {
                                setClassLoader.execute(oldClassLoader);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                                }
                            }
                            if (classLoader != null && wasTcclCreated) {
                                this.releaseLoader(classLoader);
                            }
                            throw throwable;
                        }
                        setClassLoader.execute(oldClassLoader);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                        }
                    }
                    if (classLoader != null && wasTcclCreated) {
                        this.releaseLoader(classLoader);
                    }
                }
                setClassLoader.execute(oldClassLoader);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                }
            }
            if (classLoader != null && wasTcclCreated) {
                this.releaseLoader(classLoader);
            }
        }
    }
}

