/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.internal.jaas;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.jaas.modules.WSLoginModuleImpl;
import com.ibm.ws.security.jaas.common.JAASConfiguration;
import com.ibm.ws.security.jaas.common.JAASLoginContextEntry;
import com.ibm.ws.security.jaas.common.JAASLoginModuleConfig;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={JAASConfiguration.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class JAASConfigurationImpl
implements JAASConfiguration {
    static final TraceComponent tc = Tr.register(JAASConfigurationImpl.class);
    static final List<String> defaultEntryIds = Collections.unmodifiableList(Arrays.asList("system.UNAUTHENTICATED", "system.WEB_INBOUND", "system.DEFAULT", "system.DESERIALIZE_CONTEXT", "system.RMI_INBOUND", "WSLogin"));
    public static final Class<WSLoginModuleImpl> WSLOGIN_MODULE_IMPL_CLASS = WSLoginModuleImpl.class;
    private ConcurrentServiceReferenceMap<String, JAASLoginContextEntry> jaasLoginContextEntries;
    static final long serialVersionUID = 2228981568441186307L;

    public void setJaasLoginContextEntries(ConcurrentServiceReferenceMap<String, JAASLoginContextEntry> jaasLoginContextEntries) {
        this.jaasLoginContextEntries = jaasLoginContextEntries;
    }

    public Map<String, List<AppConfigurationEntry>> getEntries() {
        HashMap<String, List<AppConfigurationEntry>> jaasConfigurationEntries = new HashMap<String, List<AppConfigurationEntry>>();
        HashMap<String, String> jaasConfigIDs = new HashMap<String, String>();
        if (this.jaasLoginContextEntries != null) {
            Iterator lcEntries = this.jaasLoginContextEntries.getServices();
            while (lcEntries.hasNext()) {
                List<AppConfigurationEntry> appConfEntry;
                JAASLoginContextEntry loginContextEntry = (JAASLoginContextEntry)lcEntries.next();
                String entryName = loginContextEntry.getEntryName();
                List loginModules = loginContextEntry.getLoginModules();
                if ("system.DEFAULT".equalsIgnoreCase(entryName)) {
                    this.ensureProxyIsNotSpecifyInSystemDefaultEntry(entryName, loginModules);
                }
                if ((appConfEntry = this.getLoginModules(loginModules)) == null || appConfEntry.isEmpty()) continue;
                if (jaasConfigIDs.containsKey(entryName)) {
                    String id = (String)jaasConfigIDs.get(entryName);
                    Tr.warning((TraceComponent)tc, (String)"JAAS_LOGIN_CONTEXT_ENTRY_HAS_DUPLICATE_NAME", (Object[])new Object[]{entryName, id, loginContextEntry.getId()});
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("configure jaasContextLoginEntry id: " + loginContextEntry.getId()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("configure jaasContextLoginEntry: " + entryName + " has " + appConfEntry.size() + " loginModule(s)"), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("appConfEntry: " + appConfEntry), (Object[])new Object[0]);
                }
                jaasConfigurationEntries.put(entryName, appConfEntry);
                jaasConfigIDs.put(entryName, loginContextEntry.getId());
            }
        }
        return jaasConfigurationEntries;
    }

    private void ensureProxyIsNotSpecifyInSystemDefaultEntry(String entryName, List<JAASLoginModuleConfig> loginModules) {
        Iterator<JAASLoginModuleConfig> i = loginModules.iterator();
        while (i.hasNext()) {
            JAASLoginModuleConfig loginModule = i.next();
            if (!loginModule.getId().equalsIgnoreCase("proxy")) continue;
            Tr.warning((TraceComponent)tc, (String)"JAAS_PROXY_IS_NOT_SUPPORT_IN_SYSTEM_DEFAULT", (Object[])new Object[0]);
            i.remove();
        }
    }

    List<AppConfigurationEntry> getLoginModules(List<JAASLoginModuleConfig> loginModules) {
        ArrayList<AppConfigurationEntry> loginModuleEntries = new ArrayList<AppConfigurationEntry>();
        for (JAASLoginModuleConfig loginModule : loginModules) {
            if (loginModule != null) {
                AppConfigurationEntry loginModuleEntry = this.createAppConfigurationEntry(loginModule);
                loginModuleEntries.add(loginModuleEntry);
                continue;
            }
            throw new IllegalStateException("Missing login module: found: " + loginModules);
        }
        return loginModuleEntries;
    }

    AppConfigurationEntry createAppConfigurationEntry(JAASLoginModuleConfig loginModule) throws IllegalArgumentException {
        String loginModuleClassName = loginModule.getClassName();
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = loginModule.getControlFlag();
        Map options = loginModule.getOptions();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("loginModuleClassName: " + loginModuleClassName + " options: " + options.toString() + " controlFlag: " + controlFlag.toString()), (Object[])new Object[0]);
        }
        AppConfigurationEntry loginModuleEntry = new AppConfigurationEntry(loginModuleClassName, controlFlag, options);
        return loginModuleEntry;
    }
}

