/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejb.injection.processor;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejb.injection.annotation.EJBImpl;
import com.ibm.ws.ejb.injection.processor.EJBInjectionBinding;
import com.ibm.ws.javaee.dd.common.Description;
import com.ibm.ws.javaee.dd.common.EJBRef;
import com.ibm.ws.javaee.dd.common.InjectionTarget;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionProcessor;
import com.ibm.wsspi.injectionengine.InjectionScope;
import com.ibm.wsspi.injectionengine.factory.EJBLinkReferenceFactory;
import com.ibm.wsspi.injectionengine.factory.IndirectJndiLookupReferenceFactory;
import com.ibm.wsspi.injectionengine.factory.OverrideReferenceFactory;
import java.lang.reflect.Member;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.EJBs;
import javax.naming.Reference;

public class EJBProcessor
extends InjectionProcessor<EJB, EJBs> {
    static final TraceComponent tc = Tr.register(EJBProcessor.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
    private IndirectJndiLookupReferenceFactory ivIndirectLookupFactory;
    private EJBLinkReferenceFactory ivEJBLinkRefFactory;

    public EJBProcessor() {
        super(EJB.class, EJBs.class);
    }

    public void initProcessor() {
        this.ivIndirectLookupFactory = this.ivNameSpaceConfig.getIndirectJndiLookupReferenceFactory();
        this.ivEJBLinkRefFactory = this.ivNameSpaceConfig.getEJBLinkReferenceFactory();
    }

    public void processXML() throws InjectionException {
        List ejbRefs;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processXML : " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        if ((ejbRefs = this.ivNameSpaceConfig.getJNDIEnvironmentRefs(EJBRef.class)) != null) {
            for (EJBRef ejbRef : ejbRefs) {
                String jndiName = ejbRef.getName();
                InjectionBinding injectionBinding = (InjectionBinding)this.ivAllAnnotationsCollection.get(jndiName);
                if (injectionBinding != null) {
                    ((EJBInjectionBinding)injectionBinding).merge(ejbRef);
                    continue;
                }
                List descs = ejbRef.getDescriptions();
                String lookupName = ejbRef.getLookupName();
                EJBImpl ejbAnnotation = new EJBImpl(ejbRef.getName(), null, ejbRef.getLink(), ejbRef.getMappedName(), descs.isEmpty() ? null : ((Description)descs.get(0)).getValue(), lookupName != null ? lookupName.trim() : null);
                EJBInjectionBinding ejbBinding = new EJBInjectionBinding((EJB)ejbAnnotation, ejbRef, this.ivNameSpaceConfig);
                List targets = ejbRef.getInjectionTargets();
                if (!targets.isEmpty()) {
                    for (InjectionTarget target : targets) {
                        Class<?> injectionType = ejbBinding.getInjectionClassTypeWithException();
                        String injectionName = target.getInjectionTargetName();
                        String injectionClassName = target.getInjectionTargetClassName();
                        ejbBinding.addInjectionTarget(injectionType, injectionName, injectionClassName);
                    }
                }
                this.addInjectionBinding(ejbBinding);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("processXML : " + (Object)((Object)this)));
        }
    }

    public void resolve(InjectionBinding<EJB> binding) throws InjectionException {
        String beanInterfaceName;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("resolve : " + binding), (Object[])new Object[0]);
        }
        Reference ref = null;
        EJBInjectionBinding ejbBinding = (EJBInjectionBinding)binding;
        String refJndiName = ejbBinding.getJndiName();
        String interfaceName = ejbBinding.getInjectionClassTypeName();
        String boundToJndiName = ejbBinding.ivBindingName;
        if (boundToJndiName == null && (boundToJndiName = ejbBinding.ivLookup) != null && boundToJndiName.equals("")) {
            boundToJndiName = null;
        }
        if (this.ivOverrideReferenceFactories != null && interfaceName != null && ejbBinding.ivClassLoader != null) {
            Class<?> injectType = ejbBinding.getInjectionClassTypeWithException();
            for (OverrideReferenceFactory factory : this.ivOverrideReferenceFactories) {
                J2EEName j2eeName;
                ref = factory.createReference((j2eeName = this.ivNameSpaceConfig.getJ2EEName()).getApplication(), j2eeName.getModule(), ejbBinding.ivBeanName, refJndiName, injectType, boundToJndiName, ejbBinding.getAnnotation());
                if (ref == null) continue;
                binding.setObjects(null, ref);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"resolve", binding);
                }
                return;
            }
        }
        if (boundToJndiName != null) {
            if (ejbBinding.ivEjbLocalRef && !boundToJndiName.startsWith("java:") && !boundToJndiName.startsWith("ejblocal:")) {
                boundToJndiName = "ejblocal:".concat(boundToJndiName);
            }
            beanInterfaceName = ejbBinding.getInjectionClassTypeName();
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("resolve : binding : " + refJndiName + " -> " + boundToJndiName + " : type = " + beanInterfaceName), (Object[])new Object[0]);
            }
            ref = this.ivIndirectLookupFactory.createIndirectJndiLookup(refJndiName, boundToJndiName, beanInterfaceName);
            binding.setObjects(null, ref);
            ejbBinding.ivBoundToJndiName = boundToJndiName;
            ejbBinding.ivIndirectLookupFactory = this.ivIndirectLookupFactory;
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resolve", binding);
            }
            return;
        }
        if (ejbBinding.getInjectionScope() == InjectionScope.GLOBAL) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resolve: missing binding");
            }
            this.ivMissingBindings.add(refJndiName);
            return;
        }
        if (ejbBinding.ivBeanInterface || ejbBinding.ivHomeInterface) {
            String homeInterfaceName;
            if (ejbBinding.ivHomeInterface) {
                beanInterfaceName = null;
                homeInterfaceName = interfaceName;
            } else {
                beanInterfaceName = interfaceName != null ? interfaceName : "java.lang.Object";
                homeInterfaceName = null;
            }
            J2EEName j2eeName = this.ivNameSpaceConfig.getJ2EEName();
            ref = this.ivEJBLinkRefFactory.createEJBLinkReference(refJndiName, j2eeName.getApplication(), j2eeName.getModule(), j2eeName.getComponent(), ejbBinding.ivBeanName, beanInterfaceName, homeInterfaceName, ejbBinding.ivEjbLocalRef, ejbBinding.ivEjbRef);
            if (this.ivOverrideReferenceFactories != null && interfaceName != null && ejbBinding.ivClassLoader == null) {
                throw new UnsupportedOperationException();
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"EJB_REF_OR_EJB_LOCAL_REF_IS_NOT_SPECIFIED_CORRECTLY_CWNEN0026E", (Object[])new Object[]{refJndiName});
            throw new InjectionConfigurationException("The " + refJndiName + " Enterprise JavaBean (EJB) home and remote or local-home and local elements are either missing or could not be resolved");
        }
        binding.setObjects(null, ref);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resolve", binding);
        }
    }

    public InjectionBinding<EJB> createInjectionBinding(EJB annotation, Class<?> instanceClass, Member member, String jndiName) throws InjectionException {
        return new EJBInjectionBinding(annotation, jndiName, this.ivNameSpaceConfig);
    }

    public String getJndiName(EJB annotation) {
        return annotation.name();
    }

    public EJB[] getAnnotations(EJBs annotation) {
        return annotation.value();
    }
}

