/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.microprofile.faulttolerance.impl.CircuitBreakerImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.FTConstants;
import com.ibm.ws.microprofile.faulttolerance.impl.RetryImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.TimeoutImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.async.QueuedFuture;
import com.ibm.ws.microprofile.faulttolerance.spi.FTExecutionContext;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ExecutionContextImpl
implements FTExecutionContext {
    private static final TraceComponent tc = Tr.register(ExecutionContextImpl.class);
    private final Method method;
    private final Object[] params;
    private final TimeoutImpl timeout;
    private final RetryImpl retry;
    private final CircuitBreakerImpl circuitBreaker;
    private final FallbackPolicy fallbackPolicy;
    private volatile int retries = 0;
    private volatile long startTime;
    private final String id;
    static final long serialVersionUID = 7199926376710695459L;

    public ExecutionContextImpl(String id, Method method, Object[] params, TimeoutImpl timeout, CircuitBreakerImpl circuitBreaker, FallbackPolicy fallbackPolicy, RetryImpl retry) {
        this.id = id;
        this.method = method;
        this.params = new Object[params.length];
        System.arraycopy(params, 0, this.params, 0, params.length);
        this.timeout = timeout;
        this.circuitBreaker = circuitBreaker;
        this.fallbackPolicy = fallbackPolicy;
        this.retry = retry;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getParameters() {
        return this.params;
    }

    public void start() {
        this.startTime = System.nanoTime();
        this.debugRelativeTime("start");
        if (this.timeout != null) {
            this.timeout.start(Thread.currentThread());
        }
    }

    public void start(QueuedFuture<?> future) {
        this.startTime = System.nanoTime();
        this.debugRelativeTime("start");
        if (this.timeout != null) {
            this.timeout.start(future);
        }
    }

    public void end() {
        this.debugRelativeTime("end");
        if (this.timeout != null) {
            this.timeout.stop(true);
        }
    }

    public long check() {
        this.debugRelativeTime("check");
        long remaining = -1L;
        if (this.timeout != null) {
            remaining = this.timeout.check();
        }
        return remaining;
    }

    public void onRetry() {
        ++this.retries;
        this.debugRelativeTime("onRetry: " + this.retries);
        if (this.timeout != null) {
            this.timeout.restart();
        }
    }

    public RetryImpl getRetry() {
        return this.retry;
    }

    public FallbackPolicy getFallbackPolicy() {
        return this.fallbackPolicy;
    }

    public CircuitBreakerImpl getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public void setNested() {
        if (this.timeout != null) {
            this.timeout.restartOnNewThread(Thread.currentThread());
        }
        int retriesRemaining = this.retry.getMaxRetries() - this.retries;
        if (this.retry.getMaxDuration() != null) {
            long delay;
            long maxDuration = this.retry.getMaxDuration().toNanos();
            long now = System.nanoTime();
            long elapsed = now - this.startTime;
            if ((maxDuration -= elapsed) <= (delay = this.retry.getDelay().toNanos())) {
                maxDuration = delay + 1L;
                retriesRemaining = 0;
            }
            this.retry.withMaxDuration(maxDuration, TimeUnit.NANOSECONDS);
        }
        this.retry.withMaxRetries(retriesRemaining);
    }

    public TimeoutImpl getTimeout() {
        return this.timeout;
    }

    public void close() {
        if (this.timeout != null) {
            this.timeout.stop();
        }
    }

    @Trivial
    public String toString() {
        return this.getDescriptor();
    }

    @Trivial
    public String getDescriptor() {
        return "Execution Context[" + this.id + "]";
    }

    @Trivial
    private void debugRelativeTime(String message) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            FTConstants.debugRelativeTime(tc, this.getDescriptor(), message, this.startTime);
        }
    }
}

