/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FTConstants {
    public static final String SCHEDULED_EXECUTOR_SERVICE_JNDI = "java:comp/DefaultManagedScheduledExecutorService";
    public static final String JSE_FLAG = "com.ibm.ws.microprofile.faulttolerance.jse";
    public static final long MIN_TIMEOUT_NANO = 1000000L;
    static final long serialVersionUID = 4183998943700660973L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Trivial
    public static void debugRelativeTime(TraceComponent tc, String id, String message, long relativePointA) {
        FTConstants.debugRelativeTime(tc, id, message, relativePointA, System.nanoTime());
    }

    @Trivial
    public static void debugRelativeTime(TraceComponent tc, String id, String message, long relativePointA, long relativePointB) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"{0}: {1}: {2}", (Object[])new Object[]{id, message, FTConstants.relativeSeconds(relativePointA, relativePointB)});
        }
    }

    @Trivial
    public static void debugTime(TraceComponent tc, String id, String message, long time) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"{0}: {1}: {2}", (Object[])new Object[]{id, message, FTConstants.toSeconds(time)});
        }
    }

    @Trivial
    public static void debugTime(TraceComponent tc, String message, long time) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"{0}: {1}", (Object[])new Object[]{message, FTConstants.toSeconds(time)});
        }
    }

    @Trivial
    public static double relativeSeconds(long relativePointA, long relativePointB) {
        long diff = relativePointB - relativePointA;
        double seconds = FTConstants.toSeconds(diff);
        return seconds;
    }

    @Trivial
    public static double toSeconds(long nanos) {
        return (double)nanos / 1.0E9;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FTConstants.class);
    }
}

