/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.faulttolerance.impl.ExecutorBuilderImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.policy.BulkheadPolicyImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.policy.CircuitBreakerPolicyImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.policy.FallbackPolicyImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.policy.RetryPolicyImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.policy.TimeoutPolicyImpl;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.ExecutorBuilder;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.FaultToleranceProviderResolver;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.PolicyExecutorProvider;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.microprofile.faulttolerance.impl.ProviderResolverImpl", service={FaultToleranceProviderResolver.class}, property={"service.vendor=IBM"}, immediate=true)
public class ProviderResolverImpl
extends FaultToleranceProviderResolver {
    private static final TraceComponent tc = Tr.register(ProviderResolverImpl.class);
    private final AtomicServiceReference<WSContextService> contextSvcRef = new AtomicServiceReference("ContextService");
    private final AtomicServiceReference<PolicyExecutorProvider> policyExecRef = new AtomicServiceReference("PolicyExecutorProvider");
    private final AtomicServiceReference<ScheduledExecutorService> scheduledExecRef = new AtomicServiceReference("ScheduledExecutorService");
    private ScheduledExecutorService jseScheduledExecutorService;
    static final long serialVersionUID = 5708497970385429878L;

    public void activate(ComponentContext cc) {
        this.contextSvcRef.activate(cc);
        this.policyExecRef.activate(cc);
        this.scheduledExecRef.activate(cc);
        FaultToleranceProviderResolver.setInstance((FaultToleranceProviderResolver)this);
    }

    public void deactivate(ComponentContext cc) throws IOException {
        FaultToleranceProviderResolver.setInstance(null);
        this.scheduledExecRef.deactivate(cc);
        this.policyExecRef.deactivate(cc);
        this.contextSvcRef.deactivate(cc);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setContextService(ServiceReference<WSContextService> ref) {
        this.contextSvcRef.setReference(ref);
    }

    protected void unsetContextService(ServiceReference<WSContextService> ref) {
        this.contextSvcRef.unsetReference(ref);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setPolicyExecutorProvider(ServiceReference<PolicyExecutorProvider> ref) {
        this.policyExecRef.setReference(ref);
    }

    protected void unsetPolicyExecutorProvider(ServiceReference<PolicyExecutorProvider> ref) {
        this.policyExecRef.unsetReference(ref);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setScheduledExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.scheduledExecRef.setReference(ref);
    }

    protected void unsetScheduledExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.scheduledExecRef.unsetReference(ref);
    }

    public BulkheadPolicy newBulkheadPolicy() {
        BulkheadPolicyImpl bulkhead = new BulkheadPolicyImpl();
        return bulkhead;
    }

    public RetryPolicy newRetryPolicy() {
        RetryPolicyImpl retry = new RetryPolicyImpl();
        return retry;
    }

    public CircuitBreakerPolicy newCircuitBreakerPolicy() {
        CircuitBreakerPolicyImpl circuitBreaker = new CircuitBreakerPolicyImpl();
        return circuitBreaker;
    }

    public FallbackPolicy newFallbackPolicy() {
        FallbackPolicyImpl fallback = new FallbackPolicyImpl();
        return fallback;
    }

    public TimeoutPolicy newTimeoutPolicy() {
        TimeoutPolicyImpl timeout = new TimeoutPolicyImpl();
        return timeout;
    }

    public <T, R> ExecutorBuilder<T, R> newExecutionBuilder() {
        WSContextService contextService = this.getContextService();
        PolicyExecutorProvider policyExecutorProvider = this.getPolicyExecutorProvider();
        ScheduledExecutorService scheduledExecutorService = this.getScheduledExecutorService();
        ExecutorBuilderImpl ex = new ExecutorBuilderImpl(contextService, policyExecutorProvider, scheduledExecutorService);
        return ex;
    }

    private WSContextService getContextService() {
        WSContextService contextService = AccessController.doPrivileged(new PrivilegedAction<WSContextService>(){
            static final long serialVersionUID = 1534453952920853191L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public WSContextService run() {
                return (WSContextService)ProviderResolverImpl.this.contextSvcRef.getService();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        return contextService;
    }

    private PolicyExecutorProvider getPolicyExecutorProvider() {
        PolicyExecutorProvider policyExecutorProvider = AccessController.doPrivileged(new PrivilegedAction<PolicyExecutorProvider>(){
            static final long serialVersionUID = -4569790263854491335L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public PolicyExecutorProvider run() {
                return (PolicyExecutorProvider)ProviderResolverImpl.this.policyExecRef.getService();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        return policyExecutorProvider;
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        ScheduledExecutorService scheduledExecutorService = AccessController.doPrivileged(new PrivilegedAction<ScheduledExecutorService>(){
            static final long serialVersionUID = -4203568667249334473L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ScheduledExecutorService run() {
                return (ScheduledExecutorService)ProviderResolverImpl.this.scheduledExecRef.getService();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        });
        if (scheduledExecutorService == null) {
            if ("true".equalsIgnoreCase(System.getProperty("com.ibm.ws.microprofile.faulttolerance.jse"))) {
                if (this.jseScheduledExecutorService == null) {
                    this.jseScheduledExecutorService = Executors.newScheduledThreadPool(10);
                }
                scheduledExecutorService = this.jseScheduledExecutorService;
            } else {
                throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT4999E", (Object[])new Object[0]));
            }
        }
        return scheduledExecutorService;
    }
}

