/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.ejb.impl;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.ejb.impl.BusinessInterfaceDescriptorImpl;
import com.ibm.ws.cdi.ejb.impl.WebSphereEjbDescriptor;
import com.ibm.ws.ejbcontainer.EJBEndpoint;
import com.ibm.ws.ejbcontainer.EJBReferenceFactory;
import com.ibm.ws.ejbcontainer.EJBType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EjbDescriptorImpl<T>
implements WebSphereEjbDescriptor<T> {
    private static final TraceComponent tc = Tr.register(EjbDescriptorImpl.class);
    private final Class<T> beanClass;
    private final EJBReferenceFactory referenceFactory;
    private Collection<BusinessInterfaceDescriptor<?>> localBusinessInterfaces;
    private Collection<BusinessInterfaceDescriptor<?>> remoteBusinessInterfaces;
    private String ejbName;
    private boolean isStateless;
    private boolean isSingleton;
    private boolean isStateful;
    private boolean isMessageDriven;
    private boolean isPassivationCapable;
    private final J2EEName ejbJ2EEName;
    private final String ejbJ2EENameString;
    private Collection<Method> removeMethods;
    static final long serialVersionUID = -870943957983336757L;

    private EjbDescriptorImpl(Class<T> beanClass, EJBEndpoint ejb, ClassLoader classLoader) throws CDIException {
        this.beanClass = beanClass;
        this.referenceFactory = ejb.getEJBType().isSession() ? ejb.getReferenceFactory() : null;
        this.ejbJ2EEName = ejb.getJ2EEName();
        this.ejbJ2EENameString = this.ejbJ2EEName.toString();
        this.init(ejb, classLoader);
    }

    /*
     * WARNING - void declaration
     */
    public static EjbDescriptor<?> newInstance(EJBEndpoint ejb, ClassLoader classLoader) throws CDIException {
        EjbDescriptor<?> descriptor = null;
        String beanClassName = ejb.getClassName();
        try {
            Class<?> beanClass = classLoader.loadClass(beanClassName);
            descriptor = EjbDescriptorImpl.newInstance(beanClass, ejb, classLoader);
        }
        catch (ClassNotFoundException beanClass) {
            void e;
            FFDCFilter.processException((Throwable)beanClass, (String)"com.ibm.ws.cdi.ejb.impl.EjbDescriptorImpl", (String)"65", null, (Object[])new Object[]{ejb, classLoader});
            throw new CDIException((Throwable)e);
        }
        return descriptor;
    }

    public static <K> EjbDescriptor<K> newInstance(Class<K> beanClass, EJBEndpoint ejb, ClassLoader classLoader) throws CDIException {
        return new EjbDescriptorImpl<K>(beanClass, ejb, classLoader);
    }

    /*
     * WARNING - void declaration
     */
    private void init(EJBEndpoint ejb, ClassLoader classLoader) throws CDIException {
        EJBType ejbType;
        try {
            List localInterfaceNames = ejb.getLocalBusinessInterfaceNames();
            this.localBusinessInterfaces = new ArrayList(localInterfaceNames.size() + 1);
            for (String interfaceName : localInterfaceNames) {
                Class<?> interfaceClass = classLoader.loadClass(interfaceName);
                this.localBusinessInterfaces.add(BusinessInterfaceDescriptorImpl.newInstance(interfaceClass));
            }
            if (ejb.isLocalBean()) {
                this.localBusinessInterfaces.add(BusinessInterfaceDescriptorImpl.newInstance(this.beanClass));
            }
            List remoteInterfaceNames = ejb.getRemoteBusinessInterfaceNames();
            this.remoteBusinessInterfaces = new ArrayList();
            for (String remoteInterfaceName : remoteInterfaceNames) {
                Class<?> remoteInterfaceClass = classLoader.loadClass(remoteInterfaceName);
                this.remoteBusinessInterfaces.add(BusinessInterfaceDescriptorImpl.newInstance(remoteInterfaceClass));
            }
        }
        catch (ClassNotFoundException localInterfaceNames) {
            void e;
            FFDCFilter.processException((Throwable)localInterfaceNames, (String)"com.ibm.ws.cdi.ejb.impl.EjbDescriptorImpl", (String)"99", (Object)this, (Object[])new Object[]{ejb, classLoader});
            throw new CDIException((Throwable)e);
        }
        this.ejbName = ejb.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("EJB Name: " + this.ejbName), (Object[])new Object[0]);
        }
        this.isStateless = (ejbType = ejb.getEJBType()) == EJBType.STATELESS_SESSION;
        this.isSingleton = ejbType == EJBType.SINGLETON_SESSION;
        this.isStateful = ejbType == EJBType.STATEFUL_SESSION;
        this.isMessageDriven = ejbType == EJBType.MESSAGE_DRIVEN;
        this.isPassivationCapable = ejb.isPassivationCapable();
        this.removeMethods = this.getRemoveMethodsForEndPoint(ejb);
    }

    /*
     * WARNING - void declaration
     */
    private Collection<Method> getRemoveMethodsForEndPoint(EJBEndpoint ejbEndpoint) throws CDIException {
        List removeMethods = null;
        try {
            removeMethods = ejbEndpoint.getStatefulRemoveMethods();
        }
        catch (EJBConfigurationException eJBConfigurationException) {
            void e;
            FFDCFilter.processException((Throwable)eJBConfigurationException, (String)"com.ibm.ws.cdi.ejb.impl.EjbDescriptorImpl", (String)"123", (Object)this, (Object[])new Object[]{ejbEndpoint});
            throw new CDIException((Throwable)e);
        }
        return removeMethods;
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public Collection<BusinessInterfaceDescriptor<?>> getLocalBusinessInterfaces() {
        return this.localBusinessInterfaces;
    }

    public Collection<BusinessInterfaceDescriptor<?>> getRemoteBusinessInterfaces() {
        return this.remoteBusinessInterfaces;
    }

    public String getEjbName() {
        return this.ejbJ2EEName.getComponent();
    }

    public Collection<Method> getRemoveMethods() {
        return this.removeMethods;
    }

    public boolean isStateless() {
        return this.isStateless;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public boolean isStateful() {
        return this.isStateful;
    }

    public boolean isMessageDriven() {
        return this.isMessageDriven;
    }

    public boolean isPassivationCapable() {
        return this.isPassivationCapable;
    }

    @Override
    public J2EEName getEjbJ2EEName() {
        return this.ejbJ2EEName;
    }

    @Override
    public EJBReferenceFactory getReferenceFactory() {
        return this.referenceFactory;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.ejbJ2EENameString.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EjbDescriptorImpl other = (EjbDescriptorImpl)obj;
        String otherEjbJ2EENameString = other.getEjbJ2EEName().toString();
        return this.ejbJ2EENameString.equals(otherEjbJ2EENameString);
    }

    public String toString() {
        return "EjbDescriptor: " + this.ejbJ2EENameString;
    }
}

