/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.security;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.messaging.security.RuntimeSecurityService;
import com.ibm.ws.messaging.security.authorization.MessagingAuthorizationException;
import com.ibm.ws.messaging.security.authorization.MessagingAuthorizationService;
import com.ibm.ws.sib.utils.ras.SibTr;
import javax.security.auth.Subject;

public class Authorization {
    private static TraceComponent tc = SibTr.register(Authorization.class, (String)"MessagingSecurity", (String)"com.ibm.ws.messaging.security.CWWKMMessages");
    private static final String CLASS_NAME = "com.ibm.ws.messaging.security.Authorization";
    private MessagingAuthorizationService messagingAuthorizationService = null;
    private final RuntimeSecurityService runtimeSecurityService = RuntimeSecurityService.SINGLETON_INSTANCE;

    public boolean checkQueueAccess(Subject authenticatedSubject, String queue, String operationType) throws MessagingAuthorizationException {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.AuthorizationcheckDestinationAccess", (Object)new Object[]{authenticatedSubject, queue, operationType});
        boolean result = false;
        if (!this.runtimeSecurityService.isMessagingSecure()) {
            result = true;
        } else if (this.messagingAuthorizationService != null) {
            result = this.messagingAuthorizationService.checkQueueAccess(authenticatedSubject, queue, operationType, true);
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.AuthorizationcheckDestinationAccess", (Object)result);
        return result;
    }

    public boolean checkAliasAccess(Subject authenticatedSubject, String destination, String aliasDestination, int destinationType, String operationType) throws MessagingAuthorizationException {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.AuthorizationcheckAliasAccess", (Object)new Object[]{authenticatedSubject, destination, operationType, aliasDestination});
        boolean result = false;
        if (!this.runtimeSecurityService.isMessagingSecure()) {
            result = true;
        } else if (this.messagingAuthorizationService != null) {
            result = this.messagingAuthorizationService.checkAliasAccess(authenticatedSubject, destination, aliasDestination, destinationType, operationType, true);
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.AuthorizationcheckAliasAccess", (Object)result);
        return result;
    }

    public boolean checkTemporaryDestinationAccess(Subject authenticatedSubject, String prefix, String operationType) throws MessagingAuthorizationException {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.AuthorizationcheckTemporaryDestinationAccess", (Object)new Object[]{authenticatedSubject, prefix, operationType});
        boolean result = false;
        if (!this.runtimeSecurityService.isMessagingSecure()) {
            result = true;
        } else if (this.messagingAuthorizationService != null) {
            result = this.messagingAuthorizationService.checkTemporaryDestinationAccess(authenticatedSubject, prefix, operationType);
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.AuthorizationcheckTemporaryDestinationAccess", (Object)result);
        return result;
    }

    public boolean checkTopicAccess(Subject authenticatedSubject, String topicSpace, String topicName, String operationType) throws MessagingAuthorizationException {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.AuthorizationcheckTopicAccess", (Object)new Object[]{authenticatedSubject, topicSpace, topicName, operationType});
        boolean result = false;
        if (!this.runtimeSecurityService.isMessagingSecure()) {
            result = true;
        } else if (this.messagingAuthorizationService != null) {
            result = this.messagingAuthorizationService.checkTopicAccess(authenticatedSubject, topicSpace, topicName, operationType);
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.AuthorizationcheckDestinationAccess", (Object)result);
        return result;
    }

    public void setMessagingAuthorizationService(MessagingAuthorizationService messagingAuthorizationService) {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.AuthorizationsetMessagingAuthorizationService", (Object)messagingAuthorizationService);
        this.messagingAuthorizationService = messagingAuthorizationService;
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.AuthorizationsetMessagingAuthorizationService");
    }
}

