/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.admin.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.ExtendedConfiguration;
import com.ibm.ws.config.admin.internal.ConfigAdminServiceFactory;
import com.ibm.ws.config.admin.internal.ExtendedConfigurationImpl;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConfigurationAdminImpl
implements ConfigurationAdmin {
    private final Bundle bundle;
    private final ConfigAdminServiceFactory caFactory;
    static final long serialVersionUID = -3783880043350273893L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ConfigurationAdminImpl(ConfigAdminServiceFactory casf, Bundle bndl) {
        this.bundle = bndl;
        this.caFactory = casf;
    }

    @Override
    public ExtendedConfiguration createFactoryConfiguration(String factoryPid) throws IOException {
        ExtendedConfiguration config = this.caFactory.getConfigurationStore().createFactoryConfiguration(factoryPid, this.bundle.getLocation());
        return config;
    }

    @Override
    public ExtendedConfiguration createFactoryConfiguration(String factoryPid, String location) throws IOException {
        this.caFactory.checkConfigurationPermission();
        ExtendedConfiguration config = this.caFactory.getConfigurationStore().createFactoryConfiguration(factoryPid, location);
        return config;
    }

    @Override
    public ExtendedConfiguration getConfiguration(String pid) throws IOException {
        ExtendedConfigurationImpl config = this.caFactory.getConfigurationStore().getConfiguration(pid, this.bundle.getLocation());
        if (config.getBundleLocation(false) != null && !config.getBundleLocation(false).equals(this.bundle.getLocation())) {
            this.caFactory.checkConfigurationPermission();
        }
        config.bind(this.bundle);
        return config;
    }

    @Override
    public ExtendedConfiguration getConfiguration(String pid, String location) throws IOException {
        this.caFactory.checkConfigurationPermission();
        return this.caFactory.getConfigurationStore().getConfiguration(pid, location);
    }

    @FFDCIgnore(value={SecurityException.class})
    public ExtendedConfiguration[] listConfigurations(String filterString) throws InvalidSyntaxException {
        if (filterString == null) {
            filterString = "(service.pid=*)";
        }
        try {
            this.caFactory.checkConfigurationPermission();
        }
        catch (SecurityException e) {
            filterString = "(&(service.bundleLocation=" + this.bundle.getLocation() + ")" + filterString + ")";
        }
        return this.caFactory.getConfigurationStore().listConfigurations(FrameworkUtil.createFilter((String)filterString));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ConfigurationAdminImpl.class);
    }
}

