/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.admin.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.admin.ConfigurationDictionary;
import com.ibm.ws.config.admin.ExtendedConfiguration;
import com.ibm.ws.config.admin.internal.ConfigAdminServiceFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.service.cm.Configuration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ExtendedConfigurationImpl
implements ExtendedConfiguration {
    private String bundleLocation = null;
    private Bundle boundBundle;
    private final ConfigAdminServiceFactory caFactory;
    private final String factoryPid;
    private final String pid;
    private ConfigurationDictionary properties = null;
    private int hashCode = 0;
    private boolean deleted = false;
    private boolean inOverridesFile = false;
    private Set<ConfigID> references;
    private Set<String> uniqueVariables = Collections.emptySet();
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicLong changeCount = new AtomicLong();
    private ConfigID configId;
    private volatile boolean sendEvents;
    static final long serialVersionUID = -7173954266841568360L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ExtendedConfigurationImpl(ConfigAdminServiceFactory casf, String bndlLocation, String factoryPid, String pid, Dictionary<String, Object> props, Set<ConfigID> references, Set<String> uniques) {
        this.caFactory = casf;
        this.bundleLocation = bndlLocation;
        this.factoryPid = factoryPid;
        this.pid = pid;
        this.setProperties(props);
        this.references = references;
        this.uniqueVariables = uniques;
        this.addPidMapping();
        this.addReferences();
    }

    @Override
    @Trivial
    public void lock() {
        this.lock.lock();
    }

    @Override
    @Trivial
    public void unlock() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Thread not lock owner");
        }
        this.lock.unlock();
    }

    @Trivial
    protected void checkLocked() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Thread not lock owner");
        }
    }

    @Trivial
    protected boolean bind(Bundle bundle) {
        this.lock.lock();
        try {
            if (this.boundBundle == null && (this.bundleLocation == null || this.bundleLocation.equals(bundle.getLocation()))) {
                this.boundBundle = bundle;
            }
            boolean bl = this.boundBundle == bundle;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Trivial
    protected void unbind(Bundle bundle) {
        this.lock.lock();
        try {
            if (this.boundBundle == bundle) {
                this.boundBundle = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Trivial
    public void delete() throws IOException {
        this.delete(true);
    }

    @Override
    public void delete(boolean fireNotifications) {
        this.lock.lock();
        try {
            this.exceptionIfDeleted();
            this.deleted = true;
            if (fireNotifications) {
                this.fireConfigurationDeleted(null);
            }
            this.removePidMapping();
            this.removeReferences();
        }
        finally {
            this.lock.unlock();
        }
        this.caFactory.getConfigurationStore().removeConfiguration(this.pid);
    }

    @Override
    public void fireConfigurationDeleted(Collection<Future<?>> futureList) {
        Future<?> caFuture = this.caFactory.notifyConfigurationDeleted(this, this.factoryPid != null);
        Future<?> configFuture = this.caFactory.dispatchEvent(2, this.factoryPid, this.pid);
        if (futureList != null) {
            futureList.add(caFuture);
            futureList.add(configFuture);
        }
    }

    @Override
    @Trivial
    public String getBundleLocation() {
        return this.getBundleLocation(true);
    }

    protected String getBundleLocation(boolean checkPermission) {
        this.lock.lock();
        try {
            this.exceptionIfDeleted();
            if (checkPermission) {
                this.caFactory.checkConfigurationPermission();
            }
            if (this.bundleLocation != null) {
                String string = this.bundleLocation;
                return string;
            }
            if (this.boundBundle != null) {
                String string = this.boundBundle.getLocation();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Trivial
    public String getFactoryPid() {
        return this.getFactoryPid(true);
    }

    public String getFactoryPid(boolean checkDeleted) {
        this.lock.lock();
        try {
            if (checkDeleted) {
                this.exceptionIfDeleted();
            }
            String string = this.factoryPid;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Trivial
    public String getPid() {
        return this.getPid(true);
    }

    public String getPid(boolean checkDeleted) {
        this.lock.lock();
        try {
            if (checkDeleted) {
                this.exceptionIfDeleted();
            }
            String string = this.pid;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object getProperty(String key) {
        this.lock.lock();
        try {
            this.exceptionIfDeleted();
            if (this.properties != null) {
                Object object = this.properties.get(key);
                return object;
            }
            Object var2_3 = null;
            return var2_3;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Dictionary<String, Object> getProperties() {
        this.lock.lock();
        try {
            ConfigurationDictionary copy;
            this.exceptionIfDeleted();
            if (this.properties == null) {
                Dictionary<String, Object> dictionary = null;
                return dictionary;
            }
            ConfigurationDictionary configurationDictionary = copy = this.properties.copy();
            return configurationDictionary;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Trivial
    public Dictionary<String, Object> getReadOnlyProperties() {
        this.lock.lock();
        try {
            this.exceptionIfDeleted();
            ConfigurationDictionary configurationDictionary = this.properties;
            return configurationDictionary;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Trivial
    public void setBundleLocation(String bundleLocation) {
        this.setBundleLocation(bundleLocation, true);
    }

    private void setBundleLocation(String bundleLocation, boolean checkPerm) {
        this.lock.lock();
        try {
            this.exceptionIfDeleted();
            if (checkPerm) {
                this.caFactory.checkConfigurationPermission();
            }
            this.bundleLocation = bundleLocation;
            this.boundBundle = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void update() throws IOException {
        this.lock.lock();
        try {
            this.exceptionIfDeleted();
            this.caFactory.getConfigurationStore().saveConfiguration(this.pid, this);
            this.caFactory.notifyConfigurationUpdated(this, this.factoryPid != null);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void update(Dictionary<String, ?> properties) throws IOException {
        this.lock.lock();
        try {
            this.doUpdateProperties(properties);
            this.fireConfigurationUpdated(null);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doUpdateProperties(Dictionary<String, ?> properties) throws IOException {
        this.exceptionIfDeleted();
        this.setProperties(properties);
        this.caFactory.getConfigurationStore().saveConfiguration(this.pid, this);
        this.changeCount.incrementAndGet();
        this.sendEvents = true;
    }

    @Override
    public void updateProperties(Dictionary<String, Object> properties) throws IOException {
        this.lock.lock();
        try {
            this.doUpdateProperties(properties);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void fireConfigurationUpdated(Collection<Future<?>> futureList) {
        if (this.sendEvents) {
            this.sendEvents = false;
            Future<?> caFuture = this.caFactory.notifyConfigurationUpdated(this, this.factoryPid != null);
            Future<?> configFuture = this.caFactory.dispatchEvent(1, this.factoryPid, this.pid);
            if (futureList != null) {
                if (caFuture != null) {
                    futureList.add(caFuture);
                }
                if (configFuture != null) {
                    futureList.add(configFuture);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCache(Dictionary<String, Object> properties, Set<ConfigID> references, Set<String> newUniques) throws IOException {
        this.lock.lock();
        try {
            this.removeReferences();
            this.setProperties(properties);
            this.references = references;
            this.uniqueVariables = newUniques;
            this.caFactory.getConfigurationStore().saveConfiguration(this.pid, this);
            this.changeCount.incrementAndGet();
            this.addReferences();
            this.sendEvents = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ConfigID getFullId() {
        if (this.configId != null) {
            return this.configId;
        }
        if (this.factoryPid == null) {
            return new ConfigID(this.pid);
        }
        String id = (String)this.properties.get("config.id");
        if (id == null) {
            return new ConfigID(this.factoryPid, null);
        }
        return ConfigID.fromProperty(id);
    }

    @Override
    @Trivial
    public Set<ConfigID> getReferences() {
        this.lock.lock();
        try {
            Set<ConfigID> set = this.references;
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Trivial
    private void removeReferences() {
        if (this.properties != null && this.references != null) {
            ConfigID configId = this.getFullId();
            this.caFactory.removeReferences(this.references, configId);
        }
    }

    @Trivial
    private void addReferences() {
        if (this.properties != null && this.references != null) {
            ConfigID configId = this.getFullId();
            this.caFactory.addReferences(this.references, configId);
        }
    }

    @Trivial
    private void addPidMapping() {
        if (this.properties != null && this.factoryPid != null && this.caFactory != null) {
            this.caFactory.registerConfiguration(this.getFullId(), this);
        }
    }

    @Trivial
    private void removePidMapping() {
        if (this.properties != null && this.factoryPid != null) {
            this.caFactory.unregisterConfiguration(this.getFullId());
        }
    }

    @Override
    @Trivial
    public boolean equals(Object o) {
        if (o != null && o instanceof Configuration) {
            String oPid = ((Configuration)o).getPid();
            if (this.pid == null) {
                return oPid == null;
            }
            return this.pid.equals(oPid);
        }
        return false;
    }

    @Override
    @Trivial
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.pid.hashCode();
        }
        return this.hashCode;
    }

    private void setProperties(Dictionary<String, ?> d) {
        if (d == null) {
            this.properties = null;
            return;
        }
        ConfigurationDictionary newDictionary = new ConfigurationDictionary();
        Enumeration<String> keys = d.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (newDictionary.get(key) == null) {
                Object value = d.get(key);
                if (value.getClass().isArray()) {
                    int arrayLength = Array.getLength(value);
                    Object copyOfArray = Array.newInstance(value.getClass().getComponentType(), arrayLength);
                    System.arraycopy(value, 0, copyOfArray, 0, arrayLength);
                    newDictionary.put(key, copyOfArray);
                    continue;
                }
                if (value instanceof Collection) {
                    newDictionary.put(key, (Object)new Vector((Collection)value));
                    continue;
                }
                newDictionary.put(key, value);
                continue;
            }
            throw new IllegalArgumentException(key + " is already present or is a case variant.");
        }
        if (this.factoryPid != null) {
            newDictionary.put("service.factoryPid", (Object)this.factoryPid);
        }
        newDictionary.put("service.pid", (Object)this.pid);
        if (this.inOverridesFile) {
            newDictionary.put("config.overrides", (Object)"true");
        }
        this.properties = newDictionary;
        this.addPidMapping();
    }

    @Override
    @Trivial
    public void setInOverridesFile(boolean inOverridesFile) {
        this.lock.lock();
        try {
            this.inOverridesFile = inOverridesFile;
            if (this.properties != null) {
                if (inOverridesFile) {
                    this.properties.put("config.overrides", (Object)"true");
                } else {
                    this.properties.remove("config.overrides");
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Trivial
    public boolean isInOverridesFile() {
        this.lock.lock();
        try {
            this.exceptionIfDeleted();
            if (this.properties != null) {
                boolean bl = this.properties.get("config.overrides") != null;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Trivial
    private void exceptionIfDeleted() {
        if (this.deleted) {
            throw new IllegalStateException("Configuration pid " + this.pid + " was deleted.");
        }
    }

    @Override
    @Trivial
    public boolean isDeleted() {
        return this.deleted;
    }

    @Trivial
    public String toString() {
        return this.getClass().getSimpleName() + "[pid=" + this.pid + ",factoryPid=" + this.factoryPid + ",boundBundle=" + this.boundBundle + ",bundleLocation=" + this.bundleLocation + "]";
    }

    @Override
    @Trivial
    public Set<String> getUniqueVariables() {
        this.lock.lock();
        try {
            if (this.uniqueVariables == null) {
                Set<String> set = Collections.emptySet();
                return set;
            }
            Set<String> set = this.uniqueVariables;
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Trivial
    public long getChangeCount() {
        return this.changeCount.get();
    }

    @Override
    public void setFullId(ConfigID id) {
        this.configId = id;
    }

    @Trivial
    protected boolean matchesFilter(Filter filter) {
        if (this.properties != null) {
            return this.properties.matches(filter);
        }
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ExtendedConfigurationImpl.class);
    }
}

