/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigEvaluatorException;
import com.ibm.websphere.config.ConfigRetrieverException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.admin.ConfigurationDictionary;
import com.ibm.ws.config.admin.ExtendedConfiguration;
import com.ibm.ws.config.xml.internal.AttributeValidationException;
import com.ibm.ws.config.xml.internal.ConfigElement;
import com.ibm.ws.config.xml.internal.ConfigExpressionEvaluator;
import com.ibm.ws.config.xml.internal.ConfigMergeException;
import com.ibm.ws.config.xml.internal.ConfigNotFoundException;
import com.ibm.ws.config.xml.internal.ConfigRetriever;
import com.ibm.ws.config.xml.internal.ConfigVariableRegistry;
import com.ibm.ws.config.xml.internal.ConfigurationInfo;
import com.ibm.ws.config.xml.internal.FactoryElement;
import com.ibm.ws.config.xml.internal.MetaTypeHelper;
import com.ibm.ws.config.xml.internal.MetaTypeRegistry;
import com.ibm.ws.config.xml.internal.ServerConfiguration;
import com.ibm.ws.config.xml.internal.ServerXMLConfiguration;
import com.ibm.ws.config.xml.internal.SimpleElement;
import com.ibm.ws.config.xml.internal.SingletonElement;
import com.ibm.ws.config.xml.internal.XMLConfigConstants;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import org.osgi.service.cm.Configuration;
import org.osgi.service.metatype.AttributeDefinition;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConfigEvaluator {
    private static final TraceComponent tc = Tr.register(ConfigEvaluator.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private static final String EMPTY_STRING = "";
    private static final String ALL_PIDS = "*";
    private final ConfigRetriever configRetriever;
    private final MetaTypeRegistry metatypeRegistry;
    private final ConfigVariableRegistry variableRegistry;
    private final ServerXMLConfiguration serverXMLConfig;
    static final long serialVersionUID = 5245532984346892633L;

    ConfigEvaluator(ConfigRetriever retriever, MetaTypeRegistry metatypeRegistry, ConfigVariableRegistry variableRegistry, ServerXMLConfiguration serverXmlConfig) {
        this.configRetriever = retriever;
        this.metatypeRegistry = metatypeRegistry;
        this.variableRegistry = variableRegistry;
        this.serverXMLConfig = serverXmlConfig;
    }

    private Object evaluateSimple(Object rawValue, EvaluationContext context, boolean ignoreWarnings) throws ConfigEvaluatorException {
        if (rawValue instanceof String) {
            return this.convertObjectToSingleValue(rawValue, null, context, -1, ignoreWarnings);
        }
        if (rawValue instanceof List) {
            return this.convertListToStringArray((List)rawValue, null, context, ignoreWarnings);
        }
        throw new IllegalStateException("Unsupported type: " + rawValue.getClass());
    }

    EvaluationResult evaluate(ConfigElement config, MetaTypeRegistry.RegistryEntry registryEntry) throws ConfigEvaluatorException {
        return this.evaluate(config, registryEntry, EMPTY_STRING, false);
    }

    EvaluationResult evaluate(ConfigElement config, MetaTypeRegistry.RegistryEntry registryEntry, String flatPrefix, boolean ignoreWarnings) throws ConfigEvaluatorException {
        List<AttributeDefinition> requiredAttributes;
        Map<String, ExtendedAttributeDefinition> attributeMap;
        if (registryEntry != null) {
            if (registryEntry.getExtends() != null) {
                String pid = registryEntry.getPid();
                attributeMap = this.metatypeRegistry.getHierarchyCompleteAttributeMap(pid);
                requiredAttributes = this.metatypeRegistry.getRequiredAttributesForHierarchy(pid);
            } else {
                attributeMap = registryEntry.getAttributeMap();
                requiredAttributes = registryEntry.getObjectClassDefinition().getRequiredAttributes();
            }
        } else {
            attributeMap = null;
            requiredAttributes = Collections.emptyList();
        }
        return this.evaluate(config, registryEntry, attributeMap, requiredAttributes, flatPrefix, ignoreWarnings);
    }

    private EvaluationResult evaluate(ConfigElement config, MetaTypeRegistry.RegistryEntry registryEntry, Map<String, ExtendedAttributeDefinition> attributeMap, List<AttributeDefinition> requiredAttributes, String flatPrefix, boolean ignoreWarnings) throws ConfigEvaluatorException {
        ConfigurationDictionary map = new ConfigurationDictionary();
        EvaluationContext context = new EvaluationContext(registryEntry);
        context.setConfigElement(config);
        context.setProperties(map);
        if (attributeMap != null) {
            String attributeName;
            ExtendedAttributeDefinition attributeDef;
            context.setAttributeDefinitionMap(attributeMap);
            for (Map.Entry<String, Object> entry : attributeMap.entrySet()) {
                Object value;
                attributeDef = (ExtendedAttributeDefinition)entry.getValue();
                if (attributeDef.isFinal() || "config.parentPID".equals(attributeName = entry.getKey()) || (value = this.evaluateMetaTypeAttribute(attributeName, context, attributeDef, flatPrefix, ignoreWarnings)) != null || !this.required(attributeDef.getID(), requiredAttributes) || context.hasUnresolvedAttribute(attributeDef) || ignoreWarnings) continue;
                String nodeName = registryEntry.getAlias();
                if (nodeName == null) {
                    nodeName = registryEntry.getChildAlias();
                }
                if (nodeName == null) {
                    nodeName = config.getNodeName();
                }
                if (config.getId() == null) {
                    Tr.error((TraceComponent)tc, (String)"error.missing.required.attribute.singleton", (Object[])new Object[]{nodeName, attributeName});
                } else {
                    Tr.error((TraceComponent)tc, (String)"error.missing.required.attribute", (Object[])new Object[]{nodeName, attributeName, config.getId()});
                }
                context.setValid(false);
            }
            for (Map.Entry<String, Object> entry : attributeMap.entrySet()) {
                attributeDef = (ExtendedAttributeDefinition)entry.getValue();
                if (!attributeDef.isFinal() || "config.parentPID".equals(attributeName = entry.getKey())) continue;
                this.evaluateMetaTypeAttribute(attributeName, context, attributeDef, flatPrefix, ignoreWarnings);
            }
        }
        for (Map.Entry<String, Object> entry : config.getAttributes().entrySet()) {
            String attributeName = entry.getKey();
            if (attributeName.startsWith("config.") || context.isProcessed(attributeName)) continue;
            if (flatPrefix != null && attributeName.equals("id") && config instanceof SimpleElement && !((SimpleElement)config).isUsingNonDefaultId()) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"skipping default id for flattened element", (Object[])new Object[0]);
                continue;
            }
            Object attributeValue = entry.getValue();
            this.evaluateSimpleAttribute(attributeName, attributeValue, context, flatPrefix, ignoreWarnings);
        }
        if (config.getId() != null) {
            ((Dictionary)map).put("config.id", config.getConfigID().toString());
        }
        ((Dictionary)map).put("config.displayId", config.getDisplayId());
        if (config.getParent() != null && (flatPrefix == null || flatPrefix.equals(EMPTY_STRING))) {
            if (config.getParent().getId() == null) {
                ((Dictionary)map).put("config.parentPID", config.getParent().getConfigID().toString());
            } else {
                String parentPid = this.lookupPid(config.getParent().getConfigID());
                if (parentPid != null) {
                    ((Dictionary)map).put("config.parentPID", parentPid);
                }
            }
        }
        context.evaluateCopiedAttributes();
        return context.getEvaluationResult();
    }

    private boolean required(String id, List<AttributeDefinition> requiredAttributes) {
        for (AttributeDefinition ad : requiredAttributes) {
            if (!id.equals(ad.getID())) continue;
            return true;
        }
        return false;
    }

    private Object evaluateSimpleAttribute(String attributeName, Object attributeValue, EvaluationContext context, String flatPrefix, boolean ignoreWarnings) throws ConfigEvaluatorException {
        context.setAttributeName(attributeName);
        context.addProcessed(attributeName);
        Object value = this.evaluateSimple(attributeValue, context, ignoreWarnings);
        if (value != null) {
            context.setProperty(flatPrefix + attributeName, value);
        }
        this.evaluateFinish(context);
        return value;
    }

    @FFDCIgnore(value={ConfigEvaluatorException.class, ConfigRetrieverException.class})
    private Object evaluateMetaTypeAttribute(final String attributeName, final EvaluationContext context, final ExtendedAttributeDefinition attributeDef, final String flatPrefix, final boolean ignoreWarnings) throws ConfigEvaluatorException {
        final ConfigElement config = context.getConfigElement();
        context.setAttributeName(attributeName);
        context.addProcessed(attributeName);
        Object rawValue = null;
        if (attributeDef.getCopyOf() != null) {
            AttributeValueCopy copy = new AttributeValueCopy(flatPrefix + attributeName, attributeDef.getCopyOf());
            context.addAttributeValueCopy(copy);
        }
        if (attributeDef.isFlat()) {
            MetaTypeRegistry.RegistryEntry nestedRegistryEntry = this.getRegistryEntry(attributeDef.getReferencePid());
            if (nestedRegistryEntry == null) {
                return null;
            }
            final HashSet<String> processedNames = new HashSet<String>();
            final AtomicInteger i = new AtomicInteger();
            String[] referenceAttributes = ConfigEvaluator.getReferenceAttributes(attributeName);
            this.evaluateFlatReference(referenceAttributes, context, nestedRegistryEntry, flatPrefix, config, i, processedNames, ignoreWarnings, attributeDef);
            ConfigEvaluatorException e = nestedRegistryEntry.traverseHierarchy(new MetaTypeRegistry.EntryAction<ConfigEvaluatorException>(){
                private ConfigEvaluatorException result;
                static final long serialVersionUID = 5749633876139111745L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean entry(MetaTypeRegistry.RegistryEntry registryEntry) {
                    String elementName = registryEntry.getEffectiveAD(attributeName);
                    if (elementName != null) {
                        context.addProcessed(elementName);
                        try {
                            ConfigEvaluator.this.evaluateFlatAttribute(attributeName, elementName, context, registryEntry, flatPrefix, config, i, processedNames, ignoreWarnings);
                        }
                        catch (ConfigEvaluatorException configEvaluatorException) {
                            void e;
                            FFDCFilter.processException((Throwable)configEvaluatorException, (String)"com.ibm.ws.config.xml.internal.ConfigEvaluator$1", (String)"314", (Object)this, (Object[])new Object[]{registryEntry});
                            this.result = e;
                            return false;
                        }
                    }
                    return true;
                }

                @Override
                public ConfigEvaluatorException getResult() {
                    return this.result;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
            if (e != null) {
                throw e;
            }
            this.evaluateFlatAttribute(attributeName, attributeName, context, nestedRegistryEntry, flatPrefix, config, i, processedNames, ignoreWarnings);
            int cardinality = attributeDef.getCardinality();
            int n = cardinality == Integer.MIN_VALUE ? Integer.MAX_VALUE : (cardinality < 0 ? -cardinality : (cardinality = cardinality == 0 ? 1 : cardinality));
            if (i.get() > cardinality) {
                throw new ConfigEvaluatorException("Attribute " + attributeDef.getID() + " exceeded maximum allowed size " + cardinality);
            }
            return i.get() == 0 ? null : i;
        }
        Object actualValue = context.getProperties().get(attributeDef.getID());
        if (actualValue != null) {
            return actualValue;
        }
        if (!attributeDef.isFinal()) {
            if (attributeDef.getType() == 1001) {
                MetaTypeRegistry.RegistryEntry registryEntry;
                if (attributeDef.getReferencePid() != null && (registryEntry = this.getRegistryEntry(attributeDef.getReferencePid())) != null) {
                    rawValue = registryEntry.traverseHierarchy(new MetaTypeRegistry.EntryAction<Object>(){
                        private Object rawValue;
                        static final long serialVersionUID = -8012042617567762178L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public boolean entry(MetaTypeRegistry.RegistryEntry registryEntry) {
                            if (registryEntry.getEffectiveAD(attributeName) != null) {
                                this.rawValue = ConfigEvaluator.this.mergeReferenceAttributes(registryEntry.getEffectiveAD(attributeName), context, attributeDef, config, this.rawValue);
                            }
                            return true;
                        }

                        @Override
                        public Object getResult() {
                            return this.rawValue;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(2.class);
                        }
                    });
                }
                rawValue = this.mergeReferenceAttributes(attributeName, context, attributeDef, config, rawValue);
            } else {
                rawValue = config.getAttribute(attributeName);
            }
        } else {
            if (this.isWildcardReference(attributeDef)) {
                String factoryPid = attributeDef.getReferencePid();
                WildcardReference ref = new WildcardReference(factoryPid, attributeDef, context.getConfigElement().getConfigID());
                context.addUnresolvedReference(ref);
                try {
                    ExtendedConfiguration[] configs = this.configRetriever.findAllConfigurationsByPid(factoryPid);
                    configs = configs == null ? new ExtendedConfiguration[]{} : configs;
                    ArrayList<String> pids = new ArrayList<String>(configs.length);
                    for (ExtendedConfiguration extConfig : configs) {
                        pids.add(extConfig.getPid());
                    }
                    actualValue = attributeDef.getCardinality() > 0 ? pids.toArray(new String[0]) : pids;
                    if (actualValue != null) {
                        context.setProperty(flatPrefix + attributeName, actualValue);
                    }
                    this.evaluateFinish(context);
                    return actualValue;
                }
                catch (ConfigRetrieverException e) {
                    throw new ConfigEvaluatorException("problem looking up configurations with factoryPid " + factoryPid);
                }
            }
            if (this.isWildcardService(attributeDef)) {
                String service = attributeDef.getService();
                WildcardService ref = new WildcardService(service, attributeDef, context.getConfigElement().getConfigID());
                context.addUnresolvedReference(ref);
                try {
                    String[] pids = new ArrayList();
                    List<MetaTypeRegistry.RegistryEntry> entries = this.metatypeRegistry.getEntriesExposingService(service);
                    if (entries != null) {
                        for (MetaTypeRegistry.RegistryEntry entry : entries) {
                            ExtendedConfiguration[] configs = this.configRetriever.findAllConfigurationsByPid(entry.getPid());
                            for (ExtendedConfiguration extConfig : configs = configs == null ? new ExtendedConfiguration[]{} : configs) {
                                pids.add(extConfig.getPid());
                            }
                        }
                    }
                    if ((actualValue = attributeDef.getCardinality() > 0 ? pids.toArray(new String[0]) : pids) != null) {
                        context.setProperty(flatPrefix + attributeName, actualValue);
                    }
                    this.evaluateFinish(context);
                    return actualValue;
                }
                catch (ConfigRetrieverException e) {
                    throw new ConfigEvaluatorException("problem looking up configurations with service " + service);
                }
            }
        }
        if (rawValue == null) {
            rawValue = this.getUnconfiguredAttributeValue(context, attributeDef);
        }
        if (rawValue != null) {
            block32: {
                try {
                    actualValue = this.evaluateMetaType(rawValue, attributeDef, context, ignoreWarnings);
                }
                catch (ConfigEvaluatorException iae) {
                    String[] validOptions = attributeDef.getOptionValues();
                    if (validOptions == null) {
                        Object badValue = rawValue;
                        rawValue = this.getUnconfiguredAttributeValue(context, attributeDef);
                        if (rawValue != null && !ignoreWarnings) {
                            Tr.warning((TraceComponent)tc, (String)"warn.config.validate.failed", (Object[])new Object[]{iae.getMessage()});
                            Tr.warning((TraceComponent)tc, (String)"warn.config.invalid.using.default.value", (Object[])new Object[]{attributeDef.getID(), badValue, rawValue});
                            actualValue = this.evaluateMetaType(rawValue, attributeDef, context, ignoreWarnings);
                        }
                        throw iae;
                    }
                    if (tc.isWarningEnabled() && !ignoreWarnings) {
                        StringBuffer strBuffer = new StringBuffer();
                        for (int i = 0; i < validOptions.length; ++i) {
                            strBuffer.append("[");
                            strBuffer.append(validOptions[i]);
                            strBuffer.append("]");
                        }
                        Tr.warning((TraceComponent)tc, (String)"warn.config.invalid.value", (Object[])new Object[]{attributeDef.getID(), rawValue, strBuffer.toString()});
                    }
                    if ((rawValue = this.getUnconfiguredAttributeValue(context, attributeDef)) == null) break block32;
                    actualValue = this.evaluateMetaType(rawValue, attributeDef, context, ignoreWarnings);
                }
            }
            if (actualValue != null) {
                context.setProperty(flatPrefix + attributeName, actualValue);
            }
            this.evaluateFinish(context);
        }
        return actualValue;
    }

    boolean isWildcardReference(ExtendedAttributeDefinition attributeDef) {
        return attributeDef.getType() == 1001 && attributeDef.getDefaultValue() != null && attributeDef.getDefaultValue().length > 0 && ALL_PIDS.equals(attributeDef.getDefaultValue()[0]) && attributeDef.getReferencePid() != null;
    }

    boolean isWildcardService(ExtendedAttributeDefinition attributeDef) {
        return attributeDef.getType() == 1001 && attributeDef.getDefaultValue() != null && attributeDef.getDefaultValue().length > 0 && ALL_PIDS.equals(attributeDef.getDefaultValue()[0]) && attributeDef.getService() != null;
    }

    private Object mergeReferenceAttributes(String attributeName, EvaluationContext context, ExtendedAttributeDefinition attributeDef, ConfigElement config, Object rawValues) {
        Object refRawValue;
        String[] referenceAttributes = ConfigEvaluator.getReferenceAttributes(attributeName);
        context.addProcessed(referenceAttributes[0]);
        context.addProcessed(referenceAttributes[1]);
        List<Object> rawValue = config.getAttribute(referenceAttributes[1]);
        if (rawValue == null) {
            rawValue = config.getAttribute(referenceAttributes[0]);
        } else if (attributeDef.getCardinality() != 0 && (refRawValue = config.getAttribute(referenceAttributes[0])) != null) {
            rawValue = ConfigEvaluator.mergeReferenceValues(attributeDef, refRawValue, rawValue);
        }
        if (rawValues == null) {
            return rawValue;
        }
        if (rawValue == null || attributeDef.getCardinality() == 0) {
            return rawValues;
        }
        return ConfigEvaluator.mergeReferenceValues(attributeDef, rawValues, rawValue);
    }

    private void evaluateFlatAttribute(String attributeName, String elementName, EvaluationContext context, MetaTypeRegistry.RegistryEntry nestedRegistryEntry, String flatPrefix, ConfigElement config, AtomicInteger i, Set<String> processedNames, boolean ignoreWarnings) throws ConfigEvaluatorException {
        if (processedNames.contains(elementName)) {
            return;
        }
        processedNames.add(elementName);
        Object rawValue = config.getAttribute(elementName);
        if (rawValue == null) {
            return;
        }
        if (!(rawValue instanceof List)) {
            return;
        }
        List rawList = (List)rawValue;
        int cardinality = context.getAttributeDefinition(attributeName).getCardinality();
        if (rawList.size() > 1 && -1 <= cardinality && cardinality <= 1) {
            SimpleElement element = this.mergeConfigElementValues(rawList, context);
            this.flattenConfigElement(element, flatPrefix, i, attributeName, elementName, context, nestedRegistryEntry, ignoreWarnings);
        } else {
            for (Object o : rawList) {
                if (!(o instanceof ConfigElement)) continue;
                this.flattenConfigElement((ConfigElement)o, flatPrefix, i, attributeName, elementName, context, nestedRegistryEntry, ignoreWarnings);
            }
        }
    }

    private void flattenConfigElement(ConfigElement nestedElement, String flatPrefix, AtomicInteger i, String attributeName, String elementName, EvaluationContext context, MetaTypeRegistry.RegistryEntry nestedRegistryEntry, boolean ignoreWarnings) throws ConfigEvaluatorException {
        String subPrefix = flatPrefix + attributeName + "." + i.get() + ".";
        context.addProcessed(elementName);
        EvaluationResult result = context.getEvaluationResult();
        EvaluationResult nestedResult = this.evaluate(nestedElement, nestedRegistryEntry, subPrefix, ignoreWarnings);
        if (nestedResult.isValid()) {
            i.incrementAndGet();
            Dictionary<String, Object> nestedProperties = nestedResult.getProperties();
            context.setProperty(subPrefix + "config.referenceType", nestedRegistryEntry.getPid());
            Enumeration<String> keys = nestedProperties.keys();
            while (keys.hasMoreElements()) {
                String string = keys.nextElement();
                Object value = nestedProperties.get(string);
                context.setProperty(string, value);
            }
            for (Map.Entry entry : nestedResult.getNested().entrySet()) {
                result.addNested((ConfigID)entry.getKey(), (EvaluationResult)entry.getValue());
            }
        }
        for (UnresolvedPidType child : nestedResult.getUnresolvedReferences()) {
            if (child instanceof UnresolvedReference) {
                UnresolvedReference unresolvedReference = (UnresolvedReference)child;
                result.addUnresolvedReference(new UnresolvedReference(unresolvedReference.getPid(), unresolvedReference.getAttributeDefinition(), unresolvedReference.value, context.getConfigElement().getConfigID()));
                continue;
            }
            if (!(child instanceof UnresolvedService)) continue;
            UnresolvedService unresolvedService = (UnresolvedService)child;
            result.addUnresolvedReference(new UnresolvedService(unresolvedService.getService(), unresolvedService.getAttributeDefinition(), unresolvedService.value, context.getConfigElement().getConfigID(), unresolvedService.getCount()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void evaluateFlatReference(final String[] attributeName, final EvaluationContext context, MetaTypeRegistry.RegistryEntry nestedRegistryEntry, final String flatPrefix, ConfigElement config, final AtomicInteger i, Set<String> processedNames, final boolean ignoreWarnings, ExtendedAttributeDefinition attributeDef) throws ConfigEvaluatorException {
        String refName = null;
        Object rawValue = null;
        for (String attName : attributeName) {
            rawValue = config.getAttribute(attName);
            if (!(rawValue instanceof String)) continue;
            refName = attName;
            break;
        }
        if (refName != null) {
            processedNames.add(attributeName[0]);
            processedNames.add(attributeName[1]);
            ServerConfiguration serverConfiguration = this.serverXMLConfig.getConfiguration();
            List<String> ids = ConfigEvaluator.getAsList((String)rawValue, attributeDef);
            for (String id : ids) {
                FactoryElement refElement;
                try {
                    refElement = serverConfiguration.getFactoryInstance(nestedRegistryEntry.getPid(), nestedRegistryEntry.getAlias(), id);
                }
                catch (ConfigMergeException configMergeException) {
                    void e;
                    FFDCFilter.processException((Throwable)configMergeException, (String)"com.ibm.ws.config.xml.internal.ConfigEvaluator", (String)"636", (Object)this, (Object[])new Object[]{attributeName, context, nestedRegistryEntry, flatPrefix, config, i, processedNames, ignoreWarnings, attributeDef});
                    throw new ConfigEvaluatorException((Throwable)e);
                }
                if (refElement == null) {
                    new UnresolvedReference(null, attributeDef, null, config.getConfigID()).reportError();
                    continue;
                }
                final String elementName = ((ConfigElement)refElement).getNodeName();
                ConfigEvaluatorException e = nestedRegistryEntry.traverseHierarchyWithRoot(new MetaTypeRegistry.EntryAction<ConfigEvaluatorException>(){
                    private ConfigEvaluatorException result;
                    static final long serialVersionUID = 4605406840454021503L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public boolean entry(MetaTypeRegistry.RegistryEntry registryEntry) {
                        if (elementName.equals(registryEntry.getPid()) || elementName.equals(registryEntry.getAlias())) {
                            context.addProcessed(attributeName[0]);
                            try {
                                ConfigEvaluator.this.flattenConfigElement(refElement, flatPrefix, i, attributeName[1], elementName, context, registryEntry, ignoreWarnings);
                            }
                            catch (ConfigEvaluatorException configEvaluatorException) {
                                void e;
                                FFDCFilter.processException((Throwable)configEvaluatorException, (String)"com.ibm.ws.config.xml.internal.ConfigEvaluator$3", (String)"657", (Object)this, (Object[])new Object[]{registryEntry});
                                this.result = e;
                                return false;
                            }
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public ConfigEvaluatorException getResult() {
                        return this.result;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(3.class);
                    }
                });
                if (e == null) continue;
                throw e;
            }
        }
    }

    private Object getUnconfiguredAttributeValue(EvaluationContext context, ExtendedAttributeDefinition attributeDef) throws ConfigEvaluatorException {
        String[] defaultValues;
        List<String> rawValue = null;
        if (this.variableRegistry != null) {
            rawValue = this.lookupVariableExtension(context, attributeDef);
        }
        if (rawValue == null && (defaultValues = attributeDef.getDefaultValue()) != null) {
            rawValue = Arrays.asList(defaultValues);
        }
        return rawValue;
    }

    private void evaluateFinish(EvaluationContext context) throws ConfigEvaluatorException {
        for (NestedInfo nestedInfo : context.getNestedInfo()) {
            MetaTypeRegistry.RegistryEntry registryEntry = nestedInfo.registryEntry;
            ConfigElement configElement = nestedInfo.configElement;
            EvaluationResult nestedResult = this.evaluate(configElement, registryEntry);
            nestedResult.setPid(nestedInfo.pid);
            if (!nestedResult.isValid()) continue;
            EvaluationResult result = context.getEvaluationResult();
            result.addNested(configElement.getConfigID(), nestedResult);
        }
        context.getNestedInfo().clear();
    }

    private List<?> mergeValues(List<?> values, ExtendedAttributeDefinition attrDef, EvaluationContext context) throws ConfigEvaluatorException {
        int size = values.size();
        if (size == 1) {
            return values;
        }
        SimpleElement configElement = this.mergeConfigElementValues(values, context);
        if (configElement == null) {
            return Collections.singletonList(values.get(0));
        }
        return Collections.singletonList(configElement);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object evaluateMetaType(Object value, ExtendedAttributeDefinition attrDef, EvaluationContext context, boolean ignoreWarnings) throws ConfigEvaluatorException {
        void var7_14;
        Vector<Object> convertedValue = null;
        int cardinality = attrDef.getCardinality();
        if (cardinality == 0) {
            if (value instanceof String) {
                return this.convertObjectToSingleValue(value, attrDef, context, -1, ignoreWarnings);
            }
            if (!(value instanceof List)) throw new IllegalStateException("Unsupported type: " + value.getClass());
            List list = (List)value;
            this.validateCardinality(list, attrDef);
            return this.convertListToSingleValue(list, attrDef, context, ignoreWarnings);
        }
        if (cardinality == -1 || cardinality == 1) {
            if (value instanceof String) {
                List<String> list = MetaTypeHelper.parseValue((String)value);
                List<?> list2 = this.mergeValues(list, attrDef, context);
                if (cardinality != -1) return this.convertListToArray(list2, attrDef, context, ignoreWarnings);
                return this.convertListToVector(list2, attrDef, context, ignoreWarnings);
            }
            if (!(value instanceof List)) throw new IllegalStateException("Unsupported type: " + value.getClass());
            List list = (List)value;
            this.validateCardinality(list, attrDef);
            List<?> list3 = this.mergeValues(list, attrDef, context);
            if (cardinality != -1) return this.convertListToArray(list3, attrDef, context, ignoreWarnings);
            return this.convertListToVector(list3, attrDef, context, ignoreWarnings);
        }
        if (value instanceof String) {
            List<String> list = ConfigEvaluator.getAsList((String)value, attrDef);
        } else {
            if (!(value instanceof List)) throw new IllegalStateException("Unsupported type: " + value.getClass());
            List list = (List)value;
        }
        this.validateCardinality((List<?>)var7_14, attrDef);
        if (cardinality >= 0) return this.convertListToArray((List<?>)var7_14, attrDef, context, ignoreWarnings);
        return this.convertListToVector((List<?>)var7_14, attrDef, context, ignoreWarnings);
    }

    private void validateCardinality(List<?> values, ExtendedAttributeDefinition attrDef) throws ConfigEvaluatorException {
        int maxSize = attrDef.getCardinality() < 1 ? 0 - attrDef.getCardinality() : attrDef.getCardinality();
        int n = maxSize = maxSize == Integer.MIN_VALUE ? Integer.MAX_VALUE : maxSize;
        if (-1 <= maxSize && maxSize <= 1) {
            return;
        }
        if (values.size() <= maxSize) {
            return;
        }
        if (attrDef.getType() == 1001) {
            MetaTypeRegistry.RegistryEntry entry = this.metatypeRegistry.getRegistryEntry(attrDef.getReferencePid());
            if (entry != null && entry.isSingleton()) {
                return;
            }
            HashSet<String> ids = new HashSet<String>();
            int nullIds = 0;
            for (Object value : values) {
                if (value instanceof ConfigElement) {
                    ConfigElement element = (ConfigElement)value;
                    if (element.getId() == null) {
                        ++nullIds;
                        continue;
                    }
                    ids.add(element.getId());
                    continue;
                }
                if (!(value instanceof String)) continue;
                ids.add(value.toString());
            }
            int size = ids.size() + nullIds;
            if (size > maxSize) {
                throw new ConfigEvaluatorException("Attribute " + attrDef.getID() + " exceeded maximum allowed size " + maxSize);
            }
        } else if (values.size() > maxSize) {
            throw new ConfigEvaluatorException("Attribute " + attrDef.getID() + " exceeded maximum allowed size " + maxSize);
        }
    }

    private boolean isHiddenExtension(ExtendedAttributeDefinition attrDef, EvaluationContext context) {
        if (attrDef == null) {
            MetaTypeRegistry.RegistryEntry registryEntry = context.getEvaluationResult().getRegistryEntry();
            return registryEntry != null && registryEntry.supportsHiddenExtensions();
        }
        return false;
    }

    private Object convertObjectToSingleValue(Object rawValue, ExtendedAttributeDefinition attrDef, EvaluationContext context, int index, boolean ignoreWarnings) throws ConfigEvaluatorException {
        if (rawValue instanceof String) {
            return this.convertStringToSingleValue((String)rawValue, attrDef, context, ignoreWarnings);
        }
        if (rawValue instanceof ConfigElement.Reference) {
            ConfigElement.Reference reference = this.processReference((ConfigElement.Reference)rawValue, context, ignoreWarnings);
            if (attrDef != null && attrDef.getType() == 1001) {
                return this.evaluateReference(reference.getId(), attrDef, context);
            }
            return this.evaluateReference(reference, context);
        }
        if (rawValue instanceof ConfigElement) {
            return this.convertConfigElementToSingleValue((ConfigElement)rawValue, attrDef, context, index, ignoreWarnings);
        }
        throw new IllegalStateException("Unsupported type: " + rawValue.getClass());
    }

    private String resolveStringValue(Object rawValue, ExtendedAttributeDefinition attrDef, EvaluationContext context, boolean ignoreWarnings) throws ConfigEvaluatorException {
        if (rawValue instanceof String) {
            return this.processString((String)rawValue, attrDef, context, ignoreWarnings);
        }
        if (rawValue instanceof ConfigElement) {
            return this.processString(((ConfigElement)rawValue).getElementValue(), attrDef, context, ignoreWarnings);
        }
        throw new IllegalStateException("Attribute type mismatch. Expected String type, got " + rawValue);
    }

    private Object convertStringToSingleValue(String rawValue, ExtendedAttributeDefinition attrDef, EvaluationContext context, boolean ignoreWarnings) throws ConfigEvaluatorException {
        String value = this.processString(rawValue, attrDef, context, ignoreWarnings);
        return this.evaluateString(value, attrDef, context);
    }

    private Object evaluateString(String strVal, ExtendedAttributeDefinition attrDef, EvaluationContext context) throws ConfigEvaluatorException {
        if (attrDef == null) {
            return strVal;
        }
        int type = attrDef.getType();
        if (type == 11) {
            return Boolean.valueOf(strVal);
        }
        if (type == 6) {
            return Byte.valueOf(strVal);
        }
        if (type == 5) {
            return Character.valueOf(strVal.charAt(0));
        }
        if (type == 7) {
            return Double.valueOf(strVal);
        }
        if (type == 8) {
            return Float.valueOf(strVal);
        }
        if (type == 3) {
            return Integer.valueOf(strVal);
        }
        if (type == 2) {
            return Long.valueOf(strVal);
        }
        if (type == 4) {
            return Short.valueOf(strVal);
        }
        if (type == 1000) {
            return MetatypeUtils.evaluateDuration((String)strVal, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        if (type == 1004) {
            return MetatypeUtils.evaluateDuration((String)strVal, (TimeUnit)TimeUnit.SECONDS);
        }
        if (type == 1005) {
            return MetatypeUtils.evaluateDuration((String)strVal, (TimeUnit)TimeUnit.MINUTES);
        }
        if (type == 1006) {
            return MetatypeUtils.evaluateDuration((String)strVal, (TimeUnit)TimeUnit.HOURS);
        }
        if (type == 1003 || type == 1008) {
            return new SerializableProtectedString(strVal.toCharArray());
        }
        if (type == 1007) {
            return Enum.valueOf(OnErrorUtil.OnError.class, strVal.trim().toUpperCase());
        }
        if (type == 1012) {
            return MetatypeUtils.evaluateToken((String)strVal);
        }
        if (type == 1001) {
            return this.evaluateReference(strVal, attrDef, context);
        }
        return strVal;
    }

    private Object convertListToSingleValue(List<?> rawValues, ExtendedAttributeDefinition attrDef, EvaluationContext context, boolean ignoreWarnings) throws ConfigEvaluatorException {
        int size = rawValues.size();
        if (size == 1) {
            return this.convertObjectToSingleValue(rawValues.get(0), attrDef, context, -1, ignoreWarnings);
        }
        SimpleElement configElement = this.mergeConfigElementValues(rawValues, context);
        if (configElement == null) {
            return this.convertObjectToSingleValue(rawValues.get(0), attrDef, context, -1, ignoreWarnings);
        }
        return this.convertConfigElementToSingleValue(configElement, attrDef, context, -1, ignoreWarnings);
    }

    private static String[] getReferenceAttributes(String name) {
        if (name.endsWith("Ref")) {
            return new String[]{name, name.substring(0, name.length() - "Ref".length())};
        }
        return new String[]{name + "Ref", name};
    }

    private static List<Object> mergeReferenceValues(AttributeDefinition attrDef, Object ... values) {
        ArrayList<Object> merged = new ArrayList<Object>();
        for (Object value : values) {
            if (value instanceof String) {
                merged.addAll(ConfigEvaluator.getAsList((String)value, attrDef));
                continue;
            }
            if (!(value instanceof List)) continue;
            for (Object ce : (List)value) {
                if (ce instanceof ConfigElement) {
                    String id = (String)((ConfigElement)ce).getAttribute("id");
                    if (id != null) {
                        merged.remove(id);
                    }
                    merged.add(ce);
                    continue;
                }
                if (ce instanceof ConfigElement.Reference) {
                    merged.add(ce);
                    continue;
                }
                if (!(ce instanceof String) || merged.contains(ce)) continue;
                merged.add(ce);
            }
        }
        return merged;
    }

    private static List<String> getAsList(String rawValue, AttributeDefinition attrDef) {
        if (attrDef.getType() == 1001) {
            String[] pids = rawValue.split("\\s*,\\s*");
            return Arrays.asList(pids);
        }
        return MetaTypeHelper.parseValue(rawValue);
    }

    private Vector<Object> convertListToVector(List<?> rawValues, ExtendedAttributeDefinition attrDef, EvaluationContext context, boolean ignoreWarnings) throws ConfigEvaluatorException {
        int size = rawValues.size();
        boolean hiddenAttr = this.isHiddenExtension(attrDef, context);
        boolean hiddenValue = false;
        Vector<Object> vector = new Vector<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object rawValue = rawValues.get(i);
            Object value = this.convertObjectToSingleValue(rawValue, attrDef, context, i, ignoreWarnings);
            if (hiddenAttr && rawValue instanceof ConfigElement) {
                hiddenValue = true;
                continue;
            }
            if (value == null) continue;
            vector.add(value);
        }
        if (vector.isEmpty() && hiddenValue) {
            return null;
        }
        return vector;
    }

    private String[] convertListToStringArray(List<?> rawValues, ExtendedAttributeDefinition attrDef, EvaluationContext context, boolean ignoreWarnings) throws ConfigEvaluatorException {
        Vector<Object> collection = this.convertListToVector(rawValues, attrDef, context, ignoreWarnings);
        return collection == null ? null : collection.toArray(new String[collection.size()]);
    }

    private Object createTypedArray(int size, int type) {
        if (type == 11) {
            return new boolean[size];
        }
        if (type == 6) {
            return new byte[size];
        }
        if (type == 5) {
            return new char[size];
        }
        if (type == 7) {
            return new double[size];
        }
        if (type == 8) {
            return new float[size];
        }
        if (type == 3) {
            return new int[size];
        }
        if (type == 2) {
            return new long[size];
        }
        if (type == 4) {
            return new short[size];
        }
        if (type == 1000) {
            return new long[size];
        }
        if (type == 1004) {
            return new long[size];
        }
        if (type == 1005) {
            return new long[size];
        }
        if (type == 1006) {
            return new long[size];
        }
        return new String[size];
    }

    private Object convertListToArray(List<?> rawValues, ExtendedAttributeDefinition attrDef, EvaluationContext context, boolean ignoreWarnings) throws ConfigEvaluatorException {
        int size = rawValues.size();
        int type = attrDef.getType();
        int i = 0;
        if (type == 11) {
            boolean[] retVal = new boolean[size];
            for (Object rawValue : rawValues) {
                String value = this.resolveStringValue(rawValue, attrDef, context, ignoreWarnings);
                retVal[i++] = Boolean.parseBoolean(value);
            }
            return retVal;
        }
        if (type == 6) {
            byte[] retVal = new byte[size];
            for (Object rawValue : rawValues) {
                String value = this.resolveStringValue(rawValue, attrDef, context, ignoreWarnings);
                retVal[i++] = Byte.parseByte(value);
            }
            return retVal;
        }
        if (type == 5) {
            char[] retVal = new char[size];
            for (Object rawValue : rawValues) {
                String value = this.resolveStringValue(rawValue, attrDef, context, ignoreWarnings);
                retVal[i++] = value.charAt(0);
            }
            return retVal;
        }
        if (type == 7) {
            double[] retVal = new double[size];
            for (Object rawValue : rawValues) {
                String value = this.resolveStringValue(rawValue, attrDef, context, ignoreWarnings);
                retVal[i++] = Double.parseDouble(value);
            }
            return retVal;
        }
        if (type == 8) {
            float[] retVal = new float[size];
            for (Object rawValue : rawValues) {
                String value = this.resolveStringValue(rawValue, attrDef, context, ignoreWarnings);
                retVal[i++] = Float.parseFloat(value);
            }
            return retVal;
        }
        if (type == 3) {
            int[] retVal = new int[size];
            for (Object rawValue : rawValues) {
                String value = this.resolveStringValue(rawValue, attrDef, context, ignoreWarnings);
                retVal[i++] = Integer.parseInt(value);
            }
            return retVal;
        }
        if (type == 2) {
            long[] retVal = new long[size];
            for (Object rawValue : rawValues) {
                String value = this.resolveStringValue(rawValue, attrDef, context, ignoreWarnings);
                retVal[i++] = Long.parseLong(value);
            }
            return retVal;
        }
        if (type == 4) {
            short[] retVal = new short[size];
            for (Object rawValue : rawValues) {
                String value = this.resolveStringValue(rawValue, attrDef, context, ignoreWarnings);
                retVal[i++] = Short.parseShort(value);
            }
            return retVal;
        }
        if (type == 1000) {
            return this.convertListToDurationArray(rawValues, attrDef, context, TimeUnit.MILLISECONDS, ignoreWarnings);
        }
        if (type == 1004) {
            return this.convertListToDurationArray(rawValues, attrDef, context, TimeUnit.SECONDS, ignoreWarnings);
        }
        if (type == 1005) {
            return this.convertListToDurationArray(rawValues, attrDef, context, TimeUnit.MINUTES, ignoreWarnings);
        }
        if (type == 1006) {
            return this.convertListToDurationArray(rawValues, attrDef, context, TimeUnit.HOURS, ignoreWarnings);
        }
        return this.convertListToStringArray(rawValues, attrDef, context, ignoreWarnings);
    }

    private long[] convertListToDurationArray(List<?> rawValues, ExtendedAttributeDefinition attrDef, EvaluationContext context, TimeUnit timeUnit, boolean ignoreWarnings) throws ConfigEvaluatorException {
        long[] retVal = new long[rawValues.size()];
        int i = 0;
        for (Object rawValue : rawValues) {
            String value = this.resolveStringValue(rawValue, attrDef, context, ignoreWarnings);
            retVal[i++] = MetatypeUtils.evaluateDuration((String)value, (TimeUnit)timeUnit);
        }
        return retVal;
    }

    protected String lookupPid(ConfigID referenceId) {
        return this.configRetriever.lookupPid(referenceId);
    }

    protected String getPid(ConfigID configId) throws ConfigNotFoundException {
        return this.configRetriever.getPid(configId);
    }

    /*
     * WARNING - void declaration
     */
    private String evaluateReference(String id, ExtendedAttributeDefinition attrDef, EvaluationContext context) throws ConfigEvaluatorException {
        if (attrDef.getReferencePid() != null) {
            String referencePid = attrDef.getReferencePid();
            if (this.metatypeRegistry.getRegistryEntry(referencePid) == null) {
                return null;
            }
            ConfigID referenceId = new ConfigID(referencePid, id);
            String pid = this.lookupPid(referenceId);
            if (pid == null) {
                UnresolvedReference ref = new UnresolvedReference(referencePid, attrDef, id, context.getConfigElement().getConfigID());
                context.addUnresolvedReference(ref);
            }
            context.getEvaluationResult().addReference(referenceId);
            return pid;
        }
        if (attrDef.getService() != null) {
            List<MetaTypeRegistry.RegistryEntry> exposers = this.metatypeRegistry.getEntriesExposingService(attrDef.getService());
            ArrayList<String> matchedPids = new ArrayList<String>();
            if (exposers != null) {
                if (attrDef.getServiceFilter() == null) {
                    for (MetaTypeRegistry.RegistryEntry entry : exposers) {
                        ConfigID referenceId = new ConfigID(entry.getPid(), id);
                        context.getEvaluationResult().addReference(referenceId);
                        String pid = this.lookupPid(referenceId);
                        if (pid == null) continue;
                        matchedPids.add(pid);
                    }
                } else {
                    String idClause = FilterUtils.createPropertyFilter((String)"id", (String)id);
                    for (MetaTypeRegistry.RegistryEntry entry : exposers) {
                        String pidClause = FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)entry.getPid());
                        String filter = "(&" + pidClause + idClause + attrDef.getServiceFilter() + ")";
                        try {
                            Configuration[] configs = this.configRetriever.listConfigurations(filter);
                            if (configs == null) continue;
                            for (Configuration config : configs) {
                                matchedPids.add(config.getPid());
                            }
                        }
                        catch (ConfigRetrieverException configs) {
                            void e;
                            FFDCFilter.processException((Throwable)configs, (String)"com.ibm.ws.config.xml.internal.ConfigEvaluator", (String)"1265", (Object)this, (Object[])new Object[]{id, attrDef, context});
                            throw new ConfigEvaluatorException("Failed retrieving configuration for " + attrDef, (Throwable)e);
                        }
                    }
                }
            }
            if (matchedPids.size() == 1) {
                return (String)matchedPids.get(0);
            }
            UnresolvedService ref = new UnresolvedService(attrDef.getService(), attrDef, id, context.getConfigElement().getConfigID(), matchedPids.size());
            context.addUnresolvedReference(ref);
            return null;
        }
        throw new ConfigEvaluatorException("Reference pid is not defined for " + attrDef);
    }

    @FFDCIgnore(value={URISyntaxException.class})
    private String processString(String value, ExtendedAttributeDefinition attrDef, EvaluationContext context, boolean ignoreWarnings) throws ConfigEvaluatorException {
        String validateResult;
        String strValue;
        if (attrDef == null) {
            return this.resolveVariables(value, context, ignoreWarnings);
        }
        String string = strValue = attrDef.resolveVariables() ? this.resolveVariables(value, context, ignoreWarnings) : value;
        if (attrDef.getType() == 1010 || attrDef.getType() == 1009) {
            strValue = PathUtils.normalize((String)strValue);
        } else if (attrDef.getType() == 1002) {
            try {
                new URI(strValue);
            }
            catch (URISyntaxException e) {
                strValue = PathUtils.normalize((String)strValue);
            }
        }
        String[] optionValues = attrDef.getOptionValues();
        if (optionValues != null) {
            String[] optionLabels = attrDef.getOptionLabels();
            for (int i = 0; i < optionValues.length; ++i) {
                if (!strValue.equalsIgnoreCase(optionValues[i]) && !strValue.equalsIgnoreCase(optionLabels[i])) continue;
                strValue = optionValues[i];
                break;
            }
        }
        if (attrDef.getType() == 11) {
            if (!"true".equalsIgnoreCase(strValue) && !"false".equalsIgnoreCase(strValue)) {
                Object[] inserts = new Object[]{strValue, attrDef.getID(), "false"};
                if (attrDef.getDefaultValue() != null && attrDef.getDefaultValue().length > 0) {
                    inserts[2] = attrDef.getDefaultValue()[0];
                }
                throw new AttributeValidationException(attrDef, strValue, Tr.formatMessage((TraceComponent)tc, (String)"error.invalid.boolean.attribute", (Object[])inserts));
            }
        } else if (attrDef.getType() != 1001 && (validateResult = attrDef.validate(MetaTypeHelper.escapeValue(strValue))) != null && validateResult.length() > 0) {
            throw new AttributeValidationException(attrDef, strValue, validateResult);
        }
        return strValue;
    }

    private ConfigElement.Reference processReference(ConfigElement.Reference reference, EvaluationContext context, boolean ignoreWarnings) throws ConfigEvaluatorException {
        String resolvedId = this.resolveVariables(reference.getId(), context, ignoreWarnings);
        if (reference.getId().equals(resolvedId)) {
            return reference;
        }
        return new ConfigElement.Reference(reference.getPid(), resolvedId);
    }

    private String evaluateReference(ConfigElement.Reference reference, EvaluationContext context) {
        String factoryPid = this.resolvePid(reference.getPid());
        ConfigID referenceId = new ConfigID(factoryPid, reference.getId());
        String pid = this.lookupPid(referenceId);
        if (pid == null) {
            Tr.warning((TraceComponent)tc, (String)"warning.pid.not.found", (Object[])new Object[]{context.getAttributeName(), reference.getId()});
        }
        context.getEvaluationResult().addReference(referenceId);
        return pid;
    }

    private MetaTypeRegistry.RegistryEntry getRegistryEntry(String pid) {
        return this.metatypeRegistry == null ? null : this.metatypeRegistry.getRegistryEntryByPidOrAlias(pid);
    }

    private String getExtends(String pid) {
        MetaTypeRegistry.RegistryEntry re = this.getRegistryEntry(pid);
        return re == null ? null : re.getExtends();
    }

    private String resolvePid(String pid) {
        MetaTypeRegistry.RegistryEntry registryEntry = this.getRegistryEntry(pid);
        return registryEntry == null ? pid : registryEntry.getPid();
    }

    private SimpleElement mergeConfigElementValues(List<?> values, EvaluationContext context) throws ConfigEvaluatorException {
        SimpleElement merged = null;
        for (Object value : values) {
            if (value instanceof SimpleElement) {
                SimpleElement in = (SimpleElement)value;
                if (merged == null) {
                    merged = (SimpleElement)value;
                }
                merged.override(in);
                continue;
            }
            return null;
        }
        merged.setIdAttribute();
        return merged;
    }

    private Object convertConfigElementToSingleValue(ConfigElement childElement, ExtendedAttributeDefinition attrDef, EvaluationContext context, int index, boolean ignoreWarnings) throws ConfigEvaluatorException {
        if (attrDef != null && attrDef.getType() != 1001) {
            return this.convertStringToSingleValue(childElement.getElementValue(), attrDef, context, ignoreWarnings);
        }
        return this.evaluateConfigElement(childElement, attrDef, context, index);
    }

    /*
     * WARNING - void declaration
     */
    private String evaluateConfigElement(ConfigElement childElement, final ExtendedAttributeDefinition parentAttribute, EvaluationContext context, int index) throws ConfigEvaluatorException {
        MetaTypeRegistry.RegistryEntry childRegistryEntry = null;
        if (parentAttribute != null && parentAttribute.getType() == 1001) {
            final String elementName = childElement.getNodeName();
            MetaTypeRegistry.RegistryEntry specifiedChildRegistryEntry = this.metatypeRegistry.getRegistryEntry(parentAttribute.getReferencePid());
            if (specifiedChildRegistryEntry == null) {
                return null;
            }
            childRegistryEntry = specifiedChildRegistryEntry.traverseHierarchy(new MetaTypeRegistry.EntryAction<MetaTypeRegistry.RegistryEntry>(){
                private MetaTypeRegistry.RegistryEntry result;
                static final long serialVersionUID = -1394164963507175748L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public boolean entry(MetaTypeRegistry.RegistryEntry registryEntry) {
                    if (elementName.equals(registryEntry.getPid()) || elementName.equals(registryEntry.getEffectiveAD(parentAttribute.getID()))) {
                        this.result = registryEntry;
                        return false;
                    }
                    return true;
                }

                @Override
                public MetaTypeRegistry.RegistryEntry getResult() {
                    return this.result;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(4.class);
                }
            });
            if (childRegistryEntry == null) {
                childRegistryEntry = specifiedChildRegistryEntry;
            }
        } else {
            childRegistryEntry = this.getRegistryEntryForChildFirstConfig(context.getEvaluationResult().getRegistryEntry(), childElement.getNodeName());
        }
        String factoryPid = childElement.getNodeName();
        if (childRegistryEntry != null) {
            factoryPid = childRegistryEntry.getPid();
        }
        ConfigElement nestedElement = childElement;
        if (childElement instanceof SimpleElement) {
            SimpleElement original = (SimpleElement)childElement;
            if (childRegistryEntry != null) {
                nestedElement = childRegistryEntry.isSingleton() ? new SingletonElement(original, factoryPid) : new FactoryElement(original, index, childRegistryEntry);
                nestedElement.setIdAttribute();
            } else {
                original.setDefaultId(index);
                nestedElement = original;
            }
            nestedElement.setParent(context.getConfigElement());
        }
        ConfigID configId = nestedElement.getConfigID();
        String pid = null;
        try {
            pid = this.getPid(configId);
        }
        catch (ConfigNotFoundException configNotFoundException) {
            void ex;
            FFDCFilter.processException((Throwable)configNotFoundException, (String)"com.ibm.ws.config.xml.internal.ConfigEvaluator", (String)"1521", (Object)this, (Object[])new Object[]{childElement, parentAttribute, context, index});
            throw new ConfigEvaluatorException("Could not obtain configuration for nested info", (Throwable)ex);
        }
        NestedInfo nestedInfo = new NestedInfo();
        nestedInfo.configElement = nestedElement;
        nestedInfo.pid = pid;
        nestedInfo.registryEntry = childRegistryEntry;
        if (!context.addNestedInfo(nestedInfo) || this.isHiddenExtension(parentAttribute, context)) {
            return null;
        }
        context.getEvaluationResult().addReference(configId);
        return pid;
    }

    private MetaTypeRegistry.RegistryEntry getRegistryEntryForChildFirstConfig(MetaTypeRegistry.RegistryEntry parentEntry, String childNodeName) {
        if (parentEntry == null) {
            return null;
        }
        for (MetaTypeRegistry.RegistryEntry pe = parentEntry; pe != null; pe = pe.getExtendedRegistryEntry()) {
            MetaTypeRegistry.RegistryEntry childAliasEntry;
            if (!pe.getObjectClassDefinition().supportsExtensions() || (childAliasEntry = this.metatypeRegistry.getRegistryEntry(pe.getPid(), childNodeName)) == null) continue;
            return childAliasEntry;
        }
        MetaTypeRegistry.RegistryEntry childEntry = this.getRegistryEntry(childNodeName);
        if (childEntry == null) {
            return null;
        }
        String ibmParentPid = childEntry.getObjectClassDefinition().getParentPID();
        String s = parentEntry.getPid();
        while (s != null) {
            if (s.equals(ibmParentPid)) {
                return childEntry;
            }
            s = this.getExtends(s);
        }
        return null;
    }

    private String resolveVariables(String str, EvaluationContext context, boolean ignoreWarnings) throws ConfigEvaluatorException {
        Matcher matcher = XMLConfigConstants.VAR_PATTERN.matcher(str);
        while (matcher.find()) {
            String var = matcher.group(1);
            String rep = this.getProperty(var, context, ignoreWarnings);
            if (rep == null) {
                rep = this.tryEvaluateExpression(var, context, ignoreWarnings);
            }
            if (rep == null) continue;
            str = str.replace(matcher.group(0), rep);
            matcher.reset(str);
        }
        return str;
    }

    @FFDCIgnore(value={NumberFormatException.class, ArithmeticException.class, ConfigEvaluatorException.class})
    private String tryEvaluateExpression(String expr, final EvaluationContext context, final boolean ignoreWarnings) {
        try {
            return new ConfigExpressionEvaluator(){
                static final long serialVersionUID = 5591870748305961533L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                String getProperty(String argName) throws ConfigEvaluatorException {
                    return ConfigEvaluator.this.getProperty(argName, context, ignoreWarnings);
                }

                @Override
                Object getPropertyObject(String argName) throws ConfigEvaluatorException {
                    return ConfigEvaluator.this.getPropertyObject(argName, context, ignoreWarnings);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(5.class);
                }
            }.evaluateExpression(expr);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ArithmeticException arithmeticException) {
        }
        catch (ConfigEvaluatorException configEvaluatorException) {
            // empty catch block
        }
        return null;
    }

    private String getProperty(String variable, EvaluationContext context, boolean ignoreWarnings) throws ConfigEvaluatorException {
        return StringUtils.convertToString(this.getPropertyObject(variable, context, ignoreWarnings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Object getPropertyObject(String variable, EvaluationContext context, boolean ignoreWarnings) throws ConfigEvaluatorException {
        Object realValue = null;
        if (context.containsValue(variable)) {
            realValue = context.getValue(variable);
        } else {
            if ("service.pid".equals(variable)) {
                try {
                    realValue = this.getPid(context.getConfigElement().getConfigID());
                    context.putValue("service.pid", realValue);
                }
                catch (ConfigNotFoundException configNotFoundException) {
                    void ex;
                    FFDCFilter.processException((Throwable)configNotFoundException, (String)"com.ibm.ws.config.xml.internal.ConfigEvaluator", (String)"1653", (Object)this, (Object[])new Object[]{variable, context, ignoreWarnings});
                    throw new ConfigEvaluatorException("Could not obtain PID for configID", (Throwable)ex);
                }
            }
            context.push(variable);
            realValue = this.lookupVariable(variable);
            if (realValue == null) {
                Map<String, ExtendedAttributeDefinition> attributeMap;
                realValue = context.getProperties().get(variable);
                if (realValue == null) {
                    ExtendedAttributeDefinition attributeDef = context.getAttributeDefinition(variable);
                    if (attributeDef != null) {
                        String currentAttribute = context.getAttributeName();
                        Set<NestedInfo> nestedInfo = context.getNestedInfo();
                        String flatPrefix = EMPTY_STRING;
                        try {
                            realValue = this.evaluateMetaTypeAttribute(variable, context, attributeDef, flatPrefix, ignoreWarnings);
                        }
                        finally {
                            context.setAttributeName(currentAttribute);
                            context.setNestedInfo(nestedInfo);
                        }
                    }
                    ConfigElement configElement = context.getConfigElement();
                    Object rawValue = configElement.getAttribute(variable);
                    if (rawValue != null) {
                        String currentAttribute = context.getAttributeName();
                        Set<NestedInfo> nestedInfo = context.getNestedInfo();
                        try {
                            realValue = this.evaluateSimpleAttribute(variable, rawValue, context, EMPTY_STRING, ignoreWarnings);
                        }
                        finally {
                            context.setAttributeName(currentAttribute);
                            context.setNestedInfo(nestedInfo);
                        }
                    }
                }
                if (realValue == null && (attributeMap = context.getAttributeMap()) != null) {
                    for (Map.Entry<String, ExtendedAttributeDefinition> entry : attributeMap.entrySet()) {
                        if (context.isProcessed(entry.getKey()) || !entry.getValue().isFlat()) continue;
                        try {
                            this.evaluateMetaTypeAttribute(entry.getKey(), context, entry.getValue(), EMPTY_STRING, true);
                        }
                        catch (ConfigEvaluatorException configEvaluatorException) {
                            FFDCFilter.processException((Throwable)configEvaluatorException, (String)"com.ibm.ws.config.xml.internal.ConfigEvaluator", (String)"1711", (Object)this, (Object[])new Object[]{variable, context, ignoreWarnings});
                        }
                    }
                    realValue = context.getProperties().get(variable);
                }
                if (realValue == null) {
                    context.addDefinedVariable(variable, null);
                }
            } else {
                context.addDefinedVariable(variable, realValue);
            }
            context.pop();
            context.putValue(variable, realValue);
        }
        return realValue;
    }

    private String lookupVariable(String variableName) {
        return this.variableRegistry != null ? this.variableRegistry.lookupVariable(variableName) : null;
    }

    private Object lookupVariableExtension(EvaluationContext context, ExtendedAttributeDefinition attrDef) throws ConfigEvaluatorException {
        String variableName = attrDef.getVariable();
        if (variableName != null) {
            ExtendedAttributeDefinition targetAttrDef;
            if (!attrDef.resolveVariables()) {
                return "${" + variableName + "}";
            }
            Object variableValue = this.variableRegistry.lookupVariable(variableName);
            if (variableValue == null && !variableName.equals(attrDef.getID()) && (targetAttrDef = context.getAttributeDefinition(variableName)) != null) {
                variableValue = this.evaluateMetaTypeAttribute(variableName, context, targetAttrDef, EMPTY_STRING, true);
            }
            context.addDefinedVariable(variableName, variableValue);
            return variableValue;
        }
        return null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class StringUtils {
        static final long serialVersionUID = -3380061034670079753L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private StringUtils() {
        }

        private static int getNextLocation(int start, String list) {
            int size = list.length();
            for (int i = start; i < size; ++i) {
                char ch = list.charAt(i);
                if (ch != '\\' && ch != ',') continue;
                return i;
            }
            return -1;
        }

        static String escapeValue(String value) {
            int start = 0;
            int pos = StringUtils.getNextLocation(start, value);
            if (pos == -1) {
                return value;
            }
            StringBuilder builder = new StringBuilder();
            while (pos != -1) {
                builder.append(value, start, pos);
                builder.append('\\');
                builder.append(value.charAt(pos));
                start = pos + 1;
                pos = StringUtils.getNextLocation(start, value);
            }
            builder.append(value, start, value.length());
            return builder.toString();
        }

        protected static String convertToString(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof List) {
                List list = (List)value;
                if (list.size() == 0) {
                    return ConfigEvaluator.EMPTY_STRING;
                }
                if (list.size() == 1) {
                    String strValue = String.valueOf(list.get(0));
                    return StringUtils.escapeValue(strValue);
                }
                StringBuilder builder = new StringBuilder();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String strValue = String.valueOf(iterator.next());
                    strValue = StringUtils.escapeValue(strValue);
                    builder.append(strValue);
                    if (!iterator.hasNext()) continue;
                    builder.append(", ");
                }
                return builder.toString();
            }
            if (value instanceof String[]) {
                String[] array = (String[])value;
                if (array.length == 0) {
                    return ConfigEvaluator.EMPTY_STRING;
                }
                if (array.length == 1) {
                    return StringUtils.escapeValue(array[0]);
                }
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < array.length; ++i) {
                    String strValue = StringUtils.escapeValue(array[i]);
                    builder.append(strValue);
                    if (i + 1 >= array.length) continue;
                    builder.append(", ");
                }
                return builder.toString();
            }
            if (value.getClass().isArray()) {
                int size = Array.getLength(value);
                if (size == 0) {
                    return ConfigEvaluator.EMPTY_STRING;
                }
                if (size == 1) {
                    String strValue = String.valueOf(Array.get(value, 0));
                    return StringUtils.escapeValue(strValue);
                }
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < size; ++i) {
                    String strValue = String.valueOf(Array.get(value, i));
                    strValue = StringUtils.escapeValue(strValue);
                    builder.append(strValue);
                    if (i + 1 >= size) continue;
                    builder.append(", ");
                }
                return builder.toString();
            }
            return value.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(StringUtils.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class WildcardService
    extends UnresolvedPidType {
        private final String service;
        static final long serialVersionUID = -4824276065049853853L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public WildcardService(String service, AttributeDefinition attr, ConfigID referringID) {
            super(attr, ConfigEvaluator.ALL_PIDS, referringID);
            this.service = service;
        }

        public String getService() {
            return this.service;
        }

        @Override
        public void reportError() {
        }

        @Override
        public boolean permanent() {
            return true;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
            result = 31 * result + (this.elementId == null ? 0 : this.elementId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof WildcardService)) {
                return false;
            }
            WildcardService other = (WildcardService)obj;
            if (this.service == null ? other.service != null : !this.service.equals(other.service)) {
                return false;
            }
            return !(this.elementId == null ? other.elementId != null : !this.elementId.equals(other.elementId));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WildcardService.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class WildcardReference
    extends UnresolvedPidType {
        private final String pid;
        static final long serialVersionUID = -6472257622729420735L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public WildcardReference(String pid, AttributeDefinition attr, ConfigID referringID) {
            super(attr, ConfigEvaluator.ALL_PIDS, referringID);
            this.pid = pid;
        }

        public String getPid() {
            return this.pid;
        }

        @Override
        public void reportError() {
        }

        @Override
        public boolean permanent() {
            return true;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pid == null ? 0 : this.pid.hashCode());
            result = 31 * result + (this.elementId == null ? 0 : this.elementId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof WildcardReference)) {
                return false;
            }
            WildcardReference other = (WildcardReference)obj;
            if (this.pid == null ? other.pid != null : !this.pid.equals(other.pid)) {
                return false;
            }
            return !(this.elementId == null ? other.elementId != null : !this.elementId.equals(other.elementId));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WildcardReference.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class UnresolvedService
    extends UnresolvedPidType {
        private final String service;
        private final int count;
        static final long serialVersionUID = -2180359170827558553L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public UnresolvedService(String service, AttributeDefinition attr, String id, ConfigID referringID, int i) {
            super(attr, id, referringID);
            this.service = service;
            this.count = i;
        }

        public String getService() {
            return this.service;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void reportError() {
            if (this.count == 0 && this.serviceExistsInRegistry()) {
                Tr.warning((TraceComponent)tc, (String)"warning.pid.not.found", (Object[])new Object[]{this.getAttributeDefinition().getID(), this.value});
            } else if (this.count > 1) {
                Tr.warning((TraceComponent)tc, (String)"warning.multiple.matches", (Object[])new Object[]{this.getAttributeDefinition().getID(), this.value});
            }
        }

        private boolean serviceExistsInRegistry() {
            return ConfigEvaluator.this.metatypeRegistry.getEntriesExposingService(this.service) != null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
            result = 31 * result + (this.elementId == null ? 0 : this.elementId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof UnresolvedService)) {
                return false;
            }
            UnresolvedService other = (UnresolvedService)obj;
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            if (this.service == null ? other.service != null : !this.service.equals(other.service)) {
                return false;
            }
            return !(this.elementId == null ? other.elementId != null : !this.elementId.equals(other.elementId));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(UnresolvedService.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class UnresolvedReference
    extends UnresolvedPidType {
        private final String pid;
        static final long serialVersionUID = -5738545462054026881L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public UnresolvedReference(String pid, AttributeDefinition attr, String id, ConfigID referringID) {
            super(attr, id, referringID);
            this.pid = pid;
        }

        public String getPid() {
            return this.pid;
        }

        @Override
        public void reportError() {
            if (this.pidExistsInRegistry()) {
                Tr.warning((TraceComponent)tc, (String)"warning.pid.not.found", (Object[])new Object[]{this.getAttributeDefinition().getID(), this.value});
            }
        }

        private boolean pidExistsInRegistry() {
            return ConfigEvaluator.this.metatypeRegistry.getRegistryEntry(this.pid) != null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            result = 31 * result + (this.pid == null ? 0 : this.pid.hashCode());
            result = 31 * result + (this.elementId == null ? 0 : this.elementId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof UnresolvedReference)) {
                return false;
            }
            UnresolvedReference other = (UnresolvedReference)obj;
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            if (this.pid == null ? other.pid != null : !this.pid.equals(other.pid)) {
                return false;
            }
            return !(this.elementId == null ? other.elementId != null : !this.elementId.equals(other.elementId));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(UnresolvedReference.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected abstract class UnresolvedPidType {
        protected final String value;
        protected final AttributeDefinition attribute;
        protected final ConfigID elementId;
        static final long serialVersionUID = 3554097491270189429L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public UnresolvedPidType(AttributeDefinition attr, String id, ConfigID referringID) {
            this.attribute = attr;
            this.value = id;
            this.elementId = referringID;
        }

        public AttributeDefinition getAttributeDefinition() {
            return this.attribute;
        }

        public abstract void reportError();

        /*
         * WARNING - void declaration
         */
        private ExtendedConfiguration getReferringConfiguration(ConfigElement element) {
            if (element == null) {
                return null;
            }
            MetaTypeRegistry.RegistryEntry entry = ConfigEvaluator.this.metatypeRegistry.getRegistryEntry(element.getConfigID().getPid());
            if (entry == null) {
                return null;
            }
            if (entry.isFactory()) {
                return ConfigEvaluator.this.configRetriever.lookupConfiguration(element.getConfigID());
            }
            try {
                return ConfigEvaluator.this.configRetriever.getConfiguration(element.getConfigID());
            }
            catch (ConfigNotFoundException configNotFoundException) {
                void e;
                FFDCFilter.processException((Throwable)configNotFoundException, (String)"com.ibm.ws.config.xml.internal.ConfigEvaluator$UnresolvedPidType", (String)"2130", (Object)this, (Object[])new Object[]{element});
                e.getStackTrace();
                return null;
            }
        }

        public ConfigurationInfo getReferringConfigurationInfo() throws ConfigMergeException {
            MetaTypeRegistry.RegistryEntry entry = ConfigEvaluator.this.metatypeRegistry.getRegistryEntry(this.elementId.getPid());
            if (entry == null) {
                return null;
            }
            ConfigElement referringElement = this.getReferringElement(entry, this.elementId);
            ExtendedConfiguration referringConfiguration = this.getReferringConfiguration(referringElement);
            if (referringConfiguration == null) {
                return null;
            }
            entry = ConfigEvaluator.this.metatypeRegistry.getRegistryEntry(referringElement);
            return new ConfigurationInfo(referringElement, referringConfiguration, entry, false);
        }

        private ConfigElement getReferringElement(MetaTypeRegistry.RegistryEntry entry, ConfigID id) throws ConfigMergeException {
            ServerConfiguration configuration = ConfigEvaluator.this.serverXMLConfig.getConfiguration();
            ConfigElement referringElement = null;
            if (id.getParent() != null) {
                ConfigID parentID = id.getParent();
                MetaTypeRegistry.RegistryEntry parentEntry = ConfigEvaluator.this.metatypeRegistry.getRegistryEntry(parentID.getPid());
                if (parentEntry == null) {
                    return null;
                }
                referringElement = this.getReferringElement(parentEntry, parentID);
            } else {
                referringElement = entry.isFactory() ? configuration.getFactoryInstance(entry.getPid(), entry.getAlias(), id.getId()) : configuration.getSingleton(entry.getPid(), entry.getAlias());
            }
            return referringElement;
        }

        public boolean permanent() {
            return false;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(UnresolvedPidType.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class EvaluationResult {
        private ConfigElement configElement;
        private Dictionary<String, Object> properties;
        private Set<ConfigID> references;
        private Map<ConfigID, EvaluationResult> nestedResults;
        private Map<String, Object> variables;
        private String pid;
        private boolean valid = true;
        private final Set<UnresolvedPidType> unresolvedReferences = new HashSet<UnresolvedPidType>();
        private final MetaTypeRegistry.RegistryEntry registryEntry;
        static final long serialVersionUID = -532615335863117056L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public EvaluationResult(MetaTypeRegistry.RegistryEntry registryEntry) {
            this.registryEntry = registryEntry;
        }

        public MetaTypeRegistry.RegistryEntry getRegistryEntry() {
            return this.registryEntry;
        }

        public boolean hasUnresolvedReference(AttributeDefinition attributeDef) {
            if (attributeDef.getType() != 1001) {
                return false;
            }
            for (UnresolvedPidType ref : this.unresolvedReferences) {
                if (!attributeDef.equals(ref.getAttributeDefinition())) continue;
                return true;
            }
            return false;
        }

        public void setValid(boolean b) {
            this.valid = b;
        }

        public boolean isValid() {
            return this.valid;
        }

        protected void addUnresolvedReference(UnresolvedPidType ref) {
            this.unresolvedReferences.add(ref);
        }

        protected void addReference(ConfigID referenceId) {
            if (this.references == null) {
                this.references = new HashSet<ConfigID>();
            }
            this.references.add(referenceId);
        }

        public Set<UnresolvedPidType> getUnresolvedReferences() {
            return this.unresolvedReferences;
        }

        public Set<ConfigID> getReferences() {
            return this.references == null ? Collections.emptySet() : this.references;
        }

        protected void addNested(ConfigID configId, EvaluationResult result) {
            if (this.nestedResults == null) {
                this.nestedResults = new HashMap<ConfigID, EvaluationResult>();
            }
            this.nestedResults.put(configId, result);
        }

        public Map<ConfigID, EvaluationResult> getNested() {
            return this.nestedResults == null ? Collections.emptyMap() : this.nestedResults;
        }

        protected void setConfigElement(ConfigElement configElement) {
            this.configElement = configElement;
        }

        public ConfigElement getConfigElement() {
            return this.configElement;
        }

        protected void setProperties(Dictionary<String, Object> properties) {
            this.properties = properties;
        }

        public Dictionary<String, Object> getProperties() {
            return this.properties;
        }

        protected void setVariables(Map<String, Object> variables) {
            this.variables = variables;
        }

        public Map<String, Object> getVariables() {
            return this.variables == null ? Collections.emptyMap() : this.variables;
        }

        protected void setPid(String pid) {
            this.pid = pid;
        }

        public String getPid() {
            return this.pid;
        }

        public Set<UnresolvedPidType> getAllUnresolvedReferences() {
            HashSet<UnresolvedPidType> allUnresolved = new HashSet<UnresolvedPidType>();
            allUnresolved.addAll(this.unresolvedReferences);
            if (this.nestedResults != null) {
                for (Map.Entry<ConfigID, EvaluationResult> entry : this.nestedResults.entrySet()) {
                    allUnresolved.addAll(entry.getValue().getAllUnresolvedReferences());
                }
            }
            return allUnresolved;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EvaluationResult.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class NestedInfo {
        ConfigElement configElement;
        MetaTypeRegistry.RegistryEntry registryEntry;
        String pid;
        static final long serialVersionUID = -7788823592792063696L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private NestedInfo() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(NestedInfo.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class EvaluationContext {
        private final EvaluationResult result;
        private final LinkedList<String> lookupStack = new LinkedList();
        private final Map<String, Object> cache = new HashMap<String, Object>();
        private final Set<String> processed = new HashSet<String>();
        private Map<String, Object> variables;
        private Map<String, ExtendedAttributeDefinition> attributeMap;
        private Set<NestedInfo> nested = new HashSet<NestedInfo>();
        private final List<AttributeValueCopy> attributeValueCopies = new ArrayList<AttributeValueCopy>();
        private String attribute;
        static final long serialVersionUID = -7403329902136160762L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public EvaluationContext(MetaTypeRegistry.RegistryEntry registryEntry) {
            this.result = new EvaluationResult(registryEntry);
        }

        public void evaluateCopiedAttributes() {
            Dictionary<String, Object> properties = this.getProperties();
            for (AttributeValueCopy copy : this.attributeValueCopies) {
                Object value = properties.get(copy.getCopiedAttribute());
                if (value == null) continue;
                this.setProperty(copy.getAttributeName(), value);
            }
            this.attributeValueCopies.clear();
        }

        public void addAttributeValueCopy(AttributeValueCopy copy) {
            this.attributeValueCopies.add(copy);
        }

        public Map<String, ExtendedAttributeDefinition> getAttributeMap() {
            return this.attributeMap;
        }

        public boolean hasUnresolvedAttribute(AttributeDefinition attributeDef) {
            return this.result.hasUnresolvedReference(attributeDef);
        }

        public void setValid(boolean b) {
            this.result.setValid(b);
        }

        protected void addUnresolvedReference(UnresolvedPidType ref) {
            this.result.addUnresolvedReference(ref);
        }

        public EvaluationResult getEvaluationResult() {
            return this.result;
        }

        protected void setConfigElement(ConfigElement configElement) {
            this.result.setConfigElement(configElement);
        }

        public ConfigElement getConfigElement() {
            return this.result.getConfigElement();
        }

        protected void setProperties(Dictionary<String, Object> properties) {
            this.result.setProperties(properties);
        }

        protected void setProperty(String key, Object value) {
            this.result.getProperties().put(key, value);
        }

        public Dictionary<String, Object> getProperties() {
            return this.result.getProperties();
        }

        protected void addProcessed(String attributeName) {
            this.processed.add(attributeName.toUpperCase(Locale.ROOT));
        }

        public boolean isProcessed(String attributeName) {
            return this.processed.contains(attributeName.toUpperCase(Locale.ROOT));
        }

        protected void setAttributeDefinitionMap(Map<String, ExtendedAttributeDefinition> attributeMap) {
            this.attributeMap = attributeMap;
        }

        public ExtendedAttributeDefinition getAttributeDefinition(String name) {
            return this.attributeMap == null ? null : this.attributeMap.get(name);
        }

        public void push(String variableName) throws ConfigEvaluatorException {
            if (this.lookupStack.contains(variableName)) {
                throw new ConfigEvaluatorException("Variable evaluation loop detected: " + this.lookupStack.subList(this.lookupStack.indexOf(variableName), this.lookupStack.size()));
            }
            this.lookupStack.add(variableName);
        }

        public void pop() {
            this.lookupStack.removeLast();
        }

        public void putValue(String variableName, Object value) {
            this.cache.put(variableName, value);
        }

        public Object getValue(String variableName) {
            return this.cache.get(variableName);
        }

        public boolean containsValue(String variableName) {
            return this.cache.containsKey(variableName);
        }

        protected void addDefinedVariable(String variableName, Object variableValue) {
            if (this.variables == null) {
                this.variables = new HashMap<String, Object>();
                this.result.setVariables(this.variables);
            }
            this.variables.put(variableName, variableValue);
        }

        protected void setAttributeName(String attribute) {
            this.attribute = attribute;
        }

        public String getAttributeName() {
            return this.attribute;
        }

        protected boolean addNestedInfo(NestedInfo nestedInfo) throws ConfigEvaluatorException {
            for (NestedInfo info : this.nested) {
                if (!info.configElement.getConfigID().equals(nestedInfo.configElement.getConfigID())) continue;
                info.configElement.override(nestedInfo.configElement);
                return false;
            }
            this.nested.add(nestedInfo);
            return true;
        }

        public Set<NestedInfo> getNestedInfo() {
            return this.nested;
        }

        protected void setNestedInfo(Set<NestedInfo> nested) {
            this.nested = nested;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EvaluationContext.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class AttributeValueCopy {
        private final String copiedAttribute;
        private final String attributeName;
        static final long serialVersionUID = -1886508072579157356L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public AttributeValueCopy(String attributeName, String copyOf) {
            this.attributeName = attributeName;
            this.copiedAttribute = copyOf;
        }

        public String getCopiedAttribute() {
            return this.copiedAttribute;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AttributeValueCopy.class);
        }
    }
}

