/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.metrics.impl.MetricRegistryImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.metrics.MetricRegistry;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SharedMetricRegistries {
    private static final ConcurrentMap<String, MetricRegistry> REGISTRIES;
    private static AtomicReference<String> defaultRegistryName;
    static final long serialVersionUID = -8122127050312101330L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    static void setDefaultRegistryName(AtomicReference<String> defaultRegistryName) {
        SharedMetricRegistries.defaultRegistryName = defaultRegistryName;
    }

    private SharedMetricRegistries() {
    }

    public static void clear() {
        REGISTRIES.clear();
    }

    public static Set<String> names() {
        return REGISTRIES.keySet();
    }

    public static void remove(String key) {
        REGISTRIES.remove(key);
    }

    public static MetricRegistry add(String name, MetricRegistry registry) {
        return REGISTRIES.putIfAbsent(name, registry);
    }

    public static MetricRegistry getOrCreate(String name) {
        MetricRegistry existing = (MetricRegistry)REGISTRIES.get(name);
        if (existing == null) {
            MetricRegistryImpl created = new MetricRegistryImpl();
            MetricRegistry raced = SharedMetricRegistries.add(name, created);
            if (raced == null) {
                return created;
            }
            return raced;
        }
        return existing;
    }

    public static synchronized MetricRegistry setDefault(String name) {
        MetricRegistry registry = SharedMetricRegistries.getOrCreate(name);
        return SharedMetricRegistries.setDefault(name, registry);
    }

    public static MetricRegistry setDefault(String name, MetricRegistry metricRegistry) {
        if (defaultRegistryName.compareAndSet(null, name)) {
            SharedMetricRegistries.add(name, metricRegistry);
            return metricRegistry;
        }
        throw new IllegalStateException("Default metric registry name is already set.");
    }

    public static MetricRegistry getDefault() {
        MetricRegistry metricRegistry = SharedMetricRegistries.tryGetDefault();
        if (metricRegistry == null) {
            throw new IllegalStateException("Default registry name has not been set.");
        }
        return metricRegistry;
    }

    public static MetricRegistry tryGetDefault() {
        String name = defaultRegistryName.get();
        if (name != null) {
            return SharedMetricRegistries.getOrCreate(name);
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SharedMetricRegistries.class);
        REGISTRIES = new ConcurrentHashMap<String, MetricRegistry>();
        defaultRegistryName = new AtomicReference();
    }
}

