/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.handlers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.datatypes.ConversionException;
import com.ibm.ws.jmx.connector.datatypes.CreateMBean;
import com.ibm.ws.jmx.connector.datatypes.MBeanInfoWrapper;
import com.ibm.ws.jmx.connector.datatypes.ObjectInstanceWrapper;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.context.root=/IBMJMXConnectorREST", "com.ibm.wsspi.rest.handler.root=/mbeans/factory", "com.ibm.wsspi.rest.handler.root=/mbeans/{objectName}"})
public class MBeanHandler
implements RESTHandler {
    public static final TraceComponent tc = Tr.register(MBeanHandler.class);
    static final long serialVersionUID = -5688897379230143533L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleRequest(RESTRequest request, RESTResponse response) {
        String method = request.getMethod();
        if (request.getPathVariable("objectName") != null) {
            if (RESTHelper.isGetMethod(method)) {
                this.objectName(request, response);
                return;
            } else {
                if (!RESTHelper.isDeleteMethod(method)) throw new RESTHandlerMethodNotAllowedError("GET,DELETE");
                this.deleteMBean(request, response);
            }
            return;
        } else {
            if (!RESTHelper.isPostMethod(method)) throw new RESTHandlerMethodNotAllowedError("POST");
            this.createMBean(request, response);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createMBean(RESTRequest request, RESTResponse response) {
        RESTHelper.ensureConsumesJson(request);
        JSONConverter converter = JSONConverter.getConverter();
        InputStream is = RESTHelper.getInputStream(request);
        CreateMBean createMBean = null;
        try {
            createMBean = converter.readCreateMBean(is);
        }
        catch (ConversionException conversionException) {
            void e;
            FFDCFilter.processException((Throwable)conversionException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.MBeanHandler", (String)"96", (Object)this, (Object[])new Object[]{request, response});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 400);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.MBeanHandler", (String)"98", (Object)this, (Object[])new Object[]{request, response});
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.MBeanHandler", (String)"100", (Object)this, (Object[])new Object[]{request, response});
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        ObjectInstance instance = MBeanServerHelper.createMBean(createMBean, converter);
        ObjectInstanceWrapper instanceWrapper = new ObjectInstanceWrapper();
        instanceWrapper.objectInstance = instance;
        instanceWrapper.mbeanInfoURL = "/IBMJMXConnectorREST/mbeans/" + RESTHelper.URLEncoder(createMBean.objectName.getCanonicalName(), null);
        OutputHelper.writeObjectInstanceOutput(response, instanceWrapper, converter);
    }

    private void objectName(RESTRequest request, RESTResponse response) {
        String objectName = RESTHelper.getRequiredParam(request, "objectName");
        ObjectName objectNameObj = RESTHelper.objectNameConverter(objectName, true, null);
        MBeanInfo mbeanInfo = MBeanServerHelper.getMBeanInfo(objectNameObj);
        MBeanInfoWrapper mbeanInfoWrapper = new MBeanInfoWrapper();
        mbeanInfoWrapper.mbeanInfo = mbeanInfo;
        String encodedObjectName = RESTHelper.URLEncoder(objectNameObj.getCanonicalName(), null);
        mbeanInfoWrapper.attributesURL = "/IBMJMXConnectorREST/mbeans/" + encodedObjectName + "/attributes";
        MBeanAttributeInfo[] attributes = mbeanInfo.getAttributes();
        HashMap<String, String> attributeURLs = new HashMap<String, String>();
        for (MBeanAttributeInfo attributeInfo : attributes) {
            String key = attributeInfo.getName();
            String value = null;
            value = mbeanInfoWrapper.attributesURL + "/" + RESTHelper.URLEncoder(key, null);
            attributeURLs.put(key, value);
        }
        mbeanInfoWrapper.attributeURLs = attributeURLs;
        MBeanOperationInfo[] operations = mbeanInfo.getOperations();
        HashMap<String, String> operationURLs = new HashMap<String, String>();
        String operationBaseURL = "/IBMJMXConnectorREST/mbeans/" + encodedObjectName + "/operations";
        for (MBeanOperationInfo operation : operations) {
            String key = operation.getName();
            String value = null;
            value = operationBaseURL + "/" + RESTHelper.URLEncoder(key, null);
            operationURLs.put(key, value);
        }
        mbeanInfoWrapper.operationURLs = operationURLs;
        OutputHelper.writeMBeanInfoOutput(response, mbeanInfoWrapper, JSONConverter.getConverter());
    }

    private void deleteMBean(RESTRequest request, RESTResponse response) {
        String objectName = RESTHelper.getRequiredParam(request, "objectName");
        ObjectName objectNameObj = RESTHelper.objectNameConverter(objectName, true, null);
        MBeanServerHelper.unregisterMBean(objectNameObj);
        response.setStatus(204);
    }
}

