/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.osgi.locator;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

public class PackageProvider {
    private static final Logger log = Logger.getLogger(PackageProvider.class.getName());
    final Bundle bundle;
    final Set<String> packages;

    public PackageProvider(Bundle bundle, String ... pkgs) {
        this.bundle = bundle;
        this.packages = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList(pkgs)));
    }

    public Class<?> loadClass(String className) {
        if (this.fromUnregisteredPackage(className)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("WILL NOT LOAD class " + className + " from unregistered package");
            }
            return null;
        }
        try {
            return this.bundle.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("CAN NOT LOAD class " + className + " from registered package");
            }
            return null;
        }
    }

    boolean fromUnregisteredPackage(String className) {
        return !this.packages.contains(PackageProvider.packageName(className));
    }

    public static String packageName(String className) {
        return className.replaceFirst("\\.?[^.]+$", "");
    }

    public Set<String> getRegisteredPackageNames() {
        return this.packages;
    }

    public String toString() {
        return "PackageProvider for bundle " + this.bundle.getSymbolicName() + ": " + this.packages;
    }
}

