/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.SearchResult;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.wim.ConfigManager;
import com.ibm.ws.security.wim.Repository;
import com.ibm.ws.security.wim.RepositoryWrapper;
import com.ibm.ws.security.wim.adapter.urbridge.URBridge;
import com.ibm.wsspi.security.wim.exception.InitializationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class UserRegistryWrapper
implements RepositoryWrapper {
    private static final String BASE_ENTRY = "registryBaseEntry";
    private static final String KEY_REGISTRY = "userRegistry";
    private final Map<String, String> baseEntries;
    private final String baseEntry;
    private URBridge urBridge;
    private final UserRegistry userRegistry;
    static final long serialVersionUID = -4611453127425091012L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public UserRegistryWrapper(UserRegistry ur, ConfigManager configManager) throws InitializationException {
        String realm = ur.getRealm();
        this.baseEntry = "o=" + realm;
        this.userRegistry = ur;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(KEY_REGISTRY, ur);
        properties.put("config.id", realm);
        properties.put(BASE_ENTRY, this.baseEntry);
        this.baseEntries = Collections.singletonMap(this.baseEntry, realm);
        this.urBridge = new URBridge(properties, ur, configManager);
    }

    @Override
    public void clear() {
        if (this.urBridge != null) {
            this.urBridge.stopCacheThreads();
        }
        this.urBridge = null;
    }

    @Override
    public Repository getRepository() {
        return this.urBridge;
    }

    @Override
    public Map<String, String> getRepositoryBaseEntries() {
        return this.baseEntries;
    }

    @Override
    public Set<String> getRepositoryGroups() {
        return Collections.singleton(this.urBridge.getRealm());
    }

    public UserRegistry getUserRegistry() {
        return this.userRegistry;
    }

    @Override
    public int isUniqueNameForRepository(String uniqueName, boolean isDn) {
        if (this.baseEntry.equals(uniqueName)) {
            return Integer.MAX_VALUE;
        }
        if (this.isUserInRealm(uniqueName)) {
            return 0;
        }
        return -1;
    }

    @FFDCIgnore(value={Exception.class})
    private boolean isUserInRealm(String uniqueName) {
        SearchResult result2;
        try {
            result2 = this.userRegistry.getUsers(uniqueName, 1);
            if (result2 != null && result2.getList().size() > 0) {
                return true;
            }
        }
        catch (Exception result2) {
            // empty catch block
        }
        try {
            result2 = this.userRegistry.getGroups(uniqueName, 1);
            if (result2 != null && result2.getList().size() > 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(UserRegistryWrapper.class);
    }
}

