/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.cache.DistributedObjectCache;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheInstanceInfo;
import com.ibm.ws.cache.CacheProviderLoaderImpl;
import com.ibm.ws.cache.CacheService;
import com.ibm.ws.cache.DistributedObjectCacheAdapter;
import com.ibm.ws.cache.ObjectCacheUnitImpl;
import com.ibm.ws.cache.Scheduler;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.intf.ObjectCacheUnit;
import com.ibm.ws.cache.intf.ServletCacheUnit;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cache.CacheProvider;
import com.ibm.wsspi.cache.DistributedObjectCacheFactory;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.library.Library;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={CacheService.class, ResourceFactory.class, ServletContainerInitializer.class}, configurationPid={"com.ibm.ws.cache"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"creates.objectClass=com.ibm.websphere.cache.DistributedObjectCache", "service.vendor=IBM"})
public class CacheServiceImpl
implements CacheService,
ResourceFactory,
ServletContextListener,
ServletContainerInitializer {
    private static final String DISK_CACHE_ALIAS = "diskCache";
    private static final String CLASS_NAME = CacheServiceImpl.class.getName();
    private static final String DEFAULT_DISTRIBUTED_MAP_ID = "defaultCache";
    private static TraceComponent tc = Tr.register(CacheServiceImpl.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static final String FACTORY_PID = "com.ibm.ws.cache";
    private static final String PROPS_JNDI_NAME = "jndiName";
    private static final String PROPS_GENERATED = "generated";
    private static final String PROPS_CACHE_PROVIDER_NAME = "cacheProviderName";
    private static CacheConfig commonCacheConfig = null;
    private static ConcurrentMap<String, CacheConfig> cacheConfigs = new ConcurrentHashMap<String, CacheConfig>();
    private final AtomicReference<ConfigurationAdmin> configAdminRef = new AtomicReference<Object>(null);
    private final AtomicReference<Scheduler> schedulerRef = new AtomicReference<Object>(null);
    private final AtomicReference<Library> sharedLibRef = new AtomicReference();
    private String cacheName = null;
    private CacheConfig config;
    private CacheProvider cacheProvider;
    public static final String CACHE_INSTANCES_PROPERTIES = "cacheinstances.properties";
    public static final String DISTRIBUTED_MAP_PROPERTIES = "distributedmap.properties";
    public static final String WEB_INF_CACHE_INSTANCES_PROPERTIES = "WEB-INF/cacheinstances.properties";
    public static final String WEB_INF_DISTRIBUTED_MAP_PROPERTIES = "WEB-INF/distributedmap.properties";
    private final Set<URL> processedUrls = new CopyOnWriteArraySet<URL>();
    private static ObjectCacheUnit objectCacheUnit = new ObjectCacheUnitImpl();
    private final AtomicReference<VariableRegistry> variableRegistryRef = new AtomicReference<Object>(null);

    public static Map<String, CacheConfig> getCacheConfigs() {
        return cacheConfigs;
    }

    @Activate
    protected void start(ComponentContext context, Map<String, Object> properties) {
        String methodName = "start()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start()", (Object[])new Object[]{context, properties});
        }
        try {
            ServerCache.setCacheServiceEarly(this);
            ServerCache.coreCacheEnabled = true;
            this.config = this.parsePropertiesFromOSGiConfigAdmin(properties);
            this.addCacheInstanceConfig(this.config, false);
            CacheProviderLoaderImpl.getInstance().addCacheProvider(this);
            if (this.config.createCacheAtServerStartup) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Creating cache instance \"" + this.config.cacheName + "\" during startup because the cache is configured to."), (Object[])new Object[0]);
                }
                ServerCache.createCache(this.config.cacheName, this.config);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)CLASS_NAME, (String)"start", (Object)this);
            Tr.error((TraceComponent)tc, (String)"DYNA1062E", (Object[])new Object[]{e.getCause()});
        }
        try {
            ServerCache.objectCacheEnabled = true;
            this.initializeConfigPropertiesFiles(this.getClass().getClassLoader(), DISTRIBUTED_MAP_PROPERTIES);
            this.initializeConfigPropertiesFiles(this.getClass().getClassLoader(), CACHE_INSTANCES_PROPERTIES);
            ArrayList<String> instanceList = this.getObjectCacheInstanceNames();
            for (String instanceName : instanceList) {
                CacheConfig cacheConfig = this.getCacheInstanceConfig(instanceName);
                if (cacheConfig == null || !cacheConfig.isCreateCacheAtServerStartup()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create object cache instance \"" + instanceName + "\" during startup because the cache is configured to."), (Object[])new Object[0]);
                }
                ServerCache.createCache(cacheConfig.getCacheName(), cacheConfig);
            }
            DistributedObjectCacheFactory.setCacheService(this);
            Tr.info((TraceComponent)tc, (String)"DYNA1056I", (Object[])new Object[0]);
        }
        catch (IllegalStateException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ObjectCacheServiceImpl.start", (String)"232", (Object)this);
            Tr.error((TraceComponent)tc, (String)"dynacache.cacheInitFailed", (Object[])new Object[]{this.config.getServerServerName(), ex.getMessage()});
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ObjectCacheServiceImpl.start", (String)"237", (Object)this);
            Tr.error((TraceComponent)tc, (String)"dynacache.cacheInitFailed", (Object[])new Object[]{this.config.getServerServerName(), ex.getMessage()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("start() objectCacheEnabled=" + ServerCache.objectCacheEnabled));
        }
    }

    public CacheConfig parsePropertiesFromOSGiConfigAdmin(Map<String, Object> properties) {
        String libraryRef;
        String cacheProviderName;
        Integer lowThreshold;
        Integer highThreshold;
        Integer memorySizeInMB;
        String jndiName;
        CacheConfig config = new CacheConfig(properties);
        String cacheName = (String)properties.get("id");
        if (cacheName.equals(DEFAULT_DISTRIBUTED_MAP_ID)) {
            cacheName = "default";
        }
        this.cacheName = config.cacheName = cacheName;
        config.jndiName = jndiName = (String)properties.get(PROPS_JNDI_NAME);
        Integer memorySizeInEntries = (Integer)properties.get("memorySizeInEntries");
        if (null != memorySizeInEntries) {
            config.cacheSize = memorySizeInEntries;
        }
        if (null != (memorySizeInMB = (Integer)properties.get("memorySizeInMB"))) {
            config.memoryCacheSizeInMB = memorySizeInMB;
        }
        if (null != (highThreshold = (Integer)properties.get("highThreshold"))) {
            config.memoryCacheHighThreshold = highThreshold;
        }
        if (null != (lowThreshold = (Integer)properties.get("lowThreshold"))) {
            config.memoryCacheHighThreshold = lowThreshold;
        }
        if ((cacheProviderName = (String)properties.get(PROPS_CACHE_PROVIDER_NAME)) != null) {
            config.cacheProviderName = cacheProviderName;
        }
        config.libraryRef = libraryRef = (String)properties.get("libraryRef");
        this.parseDiskConfiguration(properties, config);
        this.parseExternalCacheGroupConfiguration(properties, config);
        return config;
    }

    private void parseExternalCacheGroupConfiguration(Map<String, Object> properties, CacheConfig config) {
        Dictionary cacheGroupProperties = null;
        String[] cacheGroupPIDs = (String[])properties.get("cacheGroup");
        if (null != cacheGroupPIDs) {
            for (String cacheGroupPID : cacheGroupPIDs) {
                CacheConfig.ExternalCacheGroup ecg = new CacheConfig.ExternalCacheGroup();
                try {
                    Configuration cacheGroupMetaTypeConfig = this.configAdminRef.get().getConfiguration(cacheGroupPID);
                    cacheGroupProperties = cacheGroupMetaTypeConfig.getProperties();
                    if (null != cacheGroupProperties) {
                        String[] pids;
                        if (cacheGroupProperties.get("member") instanceof String[] && null != (pids = (String[])cacheGroupProperties.get("member"))) {
                            for (String pid : pids) {
                                try {
                                    Configuration memberConfig = this.configAdminRef.get().getConfiguration(pid);
                                    Dictionary memberProperties = memberConfig.getProperties();
                                    CacheConfig.ExternalCacheGroupMember ecgm = new CacheConfig.ExternalCacheGroupMember();
                                    String host = (String)memberProperties.get("host");
                                    Integer port = (Integer)memberProperties.get("port");
                                    String[] adapterBeanName = (String[])memberProperties.get("adapterBeanName");
                                    ecgm.address = host + ":" + port;
                                    ecgm.beanName = adapterBeanName[0];
                                    ecg.members.add(ecgm);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                        Enumeration keysEnum = cacheGroupProperties.keys();
                        while (keysEnum.hasMoreElements()) {
                            String key = (String)keysEnum.nextElement();
                            Object value = cacheGroupProperties.get(key);
                            if (!key.equals("name")) continue;
                            ecg.name = (String)value;
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                config.externalGroups.add(ecg);
            }
        }
    }

    private void parseDiskConfiguration(Map<String, Object> properties, CacheConfig config) {
        Dictionary diskProperties = null;
        String[] diskPIDs = (String[])properties.get(DISK_CACHE_ALIAS);
        if (null != diskPIDs) {
            for (String pid : diskPIDs) {
                try {
                    config.enableDiskOffload = true;
                    Configuration diskMetaTypeConfig = this.configAdminRef.get().getConfiguration(pid);
                    diskProperties = diskMetaTypeConfig.getProperties();
                    if (null == diskProperties) continue;
                    Enumeration keysEnum = diskProperties.keys();
                    while (keysEnum.hasMoreElements()) {
                        String key = (String)keysEnum.nextElement();
                        Object value = diskProperties.get(key);
                        if (key.equals("sizeInEntries") && null != value) {
                            config.diskCacheSize = (Integer)value;
                        }
                        if (key.equals("sizeInGB") && null != value) {
                            config.diskCacheSizeInGB = (Integer)value;
                        }
                        if (key.equals("evictionPolicy")) {
                            int evictionPolicy = value.equals("RANDOM") ? 1 : (value.equals("SIZE") ? 2 : 0);
                            config.diskCacheEvictionPolicy = evictionPolicy;
                        }
                        if (key.equals("highThreshold") && null != value) {
                            config.diskCacheHighThreshold = (Integer)value;
                        }
                        if (key.equals("lowThreshold") && null != value) {
                            config.diskCacheLowThreshold = (Integer)value;
                        }
                        if (key.equals("location")) {
                            config.diskOffloadLocation = (String)value;
                        }
                        if (!key.equals("flushToDiskOnStopEnabled")) continue;
                        config.flushToDiskOnStop = (Boolean)value;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Deactivate
    protected void stop() {
        String methodName = "stop()";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop()", (Object[])new Object[]{this.cacheName});
        }
        CacheConfig cc = (CacheConfig)cacheConfigs.remove(this.cacheName);
        CacheProviderLoaderImpl.getInstance().removeCacheProvider(this);
        DCache cache = (DCache)ServerCache.getCacheInstances().remove(this.cacheName);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Dropping cache ", (Object[])new Object[]{cache});
        }
        if (null != cache) {
            cache.stop();
            cache.clearMemory(false);
        }
        DistributedObjectCache dob = DistributedObjectCacheFactory.removeMap(this.cacheName);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Dropping object cache ", (Object[])new Object[]{dob});
        }
        if (null != cc) {
            cc.cache = null;
            cc.distributedObjectCache = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Dropping CacheConfig ", (Object[])new Object[]{cc});
        }
        if (this.cacheName.equalsIgnoreCase("baseCache")) {
            commonCacheConfig = null;
            ServerCache.cacheUnit.initialize(null);
            ServletCacheUnit scu = ServerCache.cacheUnit.getServletCacheUnit();
            if (scu != null) {
                scu.purgeState(this.cacheName);
            }
            ServerCache.cache = null;
            ServerCache.jspCache = null;
            ServerCache.commandCache = null;
            ServerCache.unsetCacheService(this);
        }
        this.deleteOSGiConfiguration();
        ServerCache.objectCacheEnabled = false;
        ServerCache.coreCacheEnabled = false;
        this.unInitializeConfigPropertiesFiles(this.getClass().getClassLoader(), DISTRIBUTED_MAP_PROPERTIES);
        this.unInitializeConfigPropertiesFiles(this.getClass().getClassLoader(), CACHE_INSTANCES_PROPERTIES);
        Collection<DistributedObjectCache> distributedMaps = DistributedObjectCacheFactory.distributedMaps.values();
        for (DistributedObjectCache distributedObjectCache : distributedMaps) {
            DCache distCache = ((DistributedObjectCacheAdapter)distributedObjectCache).getCache();
            ServerCache.getCacheInstances().remove(distCache);
            distCache.stop();
            this.deleteOSGiConfiguration(distCache.getCacheName());
        }
        DistributedObjectCacheFactory.distributedMaps.clear();
        DistributedObjectCacheFactory.unsetCacheService(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop()");
        }
    }

    private void deleteOSGiConfiguration() {
        this.deleteOSGiConfiguration(this.cacheName);
    }

    private void deleteOSGiConfiguration(String cacheName) {
        block18: {
            String methodName = "deleteOSGiConfiguration()";
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"deleteOSGiConfiguration()", (Object[])new Object[]{cacheName});
            }
            try {
                Configuration[] osgiConfigs = this.getOSGiConfiguration(cacheName);
                if (null != osgiConfigs) {
                    for (Configuration configuration : osgiConfigs) {
                        String[] cacheGroupPIDs;
                        String[] diskPIDs;
                        String generated = (String)configuration.getProperties().get(PROPS_GENERATED);
                        if (generated == null || !generated.equals("true")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Deleting OSGi Configuration ", (Object[])new Object[]{configuration.getProperties()});
                        }
                        if (null != (diskPIDs = (String[])configuration.getProperties().get("disk"))) {
                            for (String diskPID : diskPIDs) {
                                Configuration diskConfig = this.configAdminRef.get().getConfiguration(diskPID);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"\t Deleting OSGi Configuration ", (Object[])new Object[]{diskConfig.getProperties()});
                                }
                                diskConfig.delete();
                            }
                        }
                        if (null != (cacheGroupPIDs = (String[])configuration.getProperties().get("cacheGroup"))) {
                            for (String cacheGroupPID : cacheGroupPIDs) {
                                String[] pids;
                                Configuration cacheGroupMetaTypeConfig = this.configAdminRef.get().getConfiguration(cacheGroupPID);
                                Dictionary cacheGroupProperties = cacheGroupMetaTypeConfig.getProperties();
                                if (null != cacheGroupProperties && cacheGroupProperties.get("member") instanceof String[] && null != (pids = (String[])cacheGroupProperties.get("member"))) {
                                    for (String pid : pids) {
                                        Configuration memberConfig = this.configAdminRef.get().getConfiguration(pid);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"\t Deleting OSGi Configuration ", (Object[])new Object[]{memberConfig.getProperties()});
                                        }
                                        memberConfig.delete();
                                    }
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"\t Deleting OSGi Configuration ", (Object[])new Object[]{cacheGroupMetaTypeConfig.getProperties()});
                                }
                                cacheGroupMetaTypeConfig.delete();
                            }
                        }
                        configuration.delete();
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"deleteOSGiConfiguration() no configuration for: ", (Object[])new Object[]{cacheName});
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug((TraceComponent)tc, (String)"deleteOSGiConfiguration()", (Object[])new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteOSGiConfiguration()", (Object)cacheName);
        }
    }

    @Override
    public CacheConfig addCacheInstanceConfig(Properties properties) {
        CacheConfig config;
        block4: {
            config = null;
            String methodName = "addCacheInstanceConfig(Properties)";
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("addCacheInstanceConfig(Properties) properties=" + properties), (Object[])new Object[0]);
            }
            try {
                config = new CacheConfig(properties, commonCacheConfig);
                this.postProcessAndAddConfig(config, true);
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.CacheServiceImpl.addCacheInstanceConfig(Properties)", (String)"396", (Object)this);
                if (!tc.isWarningEnabled()) break block4;
                Tr.error((TraceComponent)tc, (String)"DYNA1091E", (Object[])new Object[]{properties.toString(), ex.getCause()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addCacheInstanceConfig(Properties) ALL CONFIGS " + cacheConfigs));
        }
        return config;
    }

    @Override
    public void addCacheInstanceConfig(CacheConfig config, boolean create) throws Exception {
        String methodName = "addCacheInstanceConfig(CacheConfig)";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addCacheInstanceConfig(CacheConfig) reference=" + config.cacheName + " cacheName=" + config.cacheName), (Object[])new Object[0]);
        }
        if (config.cacheName.equalsIgnoreCase("baseCache")) {
            commonCacheConfig = config;
            ServerCache.cacheUnit.initialize(commonCacheConfig);
        }
        this.postProcessAndAddConfig(config, create);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addCacheInstanceConfig(CacheConfig) ALL CONFIGS " + cacheConfigs));
        }
    }

    private void postProcessAndAddConfig(CacheConfig config, boolean create) throws IOException, InvalidSyntaxException {
        CacheConfig prevConfig = (CacheConfig)cacheConfigs.get(config.cacheName);
        if (prevConfig == null) {
            cacheConfigs.put(config.cacheName, config);
            if (create) {
                this.findOrCreateOSGiConfiguration(config);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Saved the dynacache internal config object as  ", (Object[])new Object[]{config.cacheName, config});
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Config object already exist ", (Object[])new Object[]{prevConfig.cacheName, prevConfig});
        }
    }

    private void findOrCreateOSGiConfiguration(CacheConfig config) throws IOException, InvalidSyntaxException {
        StringBuilder filter = new StringBuilder("(&").append(FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)FACTORY_PID));
        if (null != config.jndiName) {
            filter.append(FilterUtils.createPropertyFilter((String)PROPS_JNDI_NAME, (String)config.jndiName));
        } else {
            filter.append(FilterUtils.createPropertyFilter((String)"id", (String)config.cacheName));
            config.jndiName = config.cacheName;
        }
        filter.append(')');
        ConfigurationAdmin configAdmin = this.configAdminRef.get();
        if (null != configAdmin) {
            Configuration[] configs = configAdmin.listConfigurations(filter.toString());
            if (null != configs && configs.length > 0) {
                Configuration osgiCacheConfig = configs[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found OSGI Configuration", (Object[])new Object[]{osgiCacheConfig.getProperties()});
                }
            } else {
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("id", config.cacheName);
                props.put(PROPS_JNDI_NAME, config.jndiName);
                props.put(PROPS_GENERATED, Boolean.TRUE.toString());
                props.put(PROPS_CACHE_PROVIDER_NAME, config.cacheProviderName);
                if (!config.isDefaultCacheProvider()) {
                    props.put("cacheProvider.target", "(name=" + config.cacheProviderName + ")");
                }
                if (null != config.libraryRef) {
                    props.put("libraryRef", config.libraryRef);
                    props.put("sharedLib.target", "(service.pid=" + config.libraryRef + ")");
                }
                Configuration osgiCacheConfig = configAdmin.createFactoryConfiguration(FACTORY_PID);
                osgiCacheConfig.update(props);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Created OSGI Configuration", (Object[])new Object[]{osgiCacheConfig.getProperties()});
                }
            }
        }
    }

    public Configuration[] getOSGiConfiguration(String cacheName) throws IOException, InvalidSyntaxException {
        String filter;
        Configuration[] configs = null;
        ConfigurationAdmin configAdmin = this.configAdminRef.get();
        if (null != configAdmin && null != (configs = configAdmin.listConfigurations(filter = "(&" + FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)FACTORY_PID) + FilterUtils.createPropertyFilter((String)"id", (String)cacheName) + ")")) && configs.length > 0) {
            for (Configuration configuration : configs) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Found OSGI Configuration/s", (Object[])new Object[]{configuration.getProperties()});
            }
        }
        return configs;
    }

    @Override
    public CacheConfig getCacheInstanceConfig(String reference) {
        CacheConfig config;
        String methodName = "getCacheInstanceConfig()";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCacheInstanceConfig() reference=" + reference), (Object[])new Object[0]);
        }
        if ((config = (CacheConfig)cacheConfigs.get(reference)) == null) {
            if (reference.equalsIgnoreCase("services/cache/basecache")) {
                reference = "baseCache";
            } else if (reference.equalsIgnoreCase("services/cache/distributedmap")) {
                reference = "default";
            }
            config = (CacheConfig)cacheConfigs.get(reference);
        }
        if (null == config && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ALL CONFIGS", (Object[])new Object[]{cacheConfigs});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCacheInstanceConfig() config=" + (config != null ? "" + config.hashCode() : "null") + " reference=" + reference));
        }
        return config;
    }

    @Override
    public void destroyCacheInstance(String reference) {
        String methodName = "destroyCacheInstance()";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("destroyCacheInstance() reference=" + reference), (Object[])new Object[0]);
        }
        CacheConfig config = null;
        String ref = reference;
        if (reference != null) {
            if (reference.equalsIgnoreCase("services/cache/basecache")) {
                ref = "baseCache";
            } else if (reference.equalsIgnoreCase("services/cache/distributedmap")) {
                ref = "default";
            }
            config = (CacheConfig)cacheConfigs.remove(ref);
        }
        if (config != null) {
            if (config.cache != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("destroyCacheInstance() Stopping named cache: " + config.cache.getCacheName()), (Object[])new Object[0]);
                }
                config.cache.stop();
            }
            config.reset();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroyCacheInstance()");
        }
    }

    @Override
    public CacheConfig getCacheConfig() {
        return this.config;
    }

    @Override
    public ArrayList<String> getServletCacheInstanceNames() {
        ArrayList<String> list = new ArrayList<String>();
        if (cacheConfigs != null) {
            for (String cacheName : cacheConfigs.keySet()) {
                CacheConfig cacheConfig = (CacheConfig)cacheConfigs.get(cacheName);
                if (!cacheConfig.enableServletSupport) continue;
                list.add(cacheName);
            }
        }
        return list;
    }

    @Override
    public ArrayList<String> getObjectCacheInstanceNames() {
        ArrayList<String> list = new ArrayList<String>();
        if (cacheConfigs != null) {
            for (String cacheName : cacheConfigs.keySet()) {
                CacheConfig cacheConfig = (CacheConfig)cacheConfigs.get(cacheName);
                if (cacheConfig.enableServletSupport) continue;
                list.add(cacheName);
            }
        }
        return list;
    }

    @Override
    public CacheInstanceInfo[] getCacheInstanceInfo() {
        CacheInstanceInfo[] info = CacheInstanceInfo.getCacheInstanceInfo(this);
        return info;
    }

    protected void populateCacheInstanceInfo(CacheInstanceInfo info) {
        String methodName = "populateCacheInstanceInfo()";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"populateCacheInstanceInfo()", (Object[])new Object[0]);
        }
        if (cacheConfigs != null) {
            for (String cacheName : cacheConfigs.keySet()) {
                CacheConfig wccmCacheConfig = (CacheConfig)cacheConfigs.get(cacheName);
                CacheInstanceInfo.allConfigured.add(cacheName);
                CacheInstanceInfo.allFactory.add(cacheName);
                CacheInstanceInfo.allFile.add(cacheName);
                if (wccmCacheConfig.cache != null) {
                    CacheInstanceInfo.allActive.add(cacheName);
                }
                if (wccmCacheConfig.enableServletSupport) {
                    CacheInstanceInfo.servletConfigured.add(cacheName);
                    continue;
                }
                CacheInstanceInfo.objectConfigured.add(cacheName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"populateCacheInstanceInfo()");
        }
    }

    public Scheduler getScheduler() {
        return this.schedulerRef.get();
    }

    @Reference
    protected void setScheduler(Scheduler s) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setScheduler ", (Object[])new Object[]{s});
        }
        this.schedulerRef.set(s);
    }

    protected void unsetScheduler(Scheduler s) {
        this.schedulerRef.compareAndSet(s, null);
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configAdminRef.get();
    }

    @Reference
    protected void setConfigurationAdmin(ConfigurationAdmin ca) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ConfigurationAdmin ", (Object[])new Object[]{ca});
        }
        this.configAdminRef.set(ca);
    }

    protected void unsetConfigurationAdmin(ConfigurationAdmin ca) {
        this.configAdminRef.compareAndSet(ca, null);
    }

    public Object createResource(ResourceInfo ref) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createResource", (Object[])new Object[]{ref});
        }
        DistributedObjectCache dmap = null;
        if (ServerCache.coreCacheEnabled) {
            CacheConfig config = this.getCacheInstanceConfig(this.cacheName);
            if (null != config && null == (dmap = DistributedObjectCacheFactory.distributedMaps.get(config.cacheName))) {
                dmap = DistributedObjectCacheFactory.getMap(config.cacheName);
            }
            if (null == config && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"all cache names", (Object[])new Object[]{cacheConfigs.keySet()});
            }
        } else {
            throw new IllegalStateException("Core Cache Service is disabled");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createResource", (Object)dmap);
        }
        return dmap;
    }

    @Override
    public Library getSharedLibrary() {
        return this.sharedLibRef.get();
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    @Reference(name="cacheProvider", service=CacheProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setCacheProvider(CacheProvider provider) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setCacheProvider", (Object[])new Object[]{provider});
        }
        this.cacheProvider = provider;
    }

    protected void unsetCacheProvider(CacheProvider provider) {
    }

    @Reference(name="sharedLib", service=Library.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSharedLib(Library ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setSharedLib", (Object[])new Object[]{ref});
        }
        this.sharedLibRef.set(ref);
    }

    protected void unsetSharedLib(Library ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"unsetSharedLib", (Object[])new Object[]{ref});
        }
        this.sharedLibRef.set(null);
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public void onStartup(Set<Class<?>> c, ServletContext ctx) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"onStartup", (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("created listener to add to servletContext.  listener is: " + this), (Object[])new Object[0]);
        }
        ctx.addListener((EventListener)((Object)this));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"onStartup");
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        String methodName = "contextInitialized";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"contextInitialized", (Object[])new Object[]{sce.getServletContext().getContextPath()});
        }
        try {
            this.initializeConfigPropertiesFiles(sce.getServletContext(), "/distributedmap.properties");
            this.initializeConfigPropertiesFiles(sce.getServletContext(), "/cacheinstances.properties");
            this.initializeConfigPropertiesFiles(sce.getServletContext(), "/WEB-INF/distributedmap.properties");
            this.initializeConfigPropertiesFiles(sce.getServletContext(), "/WEB-INF/cacheinstances.properties");
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ObjectCacheServiceImpl.contextInitialized(ServletContextEvent)", (String)"169", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"contextInitialized");
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        String methodName = "contextDestroyed";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"contextDestroyed", (Object[])new Object[]{sce.getServletContext().getContextPath()});
        }
        try {
            this.unInitializeConfigPropertiesFiles(sce.getServletContext(), "/distributedmap.properties");
            this.unInitializeConfigPropertiesFiles(sce.getServletContext(), "/cacheinstances.properties");
            this.unInitializeConfigPropertiesFiles(sce.getServletContext(), "/WEB-INF/distributedmap.properties");
            this.unInitializeConfigPropertiesFiles(sce.getServletContext(), "/WEB-INF/cacheinstances.properties");
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ObjectCacheServiceImpl.contextDestroyed(ServletContextEvent)", (String)"184", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"contextDestroyed");
        }
    }

    @Reference(service=VariableRegistry.class)
    protected void setVariableRegistry(VariableRegistry vr) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setVariableRegistry ", (Object[])new Object[]{vr});
        }
        this.variableRegistryRef.set(vr);
    }

    protected void unsetVariableRegistry(VariableRegistry vr) {
        this.variableRegistryRef.compareAndSet(vr, null);
    }

    private void initializeConfigPropertiesFiles(ServletContext sc, String fileName) {
        block5: {
            String methodName = "initializeConfigPropertiesFiles()";
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("initializeConfigPropertiesFiles()servletcontext=" + sc + " fileName=" + fileName), (Object[])new Object[0]);
            }
            try {
                URL u = sc.getResource(fileName);
                if (u != null && !this.processedUrls.contains(u)) {
                    this.processConfigUrl(u);
                }
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"dynacache config error", (Object[])new Object[]{ex});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeConfigPropertiesFiles()");
        }
    }

    public void initializeConfigPropertiesFiles(ClassLoader cl, String fileName) {
        String methodName = "initializeConfigPropertiesFiles()";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("initializeConfigPropertiesFiles() classLoader=" + cl + " fileName=" + fileName), (Object[])new Object[0]);
        }
        try {
            Enumeration<URL> resources = cl.getResources(fileName);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if (this.processedUrls.contains(url)) continue;
                this.processConfigUrl(url);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.CacheServiceImpl.initializeConfigPropertiesFiles", (String)"638", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeConfigPropertiesFiles()");
        }
    }

    private void unInitializeConfigPropertiesFiles(ServletContext sc, String fileName) {
        try {
            URL u = sc.getResource(fileName);
            this.processedUrls.remove(u);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void unInitializeConfigPropertiesFiles(ClassLoader classLoader, String fileName) {
        try {
            Enumeration<URL> resources = classLoader.getResources(fileName);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                this.processedUrls.remove(url);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConfigUrl(URL url) throws Exception {
        String methodName = "processConfigUrl()";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processConfigUrl() configUrl=" + url), (Object[])new Object[0]);
        }
        this.processedUrls.add(url);
        Properties props = new Properties();
        try (InputStream is = url.openStream();){
            props.load(is);
        }
        int i = 0;
        VariableRegistry vr = this.variableRegistryRef.get();
        boolean found = false;
        do {
            String instancekey;
            String instanceName;
            if ((instanceName = props.getProperty(instancekey = "cache.instance." + i)) != null && instanceName.charAt(0) == '/') {
                instanceName = instanceName.substring(1);
            }
            if (instanceName != null) {
                instanceName = instanceName.trim();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processConfigUrl() Adding new cache instance. instanceName=" + instanceName), (Object[])new Object[0]);
                }
                found = true;
                Iterator<Object> it = props.keySet().iterator();
                Properties ccProps = new Properties();
                ccProps.put("com.ibm.ws.cache.CacheConfig.cacheName", instanceName);
                while (it.hasNext()) {
                    String s = (String)it.next();
                    if (!s.startsWith(instancekey + ".")) continue;
                    String value = vr.resolveString(props.getProperty(s)).trim();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processConfigUrl() Adding property: " + s + " value:" + value), (Object[])new Object[0]);
                    }
                    ccProps.put("com.ibm.ws.cache.CacheConfig" + s.substring(instancekey.length()), value);
                    String unmodifiedKey = s.substring(instancekey.length() + 1);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processConfigUrl() Adding property: " + unmodifiedKey + " value:" + value), (Object[])new Object[0]);
                    }
                    ccProps.put(unmodifiedKey, value);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processConfigUrl() Final props=" + ccProps), (Object[])new Object[0]);
                }
                DCache c = ServerCache.getCache(instanceName);
                CacheConfig cacheConfig = this.getCacheInstanceConfig(instanceName);
                if (c == null && cacheConfig == null) {
                    cacheConfig = this.addCacheInstanceConfig(ccProps);
                    if (cacheConfig.isCreateCacheAtServerStartup()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Create cache instance \"" + instanceName + "\" during startup because the cache is configured to."), (Object[])new Object[0]);
                        }
                        ServerCache.createCache(cacheConfig.getCacheName(), cacheConfig);
                    }
                } else {
                    Tr.warning((TraceComponent)tc, (String)"DYNA1057W", (Object[])new Object[]{instanceName, url.toString()});
                }
            } else {
                found = false;
            }
            ++i;
        } while (found);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("processConfigUrl() configUrl=" + url));
        }
    }

    static {
        ServerCache.cacheUnit.setObjectCacheUnit(objectCacheUnit);
    }
}

