/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.Serializable;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class DataDescriptor
implements Serializable,
PmiConstants {
    private static final long serialVersionUID = -5571274779240562143L;
    String[] dataPath = null;
    int[] dataIds = null;
    int type = -1;
    final int SUBMODULE_INDEX = 2;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public DataDescriptor() {
    }

    public DataDescriptor(String[] path) {
        this.init(path, -3);
    }

    public DataDescriptor(String[] path, int dataId) {
        this.init(path, dataId);
    }

    public DataDescriptor(String[] path, int[] dataIds) {
        this.init(path, dataIds);
    }

    public DataDescriptor(DataDescriptor parent, String name) {
        if (parent == null || parent.getType() == -1 || parent.getType() == 18) {
            this.type = -1;
        } else {
            String[] path = parent.getPath();
            if (path.length == 1 && path[0].equals("pmi")) {
                this.init(new String[]{name}, -3);
            } else {
                String[] myPath = new String[path.length + 1];
                System.arraycopy(path, 0, myPath, 0, path.length);
                myPath[myPath.length - 1] = name;
                this.init(myPath, -3);
            }
        }
    }

    public DataDescriptor(DataDescriptor parent, int dataId) {
        if (parent == null || parent.getType() == -1 || parent.getType() == 18) {
            this.type = -1;
        } else {
            this.init(parent.getPath(), dataId);
        }
    }

    public DataDescriptor(DataDescriptor parent, int[] dataIds) {
        if (parent == null || parent.getType() == -1 || parent.getType() == 18) {
            this.type = -1;
        } else {
            this.init(parent.getPath(), dataIds);
        }
    }

    private void init(String[] path, int dataId) {
        if (dataId == -3) {
            this.init(path, null);
        } else {
            this.init(path, new int[]{dataId});
        }
    }

    private void init(String[] path, int[] dataIds) {
        this.dataPath = path;
        this.dataIds = dataIds;
        if (this.dataPath != null && this.dataPath.length > 2) {
            if (this.dataPath[2].equals("methods")) {
                this.dataPath[2] = "beanModule.methods";
            } else if (this.dataPath[2].equals("servlets")) {
                this.dataPath[2] = "webAppModule.servlets";
            }
        }
        if (this.dataPath == null || this.dataPath.length == 0) {
            this.type = -1;
            if (this.dataPath == null) {
                this.dataPath = new String[0];
            }
        } else {
            for (int i = 0; i < this.dataPath.length; ++i) {
                if (this.dataPath[i] != null) continue;
                this.type = -1;
                return;
            }
            if (dataIds != null) {
                this.type = 18;
            } else {
                if (this.dataPath.length == 1 && this.dataPath[0].equals("pmi")) {
                    this.type = 12;
                }
                this.type = this.dataPath.length == 1 ? 13 : 17;
            }
        }
    }

    public String[] getPath() {
        return this.dataPath;
    }

    public int getType() {
        return this.type;
    }

    public int getType(int pathLength) {
        if (this.type == -1 || this.dataPath == null || pathLength >= this.dataPath.length) {
            return -1;
        }
        if (pathLength == 1) {
            return 13;
        }
        return 17;
    }

    public String getModuleName() {
        if (this.type == -1) {
            return null;
        }
        return this.dataPath[0];
    }

    public String getName() {
        if (this.type == -1) {
            return null;
        }
        return this.dataPath[this.dataPath.length - 1];
    }

    public int getDataId() {
        if (this.dataIds == null) {
            return -3;
        }
        return this.dataIds[0];
    }

    public int[] getDataIds() {
        return this.dataIds;
    }

    public boolean isSamePath(DataDescriptor other) {
        if (other == null) {
            return false;
        }
        if (this.type == -1 || other.getType() == -1) {
            return false;
        }
        if (this.type != other.getType()) {
            return false;
        }
        if (this.dataPath == null || other.getPath() == null) {
            return false;
        }
        String[] otherPath = other.getPath();
        if (this.dataPath.length != otherPath.length) {
            return false;
        }
        for (int i = 0; i < this.dataPath.length; ++i) {
            if (this.dataPath[i].equals(otherPath[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isDescendant(DataDescriptor other) {
        if (other == null) {
            return false;
        }
        if (this.type == -1 || other.getType() == -1) {
            return false;
        }
        String[] otherPath = other.getPath();
        if (otherPath.length >= this.dataPath.length) {
            return false;
        }
        for (int i = 0; i < otherPath.length; ++i) {
            if (this.dataPath[i].equals(otherPath[i])) continue;
            return false;
        }
        return true;
    }

    public DataDescriptor parentDescriptor() {
        if (this.type == -1) {
            return null;
        }
        if (this.dataIds != null) {
            return new DataDescriptor(this.dataPath);
        }
        if (this.dataPath.length == 1) {
            return null;
        }
        String[] myPath = new String[this.dataPath.length - 1];
        System.arraycopy(this.dataPath, 0, myPath, 0, myPath.length);
        return new DataDescriptor(myPath);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.dataPath.length; ++i) {
            ret.append(this.dataPath[i]).append("/");
        }
        if (this.dataIds != null) {
            ret.append(this.dataIds[0]);
        }
        return ret.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DataDescriptor.class);
    }
}

