/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.service;

import com.ibm.tx.jta.DestroyXAResourceException;
import com.ibm.tx.jta.XAResourceFactory;
import com.ibm.tx.jta.XAResourceNotAvailableException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jca.cm.JcaServiceUtilities;
import com.ibm.ws.jca.internal.ActivationConfig;
import com.ibm.ws.jca.internal.BootstrapContextImpl;
import com.ibm.ws.jca.internal.ResourceAdapterMetaData;
import com.ibm.ws.jca.internal.Utils;
import com.ibm.ws.jca.metadata.ConnectorModuleMetaData;
import com.ibm.ws.jca.osgi.JCARuntimeVersion;
import com.ibm.ws.jca.osgi.JCARuntimeVersion16;
import com.ibm.ws.jca.service.AdminObjectService;
import com.ibm.ws.jca.service.WSMessageEndpointFactory;
import com.ibm.ws.kernel.service.util.PrivHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.ws.tx.rrs.RRSXAResourceFactory;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EndpointActivationService
implements XAResourceFactory,
ApplicationRecycleComponent {
    private static final TraceComponent tc = Tr.register(EndpointActivationService.class);
    private static final String CONFIG_PROPS_PREFIX = "properties.0.";
    private static final int CONFIG_PROPS_PREFIX_LENGTH = "properties.0.".length();
    public static final String DESTINATION = "destination";
    public static final String DESTINATION_LOOKUP = "destinationLookup";
    private static final String ID = "id";
    public static final String PASSWORD = "password";
    private static final String USER_NAME = "userName";
    private String activationSpecClassName;
    private ServiceReference<?> authDataRef;
    private ComponentContext componentContext;
    private final Map<String, Object> configProps = new HashMap<String, Object>();
    private final AtomicServiceReference<AdminObjectService> destinationRef = new AtomicServiceReference("destination");
    private String id;
    protected final Set<String> appsToRecycle = Collections.newSetFromMap(new ConcurrentHashMap());
    private EmbeddableWebSphereTransactionManager transactionManager;
    private final AtomicServiceReference<BootstrapContextImpl> bootstrapContextRef = new AtomicServiceReference("bootstrapContext");
    private String[] requiredConfigProps;
    private final AtomicServiceReference<RRSXAResourceFactory> rrsXAResFactorySvcRef = new AtomicServiceReference("rRSXAResourceFactory");
    private JcaServiceUtilities jcasu;
    private ClassLoader raClassLoader;
    private static final JCARuntimeVersion DEFAULT_VERSION;
    private static JCARuntimeVersion runtimeVersion;
    static final long serialVersionUID = 422296426596656159L;

    @Trivial
    @ManualTrace
    protected void activate(ComponentContext context) throws Exception {
        Dictionary props = context.getProperties();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{props});
        }
        this.destinationRef.activate(context);
        this.bootstrapContextRef.activate(context);
        this.rrsXAResFactorySvcRef.activate(context);
        this.componentContext = context;
        this.activationSpecClassName = (String)props.get("properties.0.activationspec-class");
        this.id = (String)context.getProperties().get(ID);
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            String propName;
            String key = (String)keys.nextElement();
            if (key.length() <= CONFIG_PROPS_PREFIX_LENGTH || key.charAt(CONFIG_PROPS_PREFIX_LENGTH - 1) != '.' || !key.startsWith(CONFIG_PROPS_PREFIX) || (propName = key.substring(CONFIG_PROPS_PREFIX_LENGTH)).indexOf(46) >= 0 || propName.indexOf(45) >= 0 || "destinationRef".equals(propName)) continue;
            this.configProps.put(propName, props.get(key));
        }
        this.requiredConfigProps = (String[])props.get("properties.0.required-config-property");
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"activate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    private Object createActivationSpec(@Sensitive Properties activationProperties, String authAlias, AdminObjectService adminObjSvc, String destinationID, String destinationIDOrJNDIName, String appName) throws Exception {
        Object activationSpec;
        boolean trace;
        block28: {
            trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"createActivationSpec", (Object[])new Object[]{activationProperties, authAlias, adminObjSvc, destinationID, appName});
            }
            BootstrapContextImpl bootstrapContext = (BootstrapContextImpl)this.bootstrapContextRef.getServiceWithException();
            Class<?> activationSpecClass = bootstrapContext.loadClass(this.activationSpecClassName);
            String adapterName = bootstrapContext.getResourceAdapterName();
            String embeddedApp = null;
            ResourceAdapterMetaData metadata = bootstrapContext.getResourceAdapterMetaData();
            if (metadata != null && metadata.isEmbedded()) {
                embeddedApp = metadata.getJ2EEName().getApplication();
                Utils.checkAccessibility(this.id, adapterName, embeddedApp, appName, true);
            }
            activationSpec = activationSpecClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            HashMap<String, Object> activationProps = new HashMap<String, Object>();
            for (Map.Entry<Object, Object> prop : activationProperties.entrySet()) {
                String key = (String)prop.getKey();
                char firstChar = key.charAt(0);
                if (Character.isUpperCase(firstChar)) {
                    key = new StringBuilder(key.length()).append(Character.toLowerCase(firstChar)).append(key.substring(1)).toString();
                }
                activationProps.put(key, prop.getValue());
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("activation config: " + key + '=' + (key.toLowerCase().contains(PASSWORD) ? "***" : prop.getValue())), (Object[])new Object[0]);
            }
            boolean atLeastJCA17 = EndpointActivationService.atLeastJCAVersion(JCARuntimeVersion.VERSION_1_7);
            if (!(activationProps.containsKey(DESTINATION) || atLeastJCA17 && activationProps.containsKey(DESTINATION_LOOKUP))) {
                boolean added = false;
                if (atLeastJCA17 && EndpointActivationService.hasDestinationLookupProp(activationSpec)) {
                    String jndiName;
                    String string = jndiName = destinationIDOrJNDIName == null ? ((AdminObjectService)this.destinationRef.getServiceWithException()).getJndiName() : destinationIDOrJNDIName;
                    if (jndiName != null) {
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("add destinationLookup " + jndiName + " to activation props"), (Object[])new Object[0]);
                        }
                        activationProps.put(DESTINATION_LOOKUP, jndiName);
                        added = true;
                    }
                }
                if (!added && EndpointActivationService.hasDestinationProp(activationSpec)) {
                    if (destinationID == null) {
                        destinationID = ((AdminObjectService)this.destinationRef.getServiceWithException()).getId();
                    }
                    if (destinationID == null) {
                        destinationID = ((AdminObjectService)this.destinationRef.getServiceWithException()).getJndiName();
                    }
                    if (destinationID != null) {
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("add destination " + destinationID + " to activation props"), (Object[])new Object[0]);
                        }
                        activationProps.put(DESTINATION, destinationID);
                    }
                }
            }
            if (authAlias != null) {
                this.processAuthData(authAlias, activationProps);
            } else if (this.authDataRef != null) {
                activationProps.put(USER_NAME, this.authDataRef.getProperty("user"));
                activationProps.put(PASSWORD, this.authDataRef.getProperty(PASSWORD));
            }
            if (this.requiredConfigProps != null) {
                for (String name : this.requiredConfigProps) {
                    if (this.configProps.containsKey(name) || activationProps.containsKey(name) || this.bootstrapContextRef.getReference().getProperty(name) != null || DESTINATION.equals(name) && this.destinationRef.getService() != null) continue;
                    throw new ResourceException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA8813.required.activation.prop.not.set", (Object[])new Object[]{name, this.id, bootstrapContext.getResourceAdapterName()}));
                }
            }
            ComponentMetaDataAccessorImpl cmda = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
            try {
                if (metadata != null) {
                    cmda.beginContext((ComponentMetaData)metadata);
                }
                bootstrapContext.configure(activationSpec, this.id, this.configProps, activationProps, adminObjSvc, this.destinationRef);
            }
            finally {
                if (metadata != null) {
                    cmda.endContext();
                }
            }
            if (activationSpec instanceof ActivationSpec) {
                try {
                    ((ActivationSpec)activationSpec).validate();
                }
                catch (UnsupportedOperationException jndiName) {
                    void uoe;
                    Object[] objectArray = new Object[6];
                    objectArray[0] = "<sensitive java.util.Properties>";
                    objectArray[1] = authAlias;
                    objectArray[2] = adminObjSvc;
                    objectArray[3] = destinationID;
                    objectArray[4] = destinationIDOrJNDIName;
                    objectArray[5] = appName;
                    FFDCFilter.processException((Throwable)jndiName, (String)"com.ibm.ws.jca.service.EndpointActivationService", (String)"305", (Object)this, (Object[])objectArray);
                    if (!trace || !tc.isDebugEnabled()) break block28;
                    Tr.debug((TraceComponent)tc, (String)("The ActivationSpec type " + activationSpec.getClass().getName() + " does not support the validate() method."), (Object[])new Object[]{uoe});
                }
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createActivationSpec", this.destinationRef);
        }
        return activationSpec;
    }

    protected void deactivate(ComponentContext context) {
        this.destinationRef.deactivate(context);
        this.bootstrapContextRef.deactivate(context);
        this.rrsXAResFactorySvcRef.deactivate(context);
    }

    public ApplicationRecycleContext getContext() {
        ApplicationRecycleContext context = (ApplicationRecycleContext)this.bootstrapContextRef.getService();
        if (context != null) {
            return context;
        }
        return null;
    }

    public Set<String> getDependentApplications() {
        HashSet<String> members = new HashSet<String>(this.appsToRecycle);
        this.appsToRecycle.removeAll(members);
        return members;
    }

    @FFDCIgnore(value={NoSuchMethodException.class})
    private static boolean isRRSTransactional(Object activationSpec) {
        try {
            return (Boolean)activationSpec.getClass().getMethod("getRRSTransactional", new Class[0]).invoke(activationSpec, new Object[0]);
        }
        catch (NoSuchMethodException x) {
            return false;
        }
        catch (Exception x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.jca.service.EndpointActivationService", (String)"357", null, (Object[])new Object[]{activationSpec});
            return false;
        }
    }

    @FFDCIgnore(value={NoSuchMethodException.class})
    private static boolean hasDestinationProp(Object activationSpec) {
        try {
            activationSpec.getClass().getMethod("getDestination", new Class[0]);
        }
        catch (NoSuchMethodException x) {
            return false;
        }
        catch (Exception x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.jca.service.EndpointActivationService", (String)"368", null, (Object[])new Object[]{activationSpec});
            return false;
        }
        return true;
    }

    @FFDCIgnore(value={NoSuchMethodException.class})
    private static boolean hasDestinationLookupProp(Object activationSpec) {
        try {
            activationSpec.getClass().getMethod("getDestinationLookup", new Class[0]);
        }
        catch (NoSuchMethodException x) {
            return false;
        }
        catch (Exception x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.jca.service.EndpointActivationService", (String)"380", null, (Object[])new Object[]{activationSpec});
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void processAuthData(String id, Map<String, Object> activationProps) throws UnavailableException {
        ServiceReference authDataRef;
        String filter = FilterUtils.createPropertyFilter((String)ID, (String)id);
        try {
            ServiceReference[] authDataRefs = PrivHelper.getServiceReferences((ComponentContext)this.componentContext, (String)"com.ibm.websphere.security.auth.data.AuthData", (String)filter);
            if (authDataRefs == null || authDataRefs.length != 1) {
                throw new UnavailableException("authData: " + id);
            }
            authDataRef = authDataRefs[0];
        }
        catch (Exception authDataRefs) {
            void x;
            FFDCFilter.processException((Throwable)authDataRefs, (String)"com.ibm.ws.jca.service.EndpointActivationService", (String)"401", (Object)this, (Object[])new Object[]{id, activationProps});
            throw new UnavailableException("authData: " + id, (Throwable)x);
        }
        activationProps.put(USER_NAME, authDataRef.getProperty("user"));
        activationProps.put(PASSWORD, authDataRef.getProperty(PASSWORD));
    }

    public void destroyXAResource(XAResource xa) throws DestroyXAResourceException {
    }

    /*
     * WARNING - void declaration
     */
    public XAResource getXAResource(Serializable xaresinfo) throws XAResourceNotAvailableException {
        XAResource xa = null;
        if (xaresinfo != null) {
            ArrayList byteList = (ArrayList)xaresinfo;
            byte[] bytes = new byte[byteList.size()];
            int i = 0;
            for (Byte b : byteList) {
                bytes[i++] = b;
            }
            try {
                ActivationConfig config = (ActivationConfig)Utils.deserialize(bytes);
                Object activationSpec = this.createActivationSpec(config.getActivationConfigProps(), config.getAuthenticationAlias(), null, config.getDestinationRef(), null, config.getApplicationName());
                BootstrapContextImpl bootstrapContext = (BootstrapContextImpl)this.bootstrapContextRef.getServiceWithException();
                ActivationSpec[] actspecs = new ActivationSpec[]{(ActivationSpec)activationSpec};
                XAResource[] resources = bootstrapContext.resourceAdapter.getXAResources(actspecs);
                if (resources != null && resources.length == 1) {
                    xa = resources[0];
                } else if (resources != null && resources.length > 1) {
                    throw new IllegalStateException(Utils.getMessage("J2CA8800.multiple.xa.resources", bootstrapContext.getResourceAdapterName(), this.id));
                }
            }
            catch (Exception config) {
                void e;
                FFDCFilter.processException((Throwable)config, (String)"com.ibm.ws.jca.service.EndpointActivationService", (String)"449", (Object)this, (Object[])new Object[]{xaresinfo});
                throw new XAResourceNotAvailableException((Throwable)e);
            }
        }
        return xa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    public Object activateEndpoint(WSMessageEndpointFactory mef, @Sensitive Properties activationProperties, String authenticationAlias, String destinationIDOrJNDIName, AdminObjectService adminObjSvc, String adminObjSvcRefId) throws ResourceException {
        Object activationSpec;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"activateEndpoint", (Object[])new Object[]{mef, activationProperties, authenticationAlias, destinationIDOrJNDIName, adminObjSvc, adminObjSvcRefId});
        }
        BootstrapContextImpl bootstrapContext = null;
        try {
            bootstrapContext = (BootstrapContextImpl)this.bootstrapContextRef.getServiceWithException();
            String adapterPid = (String)this.bootstrapContextRef.getReference().getProperty("service.pid");
            if (adminObjSvcRefId == null) {
                adminObjSvcRefId = destinationIDOrJNDIName;
            }
            activationSpec = this.createActivationSpec(activationProperties, authenticationAlias, adminObjSvc, adminObjSvcRefId, destinationIDOrJNDIName, mef.getJ2EEName().getApplication());
            int[] fullJCAVersionArray = EndpointActivationService.getFullJCAVersion(bootstrapContext);
            mef.setJCAVersion(fullJCAVersionArray[0], fullJCAVersionArray[1]);
            mef.setRAKey(adapterPid);
            ActivationConfig config = new ActivationConfig(activationProperties, adminObjSvcRefId, authenticationAlias, mef.getJ2EEName().getApplication());
            int recoveryId = EndpointActivationService.isRRSTransactional(activationSpec) ? this.registerRRSXAResourceInfo(this.id) : this.registerXAResourceInfo(config);
            mef.setRecoveryID(recoveryId);
            if (activationSpec instanceof ActivationSpec) {
                this.appsToRecycle.add(mef.getJ2EEName().getApplication());
                this.jcasu = new JcaServiceUtilities();
                this.raClassLoader = bootstrapContext.getRaClassLoader();
                ClassLoader previousClassLoader = this.jcasu.beginContextClassLoader(this.raClassLoader);
                try {
                    bootstrapContext.resourceAdapter.endpointActivation((MessageEndpointFactory)mef, (ActivationSpec)activationSpec);
                }
                finally {
                    this.jcasu.endContextClassLoader(this.raClassLoader, previousClassLoader);
                }
            } else {
                throw new UnsupportedOperationException();
            }
            Tr.info((TraceComponent)tc, (String)"J2CA8801.act.spec.active", (Object[])new Object[]{this.id, mef.getJ2EEName()});
        }
        catch (Exception adapterPid) {
            void ex;
            Object[] objectArray = new Object[6];
            objectArray[0] = mef;
            objectArray[1] = "<sensitive java.util.Properties>";
            objectArray[2] = authenticationAlias;
            objectArray[3] = destinationIDOrJNDIName;
            objectArray[4] = adminObjSvc;
            objectArray[5] = adminObjSvcRefId;
            FFDCFilter.processException((Throwable)adapterPid, (String)"com.ibm.ws.jca.service.EndpointActivationService", (String)"523", (Object)this, (Object[])objectArray);
            Tr.error((TraceComponent)tc, (String)"J2CA8802.activation.failed", (Object[])new Object[]{bootstrapContext == null ? null : bootstrapContext.getResourceAdapterName(), ex});
            throw ex instanceof ResourceException ? (ResourceException)ex : new ResourceException((Throwable)ex);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"activateEndpoint", (Object)activationSpec);
        }
        return activationSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void deactivateEndpoint(Object activationSpec, WSMessageEndpointFactory messageEndpointFactory) throws ResourceException {
        block6: {
            try {
                BootstrapContextImpl bootstrapContext = (BootstrapContextImpl)this.bootstrapContextRef.getServiceWithException();
                if (activationSpec instanceof ActivationSpec) {
                    ClassLoader previousClassLoader = this.jcasu.beginContextClassLoader(this.raClassLoader);
                    try {
                        bootstrapContext.resourceAdapter.endpointDeactivation((MessageEndpointFactory)messageEndpointFactory, (ActivationSpec)activationSpec);
                        break block6;
                    }
                    finally {
                        this.jcasu.endContextClassLoader(this.raClassLoader, previousClassLoader);
                    }
                }
                throw new UnsupportedOperationException();
            }
            catch (Exception bootstrapContext) {
                void ex;
                FFDCFilter.processException((Throwable)bootstrapContext, (String)"com.ibm.ws.jca.service.EndpointActivationService", (String)"553", (Object)this, (Object[])new Object[]{activationSpec, messageEndpointFactory});
                Tr.error((TraceComponent)tc, (String)"J2CA8803.deactivation.failed", (Object[])new Object[]{this.bootstrapContextRef.getReference().getProperty("service.pid"), ex});
                throw new ResourceException((Throwable)ex);
            }
        }
        Tr.info((TraceComponent)tc, (String)"J2CA8804.act.spec.inactive", (Object[])new Object[]{this.id, messageEndpointFactory.getJ2EEName()});
    }

    private static int[] getFullJCAVersion(BootstrapContextImpl bootstrapContext) {
        int[] fullVersionIntArray = new int[]{1, 5};
        ResourceAdapterMetaData raMetadata = bootstrapContext.getResourceAdapterMetaData();
        if (raMetadata != null) {
            ConnectorModuleMetaData connectorMetadata = (ConnectorModuleMetaData)raMetadata.getModuleMetaData();
            String fullVersionString = connectorMetadata.getSpecVersion();
            String[] fullVersionStrArray = fullVersionString.split("\\.");
            fullVersionIntArray[0] = Integer.valueOf(fullVersionStrArray[0]);
            fullVersionIntArray[1] = Integer.valueOf(fullVersionStrArray[1]);
        }
        return fullVersionIntArray;
    }

    /*
     * WARNING - void declaration
     */
    private final int registerXAResourceInfo(ActivationConfig config) throws UnavailableException {
        ArrayList<Byte> resInfo;
        if (this.transactionManager == null) {
            throw new UnavailableException(EmbeddableWebSphereTransactionManager.class.getName());
        }
        String filter = FilterUtils.createPropertyFilter((String)ID, (String)this.id);
        try {
            byte[] bytes = Utils.serObjByte(config);
            resInfo = new ArrayList<Byte>(bytes.length);
            for (byte b : bytes) {
                resInfo.add(b);
            }
        }
        catch (IOException bytes) {
            void x;
            FFDCFilter.processException((Throwable)bytes, (String)"com.ibm.ws.jca.service.EndpointActivationService", (String)"602", (Object)this, (Object[])new Object[]{config});
            throw new IllegalArgumentException((Throwable)x);
        }
        int recoveryToken = this.transactionManager.registerResourceInfo(filter, resInfo);
        return recoveryToken;
    }

    public final int registerRRSXAResourceInfo(String actSpecId) {
        RRSXAResourceFactory xaFactory = (RRSXAResourceFactory)this.rrsXAResFactorySvcRef.getService();
        if (xaFactory == null) {
            String formattedMessage = Utils.getMessage("J2CA8807.native.rrs.not.available", new Object[0]);
            throw new IllegalStateException(formattedMessage);
        }
        String filter = FilterUtils.createPropertyFilter((String)"native.xa.factory", (String)xaFactory.getClass().getCanonicalName());
        Serializable xaResInfo = xaFactory.getXAResourceInfo(null);
        int recoveryToken = this.transactionManager.registerResourceInfo(filter, xaResInfo);
        return recoveryToken;
    }

    protected void setAuthData(ServiceReference<?> ref) {
        this.authDataRef = ref;
    }

    protected void setBootstrapContext(ServiceReference<BootstrapContextImpl> ref) {
        this.bootstrapContextRef.setReference(ref);
    }

    protected void setDestination(ServiceReference<AdminObjectService> ref) {
        this.destinationRef.setReference(ref);
    }

    protected void setEmbeddableWebSphereTransactionManager(EmbeddableWebSphereTransactionManager tm) {
        this.transactionManager = tm;
    }

    protected void setRRSXAResourceFactory(ServiceReference<RRSXAResourceFactory> ref) {
        this.rrsXAResFactorySvcRef.setReference(ref);
    }

    protected void unsetAuthData(ServiceReference<?> ref) {
        this.authDataRef = null;
    }

    protected void unsetBootstrapContext(ServiceReference<BootstrapContextImpl> ref) {
        this.bootstrapContextRef.unsetReference(ref);
    }

    protected void unsetDestination(ServiceReference<AdminObjectService> ref) {
        this.destinationRef.unsetReference(ref);
    }

    protected void unsetEmbeddableWebSphereTransactionManager(EmbeddableWebSphereTransactionManager tm) {
        this.transactionManager = null;
    }

    protected void unsetRRSXAResourceFactory(ServiceReference<RRSXAResourceFactory> ref) {
        this.rrsXAResFactorySvcRef.unsetReference(ref);
    }

    public static JCARuntimeVersion getJCARuntimeVersion() {
        return runtimeVersion;
    }

    protected void setJcaRuntimeVersion(JCARuntimeVersion ref) {
        runtimeVersion = ref;
    }

    protected void unsetJcaRuntimeVersion(JCARuntimeVersion ref) {
        Version toUnset = ref.getVersion();
        if (runtimeVersion.getVersion().compareTo(toUnset) == 0) {
            runtimeVersion = DEFAULT_VERSION;
        }
    }

    public static boolean atLeastJCAVersion(Version ver) {
        return runtimeVersion.getVersion().compareTo(ver) >= 0;
    }

    public static boolean beforeJCAVersion(Version ver) {
        return !EndpointActivationService.atLeastJCAVersion(ver);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        runtimeVersion = DEFAULT_VERSION = new JCARuntimeVersion16();
    }
}

