/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.config.CommonConfigUtils;
import com.ibm.ws.security.common.jwk.impl.JWKSet;
import com.ibm.ws.security.jwt.config.ConsumerUtils;
import com.ibm.ws.security.jwt.config.JwtConsumerConfig;
import com.ibm.ws.security.mp.jwt.MicroProfileJwtConfig;
import com.ibm.ws.security.mp.jwt.MicroProfileJwtService;
import com.ibm.ws.security.mp.jwt.SslRefInfo;
import com.ibm.ws.security.mp.jwt.error.MpJwtProcessingException;
import com.ibm.ws.security.mp.jwt.impl.SslRefInfoImpl;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.security.mp.jwt", configurationPid={"com.ibm.ws.security.mp.jwt"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={MicroProfileJwtConfig.class, JwtConsumerConfig.class}, property={"service.vendor=IBM", "type=microProfileJwtConfig"})
public class MicroProfileJwtConfigImpl
implements MicroProfileJwtConfig,
JwtConsumerConfig {
    private static TraceComponent tc = Tr.register(MicroProfileJwtConfigImpl.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    protected final boolean IS_REQUIRED = true;
    protected final boolean IS_NOT_REQUIRED = false;
    protected static final String KEY_UNIQUE_ID = "id";
    protected String uniqueId = null;
    protected SSLContext sslContext = null;
    protected SSLSocketFactory sslSocketFactory = null;
    public static final String KEY_sslRef = "sslRef";
    protected String sslRef;
    protected SslRefInfo sslRefInfo = null;
    public static final String KEY_jwksUri = "jwksUri";
    protected String jwksUri = null;
    static final String KEY_MP_JWT_SERVICE = "microProfileJwtService";
    final AtomicServiceReference<MicroProfileJwtService> mpJwtServiceRef = new AtomicServiceReference("microProfileJwtService");
    ConsumerUtils consumerUtils = null;
    JWKSet jwkSet = null;
    public static final String KEY_ISSUER = "issuer";
    String issuer = null;
    public static final String KEY_AUDIENCE = "audiences";
    String[] audience = null;
    String signatureAlgorithm = "RS256";
    public static final String CFG_KEY_HOST_NAME_VERIFICATION_ENABLED = "hostNameVerificationEnabled";
    protected boolean hostNameVerificationEnabled = false;
    public static final String KEY_TRUSTED_ALIAS = "keyName";
    private String trustAliasName = null;
    public static final String KEY_userNameAttribute = "userNameAttribute";
    protected String userNameAttribute = null;
    public static final String KEY_groupNameAttribute = "groupNameAttribute";
    protected String groupNameAttribute = null;
    public static final String CFG_KEY_TOKEN_REUSE = "tokenReuse";
    protected boolean tokenReuse = true;
    public static final String CFG_KEY_CLOCK_SKEW = "clockSkew";
    private long clockSkewMilliSeconds;
    protected CommonConfigUtils configUtils = new CommonConfigUtils();
    static final long serialVersionUID = -3357899899186062912L;

    @Reference(service=MicroProfileJwtService.class, name="microProfileJwtService", cardinality=ReferenceCardinality.MANDATORY)
    protected void setMicroProfileJwtService(ServiceReference<MicroProfileJwtService> ref) {
        this.mpJwtServiceRef.setReference(ref);
    }

    protected void unsetMicroProfileJwtService(ServiceReference<MicroProfileJwtService> ref) {
        this.mpJwtServiceRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) throws MpJwtProcessingException {
        this.mpJwtServiceRef.activate(cc);
        this.uniqueId = (String)props.get(KEY_UNIQUE_ID);
        this.initProps(cc, props);
        Tr.info((TraceComponent)tc, (String)"MPJWT_CONFIG_PROCESSED", (Object[])new Object[]{this.uniqueId});
    }

    @Modified
    protected void modified(ComponentContext cc, Map<String, Object> props) throws MpJwtProcessingException {
        this.initProps(cc, props);
        Tr.info((TraceComponent)tc, (String)"MPJWT_CONFIG_MODIFIED", (Object[])new Object[]{this.uniqueId});
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.mpJwtServiceRef.deactivate(cc);
        Tr.info((TraceComponent)tc, (String)"MPJWT_CONFIG_DEACTIVATED", (Object[])new Object[]{this.uniqueId});
    }

    @ManualTrace
    public void initProps(ComponentContext cc, Map<String, Object> props) throws MpJwtProcessingException {
        String methodName = "initProps";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{cc, props});
        }
        this.issuer = this.configUtils.getRequiredConfigAttribute(props, KEY_ISSUER);
        this.audience = this.configUtils.getStringArrayConfigAttribute(props, KEY_AUDIENCE);
        this.jwksUri = this.configUtils.getConfigAttribute(props, KEY_jwksUri);
        this.userNameAttribute = this.configUtils.getConfigAttribute(props, KEY_userNameAttribute);
        this.groupNameAttribute = this.configUtils.getConfigAttribute(props, KEY_groupNameAttribute);
        this.clockSkewMilliSeconds = this.configUtils.getLongConfigAttribute(props, CFG_KEY_CLOCK_SKEW, this.clockSkewMilliSeconds);
        this.sslRef = this.configUtils.getConfigAttribute(props, KEY_sslRef);
        this.sslRefInfo = null;
        this.sslContext = null;
        this.trustAliasName = this.configUtils.getConfigAttribute(props, KEY_TRUSTED_ALIAS);
        this.hostNameVerificationEnabled = this.configUtils.getBooleanConfigAttribute(props, CFG_KEY_HOST_NAME_VERIFICATION_ENABLED, this.hostNameVerificationEnabled);
        this.tokenReuse = this.configUtils.getBooleanConfigAttribute(props, CFG_KEY_TOKEN_REUSE, this.tokenReuse);
        this.jwkSet = null;
        this.consumerUtils = null;
        this.debug();
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    protected void debug() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("issuer: " + this.issuer), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("hostNameVerificationEnabled: " + this.hostNameVerificationEnabled), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("tokenReuse: " + this.tokenReuse), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("keyName: " + this.trustAliasName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("jwksUri:" + this.jwksUri), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userNameAttribute:" + this.userNameAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("groupNameAttribute:" + this.groupNameAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sslRef = " + this.sslRef), (Object[])new Object[0]);
        }
    }

    public boolean isHostNameVerificationEnabled() {
        return this.hostNameVerificationEnabled;
    }

    public String getId() {
        return this.getUniqueId();
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSharedKey() {
        return null;
    }

    public List<String> getAudiences() {
        if (this.audience != null) {
            ArrayList<String> audiences = new ArrayList<String>();
            for (String aud : this.audience) {
                audiences.add(aud);
            }
            return audiences;
        }
        return null;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @FFDCIgnore(value={MpJwtProcessingException.class})
    public String getTrustStoreRef() {
        if (this.sslRefInfo == null) {
            MicroProfileJwtService service = (MicroProfileJwtService)this.mpJwtServiceRef.getService();
            if (service == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"MP JWT service is not available", (Object[])new Object[0]);
                }
                return null;
            }
            this.sslRefInfo = new SslRefInfoImpl(service.getSslSupport(), service.getKeyStoreServiceRef(), this.sslRef, this.trustAliasName);
        }
        try {
            return this.sslRefInfo.getTrustStoreName();
        }
        catch (MpJwtProcessingException mpJwtProcessingException) {
            return null;
        }
    }

    public String getTrustedAlias() {
        return this.trustAliasName;
    }

    public boolean getJwkEnabled() {
        return this.jwksUri != null;
    }

    public String getJwkEndpointUrl() {
        return this.jwksUri;
    }

    public ConsumerUtils getConsumerUtils() {
        if (this.consumerUtils == null) {
            MicroProfileJwtService service = (MicroProfileJwtService)this.mpJwtServiceRef.getService();
            if (service != null) {
                this.consumerUtils = new ConsumerUtils(service.getKeyStoreServiceRef());
            } else {
                Tr.warning((TraceComponent)tc, (String)"SERVICE_NOT_FOUND_JWT_CONSUMER_NOT_AVAILABLE", (Object[])new Object[]{this.uniqueId});
            }
        }
        return this.consumerUtils;
    }

    public JWKSet getJwkSet() {
        if (this.jwkSet == null) {
            this.jwkSet = new JWKSet();
        }
        return this.jwkSet;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getSslRef() {
        return this.sslRef;
    }

    @ManualTrace
    public HashMap<String, PublicKey> getPublicKeys() throws MpJwtProcessingException {
        String methodName = "getPublicKeys";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        if (this.sslRefInfo == null) {
            MicroProfileJwtService service = (MicroProfileJwtService)this.mpJwtServiceRef.getService();
            if (service == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"MP JWT service is not available", (Object[])new Object[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)methodName, null);
                }
                return null;
            }
            this.sslRefInfo = new SslRefInfoImpl(service.getSslSupport(), service.getKeyStoreServiceRef(), this.sslRef, this.trustAliasName);
        }
        HashMap<String, PublicKey> keys = this.sslRefInfo.getPublicKeys();
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, keys);
        }
        return keys;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public SSLContext getSSLContext() throws MpJwtProcessingException {
        String methodName = "getSSLContext";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        if (this.sslContext == null) {
            MicroProfileJwtService service = (MicroProfileJwtService)this.mpJwtServiceRef.getService();
            if (service == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"MP JWT service is not available", (Object[])new Object[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)methodName, null);
                }
                return null;
            }
            SSLSupport sslSupport = service.getSslSupport();
            if (sslSupport == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SSL support could not be found for microprofile jwt service", (Object[])new Object[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)methodName, null);
                }
                return null;
            }
            try {
                JSSEHelper jsseHelper = sslSupport.getJSSEHelper();
                if (jsseHelper != null) {
                    this.sslContext = jsseHelper.getSSLContext(this.sslRef, null, null, true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("sslContext (" + this.sslRef + ") get: " + this.sslContext), (Object[])new Object[0]);
                    }
                }
            }
            catch (Exception jsseHelper) {
                void e;
                FFDCFilter.processException((Throwable)jsseHelper, (String)"com.ibm.ws.security.mp.jwt.impl.MicroProfileJwtConfigImpl", (String)"366", (Object)this, (Object[])new Object[0]);
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"FAILED_TO_GET_SSL_CONTEXT", (Object[])new Object[]{this.uniqueId, e.getLocalizedMessage()});
                throw new MpJwtProcessingException(msg, (Throwable)e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.sslContext);
        }
        return this.sslContext;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public SSLSocketFactory getSSLSocketFactory() throws MpJwtProcessingException {
        String methodName = "getSSLSocketFactory";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        if (this.sslContext == null) {
            MicroProfileJwtService service = (MicroProfileJwtService)this.mpJwtServiceRef.getService();
            if (service == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Social login service is not available", (Object[])new Object[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)methodName, null);
                }
                return null;
            }
            SSLSupport sslSupport = service.getSslSupport();
            if (sslSupport == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SSL support could not be found for microprofile jwt service", (Object[])new Object[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)methodName, null);
                }
                return null;
            }
            try {
                this.sslSocketFactory = sslSupport.getSSLSocketFactory(this.sslRef);
                JSSEHelper jsseHelper = sslSupport.getJSSEHelper();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("sslSocketFactory (" + this.sslRef + ") get: " + this.sslSocketFactory), (Object[])new Object[0]);
                }
            }
            catch (Exception jsseHelper) {
                void e;
                FFDCFilter.processException((Throwable)jsseHelper, (String)"com.ibm.ws.security.mp.jwt.impl.MicroProfileJwtConfigImpl", (String)"411", (Object)this, (Object[])new Object[0]);
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"FAILED_TO_GET_SSL_CONTEXT", (Object[])new Object[]{this.uniqueId, e.getLocalizedMessage()});
                throw new MpJwtProcessingException(msg, (Throwable)e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.sslSocketFactory);
        }
        return this.sslSocketFactory;
    }

    @Override
    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    @Override
    public String getGroupNameAttribute() {
        return this.groupNameAttribute;
    }

    public boolean isValidationRequired() {
        return true;
    }

    public long getClockSkew() {
        return this.clockSkewMilliSeconds;
    }

    public boolean getTokenReuse() {
        return this.tokenReuse;
    }
}

