/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.impl.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.mp.jwt.MicroProfileJwtConfig;
import com.ibm.ws.security.mp.jwt.error.MpJwtProcessingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MicroProfileJwtTaiRequest {
    private static TraceComponent tc = Tr.register(MicroProfileJwtTaiRequest.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    protected String providerName;
    protected HttpServletRequest request;
    protected List<MicroProfileJwtConfig> genericConfigs = null;
    MicroProfileJwtConfig microProfileJwtConfig = null;
    MpJwtProcessingException taiException = null;
    static final long serialVersionUID = 3699246724039845785L;

    public MicroProfileJwtTaiRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setSpecifiedConfig(MicroProfileJwtConfig mpJwtConfig) {
        this.microProfileJwtConfig = mpJwtConfig;
    }

    @ManualTrace
    public void addGenericConfig(MicroProfileJwtConfig mpJwtConfig) {
        String methodName = "addGenericConfig";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{mpJwtConfig});
        }
        if (mpJwtConfig != null) {
            if (this.genericConfigs == null) {
                this.genericConfigs = new ArrayList<MicroProfileJwtConfig>();
            }
            if (!this.genericConfigs.contains(mpJwtConfig)) {
                this.genericConfigs.add(mpJwtConfig);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    @ManualTrace
    public String getProviderName() {
        String methodName = "getProviderName";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        if (this.providerName == null && this.microProfileJwtConfig != null) {
            this.providerName = this.microProfileJwtConfig.getUniqueId();
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.providerName);
        }
        return this.providerName;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public List<MicroProfileJwtConfig> getGenericConfigs() {
        return this.genericConfigs;
    }

    @ManualTrace
    public Set<MicroProfileJwtConfig> getAllMatchingConfigs() {
        String methodName = "getAllMatchingConfigs";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        HashSet<MicroProfileJwtConfig> allConfigs = new HashSet<MicroProfileJwtConfig>();
        if (this.microProfileJwtConfig != null) {
            allConfigs.add(this.microProfileJwtConfig);
        }
        if (this.genericConfigs != null) {
            allConfigs.addAll(this.genericConfigs);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, allConfigs);
        }
        return allConfigs;
    }

    @ManualTrace
    public Set<String> getAllMatchingConfigIds() {
        String methodName = "getAllMatchingConfigIds";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        HashSet<String> allConfigIds = new HashSet<String>();
        Set<MicroProfileJwtConfig> allConfigs = this.getAllMatchingConfigs();
        for (MicroProfileJwtConfig config : allConfigs) {
            allConfigIds.add(config.getUniqueId());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, allConfigIds);
        }
        return allConfigIds;
    }

    @ManualTrace
    public MicroProfileJwtConfig getOnlyMatchingConfig() throws MpJwtProcessingException {
        String methodName = "getOnlyMatchingConfig";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        this.throwExceptionIfPresent();
        if (this.microProfileJwtConfig == null) {
            this.microProfileJwtConfig = this.findAppropriateGenericConfig();
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.microProfileJwtConfig);
        }
        return this.microProfileJwtConfig;
    }

    void throwExceptionIfPresent() throws MpJwtProcessingException {
        if (this.taiException != null) {
            MpJwtProcessingException exception = this.taiException;
            this.taiException = null;
            throw exception;
        }
    }

    @ManualTrace
    MicroProfileJwtConfig findAppropriateGenericConfig() throws MpJwtProcessingException {
        String methodName = "findAppropriateGenericConfig";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        if (this.genericConfigs != null) {
            if (this.genericConfigs.size() == 1) {
                this.microProfileJwtConfig = this.genericConfigs.get(0);
            } else {
                this.handleTooManyConfigurations();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.microProfileJwtConfig);
        }
        return this.microProfileJwtConfig;
    }

    void handleTooManyConfigurations() throws MpJwtProcessingException {
        String configIds = this.getConfigIds(this.genericConfigs);
        String msg = Tr.formatMessage((TraceComponent)tc, (String)"TOO_MANY_MP_JWT_PROVIDERS", (Object[])new Object[]{configIds});
        Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
        throw new MpJwtProcessingException(msg);
    }

    String getConfigIds(List<MicroProfileJwtConfig> multiConfigs) {
        String result = "";
        if (multiConfigs == null) {
            return result;
        }
        boolean bInit = true;
        for (MicroProfileJwtConfig mpJwtConfig : multiConfigs) {
            if (!bInit) {
                result = result.concat(", ");
            } else {
                bInit = false;
            }
            result = result.concat(mpJwtConfig.getUniqueId());
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Micro Profile Jwt TaiRequest [provider:").append(this.getProviderName()).append(" request:").append(this.request).append("]");
        return sb.toString();
    }

    @ManualTrace
    public boolean hasServices() {
        boolean hasServices;
        String methodName = "hasServices";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        boolean bl = hasServices = this.genericConfigs != null || this.microProfileJwtConfig != null;
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)hasServices);
        }
        return hasServices;
    }

    public void setTaiException(MpJwtProcessingException taiException) {
        this.taiException = taiException;
    }
}

