/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.mp.jwt.MicroProfileJwtConfig;
import com.ibm.ws.security.mp.jwt.error.MpJwtProcessingException;
import com.ibm.ws.security.mp.jwt.impl.utils.JwtPrincipalMapping;
import com.ibm.ws.security.mp.jwt.tai.TAIJwtUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.security.auth.Subject;
import org.eclipse.microprofile.jwt.JsonWebToken;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TAIMappingHelper {
    private static TraceComponent tc = Tr.register(TAIMappingHelper.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    @Sensitive
    String decodedTokenPayload = null;
    String username = null;
    JwtPrincipalMapping claimToPrincipalMapping = null;
    MicroProfileJwtConfig config = null;
    JsonWebToken jwtPrincipal = null;
    Hashtable<String, Object> customProperties = new Hashtable();
    TAIJwtUtils taiJwtUtils = new TAIJwtUtils();
    static final long serialVersionUID = -8520824914355983422L;

    @ManualTrace
    public TAIMappingHelper(@Sensitive String decodedPayload, MicroProfileJwtConfig clientConfig) throws MpJwtProcessingException {
        String methodName = "<init>";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{decodedPayload, clientConfig});
        }
        this.decodedTokenPayload = decodedPayload;
        this.config = clientConfig;
        if (this.decodedTokenPayload != null) {
            this.claimToPrincipalMapping = new JwtPrincipalMapping(this.decodedTokenPayload, this.config.getUserNameAttribute(), this.config.getGroupNameAttribute(), false);
            this.setUsername();
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    @ManualTrace
    public void createJwtPrincipalAndPopulateCustomProperties(@Sensitive JwtToken jwtToken) throws MpJwtProcessingException {
        String methodName = "createJwtPrincipalAndPopulateCustomProperties";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwtToken});
        }
        this.jwtPrincipal = this.createJwtPrincipal(jwtToken);
        String issuer = this.getIssuer(this.jwtPrincipal);
        if (issuer != null) {
            this.customProperties = this.populateCustomProperties(issuer);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    @ManualTrace
    public Subject createSubjectFromCustomProperties(@Sensitive JwtToken jwt) {
        String methodName = "createSubjectFromCustomProperties";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwt});
        }
        Subject subject = new Subject();
        this.customProperties.put("com.ibm.wsspi.security.cred.securityName", this.username);
        this.customProperties.put("com.ibm.ws.authentication.internal.json.web.token", this.jwtPrincipal);
        subject.getPrivateCredentials().add(this.jwtPrincipal);
        subject.getPrivateCredentials().add(this.customProperties);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)subject);
        }
        return subject;
    }

    public String getUsername() {
        return this.username;
    }

    public Hashtable<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public JsonWebToken getJwtPrincipal() {
        return this.jwtPrincipal;
    }

    void setUsername() throws MpJwtProcessingException {
        if (this.claimToPrincipalMapping != null) {
            this.username = this.claimToPrincipalMapping.getMappedUser();
        }
        if (this.username == null) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"USERNAME_NOT_FOUND", (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            throw new MpJwtProcessingException(msg);
        }
    }

    @ManualTrace
    JsonWebToken createJwtPrincipal(@Sensitive JwtToken jwtToken) {
        String methodName = "createJwtPrincipal";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwtToken});
        }
        if (this.claimToPrincipalMapping == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Claim to principal mapping object not initialized", (Object[])new Object[0]);
            }
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, null);
            }
            return null;
        }
        JsonWebToken token = this.taiJwtUtils.createJwtPrincipal(this.username, this.claimToPrincipalMapping.getMappedGroups(), jwtToken);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)token);
        }
        return token;
    }

    @ManualTrace
    String getIssuer(@Sensitive JsonWebToken jwtPrincipal) throws MpJwtProcessingException {
        String methodName = "getIssuer";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwtPrincipal});
        }
        if (jwtPrincipal == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"jwtPrincipal is null", (Object[])new Object[0]);
            }
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, null);
            }
            return null;
        }
        return jwtPrincipal.getIssuer();
    }

    @ManualTrace
    Hashtable<String, Object> populateCustomProperties(String issuer) {
        String methodName = "populateCustomProperties";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{issuer});
        }
        Hashtable<String, Object> customProperties = new Hashtable<String, Object>();
        String realm = this.getRealm(issuer);
        String uniqueID = this.getUniqueId(realm);
        List<String> groupswithrealm = this.getGroupsWithRealm(realm);
        customProperties.put("com.ibm.wsspi.security.cred.uniqueId", uniqueID);
        if (realm != null && !realm.isEmpty()) {
            customProperties.put("com.ibm.wsspi.security.cred.realm", realm);
        }
        if (!groupswithrealm.isEmpty()) {
            customProperties.put("com.ibm.wsspi.security.cred.groups", groupswithrealm);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, customProperties);
        }
        return customProperties;
    }

    @ManualTrace
    String getRealm(String issuer) {
        String methodName = "getRealm";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{issuer});
        }
        String realm = issuer;
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)realm);
        }
        return realm;
    }

    @ManualTrace
    String getUniqueId(String realm) {
        String methodName = "getUniqueId";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{realm});
        }
        String uniqueUser = null;
        if (this.claimToPrincipalMapping != null) {
            uniqueUser = this.claimToPrincipalMapping.getMappedUser();
        }
        String uniqueId = new StringBuffer("user:").append(realm).append("/").append(uniqueUser).toString();
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)uniqueId);
        }
        return uniqueId;
    }

    @ManualTrace
    List<String> getGroupsWithRealm(String realm) {
        String methodName = "getGroupsWithRealm";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{realm});
        }
        ArrayList<String> groups = null;
        if (this.claimToPrincipalMapping != null) {
            groups = this.claimToPrincipalMapping.getMappedGroups();
        }
        ArrayList<String> groupsWithRealm = new ArrayList<String>();
        if (groups != null) {
            for (String groupEntry : groups) {
                String group = new StringBuffer("group:").append(realm).append("/").append(groupEntry).toString();
                groupsWithRealm.add(group);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, groupsWithRealm);
        }
        return groupsWithRealm;
    }
}

