/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.cdi.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.faulttolerance.cdi.FTUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AbstractAnnotationConfig<T extends Annotation> {
    private static final TraceComponent tc = Tr.register(AbstractAnnotationConfig.class);
    private final Class<T> annotationType;
    private final String keyPrefix;
    private final T annotation;
    private final Class<?> annotatedClass;
    private final String targetName;
    private final Method annotatedMethod;
    static final long serialVersionUID = 4413574078049831094L;

    public AbstractAnnotationConfig(Class<?> annotatedClass, T annotation, Class<T> annotationType) {
        this(null, annotatedClass, annotation, annotationType);
    }

    public AbstractAnnotationConfig(Method annotatedMethod, Class<?> annotatedClass, T annotation, Class<T> annotationType) {
        this.annotationType = annotationType;
        if (annotatedMethod == null) {
            this.keyPrefix = AbstractAnnotationConfig.getPropertyKeyPrefix(annotatedClass);
            this.targetName = annotatedClass.getName();
        } else {
            this.keyPrefix = AbstractAnnotationConfig.getPropertyKeyPrefix(annotatedMethod);
            this.targetName = annotatedClass.getName() + "." + annotatedMethod.getName();
        }
        this.annotation = annotation;
        this.annotatedClass = annotatedClass;
        this.annotatedMethod = annotatedMethod;
    }

    protected <S> AnnotationParameterConfig<S> getParameterConfig(String name, Class<S> type) {
        AnnotationParameterConfig parameterConfig = new AnnotationParameterConfig(name, type);
        parameterConfig.init(this.annotation);
        return parameterConfig;
    }

    protected <S> AnnotationParameterConfig<Class<? extends S>> getParameterConfigClass(String name, Class<S> type) {
        AnnotationParameterConfigClass parameterConfig = new AnnotationParameterConfigClass(name, type);
        ((AnnotationParameterConfig)parameterConfig).init(this.annotation);
        return parameterConfig;
    }

    protected <S> AnnotationParameterConfig<Class<? extends S>[]> getParameterConfigClassArray(String name, Class<S> type) {
        AnnotationParameterConfigClassArray parameterConfig = new AnnotationParameterConfigClassArray(name, type);
        ((AnnotationParameterConfig)parameterConfig).init(this.annotation);
        return parameterConfig;
    }

    public Class<T> annotationType() {
        return this.annotationType;
    }

    public String getTargetName() {
        return this.targetName;
    }

    private String getPropertyKey(String prefix, String parameter) {
        String key = prefix + this.annotationType.getSimpleName() + "/" + parameter;
        return key;
    }

    private static String getPropertyKeyPrefix(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        clazz = FTUtils.getRealClass(clazz);
        String key = clazz.getName() + "/" + method.getName() + "/";
        return key;
    }

    private static String getPropertyKeyPrefix(Class<?> clazz) {
        clazz = FTUtils.getRealClass(clazz);
        String key = clazz.getName() + "/";
        return key;
    }

    public Class<?> getAnnotatedClass() {
        return this.annotatedClass;
    }

    public Method getAnnotatedMethod() {
        return this.annotatedMethod;
    }

    public void validate() {
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class AnnotationParameterConfigClassArray<S>
    extends AnnotationParameterConfig<Class<? extends S>[]> {
        private final Class<S> parameterClass;
        static final long serialVersionUID = -3811419862849266678L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AnnotationParameterConfigClassArray(String parameterName, Class<S> parameterClass) {
            super(parameterName, Class[].class);
            this.parameterClass = parameterClass;
        }

        @Override
        protected Class<? extends S>[] getConfigValue() {
            String[] configValue = this.readConfigValue(String[].class);
            Class[] result = null;
            if (configValue != null) {
                result = new Class[configValue.length];
                for (int i = 0; i < configValue.length; ++i) {
                    try {
                        result[i] = AbstractAnnotationConfig.this.annotatedClass.getClassLoader().loadClass(configValue[i]);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.microprofile.faulttolerance.cdi.config.AbstractAnnotationConfig$AnnotationParameterConfigClassArray", (String)"179", (Object)this, (Object[])new Object[0]);
                        throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"Cannot load class {0} specified in config for {1}", (Object[])new Object[]{configValue[i], AbstractAnnotationConfig.this.getPropertyKey(AbstractAnnotationConfig.this.keyPrefix, this.parameterName)}));
                    }
                    if (this.parameterClass.isAssignableFrom(result[i])) continue;
                    throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"Class {0} cannot be assigned to type {1}, as specified in config for {2}", (Object[])new Object[]{configValue[i], this.parameterClass.getName(), AbstractAnnotationConfig.this.getPropertyKey(AbstractAnnotationConfig.this.keyPrefix, this.parameterName)}));
                }
            }
            return result;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AnnotationParameterConfigClassArray.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class AnnotationParameterConfigClass<S>
    extends AnnotationParameterConfig<Class<? extends S>> {
        private final Class<S> parameterClass;
        static final long serialVersionUID = 5983708566855719431L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AnnotationParameterConfigClass(String parameterName, Class<S> parameterClass) {
            super(parameterName, Class.class);
            this.parameterClass = parameterClass;
        }

        @Override
        protected Class<? extends S> getConfigValue() {
            String configValue = this.readConfigValue(String.class);
            Class<?> result = null;
            if (configValue != null) {
                try {
                    result = AbstractAnnotationConfig.this.annotatedClass.getClassLoader().loadClass(configValue);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.microprofile.faulttolerance.cdi.config.AbstractAnnotationConfig$AnnotationParameterConfigClass", (String)"136", (Object)this, (Object[])new Object[0]);
                    throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"Cannot load class {0} specified in config for {1}", (Object[])new Object[]{configValue, AbstractAnnotationConfig.this.getPropertyKey(AbstractAnnotationConfig.this.keyPrefix, this.parameterName)}));
                }
                if (!this.parameterClass.isAssignableFrom(result)) {
                    throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"Class {0} cannot be assigned to type {1}, as specified in config for {2}", (Object[])new Object[]{configValue, this.parameterClass.getName(), AbstractAnnotationConfig.this.getPropertyKey(AbstractAnnotationConfig.this.keyPrefix, this.parameterName)}));
                }
            }
            return result;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AnnotationParameterConfigClass.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class AnnotationParameterConfig<S> {
        protected S parameterValue = null;
        protected final String parameterName;
        protected final Class<S> parameterType;
        static final long serialVersionUID = -6947352646587468292L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AnnotationParameterConfig(String parameterName, Class<S> parameterType) {
            this.parameterType = parameterType;
            this.parameterName = parameterName;
        }

        /*
         * WARNING - void declaration
         */
        private void init(T annotation) {
            try {
                S configValue = this.getConfigValue();
                if (configValue != null) {
                    this.parameterValue = configValue;
                } else {
                    Method m = AbstractAnnotationConfig.this.annotationType.getDeclaredMethod(this.parameterName, new Class[0]);
                    this.parameterValue = this.parameterType.cast(m.invoke(annotation, new Object[0]));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException configValue) {
                void e;
                FFDCFilter.processException((Throwable)configValue, (String)"com.ibm.ws.microprofile.faulttolerance.cdi.config.AbstractAnnotationConfig$AnnotationParameterConfig", (String)"75", (Object)this, (Object[])new Object[]{annotation});
                throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT5997E", (Object[])new Object[]{e}), (Throwable)e);
            }
        }

        protected S getValue() {
            return this.parameterValue;
        }

        protected S getConfigValue() {
            return this.readConfigValue(this.parameterType);
        }

        protected <P> P readConfigValue(Class<P> type) {
            String key;
            Config mpConfig = ConfigProvider.getConfig((ClassLoader)AbstractAnnotationConfig.this.annotatedClass.getClassLoader());
            Object configValue = mpConfig.getOptionalValue(key = AbstractAnnotationConfig.this.getPropertyKey(AbstractAnnotationConfig.this.keyPrefix, this.parameterName), type).orElse(null);
            if (configValue == null) {
                key = AbstractAnnotationConfig.this.getPropertyKey("", this.parameterName);
                configValue = mpConfig.getOptionalValue(key, type).orElse(null);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (configValue != null) {
                    Tr.debug((TraceComponent)tc, (String)("Found config value for " + AbstractAnnotationConfig.this.getPropertyKey(AbstractAnnotationConfig.this.keyPrefix, this.parameterName)), (Object[])new Object[]{configValue});
                } else {
                    Tr.debug((TraceComponent)tc, (String)("No config value found for " + AbstractAnnotationConfig.this.getPropertyKey(AbstractAnnotationConfig.this.keyPrefix, this.parameterName)), (Object[])new Object[0]);
                }
            }
            return configValue;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AnnotationParameterConfig.class);
        }
    }
}

