/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.cdi.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.AbstractAnnotationConfig;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackHandlerFactory;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.FaultToleranceFunction;
import com.ibm.ws.microprofile.faulttolerance.spi.FaultToleranceProvider;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FallbackConfig
extends AbstractAnnotationConfig<Fallback>
implements Fallback {
    private static final TraceComponent tc = Tr.register(FallbackConfig.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<Class<? extends FallbackHandler>> valueConfig = this.getParameterConfigClass("value", FallbackHandler.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<String> fallbackMethodConfig = this.getParameterConfig("fallbackMethod", String.class);
    static final long serialVersionUID = 4479823812278988548L;

    public FallbackConfig(Method annotatedMethod, Class<?> annotatedClass, Fallback annotation) {
        super(annotatedMethod, annotatedClass, annotation, Fallback.class);
    }

    public Class<? extends FallbackHandler<?>> value() {
        return this.valueConfig.getValue();
    }

    public String fallbackMethod() {
        return this.fallbackMethodConfig.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate() {
        block12: {
            Method originalMethod = this.getAnnotatedMethod();
            Class<?> originalMethodReturnType = originalMethod.getReturnType();
            Class<?>[] originalMethodParamTypes = originalMethod.getParameterTypes();
            Class<FallbackHandler<?>> fallbackClass = this.value();
            String fallbackMethodName = this.fallbackMethod();
            if (fallbackClass != null && fallbackClass != Fallback.DEFAULT.class && fallbackMethodName != null && !"".equals(fallbackMethodName)) {
                throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"fallback.policy.conflicts.CWMFT5009E", (Object[])new Object[]{originalMethod, fallbackClass, fallbackMethodName}));
            }
            if (fallbackClass != null && fallbackClass != Fallback.DEFAULT.class) {
                try {
                    Method[] ms = fallbackClass.getMethods();
                    Method handleMethod = FallbackHandler.class.getMethod("handle", ExecutionContext.class);
                    boolean validFallbackHandler = false;
                    for (Method m : ms) {
                        Class<?>[] params;
                        if (!m.getName().equals(handleMethod.getName()) || m.getParameterCount() != 1 || !ExecutionContext.class.isAssignableFrom((params = m.getParameterTypes())[0]) || !originalMethodReturnType.isAssignableFrom(m.getReturnType())) continue;
                        validFallbackHandler = true;
                        break;
                    }
                    if (!validFallbackHandler) {
                        throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"fallback.policy.invalid.CWMFT5008E", (Object[])new Object[]{originalMethod, fallbackClass, originalMethodReturnType, originalMethod}));
                    }
                    break block12;
                }
                catch (NoSuchMethodException ms) {
                    void e;
                    FFDCFilter.processException((Throwable)ms, (String)"com.ibm.ws.microprofile.faulttolerance.cdi.config.FallbackConfig", (String)"97", (Object)this, (Object[])new Object[0]);
                    throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT5998E", (Object[])new Object[0]), (Throwable)e);
                }
                catch (SecurityException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.faulttolerance.cdi.config.FallbackConfig", (String)"100", (Object)this, (Object[])new Object[0]);
                    throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT5998E", (Object[])new Object[0]), (Throwable)e);
                }
            }
            if (fallbackMethodName != null && !"".equals(fallbackMethodName)) {
                try {
                    Method fallbackMethod = originalMethod.getDeclaringClass().getMethod(fallbackMethodName, originalMethodParamTypes);
                    Class<?> fallbackReturn = fallbackMethod.getReturnType();
                    if (!originalMethodReturnType.isAssignableFrom(fallbackReturn)) {
                        throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"fallback.policy.return.type.not.match.CWMFT5002E", (Object[])new Object[]{fallbackMethod, originalMethod}));
                    }
                }
                catch (NoSuchMethodException fallbackMethod) {
                    void e;
                    FFDCFilter.processException((Throwable)fallbackMethod, (String)"com.ibm.ws.microprofile.faulttolerance.cdi.config.FallbackConfig", (String)"116", (Object)this, (Object[])new Object[0]);
                    throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"fallback.method.not.found.CWMFT5003E", (Object[])new Object[]{fallbackMethodName, originalMethod.getName(), originalMethod.getDeclaringClass()}), (Throwable)e);
                }
                catch (SecurityException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.faulttolerance.cdi.config.FallbackConfig", (String)"119", (Object)this, (Object[])new Object[0]);
                    throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"security.exception.acquiring.fallback.method.CWMFT5004E", (Object[])new Object[0]), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FallbackPolicy generatePolicy(InvocationContext context, BeanManager beanManager) {
        FallbackPolicy fallbackPolicy = null;
        Class<? extends FallbackHandler<?>> fallbackClass = this.value();
        String fallbackMethodName = this.fallbackMethod();
        if (fallbackClass != null && fallbackClass != Fallback.DEFAULT.class) {
            FallbackHandlerFactory fallbackHandlerFactory = FallbackConfig.getFallbackHandlerFactory(beanManager);
            return FallbackConfig.newFallbackPolicy(fallbackClass, fallbackHandlerFactory);
        }
        if (fallbackMethodName == null) throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT5998E", (Object[])new Object[0]));
        if ("".equals(fallbackMethodName)) throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT5998E", (Object[])new Object[0]));
        Object beanInstance = context.getTarget();
        Method originalMethod = context.getMethod();
        Class<?>[] paramTypes = originalMethod.getParameterTypes();
        try {
            Method fallbackMethod = beanInstance.getClass().getMethod(fallbackMethodName, paramTypes);
            Class<?> originalReturn = originalMethod.getReturnType();
            Class<?> fallbackReturn = fallbackMethod.getReturnType();
            if (!originalReturn.isAssignableFrom(fallbackReturn)) return fallbackPolicy;
            return FallbackConfig.newFallbackPolicy(beanInstance, fallbackMethod, fallbackReturn);
        }
        catch (NoSuchMethodException fallbackMethod) {
            void e;
            FFDCFilter.processException((Throwable)fallbackMethod, (String)"com.ibm.ws.microprofile.faulttolerance.cdi.config.FallbackConfig", (String)"144", (Object)this, (Object[])new Object[]{context, beanManager});
            throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"fallback.method.not.found.CWMFT5003E", (Object[])new Object[]{fallbackMethodName, originalMethod.getName(), beanInstance.getClass()}), (Throwable)e);
        }
        catch (SecurityException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.faulttolerance.cdi.config.FallbackConfig", (String)"147", (Object)this, (Object[])new Object[]{context, beanManager});
            throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"security.exception.acquiring.fallback.method.CWMFT5004E", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private static FallbackHandlerFactory getFallbackHandlerFactory(final BeanManager beanManager) {
        FallbackHandlerFactory factory = new FallbackHandlerFactory(){
            static final long serialVersionUID = -5922692287711363464L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public <F extends FallbackHandler<?>> F newHandler(Class<F> fallbackClass) {
                AnnotatedType aType = beanManager.createAnnotatedType(fallbackClass);
                CreationalContext cc = beanManager.createCreationalContext(null);
                InjectionTargetFactory factory = beanManager.getInjectionTargetFactory(aType);
                InjectionTarget injectionTarget = factory.createInjectionTarget(null);
                FallbackHandler instance = (FallbackHandler)injectionTarget.produce(cc);
                injectionTarget.inject((Object)instance, cc);
                injectionTarget.postConstruct((Object)instance);
                return (F)instance;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
        return factory;
    }

    private static <R> FallbackPolicy newFallbackPolicy(final Object beanInstance, final Method fallbackMethod, Class<R> fallbackReturn) {
        FaultToleranceFunction fallbackFunction = new FaultToleranceFunction<ExecutionContext, R>(){
            static final long serialVersionUID = 7631662184327667625L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public R execute(ExecutionContext context) throws Exception {
                Object result = fallbackMethod.invoke(beanInstance, context.getParameters());
                return result;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        };
        FallbackPolicy fallbackPolicy = FallbackConfig.newFallbackPolicy(fallbackFunction);
        return fallbackPolicy;
    }

    private static FallbackPolicy newFallbackPolicy(Class<? extends FallbackHandler<?>> fallbackHandlerClass, FallbackHandlerFactory factory) {
        FallbackPolicy fallbackPolicy = FaultToleranceProvider.newFallbackPolicy();
        fallbackPolicy.setFallbackHandler(fallbackHandlerClass, factory);
        return fallbackPolicy;
    }

    private static FallbackPolicy newFallbackPolicy(FaultToleranceFunction<ExecutionContext, ?> fallbackFunction) {
        FallbackPolicy fallbackPolicy = FaultToleranceProvider.newFallbackPolicy();
        fallbackPolicy.setFallbackFunction(fallbackFunction);
        return fallbackPolicy;
    }
}

