/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.DefaultDecoder;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.StrInterpolator;
import com.netflix.archaius.config.PrefixedViewConfig;
import com.netflix.archaius.exceptions.ParseException;
import com.netflix.archaius.interpolate.CommonsStrInterpolator;
import com.netflix.archaius.interpolate.ConfigStrLookup;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractConfig
implements Config {
    private final CopyOnWriteArrayList<ConfigListener> listeners = new CopyOnWriteArrayList();
    private final StrInterpolator.Lookup lookup;
    private Decoder decoder = new DefaultDecoder();
    private StrInterpolator interpolator = CommonsStrInterpolator.INSTANCE;
    private String listDelimiter = ",";

    public AbstractConfig() {
        this.lookup = ConfigStrLookup.from(this);
    }

    protected CopyOnWriteArrayList<ConfigListener> getListeners() {
        return this.listeners;
    }

    protected StrInterpolator.Lookup getLookup() {
        return this.lookup;
    }

    public String getListDelimiter() {
        return this.listDelimiter;
    }

    public void setListDelimiter(String delimiter) {
        this.listDelimiter = delimiter;
    }

    @Override
    public final Decoder getDecoder() {
        return this.decoder;
    }

    @Override
    public void setDecoder(Decoder decoder) {
        this.decoder = decoder;
    }

    @Override
    public final StrInterpolator getStrInterpolator() {
        return this.interpolator;
    }

    @Override
    public void setStrInterpolator(StrInterpolator interpolator) {
        this.interpolator = interpolator;
    }

    @Override
    public void addListener(ConfigListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ConfigListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyConfigUpdated(Config child) {
        for (ConfigListener listener : this.listeners) {
            listener.onConfigUpdated(child);
        }
    }

    protected void notifyError(Throwable t, Config child) {
        for (ConfigListener listener : this.listeners) {
            listener.onError(t, child);
        }
    }

    protected void notifyConfigAdded(Config child) {
        for (ConfigListener listener : this.listeners) {
            listener.onConfigAdded(child);
        }
    }

    protected void notifyConfigRemoved(Config child) {
        for (ConfigListener listener : this.listeners) {
            listener.onConfigRemoved(child);
        }
    }

    @Override
    public String getString(String key, String defaultValue) {
        Object value = this.getRawProperty(key);
        if (value == null) {
            return this.notFound(key, defaultValue != null ? this.interpolator.create(this.getLookup()).resolve(defaultValue) : null);
        }
        if (value instanceof String) {
            return this.interpolator.create(this.getLookup()).resolve(value.toString());
        }
        return value.toString();
    }

    @Override
    public String getString(String key) {
        Object value = this.getRawProperty(key);
        if (value == null) {
            return (String)this.notFound(key);
        }
        if (value instanceof String) {
            return this.interpolator.create(this.getLookup()).resolve(value.toString());
        }
        return value.toString();
    }

    protected <T> T notFound(String key, T defaultValue) {
        return defaultValue;
    }

    protected <T> T notFound(String key) {
        throw new NoSuchElementException("'" + key + "' not found");
    }

    @Override
    public Iterator<String> getKeys(final String prefix) {
        return new Iterator<String>(){
            Iterator<String> iter;
            String next;
            {
                this.iter = AbstractConfig.this.getKeys();
                while (this.iter.hasNext()) {
                    this.next = this.iter.next();
                    if (this.next.startsWith(prefix)) break;
                    this.next = null;
                }
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public String next() {
                if (this.next == null) {
                    throw new IllegalStateException();
                }
                String current = this.next;
                this.next = null;
                while (this.iter.hasNext()) {
                    this.next = this.iter.next();
                    if (this.next.startsWith(prefix)) break;
                    this.next = null;
                }
                return current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Config getPrefixedView(String prefix) {
        if (prefix == null || prefix.isEmpty() || prefix.equals(".")) {
            return this;
        }
        return new PrefixedViewConfig(prefix, this);
    }

    @Override
    public <T> T accept(Config.Visitor<T> visitor) {
        T result = null;
        Iterator<String> iter = this.getKeys();
        while (iter.hasNext()) {
            result = visitor.visitKey(this, iter.next());
        }
        return result;
    }

    protected <T> T getValue(Class<T> type, String key) {
        Object rawProp = this.getRawProperty(key);
        if (rawProp == null) {
            return this.notFound(key);
        }
        if (rawProp instanceof String) {
            try {
                String value = this.interpolator.create(this.getLookup()).resolve(rawProp.toString());
                return this.decoder.decode(type, value);
            }
            catch (NumberFormatException e) {
                return this.parseError(key, rawProp.toString(), e);
            }
        }
        if (type.isInstance(rawProp)) {
            return (T)rawProp;
        }
        return this.parseError(key, rawProp.toString(), new NumberFormatException("Property " + rawProp.toString() + " is of wrong format " + type.getCanonicalName()));
    }

    protected <T> T getValueWithDefault(Class<T> type, String key, T defaultValue) {
        try {
            return this.getValue(type, key);
        }
        catch (NoSuchElementException e) {
            return defaultValue;
        }
    }

    @Override
    public Long getLong(String key) {
        return this.getValue(Long.class, key);
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        return this.getValueWithDefault(Long.class, key, defaultValue);
    }

    @Override
    public Double getDouble(String key) {
        return this.getValue(Double.class, key);
    }

    @Override
    public Double getDouble(String key, Double defaultValue) {
        return this.getValueWithDefault(Double.class, key, defaultValue);
    }

    @Override
    public Integer getInteger(String key) {
        return this.getValue(Integer.class, key);
    }

    @Override
    public Integer getInteger(String key, Integer defaultValue) {
        return this.getValueWithDefault(Integer.class, key, defaultValue);
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.getValue(Boolean.class, key);
    }

    @Override
    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.getValueWithDefault(Boolean.class, key, defaultValue);
    }

    @Override
    public Short getShort(String key) {
        return this.getValue(Short.class, key);
    }

    @Override
    public Short getShort(String key, Short defaultValue) {
        return this.getValueWithDefault(Short.class, key, defaultValue);
    }

    @Override
    public BigInteger getBigInteger(String key) {
        return this.getValue(BigInteger.class, key);
    }

    @Override
    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.getValueWithDefault(BigInteger.class, key, defaultValue);
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        return this.getValue(BigDecimal.class, key);
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.getValueWithDefault(BigDecimal.class, key, defaultValue);
    }

    @Override
    public Float getFloat(String key) {
        return this.getValue(Float.class, key);
    }

    @Override
    public Float getFloat(String key, Float defaultValue) {
        return this.getValueWithDefault(Float.class, key, defaultValue);
    }

    @Override
    public Byte getByte(String key) {
        return this.getValue(Byte.class, key);
    }

    @Override
    public Byte getByte(String key, Byte defaultValue) {
        return this.getValueWithDefault(Byte.class, key, defaultValue);
    }

    @Override
    public <T> List<T> getList(String key, Class<T> type) {
        String value = this.getString(key);
        if (value == null) {
            return (List)this.notFound(key);
        }
        String[] parts = value.split(this.getListDelimiter());
        ArrayList<T> result = new ArrayList<T>();
        for (String part : parts) {
            result.add(this.decoder.decode(type, part));
        }
        return result;
    }

    public List getList(String key) {
        String value = this.getString(key);
        if (value == null) {
            return (List)this.notFound(key);
        }
        String[] parts = value.split(this.getListDelimiter());
        return Arrays.asList(parts);
    }

    public List getList(String key, List defaultValue) {
        String value = this.getString(key, null);
        if (value == null) {
            return this.notFound(key, defaultValue);
        }
        String[] parts = value.split(",");
        return Arrays.asList(parts);
    }

    @Override
    public <T> T get(Class<T> type, String key) {
        return this.getValue(type, key);
    }

    @Override
    public <T> T get(Class<T> type, String key, T defaultValue) {
        return this.getValueWithDefault(type, key, defaultValue);
    }

    private <T> T parseError(String key, String value, Exception e) {
        throw new ParseException("Error parsing value '" + value + "' for property '" + key + "'", e);
    }
}

