/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.clientconfig;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxrs20.clientconfig.JAXRSClientConfig;
import com.ibm.ws.jaxrs20.clientconfig.JAXRSClientConfigHolder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(immediate=true, service={JAXRSClientConfig.class}, configurationPid={"com.ibm.ws.jaxrs20.common.clientConfig"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class JAXRSClientConfigImpl
implements JAXRSClientConfig {
    private static final TraceComponent tc = Tr.register(JAXRSClientConfigImpl.class, (String)"jaxrs", (String)"com.ibm.ws.jaxrs20.internal.resources.JaxRsCommonMessages");
    private static final String URI = "uri";
    private static final HashSet<String> propertiesToRemove = new HashSet();
    private static final HashMap<String, String> propsToTranslate = new HashMap();
    static final long serialVersionUID = 3584328636858839797L;

    private Map<String, String> filterProps(Map<String, Object> props) {
        boolean debug;
        HashMap<String, String> filteredProps = new HashMap<String, String>();
        Iterator<String> it = props.keySet().iterator();
        boolean bl = debug = tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled();
        while (it.hasNext()) {
            Object unprotectedPassword;
            String key = it.next();
            if (("com.ibm.ws.jaxrs.client.proxy.password".equals(key) || "proxypassword".equalsIgnoreCase(key)) && (unprotectedPassword = props.get(key)) != null && !(unprotectedPassword instanceof ProtectedString)) {
                ProtectedString protectedPassword = new ProtectedString(unprotectedPassword.toString().toCharArray());
                props.put(key, protectedPassword);
            }
            String newKey = null;
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)("key: " + key + " value: " + props.get(key)), (Object[])new Object[0]);
            }
            if (propertiesToRemove.contains(key)) continue;
            newKey = key;
            if (propsToTranslate.containsKey(key.toLowerCase())) {
                newKey = propsToTranslate.get(key.toLowerCase());
                if (debug) {
                    Tr.debug((TraceComponent)tc, (String)(" translated " + key + " to " + newKey), (Object[])new Object[0]);
                }
            }
            filteredProps.put(newKey, props.get(key).toString());
            if (newKey.compareTo("authnToken") != 0) continue;
            String replacementKey = this.validateAuthn(props.get(key).toString());
            if (replacementKey != null) {
                filteredProps.remove(newKey);
                filteredProps.put(replacementKey, "true");
                continue;
            }
            filteredProps.remove(newKey);
        }
        return filteredProps;
    }

    private String validateAuthn(String value) {
        String result = null;
        String valueLower = value.toLowerCase();
        if (valueLower.equals("saml")) {
            result = "com.ibm.ws.jaxrs.client.saml.sendToken";
        } else if (valueLower.equals("oauth")) {
            result = "com.ibm.ws.jaxrs.client.oauth.sendToken";
        } else if (valueLower.equals("ltpa")) {
            result = "com.ibm.ws.jaxrs.client.ltpa.handler";
        }
        if (result == null) {
            Tr.warning((TraceComponent)tc, (String)"warn.invalid.authorization.token.type", (Object[])new Object[]{value});
        }
        return result;
    }

    private String getURI(Map<String, Object> props) {
        if (props == null) {
            return null;
        }
        if (props.keySet().contains(URI)) {
            return props.get(URI).toString();
        }
        return null;
    }

    private String normalize(String uri) {
        return uri;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        if (properties == null) {
            return;
        }
        String uri = this.getURI(properties);
        if (uri == null) {
            return;
        }
        uri = this.normalize(uri);
        JAXRSClientConfigHolder.addConfig(this.toString(), uri, this.filterProps(properties));
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        if (properties == null) {
            return;
        }
        JAXRSClientConfigHolder.removeConfig(this.toString());
        String uri = this.getURI(properties);
        if (uri == null) {
            return;
        }
        uri = this.normalize(uri);
        JAXRSClientConfigHolder.addConfig(this.toString(), uri, this.filterProps(properties));
    }

    @Deactivate
    protected void deactivate() {
        JAXRSClientConfigHolder.removeConfig(this.toString());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        propertiesToRemove.add("defaultSSHPublicKeyPath");
        propertiesToRemove.add("defaultSSHPrivateKeyPath");
        propertiesToRemove.add("config.overrides");
        propertiesToRemove.add("config.id");
        propertiesToRemove.add("component.id");
        propertiesToRemove.add("config.displayId");
        propertiesToRemove.add("component.name");
        propertiesToRemove.add("config.source");
        propertiesToRemove.add("service.pid");
        propertiesToRemove.add("service.vendor");
        propertiesToRemove.add("service.factoryPid");
        propertiesToRemove.add(URI);
        propsToTranslate.put("connectiontimeout", "com.ibm.ws.jaxrs.client.connection.timeout");
        propsToTranslate.put("disablecncheck", "com.ibm.ws.jaxrs.client.disableCNCheck");
        propsToTranslate.put("proxyhost", "com.ibm.ws.jaxrs.client.proxy.host");
        propsToTranslate.put("proxyport", "com.ibm.ws.jaxrs.client.proxy.port");
        propsToTranslate.put("proxytype", "com.ibm.ws.jaxrs.client.proxy.type");
        propsToTranslate.put("proxyauthtype", "com.ibm.ws.jaxrs.client.proxy.authType");
        propsToTranslate.put("proxyusername", "com.ibm.ws.jaxrs.client.proxy.username");
        propsToTranslate.put("proxypassword", "com.ibm.ws.jaxrs.client.proxy.password");
        propsToTranslate.put("receivetimeout", "com.ibm.ws.jaxrs.client.receive.timeout");
        propsToTranslate.put("sslconfig", "com.ibm.ws.jaxrs.client.ssl.config");
    }
}

