/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.AbstractAuthorizingInInterceptor;
import org.apache.cxf.interceptor.security.AccessDeniedException;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertySimpleAuthorizingInterceptor
extends AbstractAuthorizingInInterceptor {
    private static final TraceComponent tc = Tr.register(LibertySimpleAuthorizingInterceptor.class);
    static final long serialVersionUID = 3077822115520915884L;

    @Override
    public void handleMessage(Message message) throws Fault {
        Method method;
        SecurityContext sc = message.get(SecurityContext.class);
        if (sc != null && this.parseMethodSecurity(method = this.getTargetMethod(message), sc)) {
            return;
        }
        throw new AccessDeniedException("Unauthorized");
    }

    private boolean parseMethodSecurity(Method method, SecurityContext sc) {
        boolean denyAll = this.getDenyAll(method);
        if (denyAll) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found DenyAll for method: {} " + method.getName() + ", Injection Processing for web service is ignored"), (Object[])new Object[0]);
            }
            return false;
        }
        RolesAllowed rolesAllowed = this.getRolesAllowed(method);
        if (rolesAllowed != null) {
            String[] theseroles;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("found RolesAllowed in method: {} " + method.getName()), (Object[])new Object[0]);
            }
            return this.isUserInRole(sc, Arrays.asList(theseroles = rolesAllowed.value()), false);
        }
        boolean permitAll = this.getPermitAll(method);
        if (permitAll) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found PermitAll for method: {}" + method.getName()), (Object[])new Object[0]);
            }
            return true;
        }
        Class<?> cls = method.getDeclaringClass();
        return this.parseClassSecurity(cls, sc);
    }

    private boolean parseClassSecurity(Class<?> cls, SecurityContext sc) {
        DenyAll denyAll = cls.getAnnotation(DenyAll.class);
        if (denyAll != null) {
            return false;
        }
        RolesAllowed rolesAllowed = cls.getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            String[] theseroles = rolesAllowed.value();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("found RolesAllowed in class level: {} " + cls.getName()), (Object[])new Object[0]);
            }
            return this.isUserInRole(sc, Arrays.asList(theseroles), false);
        }
        return true;
    }

    private RolesAllowed getRolesAllowed(Method method) {
        return method.getAnnotation(RolesAllowed.class);
    }

    private boolean getPermitAll(Method method) {
        return method.isAnnotationPresent(PermitAll.class);
    }

    private boolean getDenyAll(Method method) {
        return method.isAnnotationPresent(DenyAll.class);
    }

    @Override
    protected List<String> getExpectedRoles(Method method) {
        return null;
    }
}

