/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.client.injection;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.ddmodel.wsbnd.Port;
import com.ibm.ws.javaee.ddmodel.wsbnd.ServiceRef;
import com.ibm.ws.javaee.ddmodel.wsbnd.WebservicesBnd;
import com.ibm.ws.jaxws.client.injection.InjectionHelper;
import com.ibm.ws.jaxws.client.injection.ServiceRefObjectFactory;
import com.ibm.ws.jaxws.client.injection.WebServiceRefBinding;
import com.ibm.ws.jaxws.client.injection.WebServiceRefBindingBuilder;
import com.ibm.ws.jaxws.client.injection.WebServiceRefInfoRefAddr;
import com.ibm.ws.jaxws.metadata.AddressingFeatureInfo;
import com.ibm.ws.jaxws.metadata.JaxWsClientMetaData;
import com.ibm.ws.jaxws.metadata.MTOMFeatureInfo;
import com.ibm.ws.jaxws.metadata.PortComponentRefInfo;
import com.ibm.ws.jaxws.metadata.RespectBindingFeatureInfo;
import com.ibm.ws.jaxws.metadata.WebServiceRefInfo;
import com.ibm.ws.jaxws.metadata.builder.WebServiceRefInfoBuilder;
import com.ibm.ws.jaxws.support.JaxWsMetaDataManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionProcessor;
import com.ibm.wsspi.injectionengine.OverrideInjectionProcessor;
import com.ibm.wsspi.injectionengine.factory.IndirectJndiLookupReferenceFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.HandlerChain;
import javax.naming.Reference;
import javax.xml.namespace.QName;
import javax.xml.ws.RespectBinding;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.MTOM;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebServiceRefProcessor
extends InjectionProcessor<WebServiceRef, WebServiceRefs>
implements OverrideInjectionProcessor<WebServiceRef, Resource> {
    private static final TraceComponent tc = Tr.register(WebServiceRefProcessor.class);
    static final long serialVersionUID = 3735213737205018009L;

    public WebServiceRefProcessor() {
        super(WebServiceRef.class, WebServiceRefs.class);
    }

    public String getJndiName(WebServiceRef webServiceRef) {
        return webServiceRef.name();
    }

    public WebServiceRef[] getAnnotations(WebServiceRefs webServiceRefs) {
        return webServiceRefs.value();
    }

    public void processXML() throws InjectionException {
        List<InjectionBinding<WebServiceRef>> bindingList;
        List serviceRefs = this.ivNameSpaceConfig.getWebServiceRefs();
        if (serviceRefs == null || serviceRefs.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No service-refs in XML for module: " + this.ivNameSpaceConfig.getModuleName()), (Object[])new Object[0]);
            }
            return;
        }
        ClassLoader moduleClassLoader = this.ivNameSpaceConfig.getClassLoader();
        if (moduleClassLoader == null) {
            throw new InjectionException("Internal Error: The classloader of module " + this.ivNameSpaceConfig.getModuleName() + " is null.");
        }
        List<com.ibm.ws.javaee.dd.common.wsclient.ServiceRef> jaxwsServiceRefs = InjectionHelper.normalizeJaxWsServiceRefs(serviceRefs, moduleClassLoader);
        if (jaxwsServiceRefs.isEmpty()) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Found JAX-WS service refs in XML for module: " + this.ivNameSpaceConfig.getModuleName()), (Object[])new Object[0]);
        }
        if ((bindingList = WebServiceRefBindingBuilder.buildJaxWsWebServiceRefBindings(jaxwsServiceRefs, this.ivNameSpaceConfig)) != null && !bindingList.isEmpty()) {
            for (InjectionBinding<WebServiceRef> binding : bindingList) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Adding binding for JAX-WS service-ref: " + binding.getJndiName()), (Object[])new Object[0]);
                }
                this.addInjectionBinding(binding);
            }
        }
    }

    public InjectionBinding<WebServiceRef> createInjectionBinding(WebServiceRef webServiceRef, Class<?> instanceClass, Member member, String jndiName) throws InjectionException {
        WebServiceRefBinding binding;
        WebServiceRefInfo wsrInfo = WebServiceRefInfoBuilder.buildWebServiceRefInfo(webServiceRef, instanceClass.getClassLoader());
        wsrInfo.setClientMetaData(JaxWsMetaDataManager.getJaxWsClientMetaData(this.ivNameSpaceConfig.getModuleMetaData()));
        if (member == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Creating new injection binding for @WebServiceRef annotation found on the " + instanceClass.getName() + " class."), (Object[])new Object[0]);
            }
            this.validateAndSetClassLevelWebServiceRef(webServiceRef, instanceClass, wsrInfo);
            HandlerChain hcAnnot = instanceClass.getAnnotation(HandlerChain.class);
            if (hcAnnot != null) {
                wsrInfo.setHandlerChainAnnotation(hcAnnot);
                wsrInfo.setHandlerChainDeclaringClassName(instanceClass.getName());
            }
            binding = new WebServiceRefBinding(wsrInfo, this.ivNameSpaceConfig);
        } else if (member instanceof Method) {
            Method method = (Method)member;
            wsrInfo.setJndiName(jndiName);
            this.validateAndSetMemberLevelWebServiceRef(webServiceRef, method, wsrInfo);
            HandlerChain hcAnnot = method.getAnnotation(HandlerChain.class);
            if (hcAnnot != null) {
                wsrInfo.setHandlerChainAnnotation(hcAnnot);
                wsrInfo.setHandlerChainDeclaringClassName(instanceClass.getName());
            }
            if (wsrInfo.getServiceRefTypeClassName() != null) {
                WebServiceRefProcessor.handleMTOM(webServiceRef, wsrInfo, method.getAnnotation(MTOM.class));
                WebServiceRefProcessor.handleRespectBinding(webServiceRef, wsrInfo, method.getAnnotation(RespectBinding.class));
                WebServiceRefProcessor.handleAddressing(webServiceRef, wsrInfo, method.getAnnotation(Addressing.class));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Creating new injection binding for the @WebServiceRef annotation on the " + method.getName() + " method in the " + method.getDeclaringClass().getName() + " class."), (Object[])new Object[0]);
            }
            binding = new WebServiceRefBinding(wsrInfo, this.ivNameSpaceConfig);
            this.addInjectionBinding(binding);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Successfully created an injection binding for the @WebServiceRef annotation on the " + method.getName() + " method in the " + method.getDeclaringClass().getName() + " class."), (Object[])new Object[0]);
            }
        } else {
            Field field = (Field)member;
            wsrInfo.setJndiName(jndiName);
            this.validateAndSetMemberLevelWebServiceRef(webServiceRef, field, wsrInfo);
            HandlerChain hcAnnot = field.getAnnotation(HandlerChain.class);
            if (hcAnnot != null) {
                wsrInfo.setHandlerChainAnnotation(hcAnnot);
                wsrInfo.setHandlerChainDeclaringClassName(instanceClass.getName());
            }
            if (wsrInfo.getServiceRefTypeClassName() != null) {
                WebServiceRefProcessor.handleMTOM(webServiceRef, wsrInfo, field.getAnnotation(MTOM.class));
                WebServiceRefProcessor.handleRespectBinding(webServiceRef, wsrInfo, field.getAnnotation(RespectBinding.class));
                WebServiceRefProcessor.handleAddressing(webServiceRef, wsrInfo, field.getAnnotation(Addressing.class));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Creating new injection binding for the @WebServiceRef annotation on the " + field.getName() + " field in the " + field.getDeclaringClass().getName() + " class."), (Object[])new Object[0]);
            }
            binding = new WebServiceRefBinding(wsrInfo, this.ivNameSpaceConfig);
            this.addInjectionBinding(binding);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Successfully created an injection binding for the @WebServiceRef annotation on the " + field.getName() + " field in the " + field.getDeclaringClass().getName() + " class. HashCode=" + Integer.toHexString(System.identityHashCode((Object)this))), (Object[])new Object[0]);
            }
        }
        return binding;
    }

    public void resolve(InjectionBinding<WebServiceRef> binding) throws InjectionException {
        WebServiceRefInfo wsrInfo = ((WebServiceRefBinding)binding).getWebServiceRefInfo();
        Reference ref = null;
        if (wsrInfo.getLookupName() != null && !wsrInfo.getLookupName().isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Build IndirectJndiLookup(" + wsrInfo.getLookupName() + ") for service-ref '" + wsrInfo.getJndiName()), (Object[])new Object[0]);
            }
            IndirectJndiLookupReferenceFactory factory = this.ivNameSpaceConfig.getIndirectJndiLookupReferenceFactory();
            ref = factory.createIndirectJndiLookup(binding.getJndiName(), wsrInfo.getLookupName(), Object.class.getName());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Obtained Reference from IndirectJndiLookup object: " + ref.toString()), (Object[])new Object[0]);
            }
        } else {
            ref = new Reference(WebServiceRefProcessor.class.getName(), ServiceRefObjectFactory.class.getName(), null);
            WebServiceRefInfoRefAddr wsrInfoRefAddr = new WebServiceRefInfoRefAddr(wsrInfo);
            ref.add(wsrInfoRefAddr);
            J2EEName j2eeName = this.ivNameSpaceConfig.getJ2EEName();
            String componenetName = null != j2eeName ? j2eeName.getComponent() : null;
            wsrInfo.setComponenetName(componenetName);
        }
        WebServiceRefInfoBuilder.configureWebServiceRefPartialInfo(wsrInfo, this.ivNameSpaceConfig.getClassLoader());
        binding.setObjects(null, ref);
    }

    /*
     * WARNING - void declaration
     */
    private void mergeWebServicesBndInfo(WebServiceRefInfo wsrInfo, JaxWsClientMetaData jaxwsClientMetaData) {
        if (jaxwsClientMetaData == null) {
            jaxwsClientMetaData = wsrInfo.getClientMetaData();
        }
        WebservicesBnd webServicesBnd = null;
        try {
            webServicesBnd = (WebservicesBnd)jaxwsClientMetaData.getModuleMetaData().getModuleContainer().adapt(WebservicesBnd.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.jaxws.client.injection.WebServiceRefProcessor", (String)"320", (Object)((Object)this), (Object[])new Object[]{wsrInfo, jaxwsClientMetaData});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Can not get the custom binding file due to {0}", (Object[])new Object[]{e});
            }
            return;
        }
        if (webServicesBnd != null) {
            J2EEName j2eeName = this.ivNameSpaceConfig.getJ2EEName();
            String componenetName = null != j2eeName ? j2eeName.getComponent() : null;
            ServiceRef serviceRef = webServicesBnd.getServiceRef(wsrInfo.getJndiName(), componenetName);
            if (serviceRef != null) {
                List portList = serviceRef.getPorts();
                if (portList != null && portList.size() > 0) {
                    for (Port port : portList) {
                        QName portQName = port.getPortQName();
                        PortComponentRefInfo portInfo = new PortComponentRefInfo(portQName);
                        portInfo.setAddress(port.getAddress());
                        portInfo.setUserName(port.getUserName());
                        portInfo.setPassword(port.getPassword());
                        portInfo.setSSLRef(port.getSSLRef());
                        portInfo.setKeyAlias(port.getKeyAlias());
                        portInfo.setProperties(port.getProperties());
                        wsrInfo.addPortComponentRefInfo(portInfo);
                    }
                }
                wsrInfo.setDefaultPortAddress(serviceRef.getPortAddress());
                wsrInfo.setProperties(serviceRef.getProperties());
                String wsdlOverride = serviceRef.getWsdlLocation();
                if (wsdlOverride != null && !wsdlOverride.isEmpty()) {
                    wsrInfo.setWsdlLocation(wsdlOverride);
                }
            }
        }
    }

    protected void validateMissingJndiName(Class<?> instanceClass, WebServiceRef webServiceRef) throws InjectionException {
        Tr.error((TraceComponent)tc, (String)"error.service.ref.class.level.annotation.name.or.type.absent", (Object[])new Object[]{instanceClass.getName()});
        throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.class.level.annotation.name.or.type.absent", (Object[])new Object[]{instanceClass.getName()}));
    }

    static void handleMTOM(WebServiceRef webServiceRef, WebServiceRefInfo wsrInfo, MTOM mtomAnnotation) {
        if (mtomAnnotation == null) {
            return;
        }
        if (wsrInfo.isWebServiceFeaturePresent(wsrInfo.getServiceRefTypeClassName(), MTOMFeatureInfo.class)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MTOM feature already present on WSR metadata, ignoring @MTOM annotation", (Object[])new Object[0]);
            }
        } else {
            MTOMFeatureInfo feature = new MTOMFeatureInfo(mtomAnnotation);
            wsrInfo.addWebServiceFeatureInfo(wsrInfo.getServiceRefTypeClassName(), feature);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Recording MTOMFeatureInfo for SEI " + wsrInfo.getServiceRefTypeClassName() + ": " + feature.toString()), (Object[])new Object[0]);
            }
        }
    }

    static void handleRespectBinding(WebServiceRef webServiceRef, WebServiceRefInfo wsrInfo, RespectBinding rbAnnotation) {
        if (rbAnnotation == null) {
            return;
        }
        if (wsrInfo.isWebServiceFeaturePresent(wsrInfo.getServiceRefTypeClassName(), RespectBindingFeatureInfo.class)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"RespectBinding feature already present on WSR metadata, ignoring @RespectBinding annotation", (Object[])new Object[0]);
            }
        } else {
            RespectBindingFeatureInfo feature = new RespectBindingFeatureInfo(rbAnnotation);
            wsrInfo.addWebServiceFeatureInfo(wsrInfo.getServiceRefTypeClassName(), feature);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Recording RespectBindingFeatureInfo for SEI " + wsrInfo.getServiceRefTypeClassName() + ": " + feature.toString()), (Object[])new Object[0]);
            }
        }
    }

    static void handleAddressing(WebServiceRef webServiceRef, WebServiceRefInfo wsrInfo, Addressing addrAnnotation) {
        if (addrAnnotation == null) {
            return;
        }
        if (wsrInfo.isWebServiceFeaturePresent(wsrInfo.getServiceRefTypeClassName(), AddressingFeatureInfo.class)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Addressing feature already present on WSR metadata, ignoring @Addressing annotation", (Object[])new Object[0]);
            }
        } else {
            AddressingFeatureInfo feature = new AddressingFeatureInfo(addrAnnotation);
            wsrInfo.addWebServiceFeatureInfo(wsrInfo.getServiceRefTypeClassName(), feature);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Recording AddressingFeatureInfo for SEI " + wsrInfo.getServiceRefTypeClassName() + ": " + feature.toString()), (Object[])new Object[0]);
            }
        }
    }

    private void validateAndSetClassLevelWebServiceRef(WebServiceRef webServiceRef, Class<?> instanceClass, WebServiceRefInfo wsrInfo) throws InjectionException {
        Class typeClass = webServiceRef.type();
        Class valueClass = webServiceRef.value();
        if (webServiceRef.lookup() != null && !webServiceRef.lookup().isEmpty()) {
            if (!(typeClass.getName().equals(Object.class.getName()) && valueClass.getName().equals(Service.class.getName()) && webServiceRef.wsdlLocation().isEmpty() && webServiceRef.mappedName().isEmpty())) {
                Tr.error((TraceComponent)tc, (String)"error.service.ref.annotation.lookup.redundant.attributes", (Object[])new Object[0]);
                throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.annotation.lookup.redundant.attributes", (Object[])new Object[0]));
            }
        } else {
            if (webServiceRef.name().isEmpty()) {
                Tr.error((TraceComponent)tc, (String)"error.service.ref.class.level.annotation.name.or.type.absent", (Object[])new Object[]{instanceClass.getName()});
                throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.class.level.annotation.name.or.type.absent", (Object[])new Object[]{instanceClass.getName()}));
            }
            if (typeClass.getName().equals(Object.class.getName())) {
                if (!Service.class.isAssignableFrom(valueClass) || valueClass.getName().equals(Service.class.getName())) {
                    Tr.error((TraceComponent)tc, (String)"error.service.ref.class.level.annotation.name.or.type.absent", (Object[])new Object[]{instanceClass.getName()});
                    throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.class.level.annotation.name.or.type.absent", (Object[])new Object[]{instanceClass.getName()}));
                }
                wsrInfo.setServiceInterfaceClassName(valueClass.getName());
                wsrInfo.setServiceRefTypeClassName(valueClass.getName());
            } else if (Service.class.isAssignableFrom(typeClass)) {
                if (typeClass.getName().equals(Service.class.getName())) {
                    if (!Service.class.isAssignableFrom(valueClass) || valueClass.getName().equals(Service.class.getName())) {
                        Tr.error((TraceComponent)tc, (String)"error.service.ref.class.level.annotation.wrong.value", (Object[])new Object[]{instanceClass.getName(), valueClass.getName()});
                        throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.class.level.annotation.wrong.value", (Object[])new Object[]{instanceClass.getName(), valueClass.getName()}));
                    }
                    wsrInfo.setServiceInterfaceClassName(valueClass.getName());
                    wsrInfo.setServiceRefTypeClassName(valueClass.getName());
                } else {
                    if (!valueClass.getName().equals(typeClass.getName()) && !valueClass.getName().equals(Service.class.getName())) {
                        Tr.error((TraceComponent)tc, (String)"error.service.ref.class.level.annotation.value.and.type.not.same", (Object[])new Object[]{instanceClass.getName()});
                        throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.class.level.annotation.value.and.type.not.same", (Object[])new Object[]{instanceClass.getName()}));
                    }
                    wsrInfo.setServiceInterfaceClassName(typeClass.getName());
                    wsrInfo.setServiceRefTypeClassName(typeClass.getName());
                }
            } else {
                if (!Service.class.isAssignableFrom(valueClass) || valueClass.getName().equals(Service.class.getName())) {
                    Tr.error((TraceComponent)tc, (String)"error.service.ref.class.level.annotation.wrong.value", (Object[])new Object[]{instanceClass.getName(), valueClass.getName()});
                    throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.class.level.annotation.wrong.value", (Object[])new Object[]{instanceClass.getName(), valueClass.getName()}));
                }
                wsrInfo.setServiceInterfaceClassName(valueClass.getName());
                wsrInfo.setServiceRefTypeClassName(typeClass.getName());
            }
        }
    }

    private void validateAndSetMemberLevelWebServiceRef(WebServiceRef webServiceRef, Member member, WebServiceRefInfo wsrInfo) throws InjectionException {
        Class<?> typeClass = webServiceRef.type();
        Class valueClass = webServiceRef.value();
        if (webServiceRef.lookup() != null && !webServiceRef.lookup().isEmpty()) {
            if (!(typeClass.getName().equals(Object.class.getName()) && valueClass.getName().equals(Service.class.getName()) && webServiceRef.wsdlLocation().isEmpty() && webServiceRef.mappedName().isEmpty())) {
                Tr.error((TraceComponent)tc, (String)"error.service.ref.annotation.lookup.redundant.attributes", (Object[])new Object[0]);
                throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.annotation.lookup.redundant.attributes", (Object[])new Object[0]));
            }
        } else {
            Class<?> effectiveType;
            Class<?> memberType = InjectionHelper.getTypeFromMember(member);
            if (memberType.getName().equals(Object.class.getName())) {
                effectiveType = typeClass;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && typeClass.getName().equals(Object.class.getName())) {
                    Tr.debug((TraceComponent)tc, (String)("The member type and the @WebServiceRef.type on the " + member.getName() + " in " + member.getDeclaringClass().getName() + "are all Object.class, so can not infer one. Will try service type injection if the @WebServiceRef.value is a subclass of Service.class."), (Object[])new Object[0]);
                }
            } else if (memberType.isAssignableFrom(typeClass)) {
                effectiveType = typeClass;
            } else if (typeClass.isAssignableFrom(memberType)) {
                effectiveType = memberType;
            } else {
                Tr.error((TraceComponent)tc, (String)"error.service.ref.member.level.annotation.type.not.compatible", (Object[])new Object[]{member.getName(), member.getDeclaringClass().getName(), typeClass.getName(), memberType.getName()});
                throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.member.level.annotation.type.not.compatible", (Object[])new Object[]{member.getName(), member.getDeclaringClass().getName(), typeClass.getName(), memberType.getName()}));
            }
            if (effectiveType.getName().equals(Object.class.getName())) {
                if (!Service.class.isAssignableFrom(valueClass) || valueClass.getName().equals(Service.class.getName())) {
                    Tr.error((TraceComponent)tc, (String)"error.service.ref.member.level.annotation.type.not.inferred", (Object[])new Object[]{member.getName(), member.getDeclaringClass().getName()});
                    throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.member.level.annotation.type.not.inferred", (Object[])new Object[]{member.getName(), member.getDeclaringClass().getName()}));
                }
                wsrInfo.setServiceRefTypeClassName(valueClass.getName());
                wsrInfo.setServiceInterfaceClassName(valueClass.getName());
            } else if (Service.class.isAssignableFrom(effectiveType)) {
                if (effectiveType.getName().equals(Service.class.getName())) {
                    if (!Service.class.isAssignableFrom(valueClass) || valueClass.getName().equals(Service.class.getName())) {
                        Tr.error((TraceComponent)tc, (String)"error.service.ref.member.level.annotation.wrong.value", (Object[])new Object[]{member.getName(), member.getDeclaringClass(), valueClass.getName()});
                        throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.member.level.annotation.wrong.value", (Object[])new Object[]{member.getName(), member.getDeclaringClass(), valueClass.getName()}));
                    }
                    wsrInfo.setServiceInterfaceClassName(valueClass.getName());
                    wsrInfo.setServiceRefTypeClassName(valueClass.getName());
                } else {
                    if (!valueClass.getName().equals(effectiveType.getName()) && !valueClass.getName().equals(Service.class.getName())) {
                        Tr.error((TraceComponent)tc, (String)"error.service.ref.member.level.annotation.value.and.type.not.same", (Object[])new Object[]{member.getName(), member.getDeclaringClass().getName()});
                        throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.member.level.annotation.value.and.type.not.same", (Object[])new Object[]{member.getName(), member.getDeclaringClass().getName()}));
                    }
                    wsrInfo.setServiceInterfaceClassName(effectiveType.getName());
                    wsrInfo.setServiceRefTypeClassName(effectiveType.getName());
                }
            } else {
                if (!Service.class.isAssignableFrom(valueClass) || valueClass.getName().equals(Service.class.getName())) {
                    Tr.error((TraceComponent)tc, (String)"error.service.ref.member.level.annotation.wrong.value", (Object[])new Object[]{member.getName(), member.getDeclaringClass(), valueClass.getName()});
                    throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.member.level.annotation.wrong.value", (Object[])new Object[]{member.getName(), member.getDeclaringClass(), valueClass.getName()}));
                }
                wsrInfo.setServiceRefTypeClassName(effectiveType.getName());
                wsrInfo.setServiceInterfaceClassName(valueClass.getName());
            }
        }
    }

    public InjectionBinding<WebServiceRef> createOverrideInjectionBinding(Class<?> instanceClass, Member member, Resource resource, String jndiName) throws InjectionException {
        InjectionBinding<WebServiceRef> binding;
        Class<?> typeClass = resource.type();
        if (member != null) {
            Class<?> inferredType = InjectionHelper.getTypeFromMember(member);
            if (typeClass.getName().equals(Object.class.getName())) {
                typeClass = inferredType;
            }
        }
        if (Service.class.isAssignableFrom(typeClass)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The @Resource annotation found has type=" + typeClass.getName() + " and is refers to a JAX-WS service reference"), (Object[])new Object[0]);
            }
            binding = WebServiceRefBindingBuilder.createWebServiceRefBindingFromResource(resource, this.ivNameSpaceConfig, typeClass, jndiName);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The @Resource annotation found did not refer to a web service reference type.", (Object[])new Object[0]);
            }
            binding = null;
        }
        return binding;
    }

    public void mergeOverrideInjectionBinding(Class<?> instanceClass, Member member, Resource resource, InjectionBinding<WebServiceRef> binding) throws InjectionException {
        WebServiceRef wsRef = WebServiceRefBindingBuilder.createWebServiceRefFromResource(resource, resource.type(), resource.name());
        binding.merge((Annotation)wsRef, instanceClass, member);
    }
}

