/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.client;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.bus.LibertyApplicationBus;
import com.ibm.ws.jaxrs20.client.bus.LibertyJAXRSClientBusFactory;
import com.ibm.ws.jaxrs20.client.configuration.LibertyJaxRsClientProxyInterceptor;
import com.ibm.ws.jaxrs20.client.configuration.LibertyJaxRsClientTimeOutInterceptor;
import com.ibm.ws.jaxrs20.client.security.LibertyJaxRsClientSSLOutInterceptor;
import com.ibm.ws.jaxrs20.client.security.ltpa.LibertyJaxRsClientLtpaInterceptor;
import com.ibm.ws.jaxrs20.client.security.oauth.LibertyJaxRsClientOAuthInterceptor;
import com.ibm.ws.jaxrs20.client.security.saml.PropagationHandler;
import com.ibm.ws.jaxrs20.client.util.JaxRSClientUtil;
import com.ibm.ws.jaxrs20.providers.api.JaxRsProviderRegister;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.client.spec.ClientImpl;
import org.apache.cxf.jaxrs.client.spec.TLSConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JAXRSClientImpl
extends ClientImpl {
    private static final TraceComponent tc = Tr.register(JAXRSClientImpl.class);
    protected boolean closed;
    protected Set<WebClient> baseClients;
    protected boolean hasSSLConfigInfo;
    private TLSConfiguration secConfig;
    private final Map<String, LibertyApplicationBus> busCache;
    static final long serialVersionUID = -4948067701710218051L;

    /*
     * WARNING - void declaration
     */
    public JAXRSClientImpl(Configuration config, TLSConfiguration secConfig) {
        block8: {
            super(config, secConfig);
            this.baseClients = new HashSet<WebClient>();
            this.hasSSLConfigInfo = false;
            this.secConfig = null;
            this.busCache = new ConcurrentHashMap<String, LibertyApplicationBus>();
            this.secConfig = secConfig;
            TLSClientParameters ttClientParams = secConfig.getTlsClientParams();
            if (secConfig.getSslContext() != null || ttClientParams.getTrustManagers() != null && ttClientParams.getTrustManagers().length > 0 && ttClientParams.getKeyManagers() != null && ttClientParams.getKeyManagers().length > 0) {
                this.hasSSLConfigInfo = true;
            }
            try {
                BundleContext bc;
                Bundle b = FrameworkUtil.getBundle(JAXRSClientImpl.class);
                BundleContext bundleContext = bc = b == null ? null : b.getBundleContext();
                if (bc != null) {
                    ArrayList providers = new ArrayList();
                    Set features = Collections.emptySet();
                    Collection refs = bc.getServiceReferences(JaxRsProviderRegister.class, null);
                    for (ServiceReference ref : refs) {
                        JaxRsProviderRegister providerRegister = (JaxRsProviderRegister)bc.getService(ref);
                        try {
                            providerRegister.installProvider(true, providers, features);
                        }
                        catch (Throwable throwable) {
                            void t;
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jaxrs20.client.JAXRSClientImpl", (String)"101", (Object)((Object)this), (Object[])new Object[]{config, secConfig});
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            String providerRegisterBundleLoc = ref.getBundle() == null ? "unknown" : ref.getBundle().getSymbolicName() + " " + ref.getBundle().getVersion();
                            Tr.debug((TraceComponent)tc, (String)("<init> failed to install providers from " + providerRegister.getClass().getName() + " loaded from " + providerRegisterBundleLoc), (Object[])new Object[]{t});
                        }
                    }
                    for (Object provider : providers) {
                        if (provider == null) continue;
                        this.register(provider);
                    }
                }
            }
            catch (Exception b) {
                void ex;
                FFDCFilter.processException((Throwable)b, (String)"com.ibm.ws.jaxrs20.client.JAXRSClientImpl", (String)"117", (Object)((Object)this), (Object[])new Object[]{config, secConfig});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"<init> failed to find and install declared providers ", (Object[])new Object[]{ex});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebTarget target(UriBuilder builder) {
        LibertyApplicationBus bus;
        ClientImpl.WebTargetImpl wt = (ClientImpl.WebTargetImpl)super.target(builder);
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        URI uri = builder.build(new Object[0]);
        bean.setAddress(uri.toString());
        WebClient targetClient = bean.createWebClient();
        ClientConfiguration ccfg = WebClient.getConfig((Object)targetClient);
        ccfg.getOutInterceptors().add(new LibertyJaxRsClientTimeOutInterceptor("pre-logical"));
        ccfg.getOutInterceptors().add(new LibertyJaxRsClientProxyInterceptor("pre-logical"));
        ccfg.getOutInterceptors().add(new LibertyJaxRsClientLtpaInterceptor());
        ccfg.getOutInterceptors().add(new LibertyJaxRsClientOAuthInterceptor());
        ccfg.getOutInterceptors().add(new PropagationHandler());
        if (!this.hasSSLConfigInfo) {
            LibertyJaxRsClientSSLOutInterceptor sslOutInterceptor = new LibertyJaxRsClientSSLOutInterceptor("pre-logical");
            sslOutInterceptor.setTLSConfiguration(this.secConfig);
            ccfg.getOutInterceptors().add(sslOutInterceptor);
        }
        String id = JaxRSClientUtil.convertURItoBusId(uri.toString());
        Map<String, LibertyApplicationBus> map = this.busCache;
        synchronized (map) {
            bus = this.busCache.get(id);
            if (bus == null) {
                bus = LibertyJAXRSClientBusFactory.getInstance().getClientScopeBus(id);
                this.busCache.put(id, bus);
            }
        }
        ccfg.setBus((Bus)bus);
        this.baseClients.add(targetClient);
        return new ClientImpl.WebTargetImpl((ClientImpl)this, wt.getUriBuilder(), wt.getConfiguration(), targetClient);
    }

    public void close() {
        super.close();
        for (WebClient wc : this.baseClients) {
            wc.close();
        }
        for (LibertyApplicationBus bus : this.busCache.values()) {
            bus.shutdown(false);
        }
        this.busCache.clear();
        this.baseClients = null;
    }

    public Map<String, LibertyApplicationBus> getBusCache() {
        return this.busCache;
    }

    public Client property(String name, @Sensitive Object value) {
        if ("com.ibm.ws.jaxrs.client.proxy.password".equals(name) && value != null && !(value instanceof ProtectedString)) {
            return super.property(name, (Object)new ProtectedString(value.toString().toCharArray()));
        }
        return super.property(name, value);
    }
}

