/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.client.security.oauth;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OAuthPropagationHelper {
    private static final TraceComponent tc = Tr.register(OAuthPropagationHelper.class, (String)"com.ibm.ws.jaxrs20.client", (String)"com.ibm.ws.jaxrs20.client.internal.resources.JAXRSClientMessages");
    public static final String ISSUED_JWT_TOKEN = "issuedJwt";
    static final long serialVersionUID = -4174256452827510495L;

    public static String getAccessTokenType() {
        return OAuthPropagationHelper.getSubjectAttributeString("token_type", true);
    }

    public static String getAccessToken() {
        return OAuthPropagationHelper.getSubjectAttributeString("access_token", true);
    }

    public static String getJwtToken() throws Exception {
        String jwt = OAuthPropagationHelper.getIssuedJwtToken();
        if (jwt == null && !OAuthPropagationHelper.isJwt(jwt = OAuthPropagationHelper.getAccessToken())) {
            jwt = null;
        }
        return jwt;
    }

    private static boolean isJwt(String jwt) {
        return jwt != null && jwt.indexOf(".") >= 0;
    }

    public static String getIssuedJwtToken() throws Exception {
        return OAuthPropagationHelper.getSubjectAttributeString(ISSUED_JWT_TOKEN, true);
    }

    public static String getScopes() {
        return OAuthPropagationHelper.getSubjectAttributeString("scope", true);
    }

    /*
     * WARNING - void declaration
     */
    static Subject getRunAsSubject() {
        try {
            return WSSubject.getRunAsSubject();
        }
        catch (WSSecurityException wSSecurityException) {
            void e;
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.jaxrs20.client.security.oauth.OAuthPropagationHelper", (String)"81", null, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception while getting runAsSubject:", (Object[])new Object[]{e.getCause()});
            }
            Tr.warning((TraceComponent)tc, (String)"failed_run_as_subject", (Object[])new Object[]{e.getLocalizedMessage()});
            return null;
        }
    }

    static String getSubjectAttributeString(String attribKey, boolean bindWithAccessToken) {
        Subject runAsSubject = OAuthPropagationHelper.getRunAsSubject();
        if (runAsSubject != null) {
            return OAuthPropagationHelper.getSubjectAttributeObject(runAsSubject, attribKey, bindWithAccessToken);
        }
        return null;
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    static String getSubjectAttributeObject(Subject subject, String attribKey, boolean bindWithAccessToken) {
        try {
            Set<Object> publicCredentials = subject.getPublicCredentials();
            String result = OAuthPropagationHelper.getCredentialAttribute(publicCredentials, attribKey, bindWithAccessToken, "publicCredentials");
            if (result == null || result.isEmpty()) {
                Set<Object> privateCredentials = subject.getPrivateCredentials();
                result = OAuthPropagationHelper.getCredentialAttribute(privateCredentials, attribKey, bindWithAccessToken, "privateCredentials");
            }
            return result;
        }
        catch (PrivilegedActionException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Did not find a value for the attribute (" + attribKey + ")"), (Object[])new Object[0]);
            }
            return null;
        }
    }

    static String getCredentialAttribute(final Set<Object> credentials, final String attribKey, final boolean bindWithAccessToken, final String msg) throws PrivilegedActionException {
        Object obj = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
            static final long serialVersionUID = -719887960180542843L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object run() throws Exception {
                int iCnt = 0;
                for (Object credentialObj : credentials) {
                    Object value;
                    Object accessToken;
                    ++iCnt;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(msg + "(" + iCnt + ") class:" + credentialObj.getClass().getName()), (Object[])new Object[0]);
                    }
                    if (!(credentialObj instanceof Map) || bindWithAccessToken && (accessToken = ((Map)credentialObj).get("access_token")) == null || (value = ((Map)credentialObj).get(attribKey)) == null) continue;
                    return value;
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }
}

