/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.config.cdi.ConfigBean;
import com.ibm.ws.microprofile.config.cdi.ConfigProducer;
import com.ibm.ws.microprofile.config.cdi.ConfigPropertyBean;
import com.ibm.ws.microprofile.config.cdi.ConfigTypeException;
import com.ibm.ws.microprofile.config.interfaces.DefaultConverters;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.inject.Provider;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={WebSphereCDIExtension.class}, property={"api.classes=org.eclipse.microprofile.config.inject.ConfigProperty;org.eclipse.microprofile.config.Config"}, immediate=true)
public class ConfigCDIExtension
implements Extension,
WebSphereCDIExtension {
    private static final TraceComponent tc = Tr.register(ConfigCDIExtension.class);
    Set<Type> validInjectionTypes = new HashSet(DefaultConverters.getDefaultConverters().keySet());
    Set<Type> badInjectionTypes = new HashSet<Type>();
    Map<ClassLoader, Config> configs = new HashMap<ClassLoader, Config>();
    static final long serialVersionUID = 2379904533039465371L;

    void processInjectionTarget(@Observes ProcessInjectionTarget<?> pit) {
        Class targetClass = pit.getAnnotatedType().getJavaClass();
        ClassLoader classLoader = targetClass.getClassLoader();
        for (InjectionPoint injectionPoint : pit.getInjectionTarget().getInjectionPoints()) {
            ConfigProperty configProperty = ConfigProducer.getConfigPropertyAnnotation(injectionPoint);
            if (configProperty == null) continue;
            Type type = injectionPoint.getType();
            Throwable configException = null;
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                configException = this.processParameterizedType(injectionPoint, pType, classLoader);
            } else {
                configException = this.processConversionType(injectionPoint, type, type, classLoader, false);
            }
            if (configException == null) continue;
            Tr.error((TraceComponent)tc, (String)"unable.to.resolve.injection.point.CWMCG5003E", (Object[])new Object[]{injectionPoint, configException});
        }
    }

    /*
     * WARNING - void declaration
     */
    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        ConfigBean configBean = new ConfigBean(beanManager);
        abd.addBean((Bean)configBean);
        this.validInjectionTypes.removeAll(this.badInjectionTypes);
        for (Type type : this.validInjectionTypes) {
            try {
                if (type instanceof TypeVariable) {
                    Type[] bounds;
                    TypeVariable typeVar = (TypeVariable)type;
                    for (Type bound : bounds = typeVar.getBounds()) {
                        this.addConfigPropertyBean(abd, beanManager, bound);
                    }
                    continue;
                }
                this.addConfigPropertyBean(abd, beanManager, type);
            }
            catch (ConfigTypeException typeVar) {
                void e;
                FFDCFilter.processException((Throwable)typeVar, (String)"com.ibm.ws.microprofile.config.cdi.ConfigCDIExtension", (String)"94", (Object)this, (Object[])new Object[]{abd, beanManager});
                abd.addDefinitionError((Throwable)e);
            }
        }
    }

    private Throwable processParameterizedType(InjectionPoint injectionPoint, ParameterizedType pType, ClassLoader classLoader) {
        Throwable configException = null;
        Type rType = pType.getRawType();
        if (Provider.class.isAssignableFrom((Class)rType)) {
            Type[] aTypes = pType.getActualTypeArguments();
            Type type = aTypes[0];
            configException = this.processConversionType(injectionPoint, type, type, classLoader, false);
        } else if (Optional.class.isAssignableFrom((Class)rType)) {
            Type[] aTypes = pType.getActualTypeArguments();
            Type type = aTypes[0];
            configException = this.processConversionType(injectionPoint, type, pType, classLoader, true);
        } else {
            configException = this.processConversionType(injectionPoint, pType, pType, classLoader, false);
        }
        return configException;
    }

    /*
     * WARNING - void declaration
     */
    private Throwable processConversionType(InjectionPoint injectionPoint, Type conversionType, Type injectionType, ClassLoader classLoader, boolean optional) {
        ConfigTypeException configException = null;
        if (conversionType instanceof Class) {
            Class clazz = (Class)conversionType;
            Config config = ConfigProvider.getConfig((ClassLoader)classLoader);
            try {
                ConfigProducer.newValue(config, injectionPoint, clazz, optional);
                this.validInjectionTypes.add(injectionType);
            }
            catch (Throwable throwable) {
                void e;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.config.cdi.ConfigCDIExtension", (String)"129", (Object)this, (Object[])new Object[]{injectionPoint, conversionType, injectionType, classLoader, optional});
                configException = e;
                this.badInjectionTypes.add(injectionType);
            }
        } else {
            configException = new ConfigTypeException(Tr.formatMessage((TraceComponent)tc, (String)"unable.to.determine.injection.type.CWMCG5001E", (Object[])new Object[]{injectionType}));
            this.badInjectionTypes.add(injectionType);
        }
        return configException;
    }

    private void addConfigPropertyBean(AfterBeanDiscovery abd, BeanManager beanManager, Type type) throws ConfigTypeException {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            this.addConfigPropertyBean(abd, beanManager, clazz);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            this.addConfigPropertyBean(abd, beanManager, pType);
        } else {
            throw new ConfigTypeException(Tr.formatMessage((TraceComponent)tc, (String)"unable.to.determine.injection.type.CWMCG5001E", (Object[])new Object[]{type}));
        }
    }

    private void addConfigPropertyBean(AfterBeanDiscovery abd, BeanManager beanManager, Class<?> type) {
        if (!type.isPrimitive()) {
            this.addConfigPropertyBean(abd, beanManager, type, type);
        }
    }

    private void addConfigPropertyBean(AfterBeanDiscovery abd, BeanManager beanManager, ParameterizedType type) throws ConfigTypeException {
        Type rType = type.getRawType();
        if (!(rType instanceof Class)) {
            throw new ConfigTypeException(Tr.formatMessage((TraceComponent)tc, (String)"unable.to.determine.injection.type.CWMCG5001E", (Object[])new Object[]{type}));
        }
        Class clazz = (Class)rType;
        this.addConfigPropertyBean(abd, beanManager, type, clazz);
    }

    private <T> void addConfigPropertyBean(AfterBeanDiscovery abd, BeanManager beanManager, Type beanType, Class<T> clazz) {
        ConfigPropertyBean<T> converterBean = new ConfigPropertyBean<T>(beanManager, beanType, clazz);
        abd.addBean(converterBean);
    }
}

