/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.config.interfaces.WebSphereConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ConfigProducer {
    private static final TraceComponent tc = Tr.register(ConfigProducer.class);
    static final long serialVersionUID = 4686336456396694591L;

    @FFDCIgnore(value={NoSuchElementException.class})
    static <T> T newValue(Config config, InjectionPoint injectionPoint, Class<T> type, boolean optional) {
        Object value;
        block4: {
            ConfigProperty qualifier = ConfigProducer.getConfigPropertyAnnotation(injectionPoint);
            String propertyName = ConfigProducer.getPropertyName(injectionPoint, qualifier);
            value = null;
            try {
                value = config.getValue(propertyName, type);
            }
            catch (NoSuchElementException e) {
                String defaultValue = qualifier.defaultValue();
                if ("org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(defaultValue)) {
                    if (optional) {
                        value = null;
                    }
                    throw e;
                }
                if (defaultValue == null) break block4;
                WebSphereConfig wConfig = (WebSphereConfig)config;
                value = wConfig.convertValue(defaultValue, type);
            }
        }
        return (T)value;
    }

    static <T> Optional<T> newOptional(Config config, InjectionPoint injectionPoint, Class<T> type) {
        T value = ConfigProducer.newValue(config, injectionPoint, type, true);
        Optional<T> optional = Optional.ofNullable(value);
        return optional;
    }

    static ConfigProperty getConfigPropertyAnnotation(InjectionPoint injectionPoint) {
        ConfigProperty configProperty = null;
        Set qualifiers = injectionPoint.getQualifiers();
        if (qualifiers != null) {
            for (Annotation qualifier : qualifiers) {
                if (!qualifier.annotationType().equals(ConfigProperty.class)) continue;
                configProperty = (ConfigProperty)qualifier;
                break;
            }
        }
        return configProperty;
    }

    static String getPropertyName(InjectionPoint injectionPoint, ConfigProperty qualifier) {
        if (qualifier == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getPropertyName", (Object[])new Object[]{"Unsupported InjectionPoint: " + injectionPoint});
            }
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"unable.to.determine.injection.name.CWMCG5002E", (Object[])new Object[]{injectionPoint}));
        }
        String propertyName = qualifier.name();
        if (propertyName.equals("")) {
            Annotated annotated = injectionPoint.getAnnotated();
            if (annotated instanceof AnnotatedField) {
                AnnotatedField field = (AnnotatedField)annotated;
                propertyName = ConfigProducer.getDefaultPropertyName(field);
            } else if (annotated instanceof AnnotatedParameter) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getPropertyName", (Object[])new Object[]{"Unsupported InjectionPoint: " + injectionPoint});
                }
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"unable.to.determine.injection.name.CWMCG5002E", (Object[])new Object[]{injectionPoint}));
            }
        }
        return propertyName;
    }

    static <T> T getDefaultValue(Config config, ConfigProperty qualifier, Class<T> type) {
        String defaultValue = qualifier.defaultValue();
        Object value = null;
        if (!"org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(defaultValue)) {
            WebSphereConfig wConfig = (WebSphereConfig)config;
            value = wConfig.convertValue(defaultValue, type);
        }
        return (T)value;
    }

    static String getDefaultPropertyName(AnnotatedField<?> field) {
        String className = field.getDeclaringType().getJavaClass().getCanonicalName();
        String fieldName = field.getJavaMember().getName();
        return className + "." + fieldName;
    }

    static String lowerCaseInitialLetter(String string) {
        return string != null && string.length() >= 1 ? string.substring(0, 1).toLowerCase() + string.substring(1) : "";
    }
}

