/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CommonConfigUtils {
    public static final TraceComponent tc = Tr.register(CommonConfigUtils.class, (String)"SecurityCommon", (String)"com.ibm.ws.security.common.internal.resources.SSOCommonMessages");
    static final long serialVersionUID = 8556662642678110011L;

    public String getConfigAttribute(Map<String, Object> props, String key) {
        return this.getConfigAttribute(props, key, null);
    }

    public String getConfigAttribute(Map<String, Object> props, String key, String defaultValue) {
        String result = this.getAndTrimConfigAttribute(props, key);
        if (key != null && result == null && defaultValue != null) {
            result = defaultValue;
        }
        return result;
    }

    public String getRequiredConfigAttribute(Map<String, Object> props, String key) {
        return this.getRequiredConfigAttribute(props, key, null);
    }

    public String getRequiredConfigAttribute(Map<String, Object> props, String key, String defaultValue) {
        String result = this.getAndTrimConfigAttribute(props, key);
        if (key != null && result == null) {
            if (defaultValue != null) {
                result = defaultValue;
            } else {
                Tr.warning((TraceComponent)tc, (String)"CONFIG_REQUIRED_ATTRIBUTE_NULL", (Object[])new Object[]{key});
            }
        }
        return result;
    }

    String getAndTrimConfigAttribute(Map<String, Object> props, String key) {
        return CommonConfigUtils.trim((String)props.get(key));
    }

    public String[] getStringArrayConfigAttribute(Map<String, Object> props, String key) {
        return CommonConfigUtils.trim((String[])props.get(key));
    }

    public boolean getBooleanConfigAttribute(Map<String, Object> props, String key, boolean defaultValue) {
        if (props.containsKey(key)) {
            return (Boolean)props.get(key);
        }
        return defaultValue;
    }

    public int getIntegerConfigAttribute(Map<String, Object> props, String key, int defaultValue) {
        if (props.containsKey(key)) {
            return (Integer)props.get(key);
        }
        return defaultValue;
    }

    public long getLongConfigAttribute(Map<String, Object> props, String key, long defaultValue) {
        if (props.containsKey(key)) {
            return (Long)props.get(key);
        }
        return defaultValue;
    }

    public static String[] trim(String[] originals) {
        if (originals == null || originals.length == 0) {
            return null;
        }
        String[] tmpResults = new String[originals.length];
        int numTrimmedEntries = 0;
        for (int i = 0; i < originals.length; ++i) {
            String original = CommonConfigUtils.trim(originals[i]);
            if (original == null) continue;
            tmpResults[numTrimmedEntries++] = original;
        }
        if (numTrimmedEntries == 0) {
            return null;
        }
        String[] results = new String[numTrimmedEntries];
        System.arraycopy(tmpResults, 0, results, 0, numTrimmedEntries);
        return results;
    }

    public static String trim(String original) {
        if (original == null) {
            return null;
        }
        String result = original.trim();
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }
}

