/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.cdi;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.flow.cdi.FlowBuilderFactoryBean;
import org.apache.myfaces.flow.cdi.FlowScopeBeanHolder;
import org.apache.myfaces.flow.cdi.FlowScopeMap;
import org.apache.myfaces.spi.FacesFlowProvider;

public class DefaultCDIFacesFlowProvider
extends FacesFlowProvider {
    private BeanManager _beanManager;
    private boolean _initialized;
    private static final String CURRENT_FLOW_SCOPE_MAP = "oam.flow.SCOPE_MAP";
    static final char SEPARATOR_CHAR = '.';

    @Override
    public Iterator<Flow> getAnnotatedFlows(FacesContext facesContext) {
        BeanManager beanManager = this.getBeanManager(facesContext);
        if (beanManager != null) {
            FlowBuilderFactoryBean bean = CDIUtils.lookup(beanManager, FlowBuilderFactoryBean.class);
            List<Flow> flows = bean.getFlowDefinitions();
            return flows.iterator();
        }
        Logger.getLogger(DefaultCDIFacesFlowProvider.class.getName()).log(Level.INFO, "CDI BeanManager not found");
        return null;
    }

    @Override
    public void doAfterEnterFlow(FacesContext context, Flow flow) {
        BeanManager beanManager = this.getBeanManager(context);
        if (beanManager != null) {
            FlowScopeBeanHolder beanHolder = CDIUtils.lookup(beanManager, FlowScopeBeanHolder.class);
            beanHolder.createCurrentFlowScope(context);
        }
        String mapKey = "oam.flow.SCOPE_MAP." + flow.getDefiningDocumentId() + '.' + flow.getId();
        context.getAttributes().remove(mapKey);
    }

    @Override
    public void doBeforeExitFlow(FacesContext context, Flow flow) {
        BeanManager beanManager = this.getBeanManager(context);
        if (beanManager != null) {
            FlowScopeBeanHolder beanHolder = CDIUtils.lookup(beanManager, FlowScopeBeanHolder.class);
            beanHolder.destroyCurrentFlowScope(context);
        }
        String mapKey = "oam.flow.SCOPE_MAP." + flow.getDefiningDocumentId() + '.' + flow.getId();
        context.getAttributes().remove(mapKey);
    }

    @Override
    public Map<Object, Object> getCurrentFlowScope(FacesContext facesContext) {
        Flow flow = facesContext.getApplication().getFlowHandler().getCurrentFlow(facesContext);
        if (flow != null) {
            String mapKey = "oam.flow.SCOPE_MAP." + flow.getDefiningDocumentId() + '.' + flow.getId();
            Map map = (Map)facesContext.getAttributes().get(mapKey);
            if (map == null) {
                map = new FlowScopeMap(this.getBeanManager(), flow.getClientWindowFlowId(facesContext.getExternalContext().getClientWindow()));
                facesContext.getAttributes().put(mapKey, map);
            }
            return map;
        }
        return null;
    }

    @Override
    public void refreshClientWindow(FacesContext facesContext) {
        BeanManager beanManager;
        Flow flow;
        if (!facesContext.getApplication().getStateManager().isSavingStateInClient(facesContext) && (flow = facesContext.getApplication().getFlowHandler().getCurrentFlow(facesContext)) != null && (beanManager = this.getBeanManager(facesContext)) != null) {
            FlowScopeBeanHolder beanHolder = CDIUtils.lookup(beanManager, FlowScopeBeanHolder.class);
            beanHolder.refreshClientWindow(facesContext);
        }
    }

    public BeanManager getBeanManager() {
        if (this._beanManager == null && !this._initialized) {
            this._beanManager = CDIUtils.getBeanManager(FacesContext.getCurrentInstance().getExternalContext());
            this._initialized = true;
        }
        return this._beanManager;
    }

    public BeanManager getBeanManager(FacesContext facesContext) {
        if (this._beanManager == null && !this._initialized) {
            this._beanManager = CDIUtils.getBeanManager(facesContext.getExternalContext());
            this._initialized = true;
        }
        return this._beanManager;
    }
}

