/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.serialization.DeserializationObjectInputStream;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsObjectMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;

public class JmsObjectMessageImpl
extends JmsMessageImpl
implements ObjectMessage {
    private static final long serialVersionUID = -8638295995751681706L;
    private JsJmsObjectMessage objMsg;
    private transient String cachedObjectToString = null;
    private static TraceComponent tc = SibTr.register(JmsObjectMessageImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");

    public JmsObjectMessageImpl() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsObjectMessageImpl");
        }
        this.messageClass = "jms_object";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsObjectMessageImpl");
        }
    }

    public JmsObjectMessageImpl(Serializable serObj) throws JMSException {
        this();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsObjectMessageImpl", (Object)serObj);
        }
        this.messageClass = "jms_object";
        this.setObject(serObj);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsObjectMessageImpl");
        }
    }

    public JmsObjectMessageImpl(JsJmsObjectMessage newMsg, JmsSessionImpl newSess) {
        super((JsJmsMessage)newMsg, newSess);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsObjectMessageImpl", (Object)new Object[]{newMsg, newSess});
        }
        this.objMsg = newMsg;
        this.messageClass = "jms_object";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsObjectMessageImpl");
        }
    }

    JmsObjectMessageImpl(ObjectMessage objectMessage) throws JMSException {
        super((Message)objectMessage);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsObjectMessageImpl", (Object)objectMessage);
        }
        this.messageClass = "jms_object";
        this.setObject(objectMessage.getObject());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsObjectMessageImpl");
        }
    }

    @Override
    public String toString() {
        String val = super.toString();
        if (this.cachedObjectToString == null) {
            String objString = null;
            Serializable obj = null;
            try {
                obj = this.getObjectInternal();
                objString = obj == null ? "<null>" : obj.getClass().toString();
            }
            catch (Exception e) {
                String reason;
                objString = reason = nls.getFormattedMessage("DESERIALIZATION_EXCEPTION_CWSIA0122", new Object[]{e.getClass().getName() + ": " + e.getMessage()}, null);
            }
            this.cachedObjectToString = objString;
        }
        return val + "\n" + this.cachedObjectToString;
    }

    public void setObject(Serializable obj) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setObject", (Object)(obj == null ? "null" : obj.getClass()));
        }
        try {
            this.checkBodyWriteable("setObject");
            if (this.producerWontModifyPayloadAfterSet) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Set REAL object into underlying message object");
                }
                this.objMsg.setRealObject(obj);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Copy object and set into underlying message");
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                this.objMsg.setSerializedObject(baos.toByteArray());
            }
            this.cachedObjectToString = null;
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Error serializing object", (Object)e);
            }
            throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "SERIALIZATION_EXCEPTION_CWSIA0121", new Object[]{e}, e, "JmsObjectMessageImpl.setObject#1", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setObject");
        }
    }

    public Serializable getObject() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getObject");
        }
        Serializable obj = null;
        try {
            obj = this.getObjectInternal();
        }
        catch (ClassNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Error deserializing object", (Object)e);
            }
            throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "DESERIALIZATION_EXCEPTION_CWSIA0122", new Object[]{e}, e, null, this, tc);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Error deserializing object", (Object)e);
            }
            throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "DESERIALIZATION_EXCEPTION_CWSIA0122", new Object[]{e}, e, "JmsObjectMessageImpl.getObject#1", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getObject", (Object)(obj == null ? "null" : obj.getClass()));
        }
        return obj;
    }

    private Serializable getObjectInternal() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getObjectInternal");
        }
        Serializable obj = null;
        ObjectInputStream ois = null;
        if (this.consumerWontModifyPayloadAfterGet) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Get REAL object from underlying message object");
            }
            obj = this.objMsg.getRealObject();
        } else {
            byte[] byteForm;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Get object from underlying message and deserialize");
            }
            if ((byteForm = this.objMsg.getSerializedObject()) != null) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(byteForm);
                    ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() {
                            return Thread.currentThread().getContextClassLoader();
                        }
                    });
                    ois = new DeserializationObjectInputStream((InputStream)bais, cl);
                    obj = (Serializable)ois.readObject();
                }
                catch (Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception deserializing object - throw on to caller");
                    }
                    throw e;
                }
                finally {
                    block19: {
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                        }
                        catch (IOException ex) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block19;
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception closing the ObjectInputStream", (Object)ex);
                        }
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getObjectInternal");
        }
        return obj;
    }

    @Override
    protected JsJmsMessage instantiateMessage() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"instantiateMessage");
        }
        JsJmsObjectMessage newMsg = null;
        try {
            newMsg = jmfact.createJmsObjectMessage();
        }
        catch (MessageCreateFailedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Error occurred creating message: ", (Object)((Object)e));
            }
            throw e;
        }
        this.objMsg = newMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"instantiateMessage", (Object)newMsg);
        }
        return newMsg;
    }
}

