/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfigurationProvider;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.ra.inbound.impl.SibRaColocatingEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaDynamicDestinationEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaScalableEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.SICoreConnectionFactorySelector;
import com.ibm.wsspi.sib.core.selector.FactoryType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

public class SibRaResourceAdapterImpl
implements ResourceAdapter,
SibMessage.Listener {
    private static final String CLASS_NAME = SibRaResourceAdapterImpl.class.getName();
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaResourceAdapterImpl.class);
    private static TraceNLS NLS = SibRaUtils.getTraceNls();
    public static final String $sccsid = "@(#) 1.30 SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaResourceAdapterImpl.java, SIB.ra, WASX.SIB, aa1225.01 08/05/14 03:57:12 [7/2/12 06:13:52]";
    private final Map<MessageEndpointFactory, SibRaEndpointActivation> _endpointActivations = new HashMap<MessageEndpointFactory, SibRaEndpointActivation>();
    private BootstrapContext _bootstrapContext;
    private static final int MAX_ENDPOINTS = 10;
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";

    public SibRaResourceAdapterImpl() {
        if (RuntimeInfo.isThinClient()) {
            SibMessage.addListener((SibMessage.Listener)this);
        }
    }

    public void message(SibMessage.Listener.MessageType type, String me, TraceComponent tc, String msgKey, Object objs, Object[] formattedMessage) {
        switch (type) {
            case AUDIT: 
            case INFO: 
            case SERVICE: 
            case WARNING: {
                System.out.println(formattedMessage[1]);
                break;
            }
            case ERROR: 
            case FATAL: {
                System.err.println(formattedMessage[1]);
            }
        }
    }

    public final void start(BootstrapContext bootstrapContext) {
        String methodName = "start";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"start", (Object)bootstrapContext);
        }
        this._bootstrapContext = bootstrapContext;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"start");
        }
    }

    public final void stop() {
        String methodName = "stop";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"stop");
        }
        Iterator<MessageEndpointFactory> iterator = this._endpointActivations.keySet().iterator();
        while (iterator.hasNext()) {
            SibRaEndpointActivation endpointActivation = this._endpointActivations.get(iterator.next());
            endpointActivation.deactivate();
        }
        this._endpointActivations.clear();
        this._bootstrapContext = null;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"stop");
        }
    }

    public final void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws NotSupportedException, ResourceException {
        SibRaEndpointConfiguration configuration;
        SibRaEndpointConfigurationProvider configurationProvider;
        String methodName = "endpointActivation";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"endpointActivation", (Object)new Object[]{messageEndpointFactory, activationSpec});
        }
        if (activationSpec instanceof SibRaEndpointConfigurationProvider) {
            configurationProvider = (SibRaEndpointConfigurationProvider)activationSpec;
            try {
                configuration = configurationProvider.getEndpointConfiguration();
            }
            catch (InvalidPropertyException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "endpointActivation"), (String)FFDC_PROBE_1, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new NotSupportedException(NLS.getFormattedMessage("INVALID_ACTIVATION_SPEC_CWSIV0452", new Object[]{activationSpec, exception}, null), (Throwable)exception);
            }
        } else {
            NotSupportedException exception = new NotSupportedException(NLS.getFormattedMessage("UNEXPECTED_ACTIVATION_SPEC_CWSIV0451", new Object[]{activationSpec, SibRaEndpointConfigurationProvider.class}, null));
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
            throw exception;
        }
        SibRaEndpointInvoker invoker = configurationProvider.getEndpointInvoker();
        SibRaEndpointActivation endpointActivation = null;
        endpointActivation = configuration.getDestination() == null ? new SibRaDynamicDestinationEndpointActivation(this, messageEndpointFactory, configuration, invoker) : (configuration.getAlwaysActivateAllMDBs() != false ? new SibRaScalableEndpointActivation(this, messageEndpointFactory, configuration, invoker) : new SibRaColocatingEndpointActivation(this, messageEndpointFactory, configuration, invoker));
        this._endpointActivations.put(messageEndpointFactory, endpointActivation);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"endpointActivation");
        }
    }

    public final void endpointDeactivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) {
        SibRaEndpointActivation endpointActivation;
        String methodName = "endpointDeactivation";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"endpointDeactivation", (Object)new Object[]{messageEndpointFactory, activationSpec});
        }
        if ((endpointActivation = this._endpointActivations.remove(messageEndpointFactory)) != null) {
            endpointActivation.deactivate();
        } else if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Endpoint deactivation called for unknown endpoint " + messageEndpointFactory));
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"endpointDeactivation");
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] activationSpecs) {
        String methodName = "getXAResources";
        if (TRACE.isAnyTracingEnabled() && TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"getXAResources", (Object)("activationSpecs=" + Arrays.toString(activationSpecs)));
        }
        XAResource[] rc = null;
        rc = new XAResource[activationSpecs.length];
        for (int i = 0; i < activationSpecs.length; ++i) {
            block16: {
                SibRaEndpointConfiguration activationSpec;
                block15: {
                    rc[i] = null;
                    activationSpec = null;
                    if (activationSpecs[i] instanceof SibRaEndpointConfigurationProvider) {
                        try {
                            activationSpec = ((SibRaEndpointConfigurationProvider)activationSpecs[i]).getEndpointConfiguration();
                        }
                        catch (InvalidPropertyException e) {
                            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + "." + "getXAResources"), (String)FFDC_PROBE_2, (Object)this);
                            if (TRACE.isAnyTracingEnabled() && TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)e));
                            }
                            break block15;
                        }
                        catch (ResourceAdapterInternalException f) {
                            FFDCFilter.processException((Throwable)f, (String)(CLASS_NAME + "." + "getXAResources"), (String)FFDC_PROBE_3, (Object)this);
                            if (TRACE.isAnyTracingEnabled() && TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)f));
                            }
                            break block15;
                        }
                    }
                    if (TRACE.isAnyTracingEnabled() && TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)TRACE, (String)("Unsupported ActivationSpec object encountered: " + activationSpecs[i]));
                    }
                }
                if (activationSpec == null) continue;
                if (TRACE.isAnyTracingEnabled() && TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)TRACE, (String)("Using activationSpec: " + activationSpec));
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("remoteServerAddress", activationSpec.getProviderEndpoints());
                map.put("targetTransport", activationSpec.getTargetTransport());
                map.put("busName", activationSpec.getBusName());
                if (TRACE.isAnyTracingEnabled() && TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)TRACE, (String)("Recovering using connection properties: " + map));
                }
                try {
                    SICoreConnectionFactory factory = SICoreConnectionFactorySelector.getSICoreConnectionFactory((FactoryType)FactoryType.TRM_CONNECTION);
                    SICoreConnection connection = factory.createConnection(activationSpec.getUserName(), activationSpec.getPassword(), map);
                    if (connection != null) {
                        rc[i] = connection.getSIXAResource();
                    }
                }
                catch (SIException e) {
                    if (!TRACE.isAnyTracingEnabled() || !TraceComponent.isAnyTracingEnabled() || !TRACE.isDebugEnabled()) break block16;
                    SibTr.debug((TraceComponent)TRACE, (String)("Exception returned from create connection:" + (Object)((Object)e)));
                }
            }
            if (!TRACE.isAnyTracingEnabled() || !TraceComponent.isAnyTracingEnabled() || !TRACE.isDebugEnabled()) continue;
            SibTr.debug((TraceComponent)TRACE, (String)("XAResource=" + rc[i]));
        }
        if (TRACE.isAnyTracingEnabled() && TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"getXAResources", (Object)("rc=" + rc));
        }
        return rc;
    }

    final BootstrapContext getBootstrapContext() {
        return this._bootstrapContext;
    }

    public final String toString() {
        SibRaStringGenerator generator = new SibRaStringGenerator(this);
        generator.addField("endpointActivations", this._endpointActivations);
        generator.addField("bootstrapContext", this._bootstrapContext);
        return generator.getStringRepresentation();
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source Info: @(#) 1.30 SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaResourceAdapterImpl.java, SIB.ra, WASX.SIB, aa1225.01 08/05/14 03:57:12 [7/2/12 06:13:52]");
        }
    }
}

