/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.AuthorizationTableService;
import com.ibm.ws.security.authorization.FeatureAuthorizationTableService;
import com.ibm.ws.security.authorization.RoleSet;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.security.PostParameterHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.feature.internal.FeatureWebSecurityConfigImpl;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FeatureWebSecurityCollaboratorImpl
extends WebAppSecurityCollaboratorImpl
implements FeatureAuthorizationTableService {
    protected volatile WebAppSecurityConfig featureSecConfig = new FeatureWebSecurityConfigImpl(null);
    private final ConcurrentHashMap<String, AuthorizationTableService> featureTables = new ConcurrentHashMap();
    static final long serialVersionUID = 5013041712430225790L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate(ComponentContext cc, Map<String, Object> props) {
        super.activate(cc, props);
    }

    protected void activateComponents() {
        this.webAppSecConfig = this.featureSecConfig;
        this.postParameterHelper = new PostParameterHelper(this.webAppSecConfig);
        this.providerAuthenticatorProxy = this.authenticatorFactory.createWebProviderAuthenticatorProxy(this.securityServiceRef, this.taiServiceRef, this.interceptorServiceRef, this.webAppSecConfig, this.webAuthenticatorRef);
        this.authenticatorProxy = this.authenticatorFactory.createWebAuthenticatorProxy(this.webAppSecConfig, this.postParameterHelper, this.securityServiceRef, this.providerAuthenticatorProxy);
    }

    protected void modified(Map<String, Object> newProperties) {
    }

    protected void deactivate(ComponentContext cc) {
        super.deactivate(cc);
    }

    public RoleSet getRolesForSpecialSubject(String resourceName, String specialSubject) {
        RoleSet roles = null;
        AuthorizationTableService authzTable = this.featureTables.get(resourceName);
        if (authzTable != null) {
            roles = authzTable.getRolesForSpecialSubject(resourceName, specialSubject);
        }
        return roles;
    }

    public RoleSet getRolesForAccessId(String resourceName, String accessId) {
        RoleSet roles = null;
        AuthorizationTableService authzTable = this.featureTables.get(resourceName);
        if (authzTable != null) {
            roles = authzTable.getRolesForAccessId(resourceName, accessId);
        }
        return roles;
    }

    public void addAuthorizationTable(String resourceName, AuthorizationTableService authzTable) {
        this.featureTables.put(resourceName, authzTable);
    }

    public void removeAuthorizationTable(String resourceName) {
        this.featureTables.remove(resourceName);
    }

    protected String getApplicationName() {
        return this.getFeatureAuthzRoleHeaderValue();
    }

    public String getFeatureAuthzRoleHeaderValue() {
        Dictionary headers;
        String name = null;
        WebAppConfig wac = this.getWebAppConfig();
        if (wac != null && wac instanceof WebAppConfiguration && (headers = ((WebAppConfiguration)wac).getBundleHeaders()) != null) {
            name = (String)headers.get("IBM-Authorization-Roles");
        }
        return name;
    }

    public boolean isAuthzInfoAvailableForApp(String resourceName) {
        AuthorizationTableService authzTable = this.featureTables.get(resourceName);
        return authzTable != null && authzTable.isAuthzInfoAvailableForApp(resourceName);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FeatureWebSecurityCollaboratorImpl.class);
    }
}

