/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation.v11.cdi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.beanvalidation.service.ValidationReleasable;
import com.ibm.ws.beanvalidation.service.ValidationReleasableFactory;
import com.ibm.ws.beanvalidation.v11.cdi.internal.ReleasableConstraintValidatorFactory;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.container.service.metadata.ComponentMetaDataListener;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectException;
import com.ibm.ws.managedobject.ManagedObjectFactory;
import com.ibm.ws.managedobject.ManagedObjectService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Map;
import java.util.WeakHashMap;
import javax.enterprise.inject.spi.BeanManager;
import javax.validation.ConstraintValidatorFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ValidationReleasableFactory.class, ComponentMetaDataListener.class})
public class ValidationReleasableFactoryImpl
implements ValidationReleasableFactory,
ComponentMetaDataListener {
    private static final TraceComponent tc = Tr.register(ValidationReleasableFactoryImpl.class);
    private static final String REFERENCE_CDI_SERVICE = "cdiService";
    private static final String REFERENCE_MANAGED_OBJECT_SERVICE = "managedObjectService";
    private final AtomicServiceReference<CDIService> cdiService = new AtomicServiceReference("cdiService");
    private final AtomicServiceReference<ManagedObjectService> managedObjectServiceRef = new AtomicServiceReference("managedObjectService");
    private final Map<ComponentMetaData, BeanManager> beanManagers = new WeakHashMap<ComponentMetaData, BeanManager>();
    static final long serialVersionUID = -6899258833233116943L;

    public <T> ManagedObject<T> createValidationReleasable(Class<T> clazz) {
        BeanManager beanManager = this.getCurrentBeanManager();
        if (beanManager != null) {
            ManagedObjectFactory<T> mof = this.getManagedBeanManagedObjectFactory(clazz);
            try {
                return mof.createManagedObject();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationReleasableFactoryImpl", (String)"71", (Object)this, (Object[])new Object[]{clazz});
            }
        }
        return null;
    }

    public ValidationReleasable<ConstraintValidatorFactory> createConstraintValidatorFactory() {
        BeanManager beanManager = this.getCurrentBeanManager();
        if (beanManager != null) {
            return new ReleasableConstraintValidatorFactory(this);
        }
        return null;
    }

    private BeanManager getCurrentBeanManager() {
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        BeanManager beanMgr = this.beanManagers.get(cmd);
        if (beanMgr == null) {
            beanMgr = ((CDIService)this.cdiService.getServiceWithException()).getCurrentBeanManager();
            this.beanManagers.put(cmd, beanMgr);
        }
        return beanMgr;
    }

    private <T> ManagedObjectFactory<T> getManagedBeanManagedObjectFactory(Class<T> clazz) {
        ModuleMetaData mmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData().getModuleMetaData();
        ManagedObjectService managedObjectService = (ManagedObjectService)this.managedObjectServiceRef.getService();
        if (managedObjectService != null) {
            try {
                ManagedObjectFactory factory = managedObjectService.createManagedObjectFactory(mmd, clazz, true);
                if (factory.isManaged()) {
                    return factory;
                }
            }
            catch (ManagedObjectException managedObjectException) {
                FFDCFilter.processException((Throwable)managedObjectException, (String)"com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationReleasableFactoryImpl", (String)"106", (Object)this, (Object[])new Object[]{clazz});
            }
        }
        return null;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.cdiService.activate(cc);
        this.managedObjectServiceRef.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.cdiService.deactivate(cc);
        this.managedObjectServiceRef.deactivate(cc);
    }

    @Reference(name="cdiService", service=CDIService.class)
    protected void setCdiService(ServiceReference<CDIService> ref) {
        this.cdiService.setReference(ref);
    }

    protected void unsetCdiService(ServiceReference<CDIService> ref) {
        this.cdiService.unsetReference(ref);
    }

    @Reference(name="managedObjectService", service=ManagedObjectService.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setManagedObjectService(ServiceReference<ManagedObjectService> ref) {
        this.managedObjectServiceRef.setReference(ref);
    }

    protected void unsetManagedObjectService(ServiceReference<ManagedObjectService> ref) {
        this.managedObjectServiceRef.unsetReference(ref);
    }

    public void componentMetaDataCreated(MetaDataEvent<ComponentMetaData> event) {
    }

    public void componentMetaDataDestroyed(MetaDataEvent<ComponentMetaData> event) {
        BeanManager beanManager = this.beanManagers.remove(event.getMetaData());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Removed bean manager from cache: ", (Object[])new Object[]{beanManager});
        }
    }
}

